/**********************************************************************/
/*   Macro to display the calendar using the unix cal command.	      */
/**********************************************************************/

void
cal(string month, string year)
{	string	buf;
	int	calbuf, calwin;
	int	curbuf = inq_buffer();

	save_position();
	sprintf(buf, "cal %s %s", month, year);
	calbuf = perform_unix_command(buf, "Calendar");
	calwin = sized_window(inq_lines(calbuf), 
			inq_line_length(calbuf), "Type <Esc> to exit");
	select_buffer(calbuf, calwin);
	delete_buffer(calbuf);
	set_buffer(curbuf);
	attach_buffer(curbuf);
	restore_position();
}
