/**********************************************************************/
/*                                                                    */
/*	CRISP - Programmable editor                                   */
/*	===========================                                   */
/*                                                                    */
/*  File:          scrap.cr                                           */
/*  Author:        P. D. Fox                                          */
/*  Created:       24 Jun 1991                     		      */
/*                                                                    */
/*  Copyright (c) 1990, 1991 Paul Fox                                 */
/*                All Rights Reserved.                                */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*  Description:  Routines to handle named scraps                     */
/*                                                                    */
/**********************************************************************/

/* SCCS ID: %Z% %M% %R%.%L% */
# include	"crisp.h"
int
cut_named_scrap()
{
	if (get_scrap_name("Cut to named scrap: ") < 0)
		return -1;
	/***********************************************/
	/*   Allow  the  replacement  cut macro to be  */
	/*   called   pretending  user  directly  got  */
	/*   there from the keyboard.		       */
	/***********************************************/
	set_calling_name(inq_called());
	return cut();
}
int
copy_named_scrap()
{
	if (get_scrap_name("Copy to named scrap: ") < 0)
		return -1;
	/***********************************************/
	/*   Allow  the  replacement  cut macro to be  */
	/*   called   pretending  user  directly  got  */
	/*   there from the keyboard.		       */
	/***********************************************/
	set_calling_name(inq_called());
	return copy();
}
int
paste_named_scrap()
{
	if (get_scrap_name("Paste named scrap: ") < 0)
		return -1;
	/***********************************************/
	/*   Allow  the  replacement  cut macro to be  */
	/*   called   pretending  user  directly  got  */
	/*   there from the keyboard.		       */
	/***********************************************/
	set_calling_name(inq_called());
	return paste();
}
int
get_scrap_name(string msg)
{	string	scrap_name;
	int	buf_id;
		
	if (get_parm(NULL, scrap_name, msg) <= 0 || 
	    scrap_name == "") {
	    	return -1;
		}
	scrap_name = "/SCRAP/" + scrap_name;
	if ((buf_id = inq_buffer(scrap_name)) <= 0)
		buf_id = create_buffer(scrap_name, NULL, TRUE);
	set_scrap_info(NULL, NULL, buf_id);
	return 0;
}
/**********************************************************************/
/*   Function  called  when  we  user  hits <Tab> at the named scrap  */
/*   prompts.							      */
/**********************************************************************/
string
compl_scrap(string name)
{	int	curbuf, curwin;
	int	buf, win, this_buf;
	string	scrap_name, s, tmp;
	int	width, ret;

	curbuf = inq_buffer();
	curwin = inq_window();
	buf = create_buffer("Named scraps", NULL, TRUE);
	set_buffer(buf);
	while (1) {
		set_buffer(next_buffer(TRUE));
		if (inq_buffer() == buf)
			break;
		inq_names(scrap_name);
		if ((inq_buffer_flags() & BF_SYSBUF) == 0)
			continue;
		if (substr(scrap_name, 1, 7) != "/SCRAP/")
			continue;
		this_buf = inq_buffer();
		save_position();
		top_of_buffer();
		s = trim(read());
		if (strlen(s) > 45)
			s = substr(s, 1, 42) + "...";
		restore_position();
		set_buffer(buf);
		sprintf(tmp, "%-10s  ==> %s\n", substr(scrap_name, 8), s);
		insert(tmp);
		set_buffer(this_buf);
		}
	set_buffer(buf);
	end_of_buffer();
	delete_line();
	sort_buffer();
	width = inq_line_length();
	if (width < 48)
		width = 48;
	if (inq_lines() < 1) {
		beep();
		}
	else {
		win = sized_window(inq_lines() + 1, width,
			"<Alt-D> to delete; <Enter> to select scrap");
		top_of_buffer();
		ret = select_buffer(buf, win, SEL_NORMAL, scrap_keys());
		if (ret >= 0) {
			goto_line(ret);
			name = split(read(), " ")[0];
			}
		}
	delete_buffer(buf);
	set_buffer(curbuf);
	set_window(curwin);
	attach_buffer(curbuf);
	message("");
	refresh();
	return name;
}
void
scrap_keys()
{
	assign_to_key("<Alt-D>", "del_scrap");
}
void
del_scrap()
{	string	s;
	int	i;
	int	buf;
	
	beginning_of_line();
	s = read();
	i = index(s, " ");
	if (i > 0) {
		s = "/SCRAP/" + substr(s, 1, i - 1);
		buf = inq_buffer(s);
		if (buf == inq_scrap())
			error("Cannot delete the current scrap.");
		else {
			delete_buffer(buf);
			delete_line();
			}
		refresh();
		}
}
