/*
 *  $Id: S.gettc.c,v 2.4 2001/08/09 10:02:38 w Exp w $
 *
 *   RED.
 *
 *  r.gettc.c -     termcap
 *               .
 *
 *  $Log: S.gettc.c,v $
 *  Revision 2.4  2001/08/09 10:02:38  w
 *  Legacy restriction removed: 32767 lines maximum at writing
 *  editing result.
 *  Fixes for ANSI-fication, "-fwritable-strings -Wtraditional"
 *  options do not reqired anymore, and -Wall going well.
 *  Some fixes "0 vs. NULL" pointers.
 *  New undocumented feature: "arg: 0l rpl ..." work with
 *  whole file now.
 *  'register' type qualifyer on the way of removing.
 *  dumpfsd() fixed to be functional (enabled by -DDEBUG).
 *  [s]append(...,"") using improved a bit.
 *  dumpfsd() activation changed to ^X.
 *  Version numbering changed to major.minor.ext.build scheme.
 *
 *  Revision 2.3  1998/05/13 18:34:30  w
 *  ANSI-     glibc  redhat-5.0.
 *       .
 *
 *  Revision 2.2  1997/06/12 23:15:29  w
 *    gt.
 *          -8,
 *     g_table (  ).
 *    .
 *      splitline(), openlines(). ( ""
 *      ).
 *    CSI (0233).
 *    cntrl- (  ,
 *    termio (BSD)):      (0377).
 *   /    ""   .
 *
 *  Revision 2.1  1997/06/02 18:47:53  w
 *     .
 *
 *  Revision 2.0  1997/05/30 18:33:56  w
 *  !!!
 *  Red   8- (control-   ).
 *         .
 *
 *  Revision 1.2  1997/04/26 13:32:03  w
 *   
 *
 *  Revision 1.1  1997/04/26 09:48:37  w
 *  Initial revision
 *
 * Revision 4.20  90/05/22  23:22:37  alex
 * First rev. red 4.2
 * 
 * Revision 4.1  88/03/31  22:07:35  alex
 *  4.1 -   UTEC, 
 * 
 * Revision 3.1.2.5  87/07/09  20:45:01  alex
 * REVISION
 * 
 * Revision 3.1.2.4  87/07/03  22:04:33  alex
 * Graph_characters used in margin
 * 
 * Revision 3.1.2.3  87/06/29  17:58:35  alex
 * Commans set to 0200-0277
 * 
 * Revision 3.1.2.2  87/06/24  22:37:51  alex
 * New readch + gettc + tc table Tested
 * 
 * Revision 3.1.2.1  87/06/19  16:56:03  alex
 * Start revision for red/4
 * 
 * Revision 3.12  87/06/12  18:06:28  alex
 *     vilcase    vt-200
 * 
 * Revision 3.11  87/06/09  19:45:10  alex
 *    tty ~ VT200  15--0013
 * 
 * Revision 3.10  87/06/06  16:47:39  alex
 *  roll    sr/sf  
 *     -t +  
 * 
 * Revision 3.9  87/06/05  23:48:02  alex
 *  roll    sr/sf  
 *     -t +  
 * 
 * Revision 3.8  87/06/04  23:41:36  alex
 * Scroll on -cs- or -al/dl- added
 * 
 * Revision 3.7  87/04/02  18:31:14  alex
 *   Utec       
 * 
 * Revision 3.6  87/04/01  19:14:49  alex
 * Revision for Utec: Cs, Ce, Ct, hR
 * 
 * Revision 3.5  86/10/29  02:45:41  root
 *  4 * ESC  2 * ESC    .
 * 
 * Revision 3.4  86/09/19  20:01:20  alex
 *   -1700
 * 
 * Revision 3.3  86/08/04  20:55:51  alex
 *  /-2
 * 
 * Revision 3.2  86/07/24  19:08:52  alex
 * '      
 * 
 * Revision 3.1  86/04/20  23:41:41  alex
 *    .
 * 
 * Revision 3.1  86/04/20  23:41:41  alex
 * *** empty log message ***
 * 
 * Revision 1.4  86/04/13  21:56:14  alex
 */

#ifndef TEST1
# define PIT /* */
# else
  void pttt();
# define PIT pttt();
# endif

extern char *UP, *BC;
char **toup= &UP;        /*   -   */

#include "r.defs.h"
#define TELE_INIT
/*#include "S.tele.h"*/

void *salloc();

# define INCTABSZ 150
/*
 *     :
 * ^C - - C & 037
 * =C -  
 * xx -    termcap   xx
 * ?xx -  ,   xx ,    ;
 * :yyyyy:zzzzz:... -    yyyyy, zzzzzz
 * ( ,    termcap)
 */

/*
 *  
 */
char *cvt_out[] = {
    /* COSTART: */  "cl?is?ti?ks?ho" ,
    /* COUP:    */  "up"    ,
    /* CODN   : */  "do"    ,
    /* CORN:    */  "\015"  ,
    /* COHO   : */  "ho"    ,
    /* CORT:    */  "nd"    ,
    /* COLT   : */  "bc"    ,
    /* COCURS:  */  "cu"    ,
    /* COBELL : */  "\007"  ,
    /* COFIN:   */  "?Ge?me?Ce?cl?fs?te?ke" ,
    /* COERASE: */  "cl"    ,
    /* COOPEN:  */  "?so"   ,
    /* COCLOSE  */  "?se"   ,
    /* COVIOPE  */  "vs"    ,
    /* COVICLO  */  "ve"    ,
    /* COCYON   */  "Cs"    ,
    /* COCYOFF  */  "Ce"    ,
    /* COILINE  */  "al"    ,
    /* CODELIN  */  "dl"    ,
    /* COSRFWD  */  "sf"    ,
    /* COSRBAK  */  "sr"    ,
    /* COCLLIN  */  "ce"    ,
    /* COCLSCR  */  "cd"    ,
    /* COANORMAL*/  "?me?se",
    /* COAINFO  */  ":m1:mr:so" ,
    /* COAERROR */  ":m2:?mbmr:?mbso",
    /* COAMARG  */  ":m3:md",
    /* COAOUT   */  ":m4:mr?md:so",
    /* COGSTART */  "gs"    ,
    /* COGEND   */  "ge"    ,
   NULL
} ;
char **cvtout = cvt_out ;   /*--  :   :
				char *cvtout[] = { ...          */

char *curspos;
int slowsw = 1;

/*
 *       .
 *
 *   DEFTABL -     ,   
 *
 */
/*------------------------------------------------------*
 *            
 *
 *           
 *
 *             :
 *
 *  1.  .     .
 *  2.     ;
 *  3.   -.
 *
 *      !
 *       ,
 *    p2 = malloc(N)   p1 = malloc(N),
 *    p2  > p1 .     (    ),
 *          !
 *------------------------------------------------------*/
char escch1 = '\012';
struct ex_int inctab[INCTABSZ] = {
    /*
     *  .  ,   
     */
  { CCRETURN        ,"^M"       },      /* return               */
  { CCRETURN        ,"^J"       },      /* return               */
  { CCMOVELEFT      ,":kl:^[^L" },      /* backward move        */
  { CCMOVERIGHT     ,":kr:^[^R" },      /* forward move         */
  { CCMOVEUP        ,":ku:^[^U" },      /* move up 1 lin        */
  { CCMOVEDOWN      ,":kd:^[^D" },      /* move down 1 line     */
  { CCHOME          ,":kh:^[^H" },      /* home cursor          */
  { CCBACKTAB       ,"^B"       },      /* tab left             */
  { CCTAB           ,"^I"       },      /* tab                  */
    /*
     *   
     */
  {  CCBACKSPACE    ,"^?"       },
  {  CCCTRLQUOTE    ,"^A"       },
  {  CCQUIT         ,"^[^?"     },
  {  CCENTER        ,"^[= "     },
  {  CCHELP         ,"^\\"      },
# define DEFTABL        13
    /*
     *     
     *       
     */
  { CCCHPORT        ,":f0:^[=0"     },
  { CCDOCMD         ,":f2f0:^[^[=0" },
  { CCENTER         ,":f1:^[=1"     },
  { CCENTER         ,":f2f1:^[^[=1" },
  { CCPLSRCH        ,":f3:^[=3"     },
  { CCMISRCH        ,":f2f3:^[^[=3" },
  { CCGOTO          ,":f4:^[=4"     },
  { CCMAKEPORT      ,":f2f4:^[^[=4" },
  { CCINSMODE       ,":f5:^[=5"     },
  { CCTABS          ,":f2f5:^[^[=5" },
  { CCDELCH         ,":f6:^[=6"     },
  { CCDELCH         ,":f2f6:^[^[=6" },
  { CCPLPAGE        ,":f7:^[=7"     },
  { CCMIPAGE        ,":f2f7:^[^[=7" },
  { CCOPEN          ,":f8:^[=8"     },
  { CCCLOSE         ,":f2f8:^[^[=8" },
  { CCPICK          ,":f9:^[=9"     },
  { CCPUT           ,":f2f9:^[^[=9" },
  { CCBACKTAB       ,":f.:^[=."     },
  { CCCTRLQUOTE     ,":f2f.:^[^[=." },
  { CCSETFILE       ,":f-:^[=-"     },
  { CCSAVEFILE      ,":f2f-:^[^[=-" },
  { CCLPORT         ,":f2kl:^[kl"   },
  { CCRPORT         ,":f2kr:^[kr"   },
    /*
     *     . 
     */
  { CCBACKTAB       ,":kB:.f."  },
  { CCPLPAGE        ,":kN:^Z"   },
  { CCMIPAGE        ,":kP:^X"   },
  { CCOPEN          ,":kA:k2"   },
  { CCCLOSE         ,":kL:k3"   },
  { CCENTER         ,":kE:k1"   },
  { CCDELCH         ,":kD:k5"   },
  { CCINSMODE       ,":kI:k4"   },
  { CCPLLINE        ,":kF:k6"   },
  { CCMILINE        ,":kR:k7"   },
    /*
     *     ^C:
     */
  {  CCPLLINE       ,"^T"   }, /*   */
  {  CCMILINE       ,"^W"   }, /*   */
  {  CCDELCH        ,"^U"   }, /*   */
  {  CCSETFILE      ,"^D"   }, /*   */
  {  CCPICK         ,"^F"   }, /*   */
  {  CCPUT          ,"^G"   }, /*   */
  {  CCDOCMD        ,"^P"   }, /*   */
  {  CCRESCREEN     ,"^L"   },
  {  CCPLSRCH       ,"^R"   },
  {  CCMISRCH       ,"^E"   },
  {  CCSAVEFILE     ,"^V"   },
  {  CCBACKSPACE    ,"^H"   },
    /*
     *    
     */
  {  CCDRAWMODE     ,":F1"  },  /* F11 */

  {  0,0}, {  0,0},  { 0,0},  { 0,0},
  {  0,0}, {  0,0},  { 0,0},  { 0,0},  { 0,0},
  {  0,0}, {  0,0},  { 0,0},  { 0,0},  { 0,0},
  {  0,0}, {  0,0},  { 0,0},  { 0,0},  { 0,0},
  {  0,0}, {  0,0},  { 0,0},  { 0,0},  { 0,0},
  {  0,0}, {  0,0},  { 0,0},  { 0,0},  { 0,0},
  {  0,0}, {  0,0},  { 0,0},  { 0,0},  { 0,0},
  {  0,0}, {  0,0},  { 0,0},  { 0,0},  { 0,0},
  {  0,0}, {  0,0},  { 0,0},  { 0,0},  { 0,0},
  {  0,0}, {  0,0},  { 0,0},  { 0,0},  { 0,0},

  {  0, 0 }
};

/*
 *   
 * ( -)
 */
int LkeySpace = 4096; /*       */
static char *PkeySpace, *PSpace;    /*        */
static int LSpace = 0;              /*   (), 0 -   */
static struct ex_int *PTab = (struct ex_int *)0;     /*       */
/*
 * ClearKeys(i) -   
 * i = 0 -   ,  
 * i = 1 -    (  termcap)
 */
void ClearKeys(m)
int m;
{
    register struct ex_int *iw;
    if ( m == 0 ) {
        iw = &inctab[DEFTABL];
	PTab = iw+1;
        while ( ++iw < &inctab[INCTABSZ] ) iw->excc = NULL;
    }
    if (LSpace) {
        free(PkeySpace);
        LSpace = 0;
    }
}

/*
 * char *AddKey(ac, av) -    
 * av[0] -  , av[1] -  
 * : 0 - O'KEY,    
 * char *AddCmd(int cmd, char *key) -   ,  
 *     cmd  key  
 */
char *AddKey(ac, av)
int ac; /* <0 - ac = 2,   cmd */
char **av;
{
    register struct ex_int *iw;
    int cmd,i;

    if (ac < 0) {
	cmd = -ac;
	ac = 2;
    } else {
	if (ac > 2 && *(av[2]) == '#')
	    ac = 2;
	if (ac != 2)
	    return("Must be: CC \"KeyValue\" ");
	cmd = makecc(av[0]);
	if (cmd < 0)
	    return("Illegal cmd");
    }
    if (PTab == 0) {
	for (iw = inctab;
	     (iw->excc != NULL) && iw < &inctab[INCTABSZ];
	     iw++) ;
	PTab = iw;
    }
    if (PTab > &inctab[INCTABSZ])
	return("Key table overflow");
    if (!LSpace)
	PSpace = PkeySpace
	       = salloc (LSpace = LkeySpace, sizeof(char));
    i = strlen(av[1])+1;
    if (PSpace + i > &PkeySpace[LSpace])
	return("Key space overflow");
    strcopy(PSpace, av[1]);
    PTab->excc = PSpace;
    PTab->incc = cmd;
    PTab++;
    PSpace += i;

    return(NULL);
}

char *AddCmd(cmd, key)
int cmd;
char *key;
{
    char *av[2];

    av[1] = key;
    if (cmd <= 0)
	return("Internal error");
    return(AddKey(-cmd, av));
}

/*  termcap */
int nfinc=8;
/*char *tgetstr(), *tgoto();*/
static char *stc;
static int ltc;
#define LTCM 400
int tcread();
int (*atcread)() = tcread;

/*
 * char *gettcs(tc) -
 *    "tc"
 * tc="XXYY..ZZ", (.   )
 */
char *gettcs(tc)
char *tc;
{
    char buftc0[LTCM], *buftc = buftc0;
    char *c;
    char tid[3];
    int i, fcase, casec = 0;
    c = tc;
    while (*c) {
	if (*c == '?') {
	    fcase = 1;
	    c++;
	} else
	    fcase = 0;
	if (*c == '\'') {
	    while ((*buftc++ = *++c) != 0);
	    buftc--;
	    break;
	}
	if ((*tc & 0340) == 0 || *tc == 0177) {
	    while ((*buftc++ = *c++) != 0) ;
	    buftc--;
	    break;
	}
	if (*c == '^') {
	    *buftc++ = (*++c == '?' ? 0177 : (*c & 037));
	    c++;
	    continue;
	}
	if (*c == '=') {
	    *buftc++ = *++c;
	    c++;
	    continue;
	}
	if (*c == ':' ) {
	    if (casec)
		break;
	    casec = 1;
	    c++;
	}
	*tid   = *c;
	tid[1] = c[1];
	tid[2] = 0;
	c += 2;
	i = (!tgetstr(tid, &buftc));
	if (i) {
	    if (fcase)
		continue;
	    if (!casec)
		return(0);
	    while (*c && *c != ':')
		if( *c++ == '=')
		    c++;
	    if (*c != ':')
		return(NULL);
	    c++;
	    buftc = buftc0;
	    continue;
	}
	buftc--;
    }
    *buftc++ = 0;
    if ((i = buftc - buftc0) > ltc) {
	if (i > LTCM)
	    return(0);
	stc = salloc(LTCM, sizeof(char));
	ltc = LTCM;
    }
    c = buftc0;
    buftc = stc;
    do {
	*stc++ = *c;
	ltc--;
    }
    while (*c++);
#ifdef TEST
    printf("%s=", tc);
    ptss(buftc);
#endif
    return(buftc);
}

/*
 *   termcap.
 *   fsd-s   2 ,    
 */
static char *buftc = NULL;
int GetTC(ifd, ailine)
FILE *ifd;
int  *ailine;
{
    register int c,co;
    register char *p;
    /*       -   */
    if (buftc == NULL)
	buftc = salloc(TBUFSIZE, sizeof(char));
    if (buftc == NULL)
	return(-1);
    /*  .  */
    p = buftc;
    c = '\n';
    /*     */
    while ( (c = ((co = c), getc(ifd)) )>= 0 )
    {
	if ( c == '\n' )                *ailine += 1;
	if ( !c )                       continue;
	if ( c == '\n' && co == '\\' )  continue;
	if ( co == '\n' && c == '.' )   break;
	if ( co == '\n' ) {
	    if (c == ' ' || c == '\t' )
		c = co;
	    continue;
        }
	if ( (p - buftc ) > 2047 )
	    return(-1);
	if ( p != buftc && p[-1] == ':' && co == ':' )
	    continue;
	*p++ = co;
    }
    *p++ = 0;
        return(0);
}

/*
 * it_compare(tp1,tp2) -
 *    
 * tp1->excc == tp2->excc == NULL - 0
 * tp1->excc == NULL - -1
 * tp2->excc == NULL - +1
 * scompare(tp1->excc,tp2->excc) -
 * != 0   -  
 *   tp2->excc  ,  tp1->excc ,  -1
 *  1
 */
static int it_compare(tp1, tp2)
struct ex_int *tp1, *tp2;
{
    register int i;

    if (tp1->excc == NULL && tp2->excc == NULL)
	return(0);
    /*      */
    if (tp1->excc == NULL)
	return(1);
    if (tp2->excc == NULL)
	return(-1);
    i = strcmp(tp1->excc, tp2->excc);
    if (i)
	return(i);
    /*  ,      */
    return((tp2->excc > tp1->excc) ? -1 : 1);
}

/*
 * tcread()
 *  .  :
 * 0 - term cap reading O'KEY
 * 1 - no termcap
 * 2 - not enoughf termcap
 */
int tcread()
{

#define USE_WIN_RESIZE 1
#if USE_WIN_RESIZE
#ifndef TIOCGWINSZ
#ifdef linux
#include <sys/termios.h>
#else /* not linux: solaris */
  /*  Solaris-2.3: */
#define TIOCGWINSZ  (('T'<<8)|104)
/* Windowing structure to support TIOCSWINSZ/TIOCGWINSZ */
struct winsize {
	unsigned short ws_row;          /* rows, in characters      */
	unsigned short ws_col;          /* columns, in character    */
	unsigned short ws_xpixel;       /* horizontal size, pixels  */
	unsigned short ws_ypixel;       /* vertical size, pixels    */
};
#endif /* linux/solaris */
#endif /* TIOCGWINSZ */
    struct winsize  size;       /* #31.w    */
    char *envstr ;              /* #31.w    */
#endif /* USE_WIN_RESIZE */

    char *fname;
    struct ex_int *iw, *ir;
    register int i;
    extern char *getenv();
    if (buftc == NULL) {
	buftc = salloc(2048, sizeof(char)) ;
	if (tgetent(buftc,getenv("TERM")) != 1)
	    return(1);
    }
    else if (tgetent(buftc,NULL) != 1)
	return(1);

#if USE_WIN_RESIZE
    /* -------- Termios-like window size.   #31.w -->>  */
    /*     Linux -         */
    if (ioctl( 2, TIOCGWINSZ, &size) < 0) {
	NLINES = tgetnum("li");
	LINEL  = tgetnum("co");
    } else {
	NLINES = size.ws_row;
	LINEL  = size.ws_col;
    }
    if ((envstr = getenv("LINES")  ) != (char *)NULL)
	NLINES = atoi(envstr);
    if ((envstr = getenv("COLUMNS")) != (char *)NULL)
	LINEL  = atoi(envstr);
printf("[1] rows=%d, cols=%d\n", NLINES, LINEL) ;
fflush(stdout);
    /* ----------------------------------   <<---   #31.w       */
#else  /* not USE_WIN_RESIZE */
    LINEL  = tgetnum("co");
    NLINES = tgetnum("li");
#endif /* USE_WIN_RESIZE */

    for (i = COSTART; i < COMCOD ; i++) {
	cvtout[i] = gettcs(cvtout[i]);
    }
    if (tgetflag("nb"))
	cvtout[COBELL]="\0";
    if (tgetflag("bs"))
	cvtout[COLT]="\010";
    if ((curspos = gettcs("cm")) != NULL)
	agoto = tgoto;
    if ((cvtout[COCURS] == NULL) && (cvtout[COOPEN] != NULL))
        cvtout[COCURS] = append(cvtout[COOPEN], append("*", cvtout[COCLOSE]));
    eolflag = !tgetflag("am") || tgetflag("xn");
    if (cvtout[COCURS] == NULL)
	cvtout[COCURS] = "@";
    if (LINEL <= 60 || NLINES < 8)
	return(2);
    if (LINEL > LINELM)
	LINEL = LINELM;
    if (NLINES > NLINESM)
	NLINES = NLINESM;
    if (!curspos)
	for (i = 0; i < COERASE; i++)
	    if (cvtout[i] == NULL)
		return(2);
#ifdef RED_CYRILL
    /* Red can in/out cyryll without the system
     * latf, but tty is cyrillic
     */
    if (tgetflag("CY") && (cvtout[COCYON] == NULL)) {
        cvtout[COCYON] = DFL_CYON; 
        cvtout[COCYOFF] = DFL_CYOFF; 
    }
    if (!lcasef && latf && cvtout[COCYON] && cvtout[COCYOFF]) {
        Rcyflag = 1; 
        latf=0; 
    }
    if (((fname = gettcs(TABLENAME)) != NULL) &&
	(i = open(fname,0))) {
#ifndef NO_AOUT
	lseek(i, (long)(sizeof (struct exec)), 0);
#endif
	if (read(i, &tablecod, (sizeof tablecod)) != sizeof tablecod)
	    Rcyflag = 0;
        close(i);
    }
#endif
    if ((cvtout[COSRFWD] == NULL) &&
	((cvtout[COSRFWD] = gettcs("nl")) == NULL))
        cvtout[COSRFWD] = "\n";
    ch_scroll = gettcs("cs");
    if (ch_scroll && (cvtout[COSRBAK] != NULL))
	can_scroll = ROLL_CS;
    else if ((cvtout[COILINE] != NULL) &&
	     (cvtout[CODELIN] != NULL))
	can_scroll = ROLL_IL;
    else if ((cvtout[COSRBAK] != NULL) &&
	     (cvtout[COCLLIN] != NULL) &&
	     (cvtout[COCLSCR] != NULL))
        can_scroll = ROLL_SF;
    /* If scroll - define default/+line for RETURN */
    if (can_scroll) {
        on_scroll = 1;
	if (can_scroll != ROLL_SF)
	    defreturn = PL1MOVEW;
    }
    /*
     *   -
     */
    get_gch();
    /*
     *   
     */
    ir = iw = inctab;
    while (ir->excc) {
	if ((iw->excc = gettcs(ir->excc)) != NULL) {
	    iw->incc = ir->incc;
            iw++;
	} else
	    nfinc++;
        ir++;
    }
    PIT;
    /*
     *   
     */
    iw->excc = NULL;
    iw->incc = 0;
    qsort(inctab, iw - inctab, (sizeof (struct ex_int)), it_compare);
    PIT;
    /*
     *     ,  
     */
    ir = iw = inctab;
    while ( ir->excc ) {
	while ((ir+1)->excc && strcmp((ir+1)->excc,ir->excc) == 0)
	    ir++;
	if (ir != iw)
	    *iw = *ir ;
	ir++ ;
	iw++;
    }
    /*    */
    while (iw < &inctab[INCTABSZ])
	iw++->excc = 0;
    PIT;
    *toup = cvtout[KB_UP];
    BC = cvtout[KB_LT];
    free(buftc);
    ClearKeys(1);

    return(0);
}

/*
 * grapf_gg[i]="GG"
 * GG -   TERMCAP,      
 * ins_how[i] = "nnnnnnnnnnn"
 * nnnn -    , +1. 0 -  
 * \77 -  -  
 *
 *     :  g2   g1 ,
 *        .  g2.
 *
 * g_table[]:
 *          1 - . 
 *          2 -   
 *          3 - . 
 *
 *          4 - BL  (    )
 *          5 - BM  ( T           )
 *          6 - BR  (   )
 *          7 - ML  ( T            )
 *         10 - CC  (              )
 *         11 - MR  ( T           )
 *         12 - TL  (   )
 *         13 - TM  ( T          )
 *         14 - TR  (  )
 *
 *         15 -     (            )
 *         16 -    (             )
 *         20 -    (     )
 *         21 -   (    )
 */

#if 0
#define G_g1 1
#define G_g2 2
#endif

/*
 *    g_table[].
 */
static struct pgdes {
    char *gg;       /*   termcap */
    int  idx;       /*   G_START */
} graf_des[] = {
  { "g1",   G_INDX(G_GH)        },
  { "g2",   G_INDX(G_DGH)       },
  { "g3",   G_INDX(G_DHGH)      },
  { "g4",   G_INDX(G_DVGH)      },
  { "g5",   G_INDX(G_KR)        },
  { "g6",   G_INDX(G_SQU)       },
  { NULL,   G_INDX(G_END + 1)   }
};
/*
 *   .
 *
 *  g_table[] -  ,  "gs"/"ge".
 *  g0table[] - draft- (ASCII-).
 *
 *     red   "gt",
 *     ,   .
 *  gt = "-*!+-+!+!+-+&;<>"
 */
#if 0
    /*"gt",        */
/*"\1\2\3\4\5\6\7\10\11\12\13\14\15\16\17\20\21", */ /* "gt" */
#endif

static char buf_grc[G_END - G_START + 2] ;
char *g_table;      /*   buf_grc[] */

char g0table[G_END - G_START + 2] =
    "-|+-+|+|+-+=I+=+I+I+=+=|+=+|+|+=+-I+-+I+I+-+><~!*+}{^v~_[]#%&" ;
/*   ---g1------====g2=====----g3-----====g4=====----g5----==g6===  */

void get_gch()
{
    struct pgdes *gt;
    register char *gi, *p;
    register int i;

    g_table = buf_grc;
    for (p = g_table; p < &buf_grc[sizeof(buf_grc)]; )
	*p++ = 0 ;
    if ((cvtout[COGSTART] == NULL) &&
	(cvtout[COGEND]   == NULL)   )
    {
	/*  g0table[] - dumb grafics */
	return;
    }
    for (gt = graf_des; gt->gg != NULL; gt++) {
	gi = gettcs(gt->gg);
	if (gi == NULL)
	    continue;
	for (i = gt->idx; (i < (&gt[1])->idx) && *gi; ) {
	    g_table[i++] = *gi++;
        }
    }
#if 0
    /*
     *  ,     ,    
     *  
     */
    if (graf_gg[G_g1] && (gi = graf_gg[G_g2]))
	g_table[014] = gi[1];
#endif

    return;
}

#ifdef TEST1
# include <stdio.h>
void pttt()
{
    register struct ex_int *fr;
    register char *c;
    char buf[128];

    fr = inctab;
    while (fr < &inctab[INCTABSZ]) {
	if (fr->excc) {
	    fprintf(stderr,"%d: %d = ",fr-inctab, fr->incc);
	    for(c= fr->excc ; *c ;c++)
		if ( *c&0340 )
		    putchar(*c);
		else
		    fprintf(stderr, "\033[7m%c\033[m", (*c) + 0100);
	    putchar(012);
	}
	fr++;
    }
    gets(buf);
}
#endif

