/*
 *  $Id: S.ttyio.c,v 2.3 2001/08/09 10:02:38 w Exp w $
 *
 *   RED.
 *
 *     : / , /.
 *    .
 *   
 *
 *  $Log: S.ttyio.c,v $
 *  Revision 2.3  2001/08/09 10:02:38  w
 *  Legacy restriction removed: 32767 lines maximum at writing
 *  editing result.
 *  Fixes for ANSI-fication, "-fwritable-strings -Wtraditional"
 *  options do not reqired anymore, and -Wall going well.
 *  Some fixes "0 vs. NULL" pointers.
 *  New undocumented feature: "arg: 0l rpl ..." work with
 *  whole file now.
 *  'register' type qualifyer on the way of removing.
 *  dumpfsd() fixed to be functional (enabled by -DDEBUG).
 *  [s]append(...,"") using improved a bit.
 *  dumpfsd() activation changed to ^X.
 *  Version numbering changed to major.minor.ext.build scheme.
 *
 *  Revision 2.2  1998/05/13 18:34:30  w
 *  ANSI-     glibc  redhat-5.0.
 *       .
 *
 *  Revision 2.1  1997/06/12 23:15:29  w
 *    gt.
 *          -8,
 *     g_table (  ).
 *    .
 *      splitline(), openlines(). ( ""
 *      ).
 *    CSI (0233).
 *    cntrl- (  ,
 *    termio (BSD)):      (0377).
 *   /    ""   .
 *
 *  Revision 2.0  1997/05/30 18:33:56  w
 *  !!!
 *  Red   8- (control-   ).
 *         .
 *
 *  Revision 1.2  1997/04/26 13:32:03  w
 *   
 *
 *  Revision 1.1  1997/04/26 09:48:37  w
 *  Initial revision
 *
 * Revision 4.20  90/05/22  23:22:28  alex
 * First rev. red 4.2
 * 
 * Revision 4.10  90/02/05  19:52:38  alex
 * Base revision 4.1
 * 
 * Revision 4.10  90/02/05  19:49:23  alex
 * Base revision 4.1
 * 
 * Revision 4.5  88/04/07  12:19:20  alex
 *    .
 * 
 * Revision 4.4  88/04/07  12:02:13  alex
 *     setscroll.
 * 
 * Revision 4.3  88/04/04  22:16:14  alex
 *        ( CS).
 * 
 * Revision 4.2  88/03/31  22:50:29  alex
 *       .
 * 
 * Revision 4.1  88/03/31  22:06:09  alex
 *  4.1 -   UTEC, 
 * 
 * Revision 3.17  88/03/30  17:25:07  alex
 *    readch.    /
 *     ChangeScroll/InsertLine-DeleteLine.
 * 
 * Revision 3.1.2.5  87/07/09  20:44:11  alex
 * REVISION
 * 
 * Revision 3.1.2.4  87/07/03  22:03:56  alex
 * Graph_characters used in margin
 * 
 * Revision 3.1.2.3  87/06/24  22:36:46  alex
 * New readch + gettc + tc table Tested
 * 
 * Revision 3.1.2.2  87/06/23  18:55:33  alex
 *  lread1  .
 * 
 * Revision 3.1.2.1  87/06/19  16:56:43  alex
 * Start revision for red/4
 * 
 * Revision 3.16  87/06/12  18:07:21  alex
 *     vilcase    vt-200
 * 
 * Revision 3.15  87/06/09  19:45:28  alex
 *    tty ~ VT200  15--0013
 * 
 * Revision 3.14  87/06/05  23:48:29  alex
 *  roll    sr/sf  
 *     -t +  
 * 
 * Revision 3.13  87/06/04  23:41:52  alex
 * Scroll on -sr- or -al/dl- added
 * 
 * Revision 3.12  87/04/21  22:46:30  alex
 * Debug
 * 
 * Revision 3.11  87/04/21  22:28:57  alex
 *    writefile.
 * 
 * Revision 3.10  87/04/02  18:29:44  alex
 *   Utec       
 * 
 * Revision 3.9  87/04/01  19:14:19  alex
 * Revision for Utec: Cs, Ce, Ct, hR
 * 
 * Revision 3.8  86/11/25  08:06:26  alex
 *  ioctl(..,TIOCFLUSH,&flag)
 * 
 * Revision 3.7  86/10/29  02:46:37  root
 *   escape-    .
 *      .
 * 
 * Revision 3.6  86/10/14  23:02:52  alex
 *   : RUSDIAG (  latdiag),   LCASEO
 * (KI40BIT   ,   lcasef  1).
 *  -1700  2 ,  .    LCASE .
 * 
 * Revision 3.5  86/09/19  21:39:35  alex
 * 
 * 
 * Revision 3.4  86/09/19  19:59:39  alex
 *   -1700
 * 
 * Revision 3.3  86/08/04  20:55:13  alex
 * Bepqh dk LMNQ/DELNQ 2
 * 
 * Revision 3.2  86/07/24  19:07:48  alex
 * '      
 *
 * Revision 3.1  86/04/20  23:43:21  alex
 *    .
 *
 * Revision 3.1  86/04/20  23:43:21  alex
 * *** empty log message ***
 */

#include "r.defs.h"
/*#include "S.tele.h"*/

/*public*/ int Cyin=0, Cyout=0;     /* used if defined RED_CYRILL */

#ifdef TERMIO
#include <termio.h>
#define  stty(des,fil) ioctl(des,TCSETA,fil)
#define  gtty(des,fil) ioctl(des,TCGETA,fil)
#define  sgttyb termio
#undef TIOCSETA
#undef TIOCGETC
#undef TIOCSLTC
#else
#include <sgtty.h>
#endif

#ifndef TERMIO
#include <sys/types.h>
#include <sys/file.h>
#endif

#define NPUTCBUF 256   /*    */

#ifdef TIOCSETA
#define stty(des,fil) ioctl(des, TIOCSETA, fil)
#define gtty(des,fil) ioctl(des, TIOCGETA, fil)
#endif

#ifdef SGTTYB /*  -2 */
#define sgttyb SGTTYB
#endif

#ifndef ANYP
#define ANYP (ODDP | EVENP)
#endif

struct sgttyb save_sgttyb;

#ifdef TIOCGETC
struct tchars save_tchars;
#endif

#ifdef TIOCSLTC
static struct ltchars tmp_ltchars, old_ltchars;
#endif

int local, localo;
int ospeed;         /*  termcap */
int cy40bit;        /*    .  */
int lcasef0;        /*   lcase   */
int latdiag;
int vilcasef;
int video_mode;     /* 0 -  , 1 -   */
int firststart = 1; /* 0 -     startup */

/*
 * ttstartup()
 *   
 */
void ttstartup()
{
    static struct sgttyb red_sgttyb;
    char *getenv();
#ifdef TIOCGETC
    static struct tchars red_tchars;

    if (!firststart)
	goto set_start;
    ioctl(2, TIOCGETC, &save_tchars);
    red_tchars = save_tchars;
    if (red_tchars.t_intrc=='\177')
	red_tchars.t_intrc = 3;        /* ETX - interrupt of RE */
    red_tchars.t_quitc = -1;
#else
    if (!firststart)
	goto set_start;
#endif
#ifdef TIOCSLTC
    ioctl(2, TIOCGLTC, &tmp_ltchars);
    old_ltchars = tmp_ltchars;
    tmp_ltchars.t_suspc = tmp_ltchars.t_dsuspc = tmp_ltchars.t_flushc = -1;
#endif
    gtty(2, &save_sgttyb);
# ifdef LOCALSET
    ioctl(2, TIOCLGET, &local);
    localo = local;
    local = LOCALSET(local);
# endif
#ifdef TERMIO
    red_sgttyb = save_sgttyb;
    lcasef = LCASEF(red_sgttyb);
    ospeed = red_sgttyb.c_cflag & CBAUD;
    latf   = LATFLG(red_sgttyb);
    kioutf = KIOFLG(red_sgttyb);
#else
    red_sgttyb = save_sgttyb;
    ospeed = save_sgttyb.sg_ospeed;
    lcasef = lcasef0 = LCFLG(save_sgttyb.sg_flags);
    latf = LATFLG(save_sgttyb.sg_flags);
    if (lcasef)
	latf = 0;
    kioutf = KIOFLG(save_sgttyb.sg_flags);
#ifdef KI40BIT
    cy40bit = KI40BIT(save_sgttyb.sg_flags);
#endif
#endif
    if (atcread) {
	register int i;

	i = (*atcread)();
	atcread = (int (*)())NULL;
	if (i) {
	    if (latf)
		latdiag = 1;
	    printf((i == 1 ?
		   DIAG("unknown term capabilities\r\n please, set TTY type (`setenv TERM type' for csh) r\n and repeat red\r\n",
			"    , \r\n   TERM (`setenv TERM '  csh)\r\n   \r\n")
			   :
		   DIAG("re can not work with this terminal\r\n",
			"red      \r\n")));
	    exit(1);
	}
    }
    if (latf)
	latdiag = 1;
#ifndef TERMIO
    red_sgttyb.sg_flags = REDFLG(red_sgttyb.sg_flags);
    if (lcasef)
	red_sgttyb.sg_flags = REDFLGL(red_sgttyb.sg_flags);
    if (lcasef && cvtout[COVIOPE]) {
	vilcasef = 1;
	lcasef = 0;
    }
# ifdef TIOCSETA
    red_sgttyb.sg_length = 0;
    red_sgttyb.sg_width = 0;
#  ifdef Y_SIGSTOP
    red_sgttyb.sg_suspc = red_sgttyb.sg_dsuspc = -1;
#  endif
#  ifdef TIOCSLTC
    red_sgttyb.sg_flushc = -1;
#  endif
# endif
#else
    if (red_sgttyb.c_cc[VINTR] == 0177)
	red_sgttyb.c_cc[VINTR] = 3;
    {
	register int i;
	for (i = 1; i < NCC /*NCCS*/ ; i++)
	    red_sgttyb.c_cc[i] = 0 ; /* 0377 ; */
    }
    red_sgttyb.c_iflag = IXON | IXOFF | ((INPCK) & red_sgttyb.c_iflag);
    red_sgttyb.c_oflag = (red_sgttyb.c_oflag & (~OPOST));
    if (latf)
	red_sgttyb.c_cflag = ((red_sgttyb.c_cflag) | CREAD);
    else
	red_sgttyb.c_cflag = ((red_sgttyb.c_cflag & (~PARENB)) | CS8 | CREAD);
    red_sgttyb.c_lflag = ECHOK | ISIG;
    red_sgttyb.c_cc[VMIN ] = 1;
    red_sgttyb.c_cc[VTIME] = 2;
    if (lcasef && cvtout[COVIOPE]) {
	vilcasef = 1;
	lcasef = 0;
    }
#endif
set_start:
#ifdef TIOCGETC
    ioctl(2, TIOCSETC, &red_tchars);
#endif
#ifdef TIOCSLTC
    ioctl(2, TIOCSLTC, &tmp_ltchars);
#endif
# ifdef LOCALSET
    ioctl(2, TIOCLSET, &local);
# endif
    stty(2, &red_sgttyb);
    video_mode = 1;
    firststart = 0;
}

/*
 * ttcleanup()
 *   
 */
void ttcleanup()
{
    setscroll(&wholescreen,0);
    putcha(COGEND);
    setatr(A_NORM);
    putcha(COFIN);
    dumpcbuf(0);
    printf("\n");
    stty(2, &save_sgttyb);
#ifdef TIOCSLTC
    ioctl(2, TIOCSLTC, &old_ltchars);
#endif
#ifdef TIOCGETC
    ioctl(2, TIOCSETC, &save_tchars);
#endif
#ifdef LOCALSET
    ioctl(2, TIOCLSET, &localo);
#endif
    video_mode = 0;
}

/*
 * pcursor(col,lin) -
 *      
 * .  0,    
 */
int pcursor(col,lin)
int col,lin;
{ 
    register char *c,sy;

    if ((c = curspos) == NIL)
	return 0;
    if (agoto)
	c = (*agoto)(curspos, col, lin);
    if (*c == 'O')
	return(0);
    while ((sy = *c++)) {
	if (!agoto && (sy & 0200)){
	    if (sy & 0100)
		sy = (sy & 077) + col;  /* 300 - col */
	    else
		sy = (sy & 077) + lin;
        }                        /* 200 - lin */
        putchb(sy);
    } 
    return (1);
}

/* ===================
 *    
 * ===================
 */

char putcbuf[NPUTCBUF];
int iputcbuf = 0;

/*
 * putcha(c) -   "c".
 * "c"    .
 *  0,    
 */
static int graphcase = 0;

int putcha(c)
register int c;
{
    register char cr, *s;
    int vineed, needgraph;
    int atr, i;
    static int vicase = 0;

    /* c &= 0377;       */
    /*c &= 0x7fff ;     */
    atr = c & ATRMASK ;
    c &= NONATRMASK ;

    /*------------------------------------------------------*
     *         (CO*),
     *         cvtout[]
     *------------------------------------------------------*/
    if (ISCOM(c)) {
	if (c == COSTART || c == COFIN)
	    n0scroll = n1scroll = -1;
	if ( c == COERASE   ||
	     c == COFIN     ||
	     c == COILINE   ||
	     c == CODELIN )
	{
	    if (graphcase)
		putcha(COGEND);
	    setatr(A_NORM);
	}
	if (c == COGSTART)
	    graphcase = 1;
	if (c == COGEND)
	    graphcase = 0;
	if ((s = cvtout[c]) == NULL)
	    return(0);
	while ((cr = *s++) != 0)
	    putchb(cr);
        goto e;
    }
    if ((char)c == (char)(ESC2))
	c = '#';
    if (vilcasef) {
	vineed = 1;
	if (c >= 'A' && c <= 'Z')
	    c = c + 'a' - 'A';
	else if (RLPRO(c))  c = c + '' - '';
	else if (c=='`'  )  c = '\'' ;
	else if (c=='|'  )  c = '!'  ;
	else if (c=='}'  )  c = ')'  ;
	else if (c=='{'  )  c = '('  ;
	else if (c=='~'  )  c = '^'  ;
	else
	    vineed = 0;
	if (vineed != vicase)
	    putcha((vicase = vineed)
		   ? COVIOPE    /* termcap "vs" (Standout cursor) */
		   : COVICLO ); /* termcap "ve" (Normal cursor visible) */
    }
    /*----------------------------------------------*
     |  ' control-':
     |
     |  1.   -8.
     |             g_table.  
     |          
     |      '' red- (  
     |       vt100   xterm).
     |
     |  2.    
     |            .
     |        -,   
     |      UNICODE.    .
     *----------------------------------------------*/

    /*------  termcap----------------*/
    if (ISGCHAR(c)) {       /*  ? */
	if ((i = g_table[(c) - G_START])) {
	    c = i;          /*   termcap */
	    needgraph = 1;
	} else {            /*    termcap */
	    c = g0table[c - G_START];
	    needgraph = 0;
	}
    } else
	needgraph = 0;
    if (needgraph != graphcase) {
	if (needgraph) {
	    if (cur_atr != A_NORM) {
		i = setatr(A_NORM);
		putcha(COGSTART);
		setatr(i);
	    } else
		putcha(COGSTART);
	} else {
	    putcha(COGEND);
	}
    }
#ifdef RED_CYRILL
    if (Rcyflag) {
	if (ISCYRILL(c)) {
	    if (!Cyout)
		putcha(COCYON);
	    Cyout = 1;
	    c = OUTT(c);
	} else if (!ISANYCHR(c) && Cyout) {
	    putcha(COCYOFF);
	    Cyout = 0;
	}
    }
#endif  /* RED_CYRILL */
#ifdef LCASEO
    if (lcasef0 && !vilcasef)
	c = (c >= 'A'   &&
	     c <= 'Z' ? c + 040
		      : (c >= 0140 && c <= 0176 ? c + 0140
						: c       ) );
#endif  /* LCASEO */
    putcbuf[iputcbuf++] = c;
    if (iputcbuf >= NPUTCBUF)
	dumpcbuf();
e:
    return(1);
}

/*
 * putchb(c) -
 *     
 */
void putchb(c)
unsigned char c;
{
    /*---*
	    if ((c & 0377) == 0200)
		c = 0;
     *---*/
#ifdef LCASEO
    if (lcasef0)
	c = (c >= 'A' &&
	     c <= 'Z' ? c + 040
		      : (c >= 0140 && c <= 0176 ? c + 0140 : c));
#endif
    /*---*
	    if (c == 0200)
		c = 0;
     *---*/
    putcbuf[iputcbuf++] = c;
    if (iputcbuf >= NPUTCBUF)
	dumpcbuf();
    return;
}

/*
 * putblanks(k) -
 *   
 */
void putblanks(k)
register int k;
{   cursorcol += k;
    if ( graphcase ) {
	graphcase = 0;
	putcha(COGEND);
    }
    while (k--) {
        putcbuf[iputcbuf++] = ' ';
        if(iputcbuf == NPUTCBUF)  dumpcbuf();
    }
    dumpcbuf(); return;
}

/*
 * dumpcbuf() -
 *   
 */
void dumpcbuf()
{
    if (iputcbuf != 0)
	write(2, putcbuf, iputcbuf);
    iputcbuf = 0;
}

/*
 * setatr() -  -
 *   
 */
int setatr(atr)
int atr;
{
    register int j;

    j = cur_atr;
    if (graphcase && atr == A_NORM)
	putcha(COGEND); /*  - .    */
    if (atr != A_NORM && j != A_NORM)
	setatr(A_NORM);
    if (atr != cur_atr)
	if (ISATR(atr))
	    putcha(A2CO(atr));
    cur_atr = atr;

    return(j);
}

extern schar *M_p, *M_e;

schar *ps_inmac;
char  *ps_exin;
int (*pf_wmac)();
schar *rmacl();
static int litchar;
static int oldchar  = -1;
static int all_errors = 0;

/*
 *  -    ,      20 
 */
schar *rmacl();
#define MAXSTEK 64
static schar *b_stekm[MAXSTEK+1], **p_stekm = b_stekm;
#define S_IN(p) {\
    if ((p != NULL) && (p_stekm < &b_stekm[MAXSTEK]))\
	*p_stekm++ = p;\
}
#define S_OUT(p) {\
    if (p_stekm > b_stekm)\
	p = *--p_stekm;\
    else\
	p = NULL;\
}
/*
 * do_macro(cmd) -   "lc" (lc -   
 *  > 0 -  , < 0 -  
 */
int do_macro(lc)
int lc;
{
    S_IN(ps_inmac);
    if ((ps_inmac = rmacl(lc)) == NULL) {
	S_OUT(ps_inmac);
	return(0);
    }
    return(1);
}

/*
 *  readch()
 *     .
 *
 *  ,     
 *     .
 *      .
 *
 *  :
 *
 * oldchar      - ,     / unread1()
 * ps_inmac     -    
 * ps_exin      -     
 * (*pf_wmac)() -    ,    CCQUIT  
 * litchar      -  (.  - )
 * rmacl(name)  -    
 */
int readch()
{
#define GETSY1(c,g) if (read(inputfile, &c, 1) != 1 || intrflag )\
			goto g;\
		    else

    register int lc;
    char sy;

    if (oldchar != -1) {
	lc = oldchar;
	oldchar = -1;
	return(lc);
    }
    dumpcbuf();
rmacro:
    if (inputfile)
	if ((lc = readfc()) != -1)
	    goto after_proto;
/*  .       */
    if (ps_inmac != NULL) {
	lc = *ps_inmac++ ;
	lc &= 0377;
	if (intrflag || *ps_inmac == 0)
	    S_OUT(ps_inmac);
	if (ISMACRO(lc)) {
	    (void)do_macro(lc);
	    goto rmacro;
	}
	goto w_proto;
    }
    if (ps_exin != NULL) {
	lc = *ps_exin++ ;
	lc &= 0377;
	if (*ps_exin == 0)
	    ps_exin = NULL;
	goto after_in;
    }
/*
 *   
 */
new:
#ifdef RED_CYRILL
    if (Rcyflag && Cyin != Cyout ) {
	infmesg(Cyin ? "R" : " ", PARAMRLANG + 1, A_OUT);
	putcha(COCYON + 1 - Cyin);
	Cyout = Cyin;
	dumpcbuf();
    }
#endif RED_CYRILL
    intrflag = 0;
    GETSY1(sy, readquit);
    lc  = sy ;
    lc &= 0377;
    if(litchar) {
	if( lc < 040)
	    lc = (lc & 037) | '@';
	litchar = 0;
	goto after_in;
    }
#ifdef RED_CYRILL
    if (Rcyflag) {
	if( lc == CHA_RUS) {Cyin = 1; goto new; }
	if( lc == CHA_LAT) {Cyin = 0; goto new; }
	if( Cyin == 1 && lc >= 040 && lc < 0177) lc = INTT(lc);
    }
#endif RED_CYRIILL
    if (ISCTRL(lc)) {
	struct ex_int *i1, *i2;
	int ts, k;

	i1 = i2 = NULL;
	ts = 0;
	sy = lc;
	while ((k = findt(&i1, &i2, sy, ts++)) == CONTF) {
	    GETSY1(sy, readquit);
	    if (sy & 0200)
		sy = STASCII(cy40bit ? (sy^040) : sy);
	}
	if (k == BADF) {
#ifndef TERMIO
	    int flag = FREAD;
	    putcha(COBELL);
	    dumpcbuf();
	    ioctl(inputfile, TIOCFLUSH, &flag);
#else
	    putcha(COBELL);
	    dumpcbuf();
	    ioctl(inputfile, TCFLSH, 0);
#endif
	    if (all_errors++ < 2)
		goto new;
	    k = CCHELP;
	}
	all_errors = 0;
	lc = k;
	if (lc == CCMAC) {
	    GETSY1(sy, readquit);
	    if (sy & 0200)
		sy = STASCII(cy40bit ? (sy ^ 040) : sy);
	    if (sy >= 'a' && sy <= 'z') {
		lc = sy - 'a' + CCMAC + 1;
	    } else
		goto new;
	}
	goto after_in;
    }
    /* ========================================================= */
    /*      lcase */
    if ((lcasef || latf) && (lc >= '@')) {
#define LBUFWSY 5
	static char bufwsy[LBUFWSY + 1];
	char bufr[2];
	char *si = bufr, *so = bufwsy;
	int i;
#ifndef MNOS
#ifndef LCASEO
	if (lcasef && (lc >= 0300))
	    lc ^= 040;      /* - */
#endif
#endif
	i = 1;
	bufr[0] = lc;
	exinss(&si, si + 1, &so, &i, LBUFWSY - 1);
	*so = 0;
	lc  = bufwsy[0] ;
	lc &= 0377;
	if (so != bufwsy + 1)
	    ps_exin = bufwsy + 1;
    }
/*
 *    
 */
after_in:
/*   */
    if ( M_p && !ADD_MACRO(lc))
	goto new; /*   */
/*   */
    if (ISMACRO(lc)) {
	if (do_macro(lc))
	    goto rmacro;
	else
	    goto new;
    }
    if (lc == CCCTRLQUOTE) {
	litchar = 1;
    }
w_proto:
    if (ttyfile > 0) {
	sy = lc;
	/*write(ttyfile, &sy, 1);      #31.w */
	PUTP(((schar)lc));   /* #31.w */
    }
after_proto:
    return(lc);
readquit:
    if (intrflag) {
	lc = CCENTER;
	intrflag = 0;
    } else
	lc = CCQUIT;
    goto w_proto;
}

void unread1(ch)
int ch;
{
    oldchar  = ch ;
    oldchar &= 0x7fff ;
}

static int isy0f = -1;
/*
 * readfc()
 * -     
 *    0,   
 */
int readfc()
{
    register int lread1;
    schar sy1 = CCQUIT;

    do {
	lread1 = isy0f;
	/*---*
	if ( intrflag || (read(inputfile, &sy1, 1) != 1))
	 *---*/
	if (intrflag ||
	    (read(inputfile, &sy1, sizeof(schar))
	     != sizeof(schar)))
        {
	    if (inputfile != ttyfile)
		close (inputfile);
	    else
		lseek(ttyfile, (long)(-1), 1);

	    inputfile = 0;
	    intrflag  = 0;
            putcha(COBELL);
            dumpcbuf();
	    return (-1);
        }
	isy0f  = sy1 ;
	isy0f &= 0x7fff ;

    } while (lread1 < 0);

    return (lread1);
}

/*
 * intrup() -
 *       ,    .
 */
int intrup()
{       
    int sy1;
    if (inputfile) {
        if(isy0f == CCINTRUP ){
	    isy0f = -1;
	    S_OUT(ps_inmac);
            return(1);
	} else
	    return(0);
    } else {
	if(intrflag) {
	    intrflag = 0;
	    sy1 = CCINTRUP;

	    /*write(ttyfile, &sy1, 1);      #31.w */
	    PUTP(sy1);   /* #31.w */

	    S_OUT(ps_inmac);
            return(1);
        }
        return(0);
    }
}

#define CCDEL 0177
/* read2() -
 *     ,   
 *       .   
 *      .
 */
char read2()
{
    char c;
    register int lread1;

    if (inputfile && (lread1 = readfc()) != -1)
	return(lread1);
    if (read(0, &c, 1) != 1) {
	c = CCDEL;
        intrflag = 0;
    }
    c &= 0177;

    /*write(ttyfile, &c, 1);    #31.w */
    PUTP(c);   /* #31.w */

    return(c);
}

/*
 * writefile -
 *       
 */

void writefile(code1, str, code2)
int code1, code2;
char *str;
{
    /* -->> #31.w -- *
	    char cd1 = code1, cd2 = code2;

	    write(ttyfile, &cd1, 1);
	    for (; *str; str++) {
		write(ttyfile, str, 1);
	    }
	    write(ttyfile, &cd2, 1);
     * <<-- #31.w -- */

    /* #31.w -->> */
    PUTP(code1);
    for (; *str; str++) {
	PUTP(*str);
    }
    PUTP(code2);
    /* <<-- #31.w */
}

/*
 * findt (&fb,&fe,sy,ns) -
 *   .
 * struct ex_int * (fb , fe) = NULL  
 *     .
 *      .
 *  :
 * CONTF -   ,
 * BADF  -     ,
 * >= 0   -  .
 */
int kioutf;
/*VARARGS*/
int findt (fb, fe, sy, ns)
struct ex_int **fb, **fe; 
char sy; 
int ns;
{ 
    char sy1; 
    register struct ex_int  *fi;

    fi = ( (*fb != NULL) ? *fb : inctab);
    *fb = NULL;
    if (sy == 0)
	return BADF;
    if (kioutf && (sy & 0100))
	sy |= 0240;                 /*     */
    for (; (fi != *fe); fi++ ) {
	if ((*fe == NULL) && (fi->excc == NULL) )
	    goto exit;
	sy1 = fi->excc[ns];
	if (kioutf && (sy1 & 0100))
	    sy1 |= 0240;            /*   .  */
	if (*fb != NULL) {
	    if (sy != sy1) goto exit;
	} else {
	    if (sy == sy1)
		*fb = fi;
        }
    }
exit: 
    *fe = fi;                   /* for "addkey" */
    if (*fb == NULL)
	return BADF;
    fi = *fb;
    if (fi->excc[ns+1])
	return CONTF;
    return (fi->incc);
}

/*---  findt
main()
  { char *s = "\017abz"; int i,j,k,l,m,is;
	i=j=k=l=m=0;
	for(is=0;*s; is++)
	{ k=findt(&i,&j,*s++,l++); if(k!=CONTF) goto ex1; }
ex1:   printf(" k= %d is= %d pt %o %o ", k,is,i,j);
  }
 t(i) int i; {return;}
---*/

/*
 * addkey(cmd,key) -
 *    
 *        
 */
extern int nfinc; /*      */
int addkey(cmd,key)
int cmd; 
char *key;
{ 
    struct ex_int *fb,*fe; 
    register struct ex_int *fw;
    register int ns,i;
    ns=0; 
    fb = fe = 0;
    while((i = findt(&fb, &fe, key[ns], ns)) == CONTF && key[ns++]);
    if(i != BADF) {
        telluser(DIAG("key redefined",""),0);
        fw = fb; 
        goto retn;
    }
    /*   =    */
    if (!nfinc) {
        error(DIAG("too many key's"," "));
        return(0);
    }
    fw = fe; nfinc--;
    while((fw++)->excc);
    do {
        *fw = *(fw-1);
    } 
    while(--fw != fe);
retn:   
#ifdef TEST
test("addkey out");
#endif
    fw ->excc = key;
    fw->incc = cmd;
    return(1);
}
#ifdef TEST
test(s) char *s;
{printf("test: %s\n",s); return(0);}
#endif

/*
 * scroll(n,bl) -    n   (),  
 *  bl. bl <0 == bl = -1-bl,    -  ,  
 *  0,   ,  1
 */
int scroll(n,bl)
int n,bl;
{
    register int i;
    int dll,ill,nl;
    int no_sf;      /*  -     sf */
#define PUTCC(c, n) for (i = n; i > 0; i--) putcha(c)

    if (!(curport->flags & WF_ROLL)) {
	/*
	 *    roll
	 */
	i = WF_NROLL;
	if (!can_scroll)
	    goto ex;
	if (curport->lmarg != 0 ||
	    curport->rmarg != wholescreen.rmarg)
	    goto ex;
	if(can_scroll == ROLL_SF
	    && (curport->tmarg != 0
	    ||  curport->bmarg != wholescreen.bmarg - NPARAMLINES))
	    goto ex;
	i = WF_YROLL;
ex:
	curport->flags |= i;
    }
    if (!(curport->flags & WF_YROLL))
	return(0);
    if ( n == 0 )
	return(1);
    no_sf = 0;
    if (bl < 0 ) {
	no_sf = 1; bl = -bl -1;
    }
    if (  n + bl > curport->btext - 2 ||
	- n + bl > curport->btext - 2    )
	return(0);
    switch(can_scroll) {
	case ROLL_CS:
	    if (!setscroll(curport,bl))
		return(0);
	    if (n > 0) {
		poscursor(0, curport->btext);
		PUTCC(COSRFWD,n);
	    } else {
		poscursor(0,bl);
		PUTCC(COSRBAK, -n);
	    }
	    if (bl)
		setscroll(curport,0);
	    break;
	case ROLL_IL:
	    if(n > 0) {
		nl  = n;
		dll = bl;
		ill = curport->btext - nl+1;
	    } else {
		nl  = -n;
		dll = curport->btext - nl+1;
		ill = bl;
	    }
	    poscursor(0, dll);
	    PUTCC(CODELIN, nl);
	    poscursor(0, ill);
	    PUTCC(COILINE, nl);
	    break;
	case ROLL_SF:
	    if (no_sf)
		return(0);
	    {
		register struct viewport *w;
		w = curport;
		if ( n > 0 ) {
		    switchport(&wholescreen);
		    poscursor(0, wholescreen.bmarg);
		    PUTCC(COSRFWD, n);
		    switchport(w);
		    if(need_box != 2 )
		    {
			poscursor(-w->ltext, w->btext-n+1);
			putcha(COCLSCR);
		    }
		} else {
		    if(need_box != 2 ) {
			poscursor( - w->ltext, w->btext + n + 1);
			putcha(COCLSCR);
		    }
		    switchport(&wholescreen);
		    poscursor(0,0);
		    for(i = -n; i; i--)
			putcha(COCLLIN), putcha(COSRBAK);
		    switchport(w);
		}
		need_box = (n == 1 || n == -1) ? 1 : 2;
		new_info = 1;
		break;
	    }
	default:
	    return(0);
    }
    shiftview(bl,n);
    return(1);
}

/*
 * setscroll(viewp,begl) -    
 *   text  
 *    begl
 */
int setscroll(viewp,begl)
register struct viewport *viewp;
{
    char *c;
    extern char *tgoto();
    int l0, l1;
    struct viewport *cur_p;

    l0 = viewp->ttext;
    l1 = viewp->btext + l0;
    l0 += begl;
    if (l0 >= l1) return(0); /*    cs  1  */
    if (n0scroll == l0 && n1scroll == l1)
	return(1);
    if (!ch_scroll)
	return(0);
    c = tgoto(ch_scroll,  l1, l0);
    if (!c)
	return(0);
    cur_p = curport;
    switchport(&wholescreen);
    while(*c)
	putchb(*c++);
    putcha(COHO);
    cursorcol = cursorline = 0;
    switchport(cur_p);
    n0scroll = l0;
    n1scroll = l1;

    return(1);
}

