/*
 *  $Id: r.defun.h,v 1.2 2001/08/09 10:02:38 w Exp w $
 *
 *   RED.
 *
 *    .
 *
 *  $Log: r.defun.h,v $
 *  Revision 1.2  2001/08/09 10:02:38  w
 *  Legacy restriction removed: 32767 lines maximum at writing
 *  editing result.
 *  Fixes for ANSI-fication, "-fwritable-strings -Wtraditional"
 *  options do not reqired anymore, and -Wall going well.
 *  Some fixes "0 vs. NULL" pointers.
 *  New undocumented feature: "arg: 0l rpl ..." work with
 *  whole file now.
 *  'register' type qualifyer on the way of removing.
 *  dumpfsd() fixed to be functional (enabled by -DDEBUG).
 *  [s]append(...,"") using improved a bit.
 *  dumpfsd() activation changed to ^X.
 *  Version numbering changed to major.minor.ext.build scheme.
 *
 *  Revision 1.1  1998/05/13 18:34:30  w
 *  Initial revision
 *
 */
/*-- S.gettc.c --*/
void    ClearKeys(int m);
int     GetTC(FILE *ifd, int *ailine);
char    *AddCmd(int cmd, char *key);
char    *AddKey(int ac, char **av);
char    *gettcs(char *tc);
void    get_gch();
int     tcread();

/*-- S.termc.c --*/
char    *tgetstr(char *id, char **area);
int     tgetent(char *bp, char *name);
int     tgetflag(char *id);
int     tgetnum(char *id);
char    *tgoto(char *CM, int destcol, int destline);
int     tnamatch(char *np);
int     tnchktc();

/*-- S.ttyio.c --*/
int     addkey(int cmd, char *key);
int     do_macro(int lc);
void    dumpcbuf();
int     findt(struct ex_int **fb, struct ex_int **fe, char sy, int ns);
int     readch();
int     intrup();
int     pcursor(int col, int lin);
void    putblanks(int k);
int     putcha(int c);
void    putchb(unsigned char c);
char    read2();
int     readfc();
int     scroll(int n, int bl);
int     setatr(int atr);
int     setscroll(struct viewport *viewp, int begl);
void    ttcleanup();
void    ttstartup();
void    unread1(int ch);
void    writefile(int code1, char *str, int code2);

/*-- Vers.c --*/
char    *getvers();

/*-- r.cmd.c --*/
int     callexec();
void    do_select();
void    helpview();
void    mainloop();

/*-- r.edit.c --*/
int     catfsd(struct workspace *w);
void    charsin(int fi, int h, int l);
#ifdef DEBUG
void    checkfsd();
void    printfsd(struct fsd *f, FILE *fd);
void    dumpfsd(char *file);
#endif  /* DEBUG */
void    closelines(int frum, int number);
void    closespaces(int line, int col, int number, int nl);
void    combineline(int line, int col);
void    doreplace(int line, int m, int jproc, int *pipef);
void    excline(int n);
int     execr(char **args);
int     exinss(char **si, char *se, char **so, int *no, int mo);
void    freefsd(struct fsd *f);
int     getline(int ln);
void    insert(struct workspace *wksp, struct fsd *f, int at);
int     breakfsd(struct workspace *w, int n, int reall);
int     chars(int flg);
int     dechars(char *line, int n);
int     normhl(int ll, int *hh);
int     wseek(struct workspace *wksp, int lno);
void    openlines(int from, int number);
void    openspaces(int line, int col, int number, int nl);
void    pcspaces(int line, int col, int number, int nl, int flg);
void    picklines(int from, int number);
void    pickspaces(int line, int col, int number, int nl);
void    plines(struct savebuf *buf, int line);
void    pspaces(struct savebuf *buf, int line, int col);
void    put(struct savebuf *buf, int line, int col);
void    putbks(int col, int n);
void    putline(int nosave);
void    splitline(int line, int col);
struct fsd *blanklines(int n);
struct fsd *copyfsd(struct fsd *f, struct fsd *end);
struct fsd *delete(struct workspace *wksp, int from, int to);
struct fsd *file2fsd(int fname);
struct fsd *pick(struct workspace *wksp, int from, int to);
struct fsd *temp2fsd(int chan);
struct fsd *writemp(char *buf, int n);
void    switchfile(int dir);
void    switchpwksp();
void    switchwksp(int make);
int     undoedit(int f);
int     wposit(struct workspace *wk, int lno);

/*-- r.file.c --*/
int     editfile(char *file, int line, int col, int mkflg, int puflg);
int     endit();
int     fsdwrite(struct fsd *ff, int nl, int newf);
int     savefile(char *file, int n) ;

/*-- r.hlam.c --*/
int     abs(int number);
char    *Itoa(int ii);
char    *append(char *name, char *ext);
char    *getnm(int uid);
char    *s2i(char *s, int *i);
int     checkpriv(int fildes);
int     getpriv(int fildes);
int     get1c(int fd);
int     get1w(int fd);
void    put1c(char c, int fd);
void    put1w(short w, int fd);
int     run_shell(char *cmd);
schar   *sappend(schar *name, schar *ext);
int     seek(int fd, int shift, int dsk);
void    strcopy(char *a, char *b);
int     tostop();
void    *salloc(size_t n, size_t size);

/*-- r.lop.c --*/
void    compl_delims();
int     compl_parents();
int     line_cop(int *p_l, int *p_c, int op, char *str);
int     linecset(int op, char *arg);
int     lineop(int lr1);
void    new_delims();
void    new_parents();
void    search(int delta);
/*char    S_setup(int *P_l, int lin, int col);*/
void    FramesDraw(int lr1, int i);
int     word_op(int *p_l, int *p_c, int op, char *arg);

/*-- r.mac.c --*/
int     MacWrite(FILE *fd);
int     NewMacro(char *name, schar *macro);
int     defkey();
int     defmac(char *name);
int     MacCreate(char *name);
int     MacEnd(int f);
int     MacExpand(int cmd);
int     mdeftag(char *name);
int     mgotag(char *name);
int     msrbuf(struct savebuf *sbuf, char *name, int op);
int     msvtag(char *name);
schar   *rmacl(int isy);
int     set_param(int nfile, int line, int col);
union macro *mname(char *name, int typ, int l);

/*-- r.main.c --*/
void    cleanup();
void    fatal(char *s);
void    igsig();
void    makestate();
void    pt_info();
void    sig(int n);
void    testsig();
#ifdef SIGNOSPC
void werrsig();
#endif

/*-- r.mall.c --*/
#ifndef _STDLIB_H
void    botch(char *s);
char    *sbrk();
void    free(char *ap);
char    *malloc(unsigned nbytes);
#ifdef DEBUG
int     allock();
void    ptfree(FILE *fd);
#endif /* DEBUG */
#endif /* _STDLIB_H  */

/*-- r.pars.c --*/
int     Param_cmd();
int     SelectArgs(char *cp, char *execargs[], int maxargs);
int     WriteMFile(schar *mp, FILE *fd) ;
char    *ParseCmd(struct cmdstr *pd, int ac, char **av);
char    *makecs(int c);
int     makecc(char *s);
schar   *ReadMFile(char *(*r_proc)(), int (*err_proc)());

/*-- r.rdf.c --*/
void    MacRestore(char *path);
int     MacSave(char *path, int howstate);
int     MatchTname(int ac, char **av);
int     ReadInit(char *path, int sysinit);
void    StateRead(char *(*rline)(), int (*errpt)());
void    StateWrite(FILE *fd, int howstate);
int     ErrI(int ko, char *s);

/*-- r.tabs.c --*/
void    InitTabs();
void    TabWrite(FILE *fd);
char    *SetTab(int *tcol, char *cmd);
char    *settab(int tabcol, char *arg);

/*-- r.tele.c --*/
void    drawport(struct viewport *newp, int vertf);
void    error(char *msg);
int     fixcurs();
void    infmesg(char *msg, int col, int atr);
void    info(char *ss, int ml);
int     param(int macro);
int     movecursor(int arg, int fix);
void    out_cols(int c0, int cf);
void    out_lines(int l0, int lf);
void    out_mark(int lin, int col, int marka);
void    out_win(int l0, int lf, int c0, int cf);
void    poscursor(int col, int lin);
void    putch(int c, int flg) ;
int     shiftview(int n0, int nl);
void    telluser(char *msg, int col);

/*-- r.var.c --*/
char    *SetVar(char *name, char *av[], int ac);
void    VarEInit();
void    WriteSet(FILE *fd);
char    *StrCalc(char *s);
char    *getkeys(char *buf0, int len);
char    *next_path(char **pps);
int     do_set(char *str);
int     InitConsts();
int     setkeys(char *keys);

/*-- r.wind.c --*/
void    cgoto(int ln, int col, int slin, int lkey);
void    chgport(int portnum);
int     drop_wksp(struct viewport *port);
void    gtfcn(int number);
void    rescreen(int nom);
void    makeport(char *file);
void    movep(int nc);
void    movew(int nl, int fix);
void    redisplay(struct workspace *w, int fn, int from, int to, int delta, int fromd);
void    removeport();
void    setupviewport(struct viewport *ww, int cl, int cr, int lt, int lb, int c);
void    switchport(struct viewport *ww);
void    to_home(struct workspace *cp, struct viewport *port);
int     unzoom(int draw);
int     zoom_w(int back);

/*-- r.rpl.c --*/
int     advance(char *alp, char *aep);
int     cclass(char *aset, unsigned char ac, int af);
int     compile(char *astr);
int     dumpo();
void    execute(char *repl);
void    puto(char *p, int n);
