/*
 *  $Id: r.edit.c,v 2.3 2001/08/09 10:02:38 w Exp w $
 *
 *   RED.
 *
 *        RED
 *
 *  $Log: r.edit.c,v $
 *  Revision 2.3  2001/08/09 10:02:38  w
 *  Legacy restriction removed: 32767 lines maximum at writing
 *  editing result.
 *  Fixes for ANSI-fication, "-fwritable-strings -Wtraditional"
 *  options do not reqired anymore, and -Wall going well.
 *  Some fixes "0 vs. NULL" pointers.
 *  New undocumented feature: "arg: 0l rpl ..." work with
 *  whole file now.
 *  'register' type qualifyer on the way of removing.
 *  dumpfsd() fixed to be functional (enabled by -DDEBUG).
 *  [s]append(...,"") using improved a bit.
 *  dumpfsd() activation changed to ^X.
 *  Version numbering changed to major.minor.ext.build scheme.
 *
 *  Revision 2.2  1998/05/13 18:34:30  w
 *  ANSI-     glibc  redhat-5.0.
 *       .
 *
 *  Revision 2.1  1997/06/12 23:15:29  w
 *    gt.
 *          -8,
 *     g_table (  ).
 *    .
 *      splitline(), openlines(). ( ""
 *      ).
 *    CSI (0233).
 *    cntrl- (  ,
 *    termio (BSD)):      (0377).
 *   /    ""   .
 *
 *  Revision 2.0  1997/05/30 18:33:56  w
 *  !!!
 *  Red   8- (control-   ).
 *         .
 *
 *  Revision 1.2  1997/04/26 13:32:03  w
 *   
 *
 *  Revision 1.1  1997/04/26 09:48:37  w
 *  Initial revision
 *
 * Revision 4.20  90/05/22  23:21:45  alex
 * First rev. red 4.2
 * 
 * Revision 4.10  90/02/05  19:52:20  alex
 * Base revision 4.1
 * 
 * Revision 4.1  88/03/31  22:01:32  alex
 *  4.1 -   UTEC, 
 * 
 * Revision 3.8  88/03/30  17:28:23  alex
 *    readch.    /
 *     ChangeScroll/InsertLine-DeleteLine.
 * 
 * Revision 3.1.2.1  87/06/19  16:59:08  alex
 * Start revision for red/4
 * 
 * Revision 3.7  87/06/05  23:49:46  alex
 *  roll    sr/sf  
 *     -t +  
 * 
 * Revision 3.6  87/06/04  23:43:10  alex
 * Scroll on -sr- or -al/dl- added
 * 
 * Revision 3.6  87/04/01  19:15:20  alex
 * Revision for Utec: Cs, Ce, Ct, hR
 * 
 * Revision 3.5  86/10/14  23:00:35  alex
 *    exinss (     ).
 * 
 * Revision 3.4  86/09/19  19:50:59  alex
 *   -1700
 * 
 * Revision 3.3  86/08/04  20:50:56  alex
 * Bepqh dk LMNQ/DELNQ 2
 * 
 * Revision 3.2  86/07/24  00:23:08  alex
 * '      
 * 
 * Revision 3.1.1.4  86/06/16  22:16:48  alex
 *      ( )
 * 
 * Revision 3.1.1.2  86/06/06  00:13:40  alex
 *   
 * 
 * Revision 3.1.1.1  86/06/05  00:03:49  alex
 * __
 * 
 * Revision 3.1  86/04/20  23:40:53  alex
 *    .
 * 
 * Revision 3.1  86/04/20  23:40:53  alex
 * *** empty log message ***
 * 
 * Revision 1.5  86/04/13  21:57:54  alex
 *
 */

#include "r.defs.h"

int charskh,charskl,charscol;   /*   (  chars) */
#define NBYMAX 150      /* .    fsdbytes, +1 */
/*struct fsd *temp2fsd(),*delete(),*pick(),*blanklines(),*writemp(),*copyfsd();*/

#ifdef DEBUG
void ptff(struct fsd *f);
void ptl(int wf);
#endif  /* DEBUG */

/*
 * struct fsd *file2fsd(fname)
 *      fname
 */
struct fsd *file2fsd(fname)
int fname;
{
    charsin(fname,0,0);
    return temp2fsd(fname);
}

/* struct fsd *temp2fsd(chan)
 * -    fsd-.
 *       chan
 */
struct fsd *temp2fsd(chan)
int chan;
{
    struct fsd *thisfsd, *lastfsd, *firstfsd;
    int nby;
    char *bpt; 
    int c;
    char fby[NBYMAX+1];
    int i,lct,nl,sh,sl,kh,kl;

    firstfsd = thisfsd = lastfsd = NULL;
    /*  . c -  ,  -1 
     *  ,  -2 -   .
     */
    c = -2;
    nby = nl = sh = sl = 0;
    FOREVER
        {
        if ( (c < 0) || (nby >= NBYMAX) || (nl == FSDMAXL))
        {
	    if (c != -2) {
                lastfsd = thisfsd;
		thisfsd = (struct fsd *)salloc(nby + SFSD, sizeof(char));
		if (firstfsd == NULL) {
		    firstfsd = thisfsd;
		} else {
		    lastfsd->fwdptr = thisfsd;
		}
                thisfsd->backptr = lastfsd;
		thisfsd->fwdptr = (struct fsd *)NULL;
                thisfsd->fsdnlines = nl;
                nlines[chan] += nl;
                thisfsd->fsdfile = chan;
                thisfsd->seekhigh = sh;
                thisfsd->seeklow = sl;
                bpt = &(thisfsd->fsdbytes);
                for (i=0; i<nby; ++i) *(bpt++) = fby[i];
            }
            if (c == -1)
	    { /*      */
		thisfsd->fwdptr = lastfsd = (struct fsd *)salloc(SFSD, sizeof(char));
                lastfsd->backptr = thisfsd;
                return (firstfsd);
            }
            sh = charskh;
            sl = charskl;
            nl = nby = lct = 0;
        }
        kh = charskh;
        kl = charskl;
        c = chars(0);
        lct = (charskl - kl) + 512 * (charskh - kh);
        if (c != -1 || lct) {
            if (lct > 127)
            {
                fby[nby++] = (lct / 128)|0200;
                lct = lct % 128;
            }
            fby[nby++] = lct;
            ++nl;
        }
    }
}

/*
 *     
 */
#define ALIGBUF                 /*    !! */
#define CHARBUFSZ 512           /* >= 512,  ALIGBUF */


int chkl,chkh;  /* position of next read from charsfi */
int charsfi,charsi,charsn;

/*
 * charsin(file,h,l) -     "char" 
 *  "fi"   (h,l) = (, ).
 */
void charsin(fi,h,l)
int fi,h,l;
{
    if (fi <= 0) {
        charsfi = fi;
        return;
    }
    if((charsfi != fi)||(chkh != h)||(l > chkl)||(l < chkl - charsn))
    {
        chkh = h;
        seek(fi,h,3);
#ifndef ALIGBUF
        seek(fi,l,1);
        chkl = l;
        charsi = charsn = 0;
#else ALIGBUF
        chkl = 0;
        charsi = l;
        charsn = 0;
#endif ALIGBUF
    }
    else charsi = charsn + l - chkl;
    ncline = 0;
    charsfi = fi;
    charskh = chkh;
    charskl = chkl + charsi - charsn;
    charskl=normhl(charskl, &charskh);
}

/*
 * int chars(flg)
 *        .
 *    chk, chkl,  charsfi.
 * (    ).
 * :    -1   .
 *  flg = 1 -   "cline".
 *     ncline,    .
 *    LINE FEED  -1,   .
 * ============================================================
 *         .
 *     ,  ,
 *    "lcase"  "lat"     
 * .
 *   (    )
 *   "dechar".
 *
 *  flg = 0 -   ,    
 *   .
 */
int chars(flg)
int flg;
{       
    char *c,*se;
    int ko;
    char *si, *so;
    static char charsbuf[CHARBUFSZ];

    if (charsfi <= 0) {
	if (lcline == 0)
	    excline(1);
        ncline = 1;
        cline[0] = NEWLINE;
        return (NEWLINE);
    }
    so = cline;
    ko = (charsi >= charsn ? 1 : 2 ) ;
    do {
	if (ko == 1) {
#ifndef ALIGBUF
	    charsn = read(charsfi, charsbuf, CHARBUFSZ);
	    charsi = 0;
#else ALIGBUF
	    charsi -= charsn;
	    charsn = read(charsfi, charsbuf, CHARBUFSZ);
#endif ALIGBUF
	    if (charsn < 0) {
                error(DIAG("Read Error","O "));
		charsn = 0;
            }
            chkl += charsn;
        }
	if (charsn <= charsi) {
	    ko = 1;
            break;
        }/* read buf empty */
	si = charsbuf + charsi;
	se = charsbuf + charsn;
	if ( !flg) {
	    c = si;
	    while ( *c++ != NEWLINE && c != se);
		charsi = c - charsbuf;
	    ko = (*(c-1) == NEWLINE ? 0 : 1 );
            continue;
        }
	while (!lcline ||
	       (ko = exinss(&si, se, &so, &ncline, lcline)) == 2)
        {
	    ncline = so - cline;
            excline(0); 
	    so = cline + ncline;
        }
	charsi = si - charsbuf;
    } 
    while (ko);
    /* ko = 0 - NEWLINE, 1 - end of file */
    chkl = normhl(chkl,&chkh);
    charskh = chkh;
    charskl = chkl + charsi - charsn;
    charskl = normhl(charskl, &charskh);
    if (ko == 1)
        charsfi = 0;
    /*    */
    if (flg) {
	*so = ' ';
	c = so;
	while (*c == ' ' && c-- != cline);
	    *++c = NEWLINE;
	ncline = (c - cline) + 1;
    }
    return( ko ? -1 : NEWLINE);
}

#ifndef DEMOSES
static char *seit="\\\\\140'{(})|!~^";
#else +DEMOSES
/*  a o  paepe co 136  176 epeca !!!*/
static char *seit="\\\\\140'{(})|!^~";
static char *seit0="\\\\";
#endif +DEMOSES

int flgtabs = 1;
int alltabs = 0;

/*
 * exinss(&si,&se,&so,&no,&mo) -
 *       .
 * *si -   
 * *(se-1) -     
 * *so -     
 *  no -    , +1 (1,  )
 *  mo - ac. oep oo  oyeo cpoe
 *
 *  :
 *       0 - end of line
 *       1 - end of input string
 *       2 - the output line overflow
 */
int exinss(si, se, so, no, mo)
char **si, *se, **so;
int *no, mo;
{
#ifndef DEMOSES
    char *st, *sf;
    unsigned sy;
    int s, s1, n, i;
    char *sft;
    int no_head;  /*    */
    int ir = 0;

    sf = *si;
    st = *so;
    /*==== se +=1; ====*/
    n = *no;

    /* main loop */
    no_head = 0;
    while ((sy = *sf & 0377) != '\n' && sf != se) {
	if ((n + 2) > mo) {
	    ir = 2;
            break;
        }
	if (sy != '\11' && sy != ' ')
	    no_head = 1;
	if ((alltabs == 1 || no_head == 0 )     &&
	    flgtabs                             &&
	    sy == '\11'
	   )
        {
	    i = (n & (~07)) + 8;
	    if (i > mo) {
		ir = 2;
                break;
            }
	    for(; n < i; n++)
		*st++ = ' ';
            goto next;
        }
	if (sy == '\177') {     /* DEL */
	    *st++ = COESC0;     /* 07 */
	    *st++ = '#';
            n += 2;
            goto next;
        }
	s1 = (sy) & 0340;       /* CNTRL X */
	if (s1 == 0) {          /* <CNTRL> ? */
	    *st++ = COESC0;     /* 07 */
	    *st++ = sy | 0100;  /* +64: <cntrl> ->    */
            n += 2;
            goto next;
        }
	/*-- Letters and symbols --*/
	if (sy != 040) {    /*    ... */
	    if ( sy == 0233             ||  /* CSI - control symbols introducer */
	    /*  (sy == S_NO1)           ||  */ /* 0377 -     */
/* FIXME */ /*   s1 == 0200             ||  */ /*   'cntrl'- */
/* FIXME */ /*   s1 == 0240             ||  */ /*  -       */
		(sy == S_NO2 && lcasef)     /* 0337 -    */
	      )
	    {
		if ((n + 4) > mo) {
		    ir = 2 ;
                    break;
                }
		*st++ = COESC0;
		*st++ = ((sy >> 6) & 3) + '0';
		*st++ = ((sy >> 3) & 7) + '0';
		*st++ = ((sy) & 7) + '0';
                n += 4;
                goto next;
            }
            /* russion letters */
	    if (latf && ((sy & 0300) == 0300) ) {
		*st++ = ESC2;
		*st++ = (sy == 0337 ?  sy & 0177
				    : (sy & 0177) ^ 040);
                n += 2;
                goto next;
            }
            /* \A  A \( \) \! ... */
	    if (lcasef) {
		*st = ESC1;
		s = ((int)sy) & 0377;
		if (s >= 'A' && s<= 'Z') {
                    *++st = s;
                    st++;
                    n += 2;
                    goto next;
                }
		if (RLPRO(s)) {
                    *++st = STK7(s);
                    st++;
                    n += 2;
                    goto next;
                }
		if (s >= 'a' && s <= 'z') {
		    *st++ = (s & 0177) ^ 040;
                    n++;
                    goto next;
                }
		if (RLSTRO(s)) {
                    *st++ = STK7(s);
                    n++;
                    goto next;
                }
                /* table twice chars */
		sft = sf;
		sf = seit;
		while (*sf && *sf++ != sy)
		    sf++;
		if (*sf) {
                    *++st = *sf;  
                    st++;
                    n += 2;
		    sf = sft;
                    goto next;
                }
		sf = sft;
            }
        }
        *st++ = sy;
        n++;
next:
        sf++;
    }
    ir = (ir ?  ir : ((sy == '\n') ? (sf++, 0) : 1) );
    *si = sf;
    *so = st;
    *no = n;
    *st = 0;
    return(ir);
#else +DEMOSES
    char *st, *sf;
    unsigned sy;
    int s, s1, n, i;
    char *sft;
    int ir = 0;
    sf = *si;
    st = *so;
    /*==== se +=1; ====*/
    n = *no;
    /* main loop */
    while ((sy = (*sf)) != '\n' && sf != se) {
	if ((n+2) > mo) {
	    ir = 2;
            break;
        }
	if ( sy == '\11' ) {
	    i = (n & (~07)) + 8;
	    if (i > mo) {
		ir = 2;
                break;
            }
	    for (; n<i; n++) *st++ = ' ';
            goto next;
        }
        /* DEL */
	if (sy == '\177') {
	    *st++ = ESC1;
	    *st++ = '#';
            n += 2;
            goto next;
        }
	/*-- Letters and symbols. --*/
	s1 = (sy) & 0340;
	if (s1 != 040) {
	    if (s1 == 0         ||
		sy == 0233      ||      /* CSI - control symbols introducer */
	     /* s1 == 0200      ||      */
	     /* s1 == 0240      ||      */
	     /* (sy == S_NO1)   ||      */
		(lcasef && sy == S_NO2))
	    {
		if (n + 4 > mo) {
		    ir = 2;
                    break;
                }
		*st++ = ESC1;
		*st++ = ((sy >> 6) & 3) + '0';
		*st++ = ((sy >> 3) & 7) + '0';
		*st++ = ((sy) & 7) + '0';
                n += 4;
                goto next;
            }
            /* russion letters */
	    if (latf && ((sy & 0300) == 0300) ) {
		*st++ = ESC2;
		*st++ = (sy == 0337 ? sy & 0177 : (sy & 0177) ^ 040);
                n += 2;
                goto next;
            }
            /* \A  A \( \) \! ... */
	    if (lcasef) {
		*st = ESC1;
		s = ((int)sy) & 0377;
		if (s >= 'A' && s <= 'Z') {
                    *++st = s;
                    st++;
                    n += 2;
                    goto next;
                }
		if (RLPRO(s)) {
		    *++st = s;
                    st++;
                    n += 2;
                    goto next;
                }
		if (s >= 'a' && s <= 'z') {
		    *st++ = s + ('G' - 'g') ;
                    n++;
                    goto next;
                }
		if (RLSTRO(s)) {
		    *st++ = s + (''-'') ;
                    n++;
                    goto next;
                }
                /* table twice chars */
		sft = sf;
		sf = speccase ? seit : seit0;
		while ( *sf && *sf++ != sy)
		    sf++;
                if( *sf) {
                    *++st = *sf;  
                    st++;
                    n += 2;
		    sf = sft;
                    goto next;
                }
		sf = sft;
            }
	    else if ( !(sy == ' '               ||
		      sy >= 'a' && sy <= 'z'    ||
		      sy >= 'A' && sy <='Z'     ||
		      (sy & 0300) == 0300 ))
	    {
		    sft = sf;
		    sf = (speccase ? seit : seit0);
		    *st = ESC1;
		    while (*sf && *sf++ != sy)
			sf++;
		    if (*sf) {
			*++st = *sf;
			st++;
			n += 2;
			sf = sft;
			goto next;
		    }
		    sf = sft;
	    }
        }
        *st++ = sy;
        n++;
next:
        sf++;
    }
    ir = ( ir?  ir : ((sy == '\n') ? (sf++, 0) : 1) );
    *si = sf;
    *so = st;
    *no = n;
    *st = 0;
    return(ir);
#endif +DEMOSES
}


/*
 * dechars(line,n) -
 *   line   () 
 *  .      line.
 * n -  .       n+1 ,
 *        NEWLINE.
 *      flgtabs
 *      0 - , 1 -  , 2 -  .
 *      .
 *   .
 */
int dechars(line,n)
char *line;
int n;
{
    char *fm,*to;       /* pointers for move */
    unsigned int cc;    /* current character */
    int lnb;            /* 1 + last non-blank col */
    int cn;             /* col number */
    int i,j;
    char *to1;

    line[n] = NEWLINE;
    fm = to = line;
    cn = -1;
    lnb = 0;
    while ((cc = (*fm++ & 0377)) != NEWLINE) {
        cn++;
	if ( cc != ' ') {
	    /*if (flgtabs == 2 || flgtabs == 1 && lnb == 0)*/
	    if (flgtabs && lnb == 0)
                /*    */
		while (8 + (lnb & (~07)) <= cn) {
		    *to++ = (lnb & 7) == 7 ? ' ' : '\t';
                    lnb &= (~07);
                    lnb += 8;
                }
	    while ( ++lnb <= cn )
		*to++ = ' ';
            /*   */
#ifndef DEMOSES
	    if (cc == COESC0) {     /* 07 */
		if( *fm >= '@' || (unsigned)(*fm) > 0200 ) {
		    *to++ = *fm++ & 037;    /* <CNTRL>X */
                    continue;
                }
		if (*fm == '#') {
                    *to++ = '\177';
		    fm++;
                    continue;
                }
                /* <esc>XXX */
		i = 0;
		j = 0;
		while (j++ < 3 && (*fm >= '0' && *fm <= '7'))
		    i = (i << 3) + (*fm++ - '0');
                *to++ = i & 0377;
                continue;
	    } else if (lcasef) {
		if (cc >= 'A' && cc <= 'Z')
		    cc = cc ^ 040;
		else if (cc >= 0140 && cc <= 0176 )
		    cc = K7TS(cc) ^ 040;
		else if (cc == ESC1 && (cc = *fm) != NEWLINE ) {
		    fm++;
		    if (cc >= 0140 && cc <= 0176) {
			cc = K7TS(cc);
		    } else if (cc < 'A' || cc > 'Z') {
			to1 = to;
			to = seit-1;
                        while (*++to && *++to != cc);
			if (*to) cc = *--to;
			to = to1;
                    }
                }
		*to++ = cc;
                continue;
	    } else if (latf && cc == ESC2 /* 037 */
			    && *fm != NEWLINE )
            {
		cc = *fm++ ^ 0240;
		if (cc == 0377)
		    cc = 0337;
            }
	    *to++ = cc;
        } /* while - continue - not skip */
    }
#else +DEMOSES
            /*   */
	    if (cc == ESC1 &&
		(*fm >= '0' && *fm <= '7' || *fm == '#'))
            {
                if ( *fm == '#') {
                    *to++ = '\177';
                    *fm++;
                    continue;
                }
                /* <esc>XXX */
		i = 0;
		j = 0;
		while (j++ < 3 && (*fm >= '0' && *fm <= '7'))
		    i = (i << 3) + (*fm++ - '0');
                *to++ = i & 0377;
                continue;
	    } else if (lcasef) {
		if (cc >= 'A' && cc <= 'Z')
		    cc = cc^040;
		else if (cc >= 0340 && cc <= 0376 )
		    cc = cc^040;
		else if (cc == ESC1 && (cc = *fm) != NEWLINE) {
                    *fm++;
		    if ( cc >= 'a' && cc <= 'z' || RLSTRO(cc))
			cc ^= 040;
		    else if (cc > ' ' && cc < '@' ||
			     cc > 'Z' && cc < 'a' ||
			     cc > 'z' && cc < '\177' )
                    {
			to1 = to;
			to = seit - 1;
                        while (*++to && *++to != cc);
			if (*to) cc = *--to;
			to = to1;
                    }
                }
		*to++ = cc;
                continue;
	    } else if (cc == ESC1 && (cc = *fm) != NEWLINE) {
                    *fm++;
		    if (cc > ' ' && cc < '@' ||
			cc > 'Z' && cc < 'a' ||
			cc > 'z' && cc < '\177' )
                    {
			to1 = to;
			to = seit - 1;
			while (*++to && *++to != cc)
			    ;
			if (*to)
			    cc = *--to;
			to = to1;
                    }
	    } else if (latf && cc == ESC2 && *fm != NEWLINE) {
		cc = *fm++ ^ 0240;
		if (cc == 0377)
		    cc = 0337;
            }
	    *to++ = cc;
        } /* while - continue - not skip */
    }
#endif +DEMOSES
    *to++ = NEWLINE;
    return (to - line);
}



/*
 * excline(n) -
 *   cline.
 * cline   , 
 * lcline -     cline;
 * ncline -   .
 */
void excline(n)
int n;
{
    int j;
    char *tmp;

    j = lcline + icline;
    if (j < n)
	j = n;
    tmp = salloc(j + 1, sizeof(char));
    icline += icline >> 1;
    while (--lcline >= 0)
	tmp[lcline] = cline[lcline];
    lcline = j;
    if (cline != 0)
	free(cline);
    cline = tmp;
}

/*
 * putbks(col,n) -
 *  n    col  
 */
void putbks(col,n)
int col,n;
{
    int i;

    if (n <= 0)
	return;
    if (col > ncline-1) {
        n += col - (ncline-1);
        col = ncline-1;
    }
    if (lcline <= (ncline += n))
	excline(ncline);
    for (i = ncline - (n + 1); i >= col; i--)
	cline[i + n] = cline[i];
    for (i = col + n - 1; i >= col; i--)
	cline[i] = ' ';
}

static struct workspace *wkspline;
/*
 * wseek(wksp,lno) -
 *        nlo
 *    wksp.
 *   chars(0)   .
 *   = 1,    , 0  
 */
int wseek(wksp,lno)
struct workspace *wksp;
int lno;
{
    char *cp;
    int h,i;
    int j,l;

    /*     */
    wkspline = wksp;
    clineno = lno;
    /* 1.  fsd,   ""   */
    if (wposit(wksp,lno))
	return (1);
    /*    */
    h = wksp->curfsd->seekhigh;
    l = wksp->curfsd->seeklow;
    i = lno - wksp->curflno;
    cp = &(wksp->curfsd->fsdbytes);
    while (i-- != 0) {
	if ((j = *(cp++)) & 0200) {
	    l += 128 * (j & 0177);
            j = *(cp++);
        }
        l += j;
    }
    l = normhl(l, &h);
    charsin(wksp->curfsd->fsdfile, h, l);
    return (0);
}

/*
 * wposit(wksp,lno) -
 *   curfsd  wksp  fsd,
 *     lno.
 */
int wposit(wk,lno)
struct workspace *wk;
int lno;
{
    struct workspace *wksp;

    wksp = wk;
    if (lno < 0)
	fatal("Wposit neg arg");
    while (lno >= (wksp->curflno + wksp->curfsd->fsdnlines))
    {
	if (wksp->curfsd->fsdfile == 0) {
            wksp->curlno = wksp->curflno;
            return (1);
        }
        wksp->curflno += wksp->curfsd->fsdnlines;
	wksp->curfsd   = wksp->curfsd->fwdptr;
    }
    while (lno < wksp->curflno) {
	if ((wksp->curfsd = wksp->curfsd->backptr) == NULL)
	    fatal("Wposit NULL backptr");
        wksp->curflno -= wksp->curfsd->fsdnlines;
    }
    if (wksp->curflno < 0)
	fatal("WPOSIT LINE CT LOST");
    wksp->curlno = lno;
    return 0;
}

/*
 * switchfile(dir) -
 *     .
 *  dir>0 -  
 *  dir<0 -  
 */
void switchfile(dir)
{
    if ( dir >= 0       &&
	 *next_args     &&
	 editfile(*next_args++,0,0,1,1) == 1 )

	return;

    if (curwksp->next_wksp == curwksp) {
	helpview();
	return;
    }
    if ( dir >= 0 )
	switchwksp(0);
    else
	switchpwksp();
    out_lines(0,-1);
    poscursor(curwksp->ccol,curwksp->crow);
}

/*
 * switchwksp(make) -
 *   wksp  .
 *   make,    wksp     
 */
void switchwksp(make)
{
    struct workspace *tempwksp;
    curwksp->ccol = cursorcol;
    curwksp->crow = cursorline;
    if ( make && curwksp->next_wksp->wfile ) {
	tempwksp = (struct workspace *)salloc(SWKSP, sizeof(char));
	tempwksp->next_wksp = curwksp->next_wksp;
	curwksp->next_wksp = tempwksp;
    }
    curwksp = curport->wksp = curwksp->next_wksp;
    curfile = curwksp->wfile;
}

/*
 * switchpwksp() -
 *   wksp   wksp
 */
void switchpwksp()
{
    struct workspace *tempwksp;
    curwksp->ccol = cursorcol;
    curwksp->crow = cursorline;
    for(tempwksp = curwksp;
	tempwksp->next_wksp != curwksp;
	tempwksp = tempwksp->next_wksp
	);
    curwksp = curport->wksp = tempwksp;
    curfile = curwksp->wfile;
}

/*
 * openlines(from,number) -
 *    from number .
 */
void openlines(from,number)
int from, number;
{
    putline(1);     /*    ,   */
    if (from >= nlines[curfile])
	return;
    nlines[curfile] += number;
    insert(curwksp, blanklines(number), from);
    redisplay((struct workspace *)NULL, curfile, from, from+number-1, number, from);
    poscursor(cursorcol, from - curwksp->ulhclno);
}

/*
 * openspaces(line,col,number, nl) -
 *  , nubmer , nl .
 */
void openspaces(line, col, number, nl)
int line, col, number, nl;
{
    int i,j;
    for (i = line; i < line + nl; i++) {
        getline(i);
        putbks(col,number);
        fcline = 1;
	putline(1);
	if ((j = i - curwksp->ulhclno) <= curport->btext)
	    out_lines(j,j);
    }
    poscursor(col - curwksp->ulhccno, line - curwksp->ulhclno);
}

/*
 * splitline(line,col) -
 *   "line,col"
 */
void splitline(line,col)
int line,col;
{
    int nsave;
    char csave;

    putline(1);
    if (line >= nlines[curfile])
	return;
    nlines[curfile]++;
    getline(line);
    if (col >= ncline - 1) {
	openlines(line+1, 1);
    } else {
	csave       = cline[col];
	cline[col]  = NEWLINE;
	nsave       = ncline;
	ncline      = col + 1;
	fcline      = 1;
	putline(1);
	cline[col]  = csave;
	insert(curwksp, writemp(cline + col, nsave - col), line + 1);
	redisplay((struct workspace *)NULL,
		  curfile, line, line + 1, 1, line + 1);
    }
    poscursor(col - curwksp->ulhccno, line - curwksp->ulhclno);
    return;
}

/*
 * closelines(frum,number) -
 *    .
 * frum < 0 -   redisplay, from = -frum
 * (  "exec").
 */
void closelines(frum,number)
int frum, number;
{
    int n,from;
    struct fsd *f;

    if ((from = frum) < 0)
	from = -from - 1;
    if (from < nlines[curfile])
	if ((nlines[curfile] -= number) <= from)
	    nlines[curfile] = from + 1;
    f = delete(curwksp, from, from + number - 1);
    if (frum >= 0)
	redisplay((struct workspace *)NULL,
		  curfile, from, from + number - 1, -number, from);
    insert(pickwksp, f, n = nlines[2]);
    redisplay((struct workspace *)NULL, 2, n, n, number, -1);
    deletebuf->linenum = n;
    deletebuf->nrows = number;
    deletebuf->ncolumns = 0;
    nlines[2] += number;
    poscursor(cursorcol, from - curwksp->ulhclno);
    return;
}

/*
 * closespaces(line,col,number,nl) -
 *    
 */
void closespaces(line,col,number,nl)
int line, col, number, nl;
{
    pcspaces(line, col, number, nl, 1);
}


/*
 * combineline(line,col) -
 *    
 */
void combineline(line, col)
int line, col;
{
    char *temp;
    int nsave, i;

    if (nlines[curfile] <= line - 2)
	nlines[curfile]--;
    getline(line + 1);
    temp = salloc(ncline, sizeof(char));
    for (i = 0; i < ncline; i++)
	temp[i] = cline[i];
    nsave = ncline;
    getline(line);
    if (col + nsave > lcline)
	excline(col + nsave);
    for (i = ncline - 1; i < col; i++)
	cline[i] = ' ';
    for (i = 0; i < nsave; i++)
	cline[col + i] = temp[i];
    ncline = col + nsave;
    fcline = 1;
    putline(1);
    free((char *)temp);
    delete(curwksp, line + 1, line + 1);
    redisplay((struct workspace *)NULL,
	      curfile, line, line + 1, -1, line + 1);
    poscursor(col - curwksp->ulhccno, line - curwksp->ulhclno);
}

/*
 * picklines(from,number) -
 *    
 */
void picklines(from,number)
int from, number;
{
    int n;
    struct fsd *f;

    f = pick(curwksp, from, from + number - 1);
    redisplay((struct workspace *)NULL,
	      curfile,
	      from,
	      from + number - 1,
	      0,
	      -1);  /* because of breakfsd */
    insert(pickwksp, f, n = nlines[2]);
    redisplay((struct workspace *)NULL, 2, n, n, number, -1);
    pickbuf->linenum = n;
    pickbuf->nrows = number;
    pickbuf->ncolumns = 0;
    nlines[2] += number;
    poscursor(cursorcol, from - curwksp->ulhclno);

    return;
}

/*
 * pickspaces(line,col,number,nl) -
 *    
 */
void pickspaces(line,col,number,nl)
int line, col, number, nl;
{
    pcspaces(line, col, number, nl, 0);
}

/*
 * pcspaces(line,col,number,nl,flg) -
 *  (flg=0) /  (flg = 1)
 *  
 */
void pcspaces(line, col, number, nl, flg)
int line, col, number, nl, flg;
{
    struct fsd *f1, *f2;
    struct fsd *f0;
    char *linebuf, *bp;
    int i;
    int j, n, line0, line1;

    putline(1);
    if (charsfi == tempfile)
	charsfi = 0;
    linebuf = salloc(number + 1, sizeof(char));
    f0 = f2 = NULL;
    line1 = (line0 = line) + nl;
    while ((nl = (line1 - line0)) != 0) {
	if (nl > FSDMAXL)
	    nl = FSDMAXL;
	f1 = (struct fsd *)salloc(SFSD + (number > 127 ? nl * 2 : nl)
				 , sizeof(char));
	if (f2 != NULL) {
	    f2->fwdptr  = f1;
            f1->backptr = f2;
	} else {
	    f0 = f1;
	}
        bp = &(f1->fsdbytes);
        f1->fsdnlines = nl;
	f1->fsdfile   = tempfile;
	f1->seekhigh  = tempfh;
	f1->seeklow   = tempfl;
	for (j = line0; j < line0 + nl; j++) {
            getline(j);
	    if (col+number >= ncline) {
		if (col+number >= lcline)
		    excline(col+number+1);
		for (i = ncline - 1; i < col + number; i++)
		    cline[i] = ' ';
		cline[col + number] = NEWLINE;
                ncline = col + number + 1;
            }
	    for (i = 0; i < number; i++)
		linebuf[i] = cline[col+i];
            linebuf[number] = NEWLINE;
	    seek(tempfile, tempfh, 3);
	    seek(tempfile, tempfl, 1);
	    if (charsfi == tempfile)
		charsfi = 0;
	    write(tempfile, linebuf, n = dechars(linebuf, number));
	    if (n > 127)
		*bp++ = (n / 128) | 0200;
	    *bp++ = n % 128;
            tempfl += n;
	    tempfl = normhl(tempfl, &tempfh);
        }
        f2 = f1; 
        line0 = line0 + nl;
    }
    (f2->fwdptr = (struct fsd *)
		  salloc(SFSD, sizeof(char)))->backptr = f2;
    nl = line1 - line;
    if (flg)
	for (j = line; j < line + nl; j++) {
	    getline(j);
	    if (col+number >= ncline) {
		if (col+number >= lcline)
		    excline(col + number + 1);
		for (i = ncline - 1; i < col + number; i++)
		    cline[i] = ' ';
		cline[col + number] = NEWLINE;
		ncline = col + number + 1;
	    }
	    for (i = col + number; i < ncline; i++)
		cline[i - number] = cline[i];
	    ncline -= number;
	    fcline = 1;
	    putline(1);
	    if ((i = j - curwksp->ulhclno) <= curport->btext)
		out_lines(i, i);
	}
    insert(pickwksp,f0,n = nlines[2]);
    redisplay((struct workspace *)NULL, 2, n, n, nl, -1);
    if (flg) {
        deletebuf->linenum = n;
        deletebuf->nrows = nl;
        deletebuf->ncolumns = number;
    } else {
        pickbuf->linenum = n;
        pickbuf->nrows = nl;
        pickbuf->ncolumns = number;
    }
    nlines[2] += nl;
    free(linebuf);
    poscursor(col - curwksp->ulhccno, line - curwksp->ulhclno);
}

/*
 * put(buf,line,col) -
 *      "buf"
 *   buf->ncolumns == 0 ,  ,
 *   .
 */
void put(buf,line,col)
struct savebuf *buf;
int line, col;
{
    if (buf->ncolumns == 0)
	plines(buf, line);
    else
	pspaces(buf, line, col);
}

/*
 * plines(buf,line) -
 *       buf.
 *   buf->ncolumns == 0 .
 */
void plines(buf,line)
struct savebuf *buf;
int line;
{
    int lbuf, cc, cl;
    struct fsd *w0, *w1;
    struct fsd *f, *g;
    int j;

    putline(1);
    cc = cursorcol;
    cl = cursorline;
    breakfsd(pickwksp, buf->linenum + buf->nrows,1);
    w1 = pickwksp->curfsd;
    breakfsd(pickwksp, buf->linenum,1);
    w0 = pickwksp->curfsd;
    f = g = copyfsd(w0,w1);
    lbuf = 0;
    while (g->fsdfile) {
        lbuf += g->fsdnlines;
        g = g->fwdptr;
    }
    insert(curwksp,f,line);
    redisplay((struct workspace *)NULL,
	      curfile, line, line + lbuf, lbuf, line);
    poscursor(cc, cl);
    if ((nlines[curfile] += lbuf) <= (j = line + lbuf))
	nlines[curfile] = j + 1;
}

/*
 * pspaces(buf,line,col)    -
 *      "buf"
 *   buf->ncolumns != 0 .
 */
void pspaces(buf,line,col)
struct savebuf *buf;
int line, col;
{
    struct workspace *oldwksp;
    char *linebuf;
    int nc, i, j;

    linebuf = salloc(nc = buf->ncolumns, sizeof(char));
    oldwksp = curwksp;
    for (i = 0; i < buf->nrows; i++) {
        curwksp = pickwksp;
        getline(buf->linenum + i);
	if (ncline - 1 < nc)
	    for (j = ncline - 1; j < nc; j++)
		cline[j] = ' ';
	for (j = 0; j < nc; j++)
	    linebuf[j] = cline[j];
        curwksp = oldwksp;
	getline(line + i);
	putbks(col, nc);
	for (j = 0; j < nc; j++)
	    cline[col+j] = linebuf[j];
        fcline = 1;
        putline(0);
	if ((j = line + i - curwksp->ulhclno) <= curport->btext)
	    out_lines(j, j);
    }
    free(linebuf);
    poscursor(col - curwksp->ulhccno, line - curwksp->ulhclno);
    return;
}
/*
 * =========    ========
 *         =     fsd =
 */
/*
 * insert(wksp,f,at) -
 *   f  ,  wksp,
 *   at.
 *     redisplay 
 *  .
 *   insert  .   .  -1
 */
void insert(wksp,f,at)
struct workspace *wksp;
struct fsd *f;
int at;
{
    struct fsd *w0, *wf, *ff;

    putline(1);
    DEBUGCHECK;
    /* determine length of insert */
    ff = f;
    /* ln = 0;      */
    while (ff->fwdptr->fsdfile) {
        /*  ln += ff->fsdnlines;  */
        ff = ff->fwdptr;
    }
    /* ln += ff->fsdnlines; */
    breakfsd(wksp,at,1);
    wf = wksp->curfsd;
    w0 = wf->backptr;
    free((char *)ff->fwdptr);
    ff->fwdptr = wf;
    wf->backptr = ff;
    f->backptr = w0;
    wksp->curfsd = f;
    wksp->curlno = wksp->curflno = at;
    if (openwrite[wksp->wfile])
	openwrite[wksp->wfile] = EDITED;
    catfsd(wksp);
    DEBUGCHECK;
}


/*
 * struct fsd *delete(wksp,from,to) -
 *     wksp.
 *    fsd -   ,
 *    .
 *  redisplay.
 *   delete  .   .  -1
 */
struct fsd *delete(wksp,from,to)
struct workspace *wksp;
int from,to;
{
    struct fsd *w0;
    struct fsd *wf,*f0,*ff;

    putline(1);
    breakfsd(wksp,to+1,1);
    DEBUGCHECK;
    wf = wksp->curfsd;
    breakfsd(wksp,from,1);
    f0 = wksp->curfsd;
    ff = wf->backptr;
    w0 = f0->backptr;
    wksp->curfsd = wf;
    wf->backptr = w0;
    f0->backptr = NULL;
/* do both in one line */
    (ff->fwdptr = (struct fsd *)
		  salloc(SFSD, sizeof(char)))->backptr = ff;
    /* w0->fwdptr   */
    catfsd(wksp);
    openwrite[wksp->wfile]=  EDITED;
    DEBUGCHECK;

    return (f0);
}

/*
 * struct fsd *pick(wksp,from,to) -
 *    fsd -   ,
 *    .
 *  redisplay.
 */
struct fsd *pick(wksp,from,to)
struct workspace *wksp;
int from,to;
{
    struct fsd *wf;

    putline(1);
    breakfsd(wksp,to+1,1);
    wf = wksp->curfsd;
    breakfsd(wksp,from,1);

    return(copyfsd(wksp->curfsd,wf));
}


/*
 * int breakfsd(w,n,reall) -
 *  fsd   n  
 * w. curlno = curflno  ,  curfsd   
 *    (     
 * ).  fsd , ,  
 *   .
 *      , 
 *     ,   .
 *       , 
 *    (  -1).
 *  "reall=1"        
 *   .
 * : breakfsd       workspace.
 *       "redisplay".
 */
int breakfsd(w,n,reall)
struct workspace *w;
int n,reall;
{
    int nby, i, j, jj, k, offs, lfb0;
    struct fsd *f, *ff, *fn;
    char *c;
    char *cc;

    DEBUGCHECK;
    if (wposit(w,n)) {
        f = w->curfsd;
        ff = f->backptr;
        free((char *)f);
        fn = blanklines(n - w->curlno);
        w->curfsd = fn;
        fn->backptr = ff;
	if (ff)
	    ff->fwdptr = fn;
	else
	    openfsds[w->wfile] = fn;
        wposit(w,n);

        return (1);
    }
    f = w->curfsd;
    cc = c = &f->fsdbytes;
    offs = 0;
    ff = f;
    nby = n - w->curflno;
    if (nby != 0) {
        /* get down to the nth line */
	for (i = 0; i < nby; i++) {
	    if ((j = *c++) & 0200) {
		offs += 128 * (j & 0177);
                j = *c++;
            }
            offs += j;
        }
        /* now make a new fsd from the remainder of f */
        i = j = jj = f -> fsdnlines - nby; /* number of lines in new fsd */
        lfb0 = c - cc;
        cc = c;
	while (--i >= 0)
	    if (*cc++ & 0200) {
		j++;
		cc++;
	    }
	ff = (struct fsd *)salloc(SFSD + j, sizeof(char));
        ff->fsdnlines = jj;
        ff->fsdfile = f->fsdfile;
        offs += f->seeklow;
        ff->seeklow = offs % 512;
	ff->seekhigh = f->seekhigh + offs / 512;
        cc = &ff->fsdbytes;
	for (k = 0; k < jj; k++)
	    if ((*cc++ = *c++) & 0200)
		*cc++ = *c++;
	if ((ff->fwdptr = f->fwdptr) != NULL)
	    ff->fwdptr->backptr = ff;
        ff->backptr = f;
        f->fwdptr = ff;
        f->fsdnlines = nby;
	if (reall && (jj > 4) && (f->backptr != NULL)) {
	    ff = (struct fsd *)salloc(SFSD + lfb0, sizeof(char));
            *ff = *f; 
	    c  = &(ff->fsdbytes);
	    cc = &(f->fsdbytes);
            while (lfb0--) { 
                *c++ = *cc++; 
            }
            ff->backptr->fwdptr = ff->fwdptr->backptr = ff;
            free((char *)f); 
	    f  = ff;
	    ff = f->fwdptr;
        }
    }
    w->curfsd = ff;
    w->curflno = n;
    DEBUGCHECK;
    return (0);
}

/*
 * struct fsd *writemp(buf,n)
 *   buf  n  . .
 *    .
 */
struct fsd *writemp(buf,n)
char *buf;
int n;
{
    struct fsd *f1,*f2;
    char *p;

    if (charsfi == tempfile)
	charsfi = 0;
    if (tempfh) {
        seek(tempfile,tempfh,3);
        seek(tempfile,tempfl,1);
    } else
	seek(tempfile,tempfl,0);
    write(tempfile, buf, n = dechars(buf, n - 1));
    /* now make fsd */
    f1 = (struct fsd *)salloc(2 + SFSD, sizeof(char));
    f2 = (struct fsd *)salloc(SFSD, sizeof(char));
    f2->backptr = f1;
    f1->fwdptr = f2;
    f1->fsdnlines = 1;
    f1->fsdfile = tempfile;
    f1->seekhigh = tempfh;
    f1->seeklow = tempfl;
    if (n <= 127)
	f1->fsdbytes = n;
    else {
        p = &f1->fsdbytes;
	*p++ = (n / 128) | 0200;
        *p = n % 128;
    }
    tempfl += n;
    tempfl = normhl(tempfl, &tempfh);
    return (f1);
}

/*
 * getline(ln) -
 *   ln   curwksp.
 *    cline,  -  ncline.
 *       wseek
 */
int getline(ln)
int ln;
{
    if (ncline > 1)
	clineexist = 1;
    if ( wkspline                           &&
	 wkspline->wfile == curwksp->wfile  &&
	 clineno == ln )
	return(clineexist);
    if (fcline)
	putline(0);
    fcline = 0;
    clineexist = 1;
    if (wseek(curwksp, ln)) {
	if (lcline == 0)
	    excline(1);
        cline[0] = NEWLINE;
        ncline = 1;
	clineexist = 0;
    } else
	chars(1);

    return(clineexist);
}

/*
 * putline(nosave) -
 *    cline  curwksp,  nl.
 * nosave > 0 -   
 */
void putline(nosave)
int nosave;
{
    struct fsd *w0,*cl;
    struct fsd *wf, *wg;
    struct workspace *w;
    int i;
    char flg;


    DEBUGCHECK;
    if (fcline == 0) {
	if (nosave)
	    clineno = -1;
        return;
    }
    fcline = 0;
    w = wkspline;
#ifdef DEBUG
    ptl(w->wfile);
#endif  /* DEBUG */
    if (nlines[w->wfile] <= clineno)
	nlines[w->wfile] = clineno + 1;
    cline[ncline - 1] = NEWLINE;
    cl = writemp(cline, ncline);
    i = clineno;
    flg = breakfsd(w,i,1);
    wg = w->curfsd;
    w0 = wg->backptr;
    if (flg == 0) {
        breakfsd(w,i+1,0);
        wf = w->curfsd;
        free((char *)cl->fwdptr);
        cl->fwdptr = wf;
        wf->backptr = cl;
    }
    free((char *)wg);
    cl->backptr = w0;
    w->curfsd = cl;
    w->curlno = w->curflno = i;
    openwrite[w->wfile] = EDITED;
    /*  , dechars  ,      */
    clineno = -1;
    catfsd(w);
    redisplay(w,w->wfile,i,i,0,-1);
    if (nosave)
	clineno = -1;
    DEBUGCHECK;
}

/*
 * undoedit(f)
 *       
 */
int undoedit(f)
{
    int lno;
    struct workspace *wksp;

    if (!fcline)
	return(-1);
    lno = clineno;
    wksp = wkspline;
    fcline = 0;     /*      */
    putline(1);     /*      */
    redisplay(NULL, wksp->wfile, lno, lno, 0, -1);

    return(0);
}

/*
 * struct fsd *copyfsd(f,end) -
 *    fsd,  f  end,   end.
 *  end = NULL -   .
 */
struct fsd *copyfsd(f,end)
struct fsd *f,*end;
{
    struct fsd *res, *ff, *rend;
    int i;
    char *c1,*c2;

    /*    res = 0;*/
    /* rend = (struct fsd *)0; */
    res = ff = rend = (struct fsd *)NULL;

    /*    res = NULL */

    while (f->fsdfile && (f != end)) {
        c1 = &f->fsdbytes;
	for (i = f->fsdnlines; i; i--)
	    if (*c1++ & 0200)
		c1++;
	c2 = (char *)f;         /* !!!   !!!*/
        i = c1 - c2;
	ff = (struct fsd *)(c2 = salloc(i, sizeof(char)));
        c2 += i;
	while (i--)
	    *--c2 = *--c1;
	if (res != NULL) {
            rend->fwdptr = ff;
            ff->backptr = rend;
            rend = ff;
	} else
	    res = rend = ff;
        f = f->fwdptr;
    }
    if (res != NULL) {
	rend->fwdptr = (struct fsd *)salloc(SFSD, sizeof(char)) ;
	(rend->fwdptr)->backptr = rend;
        rend = rend->fwdptr;
    } else {
	res = rend = (struct fsd *)salloc(SFSD, sizeof(char));
    }
    if (f->fsdfile == 0) {
	rend->seeklow = f->seeklow;
    }
    return res;
}

/*
 * freefsd(f) -
 *   fsd.
 */
void freefsd(f)
struct fsd *f;
{
    struct fsd *g;
    while (f != NULL) {
        g = f;
        f = f->fwdptr;
        free((char *)g);
    }
}

/*
 * blanklines(n) -
 *   n  
 */
struct fsd *blanklines(n)
int n;
{
    int i;
    struct fsd *f,*g;
    char *c;

    f = (struct fsd *)salloc(SFSD, sizeof(char));
    while (n) {
        i = n > FSDMAXL ? FSDMAXL : n;
	g = (struct fsd *)salloc(SFSD + i, sizeof(char));
        g->fwdptr = f;
        f->backptr = g;
        g->fsdnlines = i;
        g->fsdfile = -1;
        c = &g->fsdbytes;
        n -= i;
	while (i--)
	    *c++ = 1;
        f = g;
    }
    return (f);
}

/*
 * catfsd(w)
 *      fsd -   
 *    .
 *        w->curfsd->backptr 
 *  w->curfsd,     .
 */
int catfsd(w)
struct workspace *w;
{
    struct fsd *f0, *f;
    struct fsd *f2;
    char *c;
    char *cc;
    int i, j, l0 = 0,l1 = 0, lb0 = 0, lb1, dl, nl0, nl1, fd0, kod = 0;

    /*      l0, l1 :     ,  f0,f;
     *      lb0,lb1:     fsd
     *      nl0,nl1 :    fsd */

    f = w->curfsd;
    if ((f0 = f->backptr) == NULL) {
	openfsds[w->wfile] = f;
        return(0);
    }
    f0->fwdptr = f;
    fd0=f0->fsdfile;
    nl0=f0->fsdnlines;
    while( fd0 > 0              &&
	   fd0 == f->fsdfile    &&
	   (nl0 + (nl1 = f->fsdnlines) < FSDMAXL))
    {
	i = f0->seekhigh;
	j = f->seekhigh;
	if (i > j || (j - i > 20 ))
	    return(kod);
	dl = (j - i) * 512 + f->seeklow - f0->seeklow;
        /*    , e   */
	if (l0 == 0) {
	    i = nl0;
	    cc = c = &(f0->fsdbytes);
	    while (i--) {
		if ((j = *c++) & 0200)
		    j = (j & 0177) * 128 + *c++;
                l0 += j;
            }
	    lb0 = c - cc;
        }
	if (dl != l0)
	    return(kod);
#ifdef DEBUG
	ptff(openfsds[w->wfile]);
#endif  /* DEBUG */
        /*   fsd     */
	i = nl1;
	cc = c = &(f->fsdbytes);
	l1 = 0;
	while(i--) {
	    if ((j = *c++ ) & 0200)
		j = (j & 0177) * 128 + *c++;
            l1 += j;
        }
        lb1 = c - cc;
	f2 = f;
	f = (struct fsd *)salloc(SFSD + lb0 + lb1, sizeof(char));
        *f = *f0;
        f->fwdptr = f2->fwdptr;
	w->curfsd = f;
        w->curflno -= nl0;
	nl0 = f->fsdnlines = nl0 + nl1;
	c = &(f->fsdbytes);
	i = lb0;
	cc = &(f0->fsdbytes);
        while (i--) *c++ = *cc++;
	i = lb1;
	cc = &(f2->fsdbytes);
	while (i--)
	    *c++ = *cc++;
        lb0 += lb1;
        l0 += l1;
	kod = 1;
        free((char *)f2);
        free((char *)f0);
	f->fwdptr ->backptr = f;
	if ((f0 = f->backptr) != NULL)
	    f0->fwdptr = f;
	else
	    openfsds[w->wfile] = f;
	f0 = f;
	f = f0->fwdptr;
    }
#ifdef DEBUG
    ptff(openfsds[w->wfile]);
#endif  /* DEBUG */

    return(kod);
}

/*
 * int normhl(ll, hh)
 * int ll,*hh;
 *      (ll, hh) ,
 *  ll     hh.
 * hh   , ll 
 */
int normhl(ll, hh)
int ll, *hh;
{
    int l = ll, *h = hh;

    while (l < 0) {
	l += 512;
	(*h)--;
    }
    while (l >= 512) {
	l -= 512;
	(*h)++;
    }
    return(l);
}

/*
 * doreplace(line, m, jproc, pipef)
 *    "line" m ,   jproc,  pipef.
 */
#include <sys/wait.h>
#include <signal.h>

void doreplace(line, m, jproc, pipef)
int line, m, jproc, *pipef;
{       
    struct fsd *e,*ee;
    int n;
    int l = 0;

    close(pipef[0]);
    putline(1);
    breakfsd(curwksp,line,0);
    if (m == 0)
	close(pipef[1]);
    else {
	m = fsdwrite(curwksp->curfsd, m, pipef[1]);
        if (m == -1) {
            error(DIAG("Can't write on pipe.","   pipe."));
            kill(jproc,9);
        }       
    }
    while (wait(&n) != jproc)
	;          /* wait for completion */
    if ((n & 0177400) == 0157400) {
	error(DIAG("Can't find program to execute."
		  ,"  "));
        return; 
    }
    if ((n & 0177400) == 0177000 || (n & 0377) != 0) {
	error(DIAG("Abnormal termination of program."
		  ,"   ."));
        return; 
    }
    charsfi = -1;                   /* forget old position before fork */
    if (m)
	closelines(-1 - line, m);
    charsin(tempfile, tempfh, tempfl);
    ee = e = temp2fsd(tempfile);
    tempfh = charskh;
    tempfl = charskl;
    if (e->fsdnlines) {
        while (e->fsdfile) {
            l += e->fsdnlines;
	    e  = e->fwdptr;
        }
        insert(curwksp,ee,line);
        nlines[curfile] += l;
    }
    redisplay((struct workspace *)NULL, curfile, line, line + m, l - m, -1);
    poscursor(cursorcol, cursorline);
}

/*
 * execr(args) -
 * char **args
 *     args
 */
int execr(args)
char **args;
{
    execvp(*args, args);
    exit(0337);     /*     doreplace */
}

#ifdef DEBUG
void  printfsd(struct fsd *f,
	       FILE *fd ) ;
static FILE *fd;

void dumpfsd(file)
char *file;
{
    int i;
    struct workspace *w;
    static int first = 0;
    int j;

    if (!fd) {
	if ((file == NULL) || !(fd = fopen(file, (first == 0 ? "w" : "a") )))
	    fd = stdout;
	first++;
    }
    fprintf(fd, "\n\n\n*** DUMP FSD *** *** ***\n");
    fprintf(fd, "cline=%s clineno=%d\n ncline=%d wkspline=%p fcline=%x\n",
	    cline, clineno, ncline, wkspline, fcline);
    for (i = 0; i < MAXFILES; i++)
	if (openfsds[i]) {
	    fprintf(fd, "\n*** OPENFSDS[%d] - file %s\n", i, openfnames[i]);
	    printfsd(openfsds[i],fd);
	}
    for (i = 0; i < nportlist; i++) {
        w = portlist[i]->wksp;
	fprintf(fd,"\nViewport #%d: wksp=%p FSD chain %d, current line %d at block %p,\n",
	    i,w,w->wfile,w->curlno,w->curfsd);
	fprintf(fd,"first line %d, ulhc (%d,%d)\n",
		w->curflno, w->ulhccno, w->ulhclno);
	for (j = 0; j <= portlist[i]->btext; j++) {
	    fprintf(fd, "cols[%d]=(%d,%d)%c", j, portlist[i]->firstcol[j],
		    portlist[i]->lastcol[j],(j+1)%4?'\t':'\n');
	}
	fprintf(fd,"\n");
    }
    /*ptfree(fd);*/
    fflush(fd);
    /* if ( fd != stdout ) fclose(fd);        */
}

void ptl(int wf)
{
    if ( !fd )
	return;
    fprintf(fd, "putline n=%d l=%d wfile=%d\n",
	    clineno, ncline, wf);
    return;
}

void ptff(f) struct fsd *f;
{
    if (!fd)
	return;
    fprintf(fd, "Catfsd: f=\n");
    printfsd(f, fd);
}

/*  #ifndef WORK
 *  printfsd(f) -
 *    fsd
 */
void printfsd(f, fd)
struct fsd *f;
FILE *fd;
{
    char *c;
    int i,j;
    int lncnt = 0;  /* #31.w */

    fprintf(fd,"\n**********");
    while (f != NULL) {
	fprintf(fd, "\nfsdnl=%d chan=%d hi=%d lo=%d at %p",
		f->fsdnlines,f->fsdfile,f->seekhigh,
		f->seeklow,f);
	if ((f->fwdptr != NULL) && (f != f->fwdptr->backptr))
	    fprintf(fd, "\n*** next block bad backpointer ***");
        c = &(f->fsdbytes);
	for (i = 0; i < f->fsdnlines; i++) {
/* #31.w */ lncnt += 1;
	    if ((i % 20) == 0)
		fprintf(fd,"\n");
	    j = *c++ & 0377;
	    if (j > 128)
		j = 128 * (j - 128) + *c++;
	    fprintf(fd," %d", j);
        }
/* #31.w */ fprintf(fd,"\n last line num: %d", lncnt);
        f = f->fwdptr;
    }
}

/*
 * checkfsd() -
 *    fsd.
 */
void checkfsd()
{
    struct fsd *f;
    int nl;
    /*  struct {
	    int s0;
	    char *s1;
	}; */

    nl = 0;
    f = openfsds[curfile];
    while (f) {
	if (curwksp->curlno >= nl               &&
	    curwksp->curlno < nl + f->fsdnlines &&
	    curwksp->curfsd != f                &&
	    (curwksp->curfsd->backptr != NULL) )
	{
            fatal("CKFSD CURFSD LOST"); 
        }
	if ((f->fwdptr != NULL) && (f->fwdptr->backptr != f))
	    fatal("CKFSD BAD CHAIN");
	nl += f->fsdnlines;
        f = f->fwdptr;
    }
    /*allock();*/
}
#endif  /* DEBUG */

