/*
 *  $Id: r.file.c,v 2.2 2001/08/09 10:02:38 w Exp w $
 *
 *   RED.
 *
 *  r.file.c -   .
 *
 *  $Log: r.file.c,v $
 *  Revision 2.2  2001/08/09 10:02:38  w
 *  Legacy restriction removed: 32767 lines maximum at writing
 *  editing result.
 *  Fixes for ANSI-fication, "-fwritable-strings -Wtraditional"
 *  options do not reqired anymore, and -Wall going well.
 *  Some fixes "0 vs. NULL" pointers.
 *  New undocumented feature: "arg: 0l rpl ..." work with
 *  whole file now.
 *  'register' type qualifyer on the way of removing.
 *  dumpfsd() fixed to be functional (enabled by -DDEBUG).
 *  [s]append(...,"") using improved a bit.
 *  dumpfsd() activation changed to ^X.
 *  Version numbering changed to major.minor.ext.build scheme.
 *
 *  Revision 2.1  1998/05/13 18:34:30  w
 *  ANSI-     glibc  redhat-5.0.
 *       .
 *
 *  Revision 2.0  1997/05/30 18:33:56  w
 *  !!!
 *  Red   8- (control-   ).
 *         .
 *
 *  Revision 1.2  1997/04/26 13:32:03  w
 *   
 *
 *  Revision 1.1  1997/04/26 09:48:37  w
 *  Initial revision
 *
 * Revision 4.20  90/05/22  23:22:01  alex
 * First rev. red 4.2
 * 
 * Revision 4.10  90/02/05  19:52:24  alex
 * Base revision 4.1
 * 
 * Revision 4.1  88/03/31  22:02:42  alex
 *  4.1 -   UTEC, 
 * 
 * Revision 3.1.2.2  87/06/23  18:51:04  alex
 * wYNESENA PEREMENNAQ lread1 I \TO OTLAVENO
 * 
 * Revision 3.1.2.1  87/06/19  17:00:09  alex
 * Start revision for red/4
 * 
 * Revision 3.5  87/06/05  23:50:24  alex
 *  roll    sr/sf  
 *     -t +  
 * 
 * Revision 3.4  86/09/19  19:52:46  alex
 *   -1700
 * 
 * Revision 3.3  86/08/04  20:51:42  alex
 * Bepqh dk LMNQ/DELNQ 2
 * 
 * Revision 3.2  86/07/24  00:24:13  alex
 * '      
 * 
 * Revision 3.1.1.3  86/06/16  22:17:57  alex
 *      ( )
 * 
 * Revision 3.1.1.1  86/06/05  00:04:36  alex
 * __
 * 
 * Revision 3.1  86/04/20  23:41:27  alex
 *    .
 * 
 * Revision 3.1  86/04/20  23:41:27  alex
 * *** empty log message ***
 * 
 */

#include "r.defs.h"
#include <signal.h>

/*-- O_RDWR, O_RDONLY, .. --*/
#include <fcntl.h>

/*
 * savefile(file,n) -
 *     n   "file"
 *  file  ,    
 * openfnames[n];
 *    ,     "."
 */
int savefile(file,n)
char *file;
int n;
{
    char *f1;
    char *f0;
    int newf,nowrbak=0;

    /*   */
    putline(1);
    if (file) {
        f0=file;
    } 
    else {
        f0=openfnames[n]; 
        nowrbak=1;
    }
#if 0   /*-- #31.w -->>>*/
	/* ,  checkpriv()   --*/

    for (f1=f2=f0; *f1; f1++) if (*f1 == '/') f2 = f1;
    if (f2 > f0)
    {
        *f2 = '\0';
        i = open(f0,0);
        *f2 = '/';
    }
    else i = open (".",0);
    if (i < 0)
    {
        error (DIAG("Directory does not exist.","  ."));
        return(0);
    }
    j = checkpriv(i);
    close (i);
    if (j != 2)
    {
        if (file)
        {
            error (DIAG("Can't write in specified directory","   "));
            return(0);
        }
        if (f2 > f0)
        {
            telluser(DIAG("Hit <save> to use '.'"," <save>   '.'"),0);
            nowrbak=0;
#ifdef DEMOSES
	    editwind((struct viewport *)0,(int (*)())0,0);
	    newedit = 1;
#endif DEMOSES
	    lread1=readch();
            if (lread1 != CCSAVEFILE) return(-1);
            if ((i = open(".",0)) < 0)
            {
                error (DIAG("Directory '.' does not exist!"," '.'  !"));
                return(0);
            }
            j = checkpriv(i);
            close (i);
            if (j != 2)
            {
                error (DIAG("Can't write in '.'","  '.' "));
                return(0);
            }
            f0 = f2 +1;/* points to file name */
        }
        else
        {
            error (DIAG("Can't write in '.'","  '.' "));
            return(0);
        }
    }
#endif /*-- #31.w --<<<*/
    /*     f0 */
    f1 = append (f0,SUFFBAK);
    if (nowrbak && !movebak[n]) {
        nowrbak=0; 
        movebak[n]=1;
    }
    if (!nowrbak)
    {   
	unlink(f1);
	if (link(f0,f1))
	{
	    error (DIAG("Can't rename old file."
		       ,"    ."));
	    return(0);
	}
    }
    if (unlink(f0))
    {
	error (DIAG("Can't remove old file."
		   ,"    ."));
	return(0);
    }
    if ((newf = creat(f0,getpriv(n))) < 0)
    {
	error (DIAG("Can't create file!","   !"));
        return(0);
    }
    /*      chown(f0,userid);       */
    /*  . */
    telluser(DIAG("Saving..: ","..: "),0);
    telluser(f0,6);
    dumpcbuf(1);
    /*return (fsdwrite(openfsds[n],077777,newf) == -1 ? 0 : 1);*/
    return (fsdwrite(openfsds[n],0,newf) == -1 ? 0 : 1);
}

/*
 * fsdwrite(f,nl,newf) -
 *     f   "newf"
 *  nl != 0  -   nl  
 * -nl   (nl   
 *  "exec".
 *  -   ,  -1,  .
 */
int fsdwrite(ff,nl,newf)
struct fsd *ff;
int nl, newf;
{
    struct fsd *f;
    char *c;
    int i;
    int j,k,bflag,tlines;
    int slice = nl ? 1 : 0; /*  "nl != 0" */

    if (lcline < LBUFFER) {
	excline(LBUFFER);
    }
    f = ff;
    bflag = 1;
    tlines = 0;
    while (f->fsdfile && (!slice || nl)) {
	if (f->fsdfile > 0) {
            i = 0;
            c = &f->fsdbytes;
	    for (j=f->fsdnlines; j; j--) {
		if (slice && nl < 0) {
		    /*     */
		    if (bflag && *c != 1) {
			bflag = 0;
		    } else if (bflag == 0 && *c == 1) {
                        bflag = 1;
                        if (++nl == 0) break;
                    }
                }
		if (*c&0200) {
		    i += 128 * (*c++&0177);
		}
                i += *c++;
                ++tlines;
		/*    */
		if (slice) {
		    if (nl > 0 && --nl == 0) break;
		}
            }
            seek(f->fsdfile,f->seekhigh,3);
            seek(f->fsdfile,f->seeklow,1);
	    while (i) {
                j = i < LBUFFER ? i : LBUFFER;
                read(f->fsdfile,cline,j);
		if (write(newf,cline,j) < 0) {
#ifdef SIGNOSPC
		    if ( werrflag ) {
			error(DIAG("Write ERROR: No space!"
				  ," :  !"));
		    } else {
			error(DIAG("Danger!!! Write ERROR!"
				  ,":  !"));
		    }
		    werrflag = 0;
#else
		    error(DIAG("Danger!!! Write ERROR!"
			      ,":  !"));
#endif
                    close(newf);
                    return(-1);
                }
                i -= j;
            }
	} else {
            j = f->fsdnlines;
	    if (slice) {
		if (nl < 0) {
		    if (bflag == 0 && ++nl == 0) j = 0;
		    bflag = 1;
		} else {
		    if (j > nl) j = nl;
		    nl -= j;
		}
	    }
            k = j;
	    while (k) {
		cline[--k] = NEWLINE;
	    }
	    if (j && write(newf,cline,j) < 0) {
		error(DIAG("Danger!!! Write ERROR!"
			  ,":  !"));
                close(newf);
                return(-1);
            }
            tlines += j;
        }
        f = f->fwdptr;
    }
    close(newf);
    return tlines;
}

/*
 * editfile(file,line,col,mkflg,puflg) -
 *   file  ,   
 * line   col.
 *     .
 *   ,  mkflg  1,  
 *   .
 *   -1,       .
 *  putflg  1,      .
 */
int editfile(file,line,col,mkflg,puflg)
char *file;
int line, col, mkflg, puflg;
{
    int i,j;
    register int fn;
    register char *c,*d;
    int lread1;
    int linecursor;
    /*    */
    putline(1);
    fn = -1;
    for (i=0; i<MAXFILES;++i) if (openfnames[i] != 0)
    {
        c = file;
        d = openfnames[i];
        while (*(c++) == *d) if (*(d++) == 0)
        {
            fn = i;
            break;
        }
    }
    if (fn < 0)
    {
	j = 0 ; /*-- Default: read-only mode --*/
	fn = open(file,O_RDWR); /*   ? */
	if (fn >= 0) {
	    j = 1 ; /*-- Write allowed --*/
	    close(fn);
	}
	fn = open(file,O_RDONLY);   /*  ? */
        if (fn >= 0)
        {
            if (fn >= MAXFILES)
            {
		error(DIAG("Too many files -- editor limit!"
			  ,"  !"));
                close(fn);
                return(0);
            }
	    openwrite[fn] = j ;
	    telluser(openwrite[fn]
		      ? DIAG("Edit: ","+: ")
		      : DIAG("View: ","-: ")
		    , 0);

            telluser(file,5);
        }
        else if (mkflg)
        {
#ifndef DEMOSES
	    telluser(DIAG("Create(y/n)?: ","(y/n)?: "),0);
	    telluser(file,DIAG(15,15));
#else +DEMOSES
	    telluser(DIAG("Hit <use> (ctrl-d) to make: "
			 ," <>,  : "),0);
	    telluser(file,DIAG(28,30));
	    editwind((struct viewport *)0,(int (*)())0,0);
	    newedit = 1;
#endif +DEMOSES
	    lread1=readch();
	    if (lread1 != CCSETFILE&&lread1 != 'Y' &&lread1 != 'y')
		return(-1);

#if 0   /*-- #31.w >>>--*/
	/* ,  dir     ,
			         */

            /*   */
            for (c=d=file; *c; c++)  if (*c == '/') d = c;
            if (d > file)
            {
                *d = '\0';
                i = open(file,0);
            }
            else i = open(".",0);
            if (i < 0)
            {
		error(DIAG("Specified directory does not exist."
			  ,"  "));
                return(0);
            }
            close(i);
            if (d > file) *d = '/';
#endif  /*-- #31.w <<<--*/

            /*   */
            fn = creat(file,FILEMODE); 
            close(fn);
            if ((fn = open(file,0)) < 0)
            {
		error(DIAG("Can't create file!","   !"));
                return(0);
            }
            if (fn >= MAXFILES)
            {
                close(fn);
		error(DIAG("Too many files -- Editor limit!"
			  ,"  ."));
                return(0);
            }
            openwrite[fn] = 1;
	    chown(file,userid,groupid);
        }
        else return (-1);
        paraml = 0;   /* so its kept around */
        openfnames[fn] = file;
    }   /* For EACH file ... */
    /*  ,      */
    dumpcbuf(1);
    switchwksp(1);
    if (openfsds[fn] == (struct fsd *)0)
        openfsds[fn] = file2fsd(fn);
    curwksp->curfsd = openfsds[fn];
    curfile = curwksp->wfile = fn;
    curwksp->curlno = curwksp->curflno = 0;
    line -= defplline;
    linecursor = defplline;
    if ( line < 0 ) {
	linecursor += line;
	line = 0;
    }
    curwksp->ulhclno = line;
    curwksp->ulhccno = col;
    if (puflg)
    {
	out_lines(0,-1);
	poscursor(0,linecursor);
    }
    return(1);
}


/*
 * endit() -
 *     
 *  = 0,     
 */
int endit()
{
    register int i, ko = 1;
    putline(1);
    for (i = 0; i < MAXFILES; i++)
        if (openfsds[i] && openwrite[i] == EDITED)
	    if (savefile(NULL,i) == 0) ko = 0;
    return(ko);
}
