/*
 *  $Id: r.hlam.c,v 2.2 2001/08/09 10:02:38 w Exp w $
 *
 *   RED.
 *
 *  r.hlam.c   /  
 *
 *  $Log: r.hlam.c,v $
 *  Revision 2.2  2001/08/09 10:02:38  w
 *  Legacy restriction removed: 32767 lines maximum at writing
 *  editing result.
 *  Fixes for ANSI-fication, "-fwritable-strings -Wtraditional"
 *  options do not reqired anymore, and -Wall going well.
 *  Some fixes "0 vs. NULL" pointers.
 *  New undocumented feature: "arg: 0l rpl ..." work with
 *  whole file now.
 *  'register' type qualifyer on the way of removing.
 *  dumpfsd() fixed to be functional (enabled by -DDEBUG).
 *  [s]append(...,"") using improved a bit.
 *  dumpfsd() activation changed to ^X.
 *  Version numbering changed to major.minor.ext.build scheme.
 *
 *  Revision 2.1  1998/05/13 18:34:30  w
 *  ANSI-     glibc  redhat-5.0.
 *       .
 *
 *  Revision 2.0  1997/05/30 18:33:56  w
 *  !!!
 *  Red   8- (control-   ).
 *         .
 *
 *  Revision 1.2  1997/04/26 13:32:03  w
 *   
 *
 *  Revision 1.1  1997/04/26 09:48:37  w
 *  Initial revision
 *
 * Revision 4.20  90/05/22  23:22:03  alex
 * First rev. red 4.2
 * 
 * Revision 4.10  90/02/05  19:52:25  alex
 * Base revision 4.1
 * 
 * Revision 4.10  90/02/05  19:49:16  alex
 * Base revision 4.1
 * 
 * Revision 4.1  88/03/31  22:03:09  alex
 *  4.1 -   UTEC, 
 * 
 * Revision 3.1.2.2  87/06/24  22:34:44  alex
 * New readch + gettc + tc table Tested
 * 
 * Revision 3.1.2.1  87/06/19  17:00:25  alex
 * Start revision for red/4
 * 
 * Revision 3.7  87/06/05  23:50:35  alex
 *  roll    sr/sf  
 *     -t +  
 * 
 * Revision 3.6  86/10/29  02:47:40  root
 * checkpriv      
 *        "u-g-a"; 
 *  .    
 *   ( ,  re.std).
 * 
 * Revision 3.5  86/09/19  21:38:27  alex
 * 
 * 
 * Revision 3.4  86/09/19  19:53:32  alex
 *   -1700
 * 
 * Revision 3.3  86/08/04  20:51:58  alex
 * Bepqh dk LMNQ/DELNQ 2
 * 
 * Revision 3.2  86/07/24  00:24:37  alex
 * '      
 * 
 * Revision 3.1.1.5  86/07/15  22:12:42  alex
 * RED 3.3/EC.
 * 
 * Revision 3.1.1.4  86/06/16  22:18:22  alex
 *      ( )
 * 
 * Revision 3.1.1.2  86/06/05  18:53:33  alex
 * __
 * 
 * Revision 3.1.1.1  86/06/05  00:09:28  alex
 * *** empty log message ***
 * 
 * Revision 3.1  86/04/20  23:41:51  alex
 *    .
 * 
 * Revision 3.1  86/04/20  23:41:51  alex
 * *** empty log message ***
 * 
 */
#include "r.defs.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <malloc.h>

/*   salloc -
 *  ,   
 */
void *salloc(n, size)
size_t n;       /* #31.w */
size_t size;    /* #31.w */
{
    void *c;
    if ((c = calloc(n, size)) == NULL)
	fatal(NULL);
    return (c);
}

/*
 * checkpriv(file) -  . 0 -  ,  ;
 *                   1  
 *                   2  ,  
 */
int checkpriv(fildes)
int fildes;
{
    register struct stat *buf;
    struct stat buffer;
    int anum, num;
    register int unum,gnum;

    buf = &buffer;
    fstat(fildes,buf);
    unum = gnum = anum = 0;
    if (userid == 0) unum = gnum = anum = 1;
    if (buf->st_uid == userid || userid == 0)
    {
        if (buf->st_mode & 0200) unum = 2;
        else if (buf->st_mode & 0400) unum = 1;
    }
    if (buf->st_gid == groupid || userid == 0)
    {
        if (buf->st_mode & 020) gnum = 2;
        else if (buf->st_mode & 040) gnum = 1;
    }
    if (buf->st_mode & 02) anum = 2;
    else if (buf->st_mode & 04) anum = 1;
    num = (unum > gnum ? unum : gnum);
    num = (num  > anum ? num  : anum);
    return(num);
}

/*
 * getpriv(fildes)
 *  
 */
int getpriv(fildes)
int fildes;
{
	struct stat buffer,*buf;

	buf = &buffer;
	fstat(fildes,buf);
	return (buf->st_mode & 0777);
}

/* strcopy(a,b)
 *   b   a
 */
void strcopy(a,b)
char *a,*b;
{
    while((*a++ = *b++) != 0);
}

/* abs(n) -
 *  abs
 */
int abs(number)
int number;
{
    return (number<0 ? -number : number);
}

/*
 * append(name,ext) -  ' 
 */
char *append(name,ext)
char *name, *ext;
{
    int lname;
    register char *c, *d, *newname;

    lname = 0;
    c = name; 
    while (*c++) ++lname;
    if (ext != NULL) {
	c = ext;
	while (*c++) ++lname;
    }
    newname = c = salloc(lname + 1, sizeof(char));
    d = name; 
    while (*d) *c++ = *d++;
    if (ext != NULL) {
	d = ext;
	while ((*c++ = *d++) != 0);
    }
    return newname;
}

/*
 * sappend(name, ext) -  append()  schar-
 */
schar *sappend(name, ext)
schar *name, *ext;
{
    int lname;
    schar *c, *d, *newname;

    lname = 0;
    c = name; 
    while (*c++) ++lname;
    if (ext != NULL) {
	c = ext;
	while (*c++) ++lname;
    }
    newname = c = salloc(lname + 1, sizeof(schar));
    d = name; 
    while (*d) *c++ = *d++;
    if (ext != NULL) {
	d = ext;
	while ((*c++ = *d++) != 0);
    }
    return newname;
}

/*
 * s2i(s,*i) -   s  .    *i.
 *              , 
 *         ,  NULL.
 */
char *s2i(s,i)
char *s;
int *i;
{
    register char lc,c;
    register int val;
    int sign;
    char *ans;

    sign = 1;
    val = lc = 0;
    ans = NULL ;
    while ((c = *s++) != 0) {
	if (c >= '0' && c <= '9')
	    val = 10*val + c - '0';
	else if (c == '-' && lc == 0)
	    sign = -1;
        else {
            ans = --s; 
            break; 
        }
        lc = c;
    }
    *i = val * sign;

    return ans;
}

/*
 * getnm() -          .
 */
#define LNAME 8
static char namewd[LNAME+1];

char *getnm(uid)
int uid;
{
	register int i;

	i = LNAME; 
	namewd[LNAME]=0;
	while( i>1 && uid>0) {
		namewd[--i]= '0' + uid %10;
		uid /= 10;
	}
	return(&namewd[i]);
}

/*
 * get1c, get1w(fd) -  /
 * put1c, put1w(w,fd) -  /
 */
int get1w(fd)
int fd;
{ 
    short i;
    if (read(fd, &i, SWORD) == SWORD)
	return(i);
    return(-1);
}

int get1c(fd)
int fd;
{
    char c;
    if (read(fd, &c, 1) == 1) return((unsigned)c);
    return(-1);
}

void put1w(w,fd)
short w;
int fd;
{
    write(fd, &w, SWORD);
    return;
}

void put1c(c,fd)
int fd; 
char c;
{
    write(fd, &c, 1);
    return;
}


/* seek - aea  lseek
 *  /  seek      oldseek
 */
int seek(fd, shift, dsk)
{
    long i;

    i = shift;
    if ( dsk >= 3 )
	dsk -= 3, i *= 512l;
    return((int)lseek(fd,i,dsk));
}

/*
 * tostop() -
 *    (   tty)
 */
int tostop()
#if !defined(Y_SIGSTOP) || !defined(SIGSTOP)
{ 
    return(1);
}
#else
{
    ttcleanup();
    kill(0,SIGSTOP);
    ttstartup();
    return(0);
}
#endif

/*
 * run_shell(char *cmd)
 *   UNIX   
 */
int run_shell(cmd)
char *cmd;
{
	char c;
	int i;
	int curl, curc;

	curl = cursorline;
	curc = cursorcol;
	ttcleanup();
	i = system(cmd);
	write(2,"\n\nPress ANY key to return to editor...",38);
	read(2,&c,1);
	ttstartup();
	poscursor(curc, curl);
	rescreen(0);
	return(i);
}

# define MI 20
char *Itoa(ii)
int ii;
{
	static char ib[MI+1];
	register char *s;
	register int j,i;
	s = &ib[MI];
	i = (ii >= 0 ? ii : -ii);
	while ( i )
	{
		j = i / 10;
		*--s = (i - j*10) + '0';
		i = j;
		if ( ib+2  > s ) return("**");
	}
	if ( s == &ib[MI] ) *--s = '0';
	if ( ii < 0 ) *--s = '-';
	return(s);
}
