/*
 *  $Id: r.lop.c,v 2.4 2001/08/09 10:02:38 w Exp w $
 *
 *   RED.
 *
 *  r.lop.c -   (   )
 *
 *  $Log: r.lop.c,v $
 *  Revision 2.4  2001/08/09 10:02:38  w
 *  Legacy restriction removed: 32767 lines maximum at writing
 *  editing result.
 *  Fixes for ANSI-fication, "-fwritable-strings -Wtraditional"
 *  options do not reqired anymore, and -Wall going well.
 *  Some fixes "0 vs. NULL" pointers.
 *  New undocumented feature: "arg: 0l rpl ..." work with
 *  whole file now.
 *  'register' type qualifyer on the way of removing.
 *  dumpfsd() fixed to be functional (enabled by -DDEBUG).
 *  [s]append(...,"") using improved a bit.
 *  dumpfsd() activation changed to ^X.
 *  Version numbering changed to major.minor.ext.build scheme.
 *
 *  Revision 2.3  1998/05/13 18:34:30  w
 *  ANSI-     glibc  redhat-5.0.
 *       .
 *
 *  Revision 2.2  1997/06/12 23:15:29  w
 *    gt.
 *          -8,
 *     g_table (  ).
 *    .
 *      splitline(), openlines(). ( ""
 *      ).
 *    CSI (0233).
 *    cntrl- (  ,
 *    termio (BSD)):      (0377).
 *   /    ""   .
 *
 *  Revision 2.1  1997/06/02 18:47:53  w
 *     .
 *
 *  Revision 2.0  1997/05/30 18:33:56  w
 *  !!!
 *  Red   8- (control-   ).
 *         .
 *
 *  Revision 1.2  1997/04/26 13:32:03  w
 *   
 *
 *  Revision 1.1  1997/04/26 09:48:37  w
 *  Initial revision
 *
 *  Revision 4.20  90/05/22  23:22:06  alex
 *  First rev. red 4.2
 * 
 */
#include "r.defs.h"
#include <stdio.h>
#include <string.h>

int clrsw;          /* 1 -             */
int csrsw;          /* 1 -      */
int imodesw;        /* 1 -                      */

extern int rep_count;
extern int BarDrawDir;  /*        */

extern char *g_table, g0table[];

/*
 *       
 */
char *left_parents ="({['`\"";
char *right_parents=")}]'`\"";
static SCALE s_parents[LSCALE(256)];
static int is_parents;

/*    !!! */
#define ISPARENT(i)   ISBIT(s_parents, (((int)i) & 0377))
#define SETPARENT(i) SETBIT(s_parents, (((int)i) & 0377))

/*        */
static SCALE s_delims[LSCALE(256)];
char *delimiters=" ~!@#$%^&*(-+=`\\\"';:.>,</?";
int is_delims;
#define ISDELIM(i)   ISBIT(s_delims, (((int)i) & 0377))
#define SETDELIM(i) SETBIT(s_delims, (((int)i) & 0377))

/*    / */
/*       */
char *wDleft = "-1DI+1";/* */
char *wDright= "+ID"; /* */

/*    ,     */
/* char *wDleft = "-1ID+i";   */
/* char *wDright= "+DI";      */

/*   -    */
char *w_left, *w_right;

/* #define ABS_COL(c)  ((c) + curwksp->ulhccno) */
/* #define ABS_LIN(l)  ((l) + curwksp->ulhclno) */

/*
 * ,      
 * new_parents
 * new_delims
 */
void new_parents()
{
    is_parents = 0;
}

void new_delims()
{
    is_delims = 0;
}


/*
 * compl_delims() -       
 */
void compl_delims()
{
    int i;
    char *l;

    for (i = 0; i < LSCALE(256); i++)
	s_delims[i] = 0l;
    for (l = delimiters; *l; l++) {
	i = *l;
	SETDELIM(i);
	/*       */
	if (i == ' ')
	    SETDELIM(012);
    }
    is_delims = 1;
}

/*
 * compl_parents() -        
 * ,         
 * : 0 - , -1 -   
 */
int compl_parents()
{
    int i;
    char *l,*p;

    for(i = 0; i < LSCALE(256); i++)
	s_parents[i] = 0l;
    for(l = left_parents, p = right_parents;
	*l && *p;
	l++, p++)
    {
	i = *l;
	SETPARENT(i);
	i = *p;
	SETPARENT(i);
    }
    is_parents = 1;

    return ((*l == 0 && *p == 0) ? 0 : -1);
}

/*
 * linecset(int op, char *arg)
 * int op;
 * char *arg;
 * -   CCBEGIN, CCEND, CCWORDLEFT, CCWORDRIGHT
 *        
 *    
 */
char *line_mesg;

int linecset(op, arg)
int op;
char *arg;
{
    int ln,col;

    ln = ABS_LIN(cursorline);
    col= ABS_COL(cursorcol);
    line_mesg = NULL ;
    if (line_cop(&ln, &col, op, arg) < 0) {
	error(line_mesg);
	rep_count = 0;
	return(-1);
    }
    cgoto(ln, col, -1, 0);
    return(0);
}


/*-------------------------------------------------------
 *        .
 *
 *      (BarDrawDir != 0),
 *       (lr1)  
 *        (oldch):
 *
 *      1.  oldch -   - 
 *             map[oldch, lr1].
 *
 *     (oldch -  ):
 *
 *      2.       
 *          -   
 *          (BarDrawDir)  
 *            dirmap[BarDrawDir-1, lr1].
 *
 *    :
 *
 *      3.  `--' -   ,
 *             `|'  -     .
 */
char FramesChars[] = "" ;

#ifdef GTABLEMAP
/*------------------------------------------------------------------
 *  koi2gtable[] -    -8-
 *  (FramesChars[])  G_START.
 *  (+1,    0   char).
 *
 *   . r.defs.h ( G_START)
 */
		 /* "                                           " */
char koi2gtable[] = "\02\10\51\41\15\46\33\13\03\04\12\06\01\07\47\14\32\40\31\37\05\11" ;
/*-------------------------------------------------------
 *      :
 *    FramesDraw()       ,
 *   :
 *       ,   ( ),
 *     ,    termcap "g1"..."g4".
 *           ASCII (g0table[]),
 *    g1...g4     -  (0).
 */
#endif

void FramesDraw(lr1, i)
int lr1;
int i;              /*   cline[] */
{
    int dir = 1;
    int oldch ;
    char *p ;
    char *src = FramesChars ;
    char *map[] = {
     /* ""  FramesChars[] */
	"",     /* Left     */
	"",     /* Right    */
	"",     /* Up       */
	""      /* Down     */
    } ;
    char *dirmap[] = {
     /* "1234":  to Left,Right,Up,Down,UNDEF   */
	"\000",    /* From Left  to ...*/
	"\000",    /* From Right to ...*/
	"\000",    /* From Up    to ...*/
	"\000",    /* From Down  to ...*/
	""        /* From UNDEF to ...*/
    } ;

    oldch = cline[i] ;

    switch (lr1) {              /*      */
	case CCMOVELEFT:
	    dir = 0 ;
	    break ;
	case CCMOVERIGHT:
	    dir = 1 ;
	    break ;
	case CCMOVEUP:
	    dir = 2 ;
	    break ;
	case CCMOVEDOWN:
	    dir = 3 ;
	    break ;
    }
    if ((p = index(src, oldch)) != NULL) {
	lr1 = map[dir][p - src] ;
    } else {
	p = &dirmap[BarDrawDir - 1][dir] ;
	if (*p)
	    lr1 = *p ;
	else
	    lr1 = oldch ;
    }
    /*--    --*/

    if (oldch != lr1) {
	cline[i] = lr1 ;
#ifdef  GTABLEMAP
	/*------------------------------------------*
	 |      g_table[].
	 |
	 | (  ! "" 
	 |  ,     cline[i].)
	 *------------------------------------------*/
	p = index(src, lr1) ;
	putch(p == NULL ? lr1
			: koi2gtable[p - src] + G_START - 1
	     , 1) ;
#else   /* -GTABLEMAP */
	putch(lr1, 1) ;
#endif  /* GTABLEMAP */
	movecursor(CCMOVELEFT, 1);
    }

    BarDrawDir = dir + 1 ;

}

/*     */
/*  */
static char *ess, *ss, *bss;

/* S_setup(int *pl; int lin, col)
 *  - 0 -  , -1 -   ,   
 *     ,    012
 *       012
 */
static char S_setup(P_l, lin,col)
int *P_l;
int lin, col;
{
    int ko = -1; /* <0 -  *s */

    if (lin < 0)
	return(0);
    if (!getline(*P_l = lin))
	ko = 0;
    bss = cline;
    ess = cline + (ncline - 1);
    if (col < 0 || col >= ncline -1)
	ss =  ess;
    else
	ss = cline + col;
    if (ko == 0)
	return(0);
    else
	return(*ss);
}
/* S_next(l), S_prev(l) -  " / 
 *  -    
 */
#define S_next(l) (++ss<=ess? (*ss) : S_setup(&l, l+1, 0))
#define S_prev(l) (--ss>=bss? (*ss) : S_setup(&l, l-1,-1))


/*
 *      
 * line_cop(char *p_l, *P_c; int op; char *arg)
 *    p_l, p_c
 * -1 -   
 * 1  - ,     (      )
 *      char *line_mesg;
 */
int line_cop(p_l, p_c, op, str)
int op;
char *str;
int *p_l, *p_c;
{
    int ln;
    register char *s;
    int col, scol;

    ln  = *p_l;
    col = *p_c;
next:
    getline(ln);
    switch (op) {
	case CCBEGIN:
	    for (s = cline; *s == ' '; s++);
	    scol = s - cline;
	    if (col <= scol && ln) {
		ln--;
		col = 32000;
		goto next;
	    }
	    *p_l = ln;
	    *p_c = scol;
	    /* 1 ,      */
	    return(col <= scol ? 1 : 0);
	case CCEND:
	    for (s = cline + ncline - 1;
		 (*s == NEWLINE || *s == ' ') && s >= cline;
		 s--) ;
	    scol = s - cline +1 ;
	    if (col >= scol     &&
		ln < nlines[curwksp->wfile])
	    {
		col = -1;
		ln++;
		goto next;
	    }
	    *p_l = ln;
	    *p_c = scol;
	    return(col >= scol? 1 : 0);
	case CCPSEARCH:
	    /*
	     * 0.  -- -   
	     * 1.  . 
	     * 3.  . .    , 
	     *     .
	     * 4.  .  -  4.
	     * 5.  - -   
	     * 6.  :   -
	     *     = 
	     *    1 = 
	     *    2 - 
	     *    
	     *     = 
	     *    1 = 
	     *    2 = 
	     * 7.  . 1 ++, 2--
	     *         
	     *     0,     1
	     */
	    if (!is_parents && compl_parents() < 0) {
err_ptab:
		line_mesg = DIAG("Error in parent tables",
				 "   ");
		return(-1);
	    }
	    {
		register char c;
		int level;
		char p1 = 0, p2; /*   .  */
		int fwd = 0; /* 0 - , 1 -  */
		int ko = 1;  /*    ,   */

		c = S_setup(&ln, ln,col);
		if (c != 0 && ISPARENT(c)) {
		    /*  ? */
		    for (s = left_parents; *s && *s != c; s++) ;
		    if (*s) {
			fwd = 1;
			p1 = *s;
			p2 = right_parents[s - left_parents];
			goto find_p;
		    }
		    /*  ? */
		    for (s = right_parents; *s && *s != c; s++ )
			;
		    if (*s) {
			fwd = 0;
			p1 = *s;
			p2 = 0377 & left_parents[s - right_parents];
			goto find_p;
		    }
		    /*    -   ,     */
		    goto err_ptab;
find_p:
		    level = 1; /*    */
		    ko = 0;
		    while ((c = (fwd ? S_next(ln) : S_prev(ln))) != 0) {
			if (c == p2) {
			    level--;
			} else if (c == p1) {
			    level++;
			}
			if (level == 0) {
			    break;
			}
		    }
		} else {
		    /* .  -   -     */
		    while ((c = S_prev(ln)) != 0) {
			if (ISPARENT(c)) {
			    /*  ?     ! */
			    for (s = left_parents; *s && *s != c; s++) ;
			    if (*s) {
				if (*s == right_parents[s-left_parents])
				    continue;   /* .  -    */
				break; /* ,   */
			     }
			     /*  ?    ,    */
			     for (s = right_parents; *s && *s != c; s++ ) ;
			     if (*s) {
				 level = 1;
				 p1 = *s;
				 p2 = 0377 & left_parents[s - right_parents];
			     } else {
				goto err_ptab;
			     }
			     while ((c = S_prev(ln)) != 0) {
				if (c == p2) {
				    level--;
				} else if (c == p1) {
				    level++;
				}
				if (level == 0) {
				    break;
				}
			     }
			     /*    .    */
			}
		    }
		}
		/*       -     */
		if (c) {
		    scol = ss - cline;
		    if (scol < 0)
			scol = 0;
		    *p_l = ln;
		    *p_c = scol;
		    return(ko);
		} else
		    line_mesg = DIAG("Not in parents",
				     "  ");
		return(-1);
	    }
	case CCWORDLEFT:
	case CCWORDRIGHT:
	    return(word_op(p_l, p_c, op, str) );
	default:
	    line_mesg = DIAG("Not implemented yet",
			     "  ");
	    return(-1);
    }
}

int word_op(p_l, p_c, op, arg)
int *p_l, *p_c;
int op;
char *arg;
{
    int lin, col, scol;
    int fwd;        /* 1 - , 0 -  */
    register char c;
    register int i;     /*  */
    int in1line = -1;   /*  >= 0 ,               */
    int chk_cod;        /* 1 -   , 0 -    */
    int cmd;            /*     */
    int in1char;        /* 0 - while, 1 - 1  */

    lin = *p_l;
    col = *p_c;
    getline(lin);
    if (!is_delims)
	compl_delims();
    switch (op) {
	case CCWORDRIGHT:
	    fwd = 1;
	    if (arg == NULL)
		arg = w_right ? w_right : wDright;
	    goto avto;
	case CCWORDLEFT:
	    fwd = 0;
	    if (arg == NULL)
		arg = w_left ? w_left : wDleft;
	    goto avto;
	default:
	    line_mesg = DIAG("Ill. op"," ");
	    return(-1);
    }
avto:
    /*   */
    /* : fwd = 1 - , 0 - 
     * cmd - .  
     * in1line -   ,  >= 0.
     *    in1line
     * :
     * + -   
     * - -   
     * I -      0, 
     * D -     0, 
     * i -      0,   1
     * d -     0,   1
     * 1 -   1 
     * L -    ( ) 
     * l -    () 
     *
     */
    c = S_setup( &lin, lin, col);
    while ((cmd = *arg++) != 0) {
	switch (cmd) {
	    case '+':
		fwd = 1;
		continue;
	    case '-':
		fwd = 0;
		continue;
	    case 'L':
		in1line = lin;
		continue;
	    case 'l':
		in1line = -1;
		continue;
	    case '1':
		c = (fwd ? S_next(lin) : S_prev(lin));
		continue;
	    case 'D':
		chk_cod = 1;
		goto c_while;
	    case 'd':
		chk_cod = 1;
		goto c_1;
	    case 'I':
		chk_cod = 0;
		goto c_while;
	    case 'i':
		chk_cod = 0;
		goto c_1;
	    default:
		line_mesg = DIAG(" :Bad control char"," :. . ");
		line_mesg[0] = cmd;
		return(-1);
        };
c_1:  
        in1char = 1;
        goto do_while;
c_while:
        in1char = 0;
do_while:
	do {
	    if (in1char > 1)
		break;
            in1char += in1char;
	    if (in1line >= 0 && in1line != lin)
                goto set_1line;
            i = (ISDELIM(c) != 0 );
	    if (c == 0 || i != chk_cod)
		break;
	} while ((c = (fwd ? S_next(lin) : S_prev(lin))) != 0);
        continue;
set_1line:
	if (lin > in1line)
	    c = S_setup(&lin, in1line, -1); /*   */
	else
	    c = S_setup( &lin, in1line, 0);
        continue;
    }
    scol = ss -cline;
    if (scol < 0)
	scol = 0;
    *p_l = lin;
    *p_c = scol;
    return( *arg ? 1 : 0);
}

/*
 * lineop() -  
 *     .
 *    lr1.
 */
int lineop(lr1)
int lr1;
{
    register int i, k;
    int thiscol, thisrow, j;
    int old;
    int first_p = 0;

    if (openwrite[curfile] == 0)
	goto nowriterr;

    /*movecursor(0, fix_screen);*/  /*  ,   */

repop:
    /*  BACKSPACE  1  */
    if (lr1 == CCBACKSPACE && cursorcol == 0) {
	if ((i = ABS_COL(0)) > 0 ) {
	    /*--       --*/
	    cgoto(ABS_LIN(cursorline), i - 1, -1, 0);
	    movecursor(CCMOVERIGHT, 1);
	    goto repop;
	}
	goto contin;
    }

    /*    ? ! */
    old = getline(ABS_LIN(cursorline));

    /*--     --*/
    if ( lr1 == CCDELCH                 ||
	(lr1 == CCBACKSPACE && imodesw) ||
	 lr1 == CCTRUNCATE)
    {
	thiscol = ABS_COL(cursorcol) ;  /*     */
	thisrow = cursorline;
	if (lr1 == CCBACKSPACE)
	    thiscol--;
	if (ncline < thiscol + 2) {
	    if (lr1 == CCBACKSPACE)
		movecursor(CCMOVELEFT, 1);
	    goto contin;
	}
	if (lr1 == CCTRUNCATE) {
	    cline[thiscol] = cline[ncline - 1];
	    ncline = thiscol + 1;
	} else {
	    for (i = thiscol; i < ncline - 2; i++)
		cline[i] = cline[i + 1];
	    ncline-- ;
	}
	thiscol -= curwksp->ulhccno;
	fcline = 1;
	out_cols(thiscol, -1);
	poscursor(thiscol, thisrow);
	goto contin;
    }
    /*     */
    if (cursorcol + curport->ltext + 1 >= curport->rmarg) {
	if (!first_p++) {
	    movep(defrport);
	    goto repop;
	} else
	    goto margerr;
    }
    fcline = 1;

    /*--  BACKSPACE: <^H><space><^H> --*/
    if ((j = (lr1 == CCBACKSPACE)) != 0) {
	movecursor(CCMOVELEFT, 1);  /* ^H    */
	lr1 = ' ';                  /* space */
	/*   ^H - .. */
    }
    if ((i = ABS_COL(cursorcol)) >= (lcline - 2))
	excline(i + 2) ;
    if (i >= (ncline - 1)) {
	for (k = ncline - 1; k <= i; k++)
	    cline[k] = ' ';
	cline[i + 1] = NEWLINE;
	ncline = i + 2;
    } else if (imodesw) {
	thiscol = ABS_COL(cursorcol) ;
	thisrow = cursorline;
	if (ncline >= lcline)
	    excline(ncline + 1);
	for (i = ncline; i > thiscol; i--)
	    cline[i] = cline[i - 1];
	ncline++;
	thiscol -= curwksp->ulhccno;
	out_cols((1 + thiscol), -1);
	poscursor(thiscol, thisrow);
    }

    /*   */
    if (cursorcol >= curport->rtext)
	curport->redit = curport->rtext + 1;

    /*   */
    if (lr1 == CCCTRLQUOTE)
	lr1 = COESC0;

    /*   (  - 10) */
    if (cursorcol == curport->rtext - 10)
	putcha(COBELL);

    if (BarDrawDir) {
	/*------------------------------------------
	 *   
	 */
	FramesDraw(lr1, i) ;
    } else {
	/*------------------------------------------
	 *     
	 */
	cline[i] = lr1;
	putch(lr1, 1);
    }

    /*    */
    curport->redit = curport->rtext;

    /*--  ^H  BACKSPACE --*/
    if (j)
	movecursor(CCMOVELEFT, 1);

contin:
    msvtag("1");
    return(1);

margerr:
    error("Margin stusk; move cursor to free.");
    goto errdone;
nowriterr:
    error(DIAG("You cannot modify this file!"
	      ,"     ."));
    goto errdone;
errdone:
    return(0);
}

/*
 * search(delta) -
 *  /  
 * delta =  1  / -1
 *  ,  ,  
 *   .
 *  "searchkey"
 */
void search(delta)
int delta;
{
    register char *at, *sk, *fk;
    int ln, lkey, col, lin, slin, i;

    paraml = 0;
    if (searchkey == 0 || *searchkey == 0) {
	error(DIAG("Nothing to search for.",
		   "  -?"));
	return;
    }
    col = cursorcol;
    slin = lin = cursorline;

    if (delta == 1)
	telluser("+", 0);
    else
	telluser("-", 0);
    telluser(DIAG("search: ",": "),1);
    i=lcasef;
/* --- */
    lcasef = 0; /*   : */
    telluser(searchkey, 9);
    lcasef = i;
/* --- */
    putch(COCURS,1);
    poscursor(col,lin);
    dumpcbuf(1);
    lkey = 0;
    sk = searchkey;
    while (*sk++)
	lkey++;
    getline(ln = ABS_LIN(lin));
    /* putline(0);      */
    at = cline + ABS_COL(col) ;
    FOREVER {
	at += delta;
	while (at <  cline || at >  cline + ncline - lkey) {
	    /* ,      */
	    if ((i = intrup()) || (ln += delta) < 0 ||
		(wposit(curwksp, ln) && delta == 1))
	    {
		out_win(lin,lin,col,col);
		poscursor(col,lin);
		error(i ? "Interup."
			: DIAG("Search key not found."
			      ,"  ."));
		csrsw = 0;
		rep_count = 0;
		return;
	    }
	    getline(ln);
	    /* putline(0);      */
	    at = cline;
	    if (delta < 0)
		at += ncline - lkey;
	}
	sk = searchkey;
	fk = at;
	while (*sk == *fk++ && *++sk)
	    ;
	if (*sk == 0) {
	    cgoto(ln, at-cline, slin, 0);
	    csrsw = 1;  /* put up a bullit briefly */
	    return;
	}
    }   /* FOREVER */
}

