/*
 *  $Id: r.main.c,v 2.4 2001/08/09 10:02:38 w Exp w $
 *
 *   RED.  . .. ,  
 *
 *    - /,  ,
 *   
 *
 *  $Log: r.main.c,v $
 *  Revision 2.4  2001/08/09 10:02:38  w
 *  Legacy restriction removed: 32767 lines maximum at writing
 *  editing result.
 *  Fixes for ANSI-fication, "-fwritable-strings -Wtraditional"
 *  options do not reqired anymore, and -Wall going well.
 *  Some fixes "0 vs. NULL" pointers.
 *  New undocumented feature: "arg: 0l rpl ..." work with
 *  whole file now.
 *  'register' type qualifyer on the way of removing.
 *  dumpfsd() fixed to be functional (enabled by -DDEBUG).
 *  [s]append(...,"") using improved a bit.
 *  dumpfsd() activation changed to ^X.
 *  Version numbering changed to major.minor.ext.build scheme.
 *
 *  Revision 2.3  1998/05/13 18:34:30  w
 *  ANSI-     glibc  redhat-5.0.
 *       .
 *
 *  Revision 2.2  1997/12/29 17:44:32  w
 *    optarg,  next_path()   .
 *
 *  Revision 2.1  1997/06/12 23:15:29  w
 *    gt.
 *          -8,
 *     g_table (  ).
 *    .
 *      splitline(), openlines(). ( ""
 *      ).
 *    CSI (0233).
 *    cntrl- (  ,
 *    termio (BSD)):      (0377).
 *   /    ""   .
 *
 *  Revision 2.0  1997/05/30 18:33:56  w
 *  !!!
 *  Red   8- (control-   ).
 *         .
 *
 *  Revision 1.3  1997/04/28 13:17:57  w
 *      :
 *   getuid/getgid  geteuid/getegid;
 *    unlink()    tmp.
 *
 *  Revision 1.2  1997/04/26 13:32:03  w
 *   
 *
 *  Revision 1.1  1997/04/26 09:48:37  w
 *  Initial revision
 *
 * Revision 4.20  90/05/22  23:22:10  alex
 * First rev. red 4.2
 * 
 * Revision 4.10  90/02/05  19:52:30  alex
 * Base revision 4.1
 *
 * Revision 4.10  90/02/05  19:49:18  alex
 * Base revision 4.1
 *
 * Revision 4.1  88/03/31  22:04:06  alex
 *  4.1 -   UTEC, 
 *
 * Revision 3.1.2.6  87/07/09  20:42:35  alex
 * REVISION
 *
 * Revision 3.1.2.5  87/07/03  22:02:45  alex
 * Graph_characters used in margin
 *
 * Revision 3.1.2.4  87/06/24  22:34:59  alex
 * New readch + gettc + tc table Tested
 *
 * Revision 3.1.2.3  87/06/23  20:51:36  alex
 * Automatic_revisions
 *
 * Revision 3.1.2.2  87/06/23  18:51:57  alex
 * wYNESENA PEREMENNAQ lread1 I \TO OTLAVENO
 *
 * Revision 3.1.2.1  87/06/19  17:01:14  alex
 * Start revision for red/4
 *
 * Revision 3.16  87/06/12  18:10:36  alex
 *     vilcase    vt-200
 *
 * Revision 3.15  87/06/06  16:49:20  alex
 *  roll    sr/sf  
 *     -t +  
 *
 * Revision 3.14  87/06/05  23:50:59  alex
 *  roll    sr/sf  
 *     -t +  
 *
 * Revision 3.13  87/06/04  23:44:05  alex
 * Scroll on -sr- or -al/dl- added
 *
 * Revision 3.12  87/04/21  22:46:13  alex
 * Debug
 *
 * Revision 3.11  87/04/02  18:32:07  alex
 *   Utec       
 *
 * Revision 3.10  87/04/01  19:13:58  alex
 * Revision for Utec: Cs, Ce, Ct, hR
 *
 * Revision 3.9  86/11/25  08:06:07  alex
 *  ioctl(..,TIOCFLUSH,&flag)
 *
 * Revision 3.8  86/10/29  02:45:11  root
 *   27 .
 *
 * Revision 3.7  86/10/14  23:02:21  alex
 * .
 *
 * Revision 3.6  86/09/19  21:38:58  alex
 *
 *
 * Revision 3.5  86/09/19  19:54:51  alex
 *   -1700
 *
 * Revision 3.4  86/08/04  20:52:34  alex
 * Bepqh dk LMNQ/DELNQ 2
 *
 * Revision 3.3  86/07/24  23:37:38  alex
 * Ob}aq wers
 *    3.3
 *
 * Revision 3.2  86/07/24  19:04:32  alex
 * '      
 *
 * Revision 3.1.1.6  86/07/15  22:13:04  alex
 * RED 3.3/EC.
 *
 * Revision 3.1.1.5  86/06/20  23:33:40  alex
 *       "C" -    .
 *      3.2 (  ).
 *
 * Revision 3.1.1.4  86/06/16  22:19:26  alex
 *      ( )
 *
 * Revision 3.1.1.2  86/06/06  00:14:36  alex
 *   
 *
 * Revision 3.1.1.1  86/06/05  00:05:55  alex
 * __
 *
 * Revision 3.1  86/04/20  23:42:22  alex
 *    .
 * Revision 1.5  86/04/13  21:56:42  alex
 * .
 *
 */


/*
 * :
 *
 *      red []  [ ]
 *
 *      
 *      red [] -R
 *      ( )
 *      
 *      red [] -r _
 *      (    )
 *      
 *      red  []
 *      (    )
 *
 *      :
 *      -R -  
 *      -r _ -    
 *      -k-+ -    
 *      -f -    
 *      -i _ -   -   
 *         ,   :.
 *      -m -   -
 *           REDKEYS.  
 *         "-"  "+".
 */
#include "r.defs.h"
#include <signal.h>

/*-- O_RDWR, ... --*/
#include <fcntl.h>

#if 0
static char *sccsid="@(#) RED / DEMOS-EC/SM $Header: /opt/home/compsrv/w/utils/binutils/red-w/red-w-2.1.7/RCS/r.main.c,v 2.4 2001/08/09 10:02:38 w Exp w $";
#endif

struct savebuf pb, db;
/*void sig(),igsig(),testsig();*/
/*long lseek();*/
#ifdef SIGNOSPC
void werrsig();
int werrflag;
#endif
/*extern char *getvers();*/
static void startup(int mode);

/*  -  ,  .   */
extern int chg_flag;

/*
 *   getopt
 */
extern char *optarg;
extern int optind, opterr;
char **next_args;
/*
 * main(nargs,args)
 *  
 */
int main(nargs,args)
int nargs;
char **args;
{
    int WorkMode;
    int c;
    schar ichar ;
    char *cp, *getenv();
    char *arg0 = args[0];
    int no_macro = 0;
    WorkMode = 0; /*  : 0 - ,
				   1 - ,
				   2 -   %wtt.. */
    setbuf(stdout,NULL);
    pt_info();
#ifdef ALLDIAG
    latdiag = ((cp = getenv ("MSG")) && *cp == 'l');
#endif
    /*    ENVIRONMENT */
    VarEInit();
    if ( nargs == 2 && strcmp(args[1],"-") == 0 )
    {
	WorkMode = 2; nargs--; args++;
    }
    while ( (c = getopt(nargs, args, "Rmr:k:fi:") ) >= 0 )
	switch (c) {
	case 'f': InitPath = "";
	    break;
	case 'm': no_macro = 1;
	    break;
	case 'R': WorkMode = 2;
	    break;
	case 'r': cp = optarg;
	    if ((inputfile = open(cp, 0)) < 0)
	    {
		printf("Can't open command file %s.\n",cp);
		exit(1);
	    }
	    break;
	case 'k':
	    RedKeys = append(RedKeys,optarg);
	    break;
	case 'i':
	    InitPath = append(optarg,NULL);
	    break;
	case '?':
	    printf("Using:\n");
	    printf("%s [options] [files] - call editor\n%s - call with old state\n%s -R - repeat edition after system crash\n", arg0, arg0, arg0);
	    printf("options:\n");
	    printf("       -f             - no read init file\n");
	    printf("       -i path        - change init_file_path to path\n");
	    printf("       -m             - no read macro/status file\n");
	    printf("       -k keys1+keys2 - unset keys1 and set keys2\n");
	    printf("       -r file        - read seans protocol from file\n");
	    exit(1);
    }
    args  += (optind - 1);
    nargs -= (optind - 1);
    if (WorkMode == 0 && (nargs <= 1)) {
	WorkMode = 1 ;
	ichar = '!'  ;
    } else
	ichar = ' ' ;

    startup(WorkMode);

    if (inputfile) {
	/*if (read(inputfile, &ichar, 1) <= 0)*/
	if (GETP(ichar,inputfile) == -1) {
	    cleanup();
	    printf("Command file is empty.\n");
	    exit(1);
	}
    }
    else
	PUTP(ichar);    /*  oopa ceaca */
    if ( !no_macro )
	ReadInit(ichar == '!' ? rfile : MacroFile, 1 /*  0 ?... */);
    if (nportlist == 0)
	makestate();
    next_args = &args[1];
    if (nargs > 1 && *args[1] != '\0') {
	extern char *Itoa();
	int i;

	i =  1;
	next_args++;
	if (nargs > 2) {
	    if (s2i(args[2], &i) != NULL) {
		i = 1;
	    } else {
		next_args++;
	    }
	}
	poscursor(curwksp->ccol, curwksp->crow);
	if (editfile(args[1], i - 1, 0, 1, 1) <= 0) {
	    out_lines(0, -1);
	    poscursor (curwksp->ccol, curwksp->crow);
	} else {
	    writefile(CCENTER, args[1], CCSETFILE);
	    writefile(CCENTER, Itoa(i), CCGOTO);
	}
    } else {
	out_lines(0, -1);
	poscursor (curwksp->ccol, curwksp->crow);
    }
    telluser( getvers(),0);
    mainloop();
    MacSave(rfile,2);   /*    */
    cleanup();
    dumpcbuf(0);
    pt_info();
    exit(0);
}

void pt_info()
{
    printf("\n\n   In edit session press HELP or CTRL+\\ for HELP \n   %s\n",getvers());
}

/*char *ttyname();*/
int oldttmode;
/*
 * startup(mode) -    
 *
 *         mode:    2 -    ttyfile ;
 *                  1 -  
 *                  0 -  
 */
static void startup(mode)
int mode;
{
    register int i;
    char *StrCalc();

    NICE; /*   (.  ned.?defs) */
    userid  = GETUID;
    groupid = GETGID;
    setuid(userid);
    setgid(groupid);

    InitConsts();
    InitTabs();
    if ( RedKeys ) {
	setkeys(RedKeys);
	free(RedKeys);
	RedKeys = NULL;
    }
    /*   . */
    ReadInit(InitPath, 1);
    /* ,    -  !! */
    chg_flag = 1;
    /*   ,     */
    ErrI(-1,NULL);
    /*    */
    ttstartup();
    for (i = LINEL; i;)
	blanks[--i] = ' ';
    tmpname = StrCalc(TTYtmp);      /* "%wretm/%d.%u" */
    ttytmp  = StrCalc(TTYnm);       /* "%wrett/%d.%u" */
    rfile   = StrCalc(RFile);
    /*    . ,     */
    setupviewport(&wholescreen, 0, LINEL-1, 0, NLINES-1, 0);
    curport = &wholescreen;
    if ( mode != 2 && close(open(tmpname,0)) >= 0 )
    {
	char buf[128];
	putcha(COERASE);
	poscursor(0,0);
	info(DIAG("Warning: old session was aborted possibly!"
		 ,":  , ,  ")
	    ,LINEL);
	poscursor(0,1);
	info(DIAG("You can repeat session by calling editor vith option -R"
		 ,"   ,     -R")
	    ,LINEL);
	poscursor(0,2);
	info(DIAG("Before you must to chdir to the same directory"
		 ,"       ,    ")
	    ,LINEL);
	poscursor(0,3);
	info(DIAG("If you continue now, old session would be lost!"
		 ,"  ,   ")
	    ,LINEL);
	buf[0] = 0;
	do {
	    poscursor(0,4);
	    info(DIAG("Enter: 1 - to cont, 0 - to abort ..."
		     ,": 1 -  , 0 -  .")
		,LINEL);
	    dumpcbuf();
	} while(read(0,buf,127) > 0  &&
		buf[0] != '0'        &&
		buf[0] != '1'          ) ;
	if (buf[0] != '1') {
	    ttcleanup();
	    exit(1);
	}
	putcha(COERASE);
    }
    if ((i = open(tmpname,0 /*O_RDONLY*/)) >= 0) {  /* ../retm/... */
	close(i);
	if ((i = unlink(tmpname)) < 0) {
	    ttcleanup();
	    printf("\nCan't remove temporary file %s\n\n", tmpname);
	    exit(1);
	}
    }
    if ((i = creat(tmpname,0600)) < 0)
    {
	ttcleanup();
	printf("\nCan't create temporary file %s\n\n", tmpname);
	exit(1);
    }

    /*     read/write -   */
    close(i);
    if ((i = open(tmpname, 2 /* O_RDWR */ )) < 0) {
	ttcleanup();
	printf("\nCan't modify temporary file %s\n\n", tmpname);
	exit(1);
    }
    openfnames[i] = tmpname;
    openwrite [i] = 1;
    tempfile = i;

    /*      [../rett/...] */
    ttyfile = open(ttytmp, O_RDWR );    /* ../rett/...  */
    if (mode == 2) {            /*   (-R) */
	if (ttyfile >= 0) {
	    inputfile = ttyfile;
	} else {
	    ttcleanup();
	    printf("\nCan't open protocol file %s\n\n", ttytmp);
	    exit(1);
	}
    } else {                    /*   */
	if (ttyfile >= 0) {
	    close(ttyfile);
	    if ((ttyfile = unlink(ttytmp)) < 0) {
		ttcleanup();
		printf("\nCan't remove protocol file %s\n\n", ttytmp);
		exit(1);
	    }
	}
	if ((ttyfile = creat(ttytmp, FILEMODE)) < 0) {
	    /*-- ttyfile = -1; --*/
	    ttcleanup();
	    printf("\nCan't create protocol file %s\n\n", ttytmp);
	    exit(1);
	}
    }

    /*  '#' --      */
    openfnames[2] = "#";
    nlines[2] = 0;
    pickwksp  = (struct workspace *)salloc(SWKSP, sizeof(char));
    pickwksp->curfsd = openfsds[2]
		     = (struct fsd *)salloc(SFSD, sizeof(char));
    pickwksp->wfile = 2;
    pickbuf   = &pb;
    deletebuf = &db;
    if (RedKeys) {
	setkeys(RedKeys);
	free(RedKeys);
	RedKeys = NULL;
    }
    /*    HELP  .. */
    setupviewport( &zoomport, 0, LINEL-1, 0, ZOOML-1,0);
    /*     */
    setupviewport(&paramport,LMARG-1,LINEL-LMARG,NLINES-NPARAMLINES,NLINES-1,0);
    /* paramport.rtext -= 3;    */
    paramport.redit = PARAMREDIT - 5 - LMARG*2;
    /*        */
    /*
     *  
     */
    for (i = SIGTERM; i; i--) signal(i,sig);
    signal(SIGINT,testsig);
    signal(SIGQUIT,igsig);
#ifdef SIGSTOP
    signal(SIGTSTP,SIG_IGN);
    signal(SIGCONT,SIG_IGN);
#endif
#ifdef SIGNOSPC
    signal(SIGNFILE,werrsig);
    signal(SIGNOSPC,werrsig);
#endif
#ifdef SV_INTERRUPT
    /*       */
    {
	struct sigvec veci;
	sigvec(SIGINT,(struct sigvec *)0, &veci);
	veci.sv_flags |= SV_INTERRUPT;
	sigvec(SIGINT, &veci, (struct sigvec *)0);
    }
#endif
    curport = &wholescreen;
    putcha(COSTART);
    putcha(COHO);
    dumpcbuf();
    excline(0);
    return;
}

/*
 * cleanup() -
 *   
 */
void cleanup()
{
    /* restore tty mode and exit */
    ttcleanup();
    close(tempfile);
    unlink(tmpname);
    close(ttyfile);
}

/*
 * makestate() --    
 */
void makestate()
{
    register struct viewport *port;

    if (RedKeys) {
	setkeys(RedKeys);
	free(RedKeys);
	RedKeys = NULL;
    }
    nportlist = 1;
    port = portlist[0]
	 = (struct viewport *)salloc(SVIEWPORT, sizeof(char));
    setupviewport(portlist[0],0,LINEL-1,0,NLINES-NPARAMLINES-1,1);
    drawport(port, DRAW_ALL /* DRAW_HORI */);
    if (zoomflag) {
	port    = portlist[nportlist++] = &zoomport;
	zoomedp = portlist[0];
	switchport(port);
    }
    poscursor(0,0);
}

/*
 * sig() -
 *  
 */
static char fat_sig[] = "..: Fatal signal\n";
void sig(n)
{
    fat_sig[0] = n/10+'0';
    fat_sig[1] = n%10+'0';
    fatal(fat_sig);
}

#ifdef SIGNOSPC
/* werrsig() - opaoa o. ac    */
void werrsig()
{
    werrflag = 1;
    signal(SIGQUIT,werrsig);
    signal(SIGINT,testsig);
    signal(SIGNFILE,werrsig);
    signal(SIGNOSPC,werrsig);
}
#endif

/* igsig() -   */
void igsig()
{
    signal(SIGQUIT,igsig);
#ifdef SIGNOSPC
    signal(SIGNFILE,igsig);
    signal(SIGNOSPC,igsig);
#endif
}

/*
 * testsig() -
 * ,    
 */
void testsig()
{
/*  BSD 4.3    */
#ifndef SV_INTERRUPT
    signal(SIGINT, igsig);
#endif
    if (intrflag)
	fatal(DIAG("RED WAS INTERUPTED\n","RED \n"));
    igsig();
    intrflag = 1;
}

/*
 * fatal(s) --   
 */
void fatal(s)
char *s;
{
    putcha(COFIN);
    putcha(COBELL);
    putcha(COBELL);
    dumpcbuf(0);
    ttcleanup();
    printf(DIAG("\nFirst the bad news - the RED just    "
	       ,"\n  : Red :"));
    if (s) {
	printf(DIAG("died:\n%s\n"
	      ,": \n%s\n"),s);
    }
    else printf(DIAG("ran out of space.\n"
		    ,"  "));
    if(userid%51==0) printf("\n ReD - KiAe MoScOw RuDnEv A.p.\n");
    printf(DIAG("\n Now the good news - your editing session can be reproduced\n  from file "
	       ,"\n     :"));
    printf(ttytmp);
    printf(DIAG("\n use command 're -R' to do it.\n"
	       ,"\n  're -R'\n"));
/*#ifndef WORK*/
#ifdef DEBUG
    if (inputfile || (!isatty(1)) )
	      dumpfsd(FSDDUMP);
#endif
    close(ttyfile);
    exit(1);
/*    abort(1);       */
}
/*    .. ,  . , 1984 */

