/*
 *  $Id: r.mall.c,v 2.2 2001/08/09 10:02:38 w Exp w $
 *
 *   RED.
 *
 *  r.mall.c - / .
 *            ,
 *           
 *
 *  $Log: r.mall.c,v $
 *  Revision 2.2  2001/08/09 10:02:38  w
 *  Legacy restriction removed: 32767 lines maximum at writing
 *  editing result.
 *  Fixes for ANSI-fication, "-fwritable-strings -Wtraditional"
 *  options do not reqired anymore, and -Wall going well.
 *  Some fixes "0 vs. NULL" pointers.
 *  New undocumented feature: "arg: 0l rpl ..." work with
 *  whole file now.
 *  'register' type qualifyer on the way of removing.
 *  dumpfsd() fixed to be functional (enabled by -DDEBUG).
 *  [s]append(...,"") using improved a bit.
 *  dumpfsd() activation changed to ^X.
 *  Version numbering changed to major.minor.ext.build scheme.
 *
 *  Revision 2.1  1998/05/13 18:34:30  w
 *  ANSI-     glibc  redhat-5.0.
 *       .
 *
 *  Revision 2.0  1997/05/30 18:33:56  w
 *  !!!
 *  Red   8- (control-   ).
 *         .
 *
 *  Revision 1.2  1997/04/26 13:32:03  w
 *   
 *
 *  Revision 1.1  1997/04/26 09:48:37  w
 *  Initial revision
 *
 * Revision 4.20  90/05/22  23:22:24  alex
 * First rev. red 4.2
 * 
 * Revision 4.10  90/02/05  19:52:37  alex
 * Base revision 4.1
 * 
 * Revision 4.1  88/03/31  22:05:54  alex
 *  4.1 -   UTEC, 
 * 
 * Revision 3.1.2.1  87/06/19  17:01:55  alex
 * Start revision for red/4
 * 
 * Revision 3.6  87/06/05  23:51:15  alex
 *  roll    sr/sf  
 *     -t +  
 * 
 * Revision 3.5  87/06/04  23:44:25  alex
 * Scroll on -sr- or -al/dl- added
 * 
 * Revision 3.4  86/09/19  19:58:11  alex
 *   -1700
 * 
 * Revision 3.3  86/08/04  20:54:15  alex
 * Bepqh dk LMNQ/DELNQ 2
 * 
 * Revision 3.2  86/07/24  19:07:20  alex
 * '      
 * 
 * Revision 3.1.1.1  86/06/05  00:07:48  alex
 * __
 * 
 * Revision 3.1  86/04/20  23:43:55  alex
 *    .
 * 
 * Revision 3.1  86/04/20  23:43:55  alex
 * *** empty log message ***
 * 
 */

#ifndef _STDLIB_H

#include "r.defs.h"

#ifdef DEBUG
#define ASSERT(p) if(!(p)) {botch("p");} else
void botch(s)
char *s;
{
    printf("assertion botched: %s\n",s);
    fatal("Mallock DESTROIED\n");
}
#else /* !DEBUG */
#define ASSERT(p)
#endif  /* DEBUG */

/*	avoid break bug */
#ifdef pdp11
#define GRANULE 64
#else
#define GRANULE 0
#endif
/*  
 *   
 *     ,   
 *  .
 *        .
 *      ( ALIGN)
 *       ""
 * (1 - , 0 - ).
 *     .
 *   (   alloct)   
 *    
 *
 * ALIGN, NALIGN, BLOCK, BUSY, INT
 * INT -  ,   - .
 */
#define INT int
#define ALIGN int
#define NALIGN 1
#define WORD sizeof(union store)
#ifdef UTEC
#define BLOCK (1024*4)
#else
#ifdef pdp11
#define BLOCK 256      /* a multiple of WORD*/
#else
#define BLOCK 1024
#endif
#endif UTEC
#define BUSY 1
#undef NULL
#define NULL 0
#define testbusy(p) ((INT)(p)&BUSY)
#define setbusy(p) (union store *)((INT)(p)|BUSY)
#define clearbusy(p) (union store *)((INT)(p)&~BUSY)

union store { union store *ptr;
	      ALIGN dummy[NALIGN];
	      int calloc;	/*calloc clears an array of integers*/
};

static	union store allocs[2];	/*initial arena*/
static	union store *allocp;	/*search ptr*/
static	union store *alloct;	/*arena top*/
static	union store *allocx;	/*for benefit of realloc*/
/*char    *sbrk();*/

char *malloc(nbytes)
unsigned nbytes;
{
    union store *p, *q;
    nw;
    static temp;    /*coroutines assume no auto*/

    if(allocs[0].ptr==0) {  /*first time*/
	allocs[0].ptr = setbusy(&allocs[1]);
	allocs[1].ptr = setbusy(&allocs[0]);
	alloct = &allocs[1];
	allocp = &allocs[0];
    }
    nw = (nbytes+WORD+WORD-1)/WORD;
    ASSERT(allocp>=allocs && allocp<=alloct);
    ASSERT(allock());
    for(p=allocp; ; ) {
	for(temp=0; ; ) {
	    if(!testbusy(p->ptr)) {
		while(!testbusy((q=p->ptr)->ptr)) {
		    ASSERT(q>p&&q<alloct);
		    p->ptr = q->ptr;
		}
		if(q>=p+nw && p+nw>=p)
		    goto found;
	    }
	    q = p;
	    p = clearbusy(p->ptr);
	    if(p>q)
		ASSERT(p<=alloct);
	    else if(q!=alloct || p!=allocs) {
		ASSERT(q==alloct&&p==allocs);
		return(NULL);
	    } else if(++temp>1)
		break;
	}
	temp = ((nw+BLOCK/WORD)/(BLOCK/WORD))*(BLOCK/WORD);
	q = (union store *)sbrk(0);
	if(q+temp+GRANULE < q) {
	    return(NULL);
	}
	q = (union store *)sbrk(temp*WORD);
	if((INT)q == -1) {
	    return(NULL);
	}
	ASSERT(q>alloct);
	alloct->ptr = q;
	if(q!=alloct+1)
	    alloct->ptr = setbusy(alloct->ptr);
	alloct = q->ptr = q+temp-1;
	alloct->ptr = setbusy(allocs);
    }
found:
    allocp = p + nw;
    ASSERT(allocp<=alloct);
    if(q>allocp) {
	allocx = allocp->ptr;
	allocp->ptr = p->ptr;
    }
    p->ptr = setbusy(allocp);
    return((char *)(p+1));
}

/*	freeing strategy tuned for LIFO allocation
*/
void free(ap)
char *ap;
{
    union store *p = (union store *)ap;

    ASSERT(p>clearbusy(allocs[1].ptr)&&p<=alloct);
    ASSERT(allock());
    allocp = --p;
    ASSERT(testbusy(p->ptr));
    p->ptr = clearbusy(p->ptr);
    ASSERT(p->ptr > allocp && p->ptr <= alloct);
}

#if 0
 /*--  red   --*/

 /*      realloc(p, nbytes) reallocates a block obtained from malloc()
  *      and freed since last call of malloc()
  *      to have new size nbytes, and old content
  *      returns new location, or 0 on failure
 */

char *
realloc(p, nbytes)
union store *p;
unsigned nbytes;
{
    union store *q;
    union store *s, *t;
    unsigned nw;
    unsigned onw;
    if(testbusy(p[-1].ptr))
	    free((char *)p);
    onw = p[-1].ptr - p;
    q = (union store *)malloc(nbytes);
    if(q==NULL || q==p)
	    return((char *)q);
    s = p;
    t = q;
    nw = (nbytes+WORD-1)/WORD;
    if(nw<onw)
	    onw = nw;
    while(onw--!=0)
	    *t++ = *s++;
    if(q<p && q+nw>=p)
	    (q+(q+nw-p))->ptr = allocx;
    return((char *)q);
}
#endif /* 0 */

#ifdef DEBUG
int allock()
{
    union store *p;
    int x;
    x = 0;
    for (p = &allocs[0]; clearbusy(p->ptr) > p; p = clearbusy(p->ptr) ) {
	if (p == allocp)
            x++;
    }
    ASSERT(p == alloct);
    return(x == 1 | p == allocp);
}

static ptflag = 0;
void ptfree(fd)
FILE *fd;
{ 
    union store *p,*q;
    int i=0;
    if (ptflag++) return;
    fprintf(fd,"\n FREE LIST:\n");
    ASSERT(allocp>allocs && allocp <= alloct);
    for (p=allocs; ;)   {
        if ( !testbusy(p->ptr) )
        {
	    fprintf(fd," 0%o( %d)\t%c", p,
		((int)p->ptr - (int)p) - (WORD), (++i%4?' ':012));
        }
        q = p;
        p = clearbusy(p->ptr);
	if ( p > q ) ASSERT( p <= alloct );
        else if ( q != alloct || p != allocs ) { 
	    fprintf(fd,"Corrupt arena\n");
            return;
        }
	else {fprintf(fd,"\n"); return;}
    }
}
#endif /* DEBUG */

#endif /* _STDLIB_H  */
