/*
 *  $Id: r.pars.c,v 2.4 2001/08/09 10:02:38 w Exp w $
 *
 *   RED.
 *
 *   r.pars.c -    RED.
 *
 *  $Log: r.pars.c,v $
 *  Revision 2.4  2001/08/09 10:02:38  w
 *  Legacy restriction removed: 32767 lines maximum at writing
 *  editing result.
 *  Fixes for ANSI-fication, "-fwritable-strings -Wtraditional"
 *  options do not reqired anymore, and -Wall going well.
 *  Some fixes "0 vs. NULL" pointers.
 *  New undocumented feature: "arg: 0l rpl ..." work with
 *  whole file now.
 *  'register' type qualifyer on the way of removing.
 *  dumpfsd() fixed to be functional (enabled by -DDEBUG).
 *  [s]append(...,"") using improved a bit.
 *  dumpfsd() activation changed to ^X.
 *  Version numbering changed to major.minor.ext.build scheme.
 *
 *  Revision 2.3  1998/05/13 18:34:30  w
 *  ANSI-     glibc  redhat-5.0.
 *       .
 *
 *  Revision 2.2  1997/06/12 23:15:29  w
 *    gt.
 *          -8,
 *     g_table (  ).
 *    .
 *      splitline(), openlines(). ( ""
 *      ).
 *    CSI (0233).
 *    cntrl- (  ,
 *    termio (BSD)):      (0377).
 *   /    ""   .
 *
 *  Revision 2.1  1997/06/02 18:47:53  w
 *     .
 *
 *  Revision 2.0  1997/05/30 18:33:56  w
 *  !!!
 *  Red   8- (control-   ).
 *         .
 *
 *  Revision 1.2  1997/04/26 13:32:03  w
 *   
 *
 *  Revision 1.1  1997/04/26 09:48:37  w
 *  Initial revision
 *
 *  Revision 4.20  90/05/22  23:21:36  alex
 *  First rev. red 4.2
 */
#include "r.defs.h"

# define ZZ(a,b)    ((((a) & 0377) << 8 | ((b) & 0377)) | (040 << 8) | 040)
# define C1(zz)     ((((zz) >> 8) & 0377) & 0137)
# define C2(zz)     ((zz) & 0377)

/*
 *    
 *    
 */
struct cmd_names {
    int cmd_zz;
    int cmd_cod;
} cmd_names[] = {

		   /*  / Return */
  { ZZ('R','t'),    CCRETURN        },          /* ReTurn       */

		   /*    */
  { ZZ('C','d'),    CCMOVEDOWN,     },          /* CursorDown   */
  { ZZ('C','h'),    CCHOME,         },          /* CursorHome   */
  { ZZ('C','l'),    CCMOVELEFT,     },          /* CursorLeft   */
  { ZZ('C','-'),    CCMOVELEFT,     },          /* CursorLeft   */
  { ZZ('C','r'),    CCMOVERIGHT,    },          /* CursorRight  */
  { ZZ('C','+'),    CCMOVERIGHT,    },          /* CursorRight  */
  { ZZ('C','u'),    CCMOVEUP,       },          /* CursorUp     */
  { ZZ('C','b'),    CCBEGIN,        },          /* CursorBegin  */
  { ZZ('C','e'),    CCEND,          },          /* CursorEnd    */

		   /*   */
  { ZZ('F','d'),    CCDRAWMODE,     },          /* FramesDraw trigger */

		   /*    */
  { ZZ('T','-'),    CCBACKTAB,      },          /* TabLeft      */
  { ZZ('T','l'),    CCBACKTAB,      },          /* TabLeft      */
  { ZZ('T','r'),    CCTAB,          },          /* TabRight     */
  { ZZ('T','+'),    CCTAB,          },          /* TabRight     */
  { ZZ('T','s'),    CCTABS,         },          /* TabSet       */

		   /*        */
  { ZZ('W','l'),    CCWORDLEFT,     },          /* WordLeft     */
  { ZZ('W','r'),    CCWORDRIGHT,    },          /* WordRight    */
  { ZZ('W','s'),    CCWORDSELECT,   },          /* WordSelect   */
  { ZZ('W','g'),    CCWORDGET,      },          /* WordGet      */

		   /*     */
  { ZZ('P','+'),    CCPLPAGE,       },          /* PageNext     */
  { ZZ('L','+'),    CCPLLINE,       },          /* LineNext     */
  { ZZ('P','r'),    CCRPORT,        },          /* PageRight    */
  { ZZ('P','-'),    CCMIPAGE,       },          /* PagePrev     */
  { ZZ('L','-'),    CCMILINE,       },          /* Line-        */
  { ZZ('P','l'),    CCLPORT,        },          /* PageLeft     */
  { ZZ('G','o'),    CCGOTO,         },          /* GOto         */

		   /*     */
  { ZZ('S','+'),    CCPLSRCH,       },          /* Search+      */
  { ZZ('S','-'),    CCMISRCH,       },          /* Search-      */
  { ZZ('S','p'),    CCPSEARCH,      },          /* SearchP      */

		   /*    */
  { ZZ('D','c'),    CCDELCH,        },          /* DelChar      */
  { ZZ('B','s'),    CCBACKSPACE,    },          /* BackSpace    */
  { ZZ('I','m'),    CCINSMODE,      },          /* InsertMode   */
  { ZZ('Q','c'),    CCCTRLQUOTE,    },          /* QuoteChar    */
  { ZZ('U','d'),    CCUNDO,         },          /* UnDo edition */

		   /*     */
  { ZZ('W','c'),    CCCHPORT,       },          /* WindChange   */
  { ZZ('W','m'),    CCMAKEPORT,     },          /* WindMake     */
  { ZZ('W','z'),    CCZOOMPORT,     },          /* Window Zoom  */

		   /*        */
  { ZZ('L','i'),    CCOPEN,         },          /* LineInsert   */
  { ZZ('L','d'),    CCCLOSE,        },          /* LineDelete   */
					       /* LineErase    */
  { ZZ('L','t'),    CCTRUNCATE,     },          /* LineTruncate */
  { ZZ('L','s'),    CCLINESPLIT,    },          /* LineSplit    */
  { ZZ('L','j'),    CCLINEJOIN,     },          /* LineJoin     */
  { ZZ('B','g'),    CCPICK,         },          /* BufGet       */
  { ZZ('B','p'),    CCPUT,          },          /* BufPut       */
					       /* BufReplace   */
		   /*     */
  { ZZ('F','o'),    CCSETFILE,      },          /* FileOpen     */
  { ZZ('F','s'),    CCSAVEFILE,     },          /* FileSave     */
					       /* FileChange   */
		   /*   */
  { ZZ('E','c'),    CCDOCMD,        },          /* ExecCmd      */
  { ZZ('E','n'),    CCENTER,        },          /* ENter        */
  { ZZ('A','s'),    CCSELECT,       },          /* ArgSelect    */
  { ZZ('Q','u'),    CCQUIT,         },          /* QUit         */
  { ZZ('R','s'),    CCRESCREEN,     },          /* ReScreen     */
  { ZZ('H','e'),    CCHELP,         },          /* HElp         */

		   /*    */
  { ZZ('M','c'),    CCDEFMACRO,     },          /* MacroCreate  */
  { ZZ('M','s'),    CCSAVEMACRO,    },          /* MacroSave    */
  { ZZ('M','r'),    CCREADMACRO,    },          /* MacroRead    */

    /*   */
  { 0, 0 }
};

/*
 * makecc(s) -     
 */
int makecc (s)
char *s;
{
    int c;
    register struct cmd_names *pcm;

    if (s[0] == '?' && s[1] == 0)
	return(CCHELP);
    if (*s == '$') {
	c = s[1] | 040;
	if (c == '$')
	    return(CCMAC);
	if (c >= '0' && c <= '9')
	    c = 'z' + 1 + (c - '0');
	c = c - ('a' | 040) + CCMAC + 1;
	if (!ISMACRO(c))
	    return(-1);
	return(c);
    }
    c = ZZ(s[0], s[1]);
    for (pcm = cmd_names; pcm->cmd_zz; pcm++) {
	if (pcm->cmd_zz == c) {
	    return(pcm->cmd_cod);
	}
    }
    return(-1);
}

/*
 * char *makecs(c) -      
 *      
 * NULL -  
 */
char *makecs(c)
int c;
{
    static char ss[3]; /* 2   0 */
    register struct cmd_names *pcm;

    /*  -   */
    if (ISMACRO(c)) {
	ss[0] = '$';
	ss[1] = (c - CCMAC + 1) + 'a';
	return(ss);
    }
    /*   -    */
    if (!ISACMD(c))
	return(NULL);
    for (pcm = cmd_names; pcm->cmd_zz; pcm++) {
	if (pcm->cmd_cod == c) {
	    ss[0] = C1(pcm->cmd_zz);
	    ss[1] = C2(pcm->cmd_zz);
	    return(ss);
	}
    }
    return(NULL);
}

/*
 * SelectArgs(line, av, MAX) = ac
 * -     
 *     av,  
 *   . ac < 0 - 
 *  -  ''
 *             ""
 *             
 *             ;
 *         ; -  ,  
 *         "semiColon"
 *    
 */
static char semiColon[2];

int SelectArgs(cp, execargs, maxargs)
register char *cp;
char *execargs[];
int maxargs;
{
    register char **e = execargs;
    register char *wp;

    semiColon[0] = ';';
    semiColon[1] = 0;
    while (*cp == ' ' ) cp++;
    wp = cp;
    while (*cp != 0) {
	*e++ = wp;              /*   */
	if ((e-execargs) >= maxargs) goto noargerr; /*   */
	/*     */
	while ( *cp && *cp != ';' && *cp != ' ' && *cp != '\n' )
	{
	    if (*cp == DQUOTA) {
		cp++;
		while (*cp !=  DQUOTA)
		    if (*cp == 0) goto noargerr;
		    else *wp++ = *cp++;
		cp++;
		continue;
	    };
	    if (*cp == QUOTA) {
		cp++;
		while (*cp !=  QUOTA)
		    if (*cp == 0) goto noargerr;
		    else *wp++ = *cp++;
		cp++;
		continue;
	    };
	    while (*cp != ';' && *cp != DQUOTA && *cp != QUOTA &&
		   *cp != ' ' && *cp != '\n' && *cp ) *wp++ = *cp++;
	}
	if ( *cp == ';' ) {
		*e++ = semiColon;       /* ; -    */
		if ((e-execargs) >= maxargs) goto noargerr; /*   */
	}
	while ( *cp == ';' || *cp == ' ' || *cp == '\n') *cp++ = 0;
	*wp++ = 0;
    }
    *e = 0;
    return(e - execargs);
noargerr:
    return(-1);
}

/*
 *  :
 * # 
 * " 
 * <> 
 * [{.}][][ ][; ...]
 * . - ,    Rt,      
 *  -  ,   1
 *  , @,      
 *   ,  En;@ ; ,  
 * ------
 * En
 *  
 * 
 * -------
 */
/*
 * 
 * Sel1cmd -  1      ';'
 * Sel1cmd(ac1,av1,ac, av)
 */
# define Get1cmd(ac1, av1, ac, av) {\
    for (ac1 = 0, av1 = av;\
	 ac > 0 && *av != semiColon;\
	 ac--, av++, ac1++);\
    if (ac > 0)\
	ac--, av++;\
}

/*
 * char *ParseCmd(d_cmd, ac, av )
 * struct cmdstr *d_cmd
 * -  1 
 *    
 *    NULL,   -   
 */
char *ParseCmd(pd, ac, av)
register struct cmdstr *pd;
int ac;
char **av;
{
    register char *p;
    register int i;
    int l = 0;      /*    */

    p = av[0];
    i = 0;
    pd->cmd_break = 0;
    if (*p == '.') {
	p++;
	pd->cmd_break = 1;
    }
    while (*p >= '0' && *p <= '9') {
	i = i*10 + (*p - '0');
        p++;
	l++;
    }
    /*   -   1  */
    if (l == 0)
	i = 1;
    av++; 
    ac--;
    pd->cmd_rep = i;
    if (p[0] == '@' && p[1] == 0)
	i = 0;
    else
	i = makecc(p);
    if (i < 0)
	return("Illegal command");
    pd->cmd_cmd = i;

    /*      ,    .  0  1 */
    if (ac < 0 || ac > 1)
	return("Illegal opt. count");
    pd->cmd_ac = ac;
    if (ac == 1)
	pd->cmd_av = av;
    else
	pd->cmd_av = (char **)0;
    return(NULL);
}


/*
 * schar *ReadMFile (r_proc, err_proc)
 *    - 
 * (*r_proc)(buf, len) -   
 *     
 * (*err_proc)(s1,s2)
 * -    
 */
/*
 * 1.   
 * 2.  - _ = 0
 * 3.   
 * 4. !
 * 5.  1-  != ".",   ,    Rt
 * 6.  1-  ' '  '"',   , _ = 1, 
 * 7.  1-  "'"  ".",   1
 * 8.  ,  __
 * 9.  =
 * 10.   
 * 11.  ,  "En", 
 * 12. 
 * 13.    
 * 14.    !
 * 15.  
 * 16.  (__)
 */
# ifndef MAX_MACLEN
# define MAX_MACLEN 512
# endif
# ifndef MAX_ILINE
# define MAX_ILINE  128
# endif

schar *macrobuf, *mep;
schar *mp;

# define MPUTC(c, Err)  if (mp  > mep) {\
			    goto Err;  }\
			else {\
			    *mp++ = (c); }

# define MINIT(len) {\
			mp = macrobuf = salloc(len, sizeof(schar)) ;\
			mep = &macrobuf[len-2] ;\
		    }

# define MGET   ((*mp++ = 0), macrobuf)

# define MFREE  if ((void *)macrobuf != NULL) {\
		    free((void *)macrobuf) ;\
		    macrobuf = (schar *)NULL ;\
		} else

# ifdef PARSERDEB
# define DEB(s) ErrI(1,s)
#else
# define DEB(s) /* */
# endif
/* */
schar *ReadMFile(r_proc, err_proc)
char *(*r_proc)();
int (*err_proc)();
{
    char line[MAX_ILINE+2],
	 *args[MAX_IARGS+1],
	 **av,
	 **av1;
    register unsigned char *p;
    schar sc, *sp ;
    struct cmdstr scmd;
    int ac, ac1;
    /*int rep;*/
    int was_text;
    int errors = 0;

    was_text = 0;
    MINIT(MAX_MACLEN);
    DEB("Mread start");
    sp = NULL;
    while ((*r_proc)(line,MAX_ILINE) != NULL) {
	DEB(line);
	if (line[0] == '#' )
	    continue;
	if (line[0] == ' ' || line[0] == '"' ) {
	    if (was_text) {
		MPUTC(CCRETURN, too_long);
	    }
	    for (p = &line[1]; *p && *p != '\n' ; p++) {
		sc = *p ;
		MPUTC(sc & 0377, too_long);
	    }
            was_text = 1;
            continue;
        }
	DEB("Start select");
        ac = SelectArgs(line, args, MAX_IARGS);
	av = args;
	DEB("End select");
	if (ac < 0) {
	    (*err_proc)("Syntax error");
            errors = 1;
            continue;
        }
	while (ac > 0) {
	    DEB("Start GET1");
	    Get1cmd(ac1, av1, ac, av);
	    if (ac1 <= 0 )
		continue;
	    p = ParseCmd(&scmd, ac1, av1);
	    if (p != NULL) {
		(*err_proc)(p);
                errors = 1;
                continue;
            }
	    if (was_text && scmd.cmd_break) {
		MPUTC(CCRETURN, too_long);
	    }
	    was_text = 0;
	    while (scmd.cmd_rep-- > 0) {
		if (scmd.cmd_ac > 0) {
		    if (scmd.cmd_cmd) {
			MPUTC(CCENTER, too_long);
		    }
		    DEB("Arg");
		    DEB(*(scmd.cmd_av));
		    for (p = *(scmd.cmd_av); *p; p++) {
			sc = *p ;
			MPUTC(sc & 0377, too_long);
		    }
                }
		if (scmd.cmd_cmd) {
		    MPUTC(scmd.cmd_cmd, too_long);
		}
            }
            /*     */
        }
        /*   */
    }
    if (errors == 0) {
	sp = sappend(MGET, /* (schar *) "" */ NULL);
    }
    MFREE;
    return(sp);
too_long:
    (*err_proc)("Too long macro");
    while ((*r_proc)(line, MAX_ILINE) != NULL) ;
    MFREE;
    return(sp);
}

/*
 * WriteMFile(schar *macro, FILE *fd)
 * -  -   fd
 */
int WriteMFile(mp, fd)
register schar *mp;
FILE *fd;
{
    register char *cmd;
    register int lc, count;
    /*register int llc;*/
    schar *amp;
    char qchar;
    int ko = 0;

    while ( (lc = *mp++) ) {
	lc &= 0177777;
        /*    ,    */
	if ( !ISACMD(lc) && !ISMACRO(lc) ) {
	    putc('"', fd);
	    putc(lc, fd);
	    while ((lc = (*mp++ & 0777) ) && !ISACMD(lc) && !ISMACRO(lc) )
		putc(lc, fd);
	    putc('\n', fd);
	    mp--;
	} else {
	    if (lc == CCENTER) {
                amp = mp;
		while ( (lc = *amp++) ) {
		    lc &= 0177777 ;
		    if (ISACMD(lc) || ISMACRO(lc))
			break;
		}
                /*      -       */
		if (lc && (cmd = makecs(lc)) != NULL) {
		    fputs(cmd, fd);
                    qchar = DQUOTA;
		    putc(' ', fd);
		    putc(qchar, fd);
		    while (mp < amp-1) {
                        lc = *mp++;
			lc &= 0177777 ;
			if (lc == qchar) {
			    putc(qchar, fd);
			    qchar = (qchar == DQUOTA ? QUOTA : DQUOTA);
			    putc(qchar, fd);
                        }
			putc(lc, fd);
                    }
		    putc(qchar, fd);
		    putc('\n', fd);
                    mp = amp;
                    continue;
                }
            }
	    count = 1;
	    while ((*mp & 0177777) == lc) {
		count++;
		mp++;
	    }
            cmd = makecs(lc);
	    if (cmd == NULL) {
		ko = -1;
		cmd = "??";
	    }
	    if (count != 1)
		fprintf(fd, "%d%s\n", count, cmd);
	    else
		fprintf(fd, "%s\n", cmd);
        }
    }
    return(ko);
}

extern int rep_count;
/*
 * Param_cmd() -     paramv.
 * :
 *   -  , -1 - 
 *            paramtype - ,   param(0)
 *               paramtype == 2 -    
 *
 *  :    (<d> -     )
 * <d> -   
 * <d>KK<> -    
 * <d>KK <> -   
 * 1.  
 * 2. ,    
 * 3.   
 * 4.  paramv, paraml
 * 5.  paramtype
 * 6. 
 *   r.cmd.c <d>  
 */
int Param_cmd()
{
    register char *cp;
    /*register char *pv;*/
    int cmd;
    /*char *cpv;*/
    char *paramv1;
    int is_param = 0;

    paramv1 = s2i(paramv, &rep_count);
    if (paramv1 == NULL || rep_count <= 0)
	paramv1 = paramv;
    cp = paramv1;
    while (*cp && *cp != ' ') {
	cp++;
    }
    if (*cp == ' ') {
	*cp = '\0';
	is_param = 1;
	cp++;
    }
    cmd = makecc(paramv1);
    if (cmd < 0) {
	/*   paramv */
	if (is_param)
	    cp[-1] = ' ';
	rep_count = 0;
	return(-1);
    }
    if (*cp == 0) {
	paraml = 0;
	free(paramv);
	paramtype = (is_param ? 0 : 2 );
	return(cmd);
    }
    /*    */
    paraml = paraml - ( cp - paramv1);
    cp = append(cp,NULL);
    free(paramv);
    paramv = cp;
    paramtype = 1;

    return(cmd);
}

