/*
 *  $Id: r.rdf.c,v 2.2 2001/08/09 10:02:38 w Exp w $
 *
 *   RED.
 *
 *  r.rdf.c - ,     
 *                ,  
 *     (      , 
 *   ,     -    )
 *
 *  $Log: r.rdf.c,v $
 *  Revision 2.2  2001/08/09 10:02:38  w
 *  Legacy restriction removed: 32767 lines maximum at writing
 *  editing result.
 *  Fixes for ANSI-fication, "-fwritable-strings -Wtraditional"
 *  options do not reqired anymore, and -Wall going well.
 *  Some fixes "0 vs. NULL" pointers.
 *  New undocumented feature: "arg: 0l rpl ..." work with
 *  whole file now.
 *  'register' type qualifyer on the way of removing.
 *  dumpfsd() fixed to be functional (enabled by -DDEBUG).
 *  [s]append(...,"") using improved a bit.
 *  dumpfsd() activation changed to ^X.
 *  Version numbering changed to major.minor.ext.build scheme.
 *
 *  Revision 2.1  1998/05/13 18:34:30  w
 *  ANSI-     glibc  redhat-5.0.
 *       .
 *
 *  Revision 2.0  1997/05/30 18:33:56  w
 *  !!!
 *  Red   8- (control-   ).
 *         .
 *
 *  Revision 1.2  1997/04/26 13:32:03  w
 *   
 *
 *  Revision 1.1  1997/04/26 09:48:37  w
 *  Initial revision
 *
 *  Revision 4.20  90/05/22  23:22:26  alex
 *  First rev. red 4.2
 */
#include "r.defs.h"

/*
extern char *InitPath;
extern char *MacroFile;
extern char *RedKeys;
extern char *SetVar(), *AddKey(), *AddCmd();
extern char *StrCalc();
extern char *SetTab();
extern char *getkeys();
*/

/*
 * read_init(path) -
 *  -
 *
 * path - path    
 *
 *   :
 * # - 
 * set VAR VALUE -  
 * keytab {|add|replace}
 * .....
 * .
 * -     
 * termcap
 * ...
 * .
 * -   termcap-a
 * (      TERMCAP   )
 * .
 * macro Letter [Key]
 * 
 * .
 * -  
 *          
 *   (  gettc )
 *
 */
# define INI_SET        1
# define INI_KEY        2
# define INI_READ       3
# define INI_TERMCAP    4
# define INI_MACRO      5
# define INI_ATR        6
# define INI_TABS       7
# define INI_STAT       8

/*  -    */
# define ARGS(N)    (01 << (N))
# define ARGSA      017777

static struct ini_keys {
    char *i_keyw;
    int   i_args;
    int   i_kod;
} ini_keys[] = {
  { "set",      ARGS(2)|ARGS(1) ,   INI_SET,    },
  { "keytab",   ARGS(0)|ARGS(1),    INI_KEY,    },
  { "read",     ARGS(1),            INI_READ,   },
  { "termcap",  ARGSA,              INI_TERMCAP,},
  { "macro",    ARGS(1)|ARGS(2),    INI_MACRO,  },
  { "attr",     ARGSA,              INI_ATR,    },
  { "read",     ARGS(1),            INI_READ,   },
  { "tabset",   ARGSA,              INI_TABS,   },
  { "status",   ARGS(0),            INI_STAT,   },
  { NULL,       0,                  0           },
};

# ifndef MAX_ILINE
# define MAX_ILINE      128
# endif
# ifndef MAX_IARGS
# define MAX_IARGS      10
# endif

/*
 *      ..
 */
/*extern schar *ReadMFile();*/
FILE         *curr_ifd;
char         *curr_ifname;
int          curr_iline;

static char *ini_rline(char *buf, int len);
static int  mac_perr(char *s1, char *s2);

int ReadInit(path, sysinit)
char *path;
int sysinit;    /* 1 -    */
{
    char  *cp = NULL;
    schar *sp;
    FILE *ifd;          /*  */
    char *ifname;
    char *rname;
    int iline;
    /*    */
    char buf[MAX_ILINE];
    char *iargs[MAX_IARGS+1],**av;
    int i;
    int ac;
    /*char *next_path();*/
    struct ini_keys *pit;

    /*   */
    /* 1.    */
    while (path != NULL && ((ifname = next_path(&path)) != NULL)) {
	ifname = StrCalc(ifname);
	if ((ifd = fopen(ifname,"r")) != NULL )
	    goto read_file;
	free(ifname);
    }
    return(0);

read_file:
    curr_ifd = ifd;
    curr_ifname = ifname;
    curr_iline = 0;

    while (ini_rline(buf,MAX_ILINE)) {
	if (buf[0] == '#')
	    continue;
	ac = SelectArgs(buf, iargs, MAX_IARGS);
	if (ac < 0)
	    continue;
	for (pit = ini_keys; pit->i_keyw != NULL; pit++)
	    if (strcmp(pit->i_keyw, iargs[0]) == 0)
		break;
	if (pit->i_keyw == NULL) {
	    ErrI(1,"Unknown init command: ");
	    continue;
	}
	/*  .   */
	if ((ARGS(ac) | pit->i_args) == 0) {
	    ErrI(1,"Bad options count");
	    continue;
	}
	switch ( pit->i_kod ) {
	    case INI_SET:
		if ((cp = SetVar(iargs[1], &iargs[2], ac-2)) != NULL )
		    ErrI(1,cp);
		continue;
	    case INI_TABS:
		av = &iargs[1];
		ac -= 1;
		i = 0;  /*    */
		while (ac-- && (cp = SetTab( &i, *av++)) == NULL) ;
		if (cp != NULL)
		    ErrI(1, cp);
		continue;
	    case INI_KEY:
		if (ac == 2 && strcmp(iargs[1],"replace") == 0)
		    ClearKeys(0);
		else if (ac == 2 && strcmp(iargs[1], "add") != 0) {
		    ErrI(1, "Bad option in `keytab'");
		    continue;
		}
		while (ini_rline(buf,MAX_ILINE)) {
		    ac = SelectArgs(buf, iargs, MAX_IARGS);
		    if (sysinit     &&
			(cp = AddKey(ac, iargs)) != NULL)
			ErrI(1, cp);
		}
		curr_ifd = ifd;
		break;
	    case INI_TERMCAP:
		if (MatchTname(ac-1, iargs + 1) && sysinit)
		    GetTC(ifd, &curr_iline);
		else
		    while(ini_rline(buf, MAX_ILINE)) ;
		break;
	    case INI_MACRO:
		/*     */
		sp = ReadMFile(ini_rline, mac_perr);
		/* ,   */
		while (ini_rline(buf, MAX_ILINE)) ;
		/*   */
		if (sp != NULL)  {
		    i = NewMacro(iargs[1], sp);
		    if (i <= 0) {
			ErrI(1, "Illegal macro name");
			free(sp);
			break;
		    }
		    if (ac > 2 && sysinit) {
			cp = AddCmd(i, iargs[2]);
			if (cp)
			    ErrI(1, cp);
		    }
		}
		break;
	    case INI_READ:
		iline = curr_iline;
		rname = iargs[1];
		if (strcmp(rname,"NEXT") == 0)
		    rname = path;
		if ( strcmp(rname,"MACRO") == 0)
		    rname = MacroFile;
		if (ReadInit(rname,sysinit) <= 0
		    /* && rname != path */)
		{
		    ErrI(1, "Can not find init file: ");
		}
		curr_ifd    = ifd;
		curr_ifname = ifname;
		curr_iline  = iline;
		continue;
	    case INI_STAT:
		/*    */
		if (nportlist == 0 )
		    StateRead(ini_rline, mac_perr);
		/* ,   */
		while (ini_rline(buf, MAX_ILINE)) ;
		break;
	    default:
		break;
	}
	/*    */
	curr_ifd = ifd;
    }
    if (ifd != NULL)
	fclose(ifd);
    if (ifname)
	free(ifname);
    curr_ifname = NULL;

    return(1);
}

/*
 * ini_rline(buf,len) -   
 * NULL -      "."
 */
static char *ini_rline(buf, len)
char *buf;
{
    register char *p;
    if (curr_ifd == NULL)
	return(NULL);
next:
    curr_iline++;
    p = fgets(buf, len, curr_ifd);
    if ( p == NULL ||
	(p[0] == '.' && (p[1] == 0 || p[1] == '\n'))
    ) {
	curr_ifd = NULL ;
	return(NULL);
    }
/*      */
    if (p[0] == '#' || p[0] == '\n')
	goto next;
    return(p);
}

/*
 * ErrI(kod,s);
 * -       
 * - kod = 0 - Warn
 * -       1 - No fatal
 *         2 - fatal
 *  ko < 0,      
 */
static int errkod = -1;

int ErrI(ko, s)
int ko;
char *s;
{
    char c;
    char err_buf[256];
    char *Itoa();

    if (ko > errkod)
	errkod = ko;
    if (ko < 0 && errkod < 0)
	return(0);
    if (ko > 0) {
	if (s == NULL)
	    s = "";
	if (video_mode != 0) {
	    if ( curr_ifname )
		sprintf(err_buf, "Err `%s'(%d): %s",
			curr_ifname, curr_iline,s);
	    else
		sprintf(err_buf, "Err: %s", s);
	    putcha(COBELL);
	    error(err_buf);
	    sleep(1);
	} else {
	    sprintf(err_buf, "Error in `%s'(%d): %s",
		    curr_ifname, curr_iline,s);
	    printf("%s\n", err_buf);
	}
    }
    if (ko  < 0 && errkod == 1) {
	printf("Press any key to continue!..");
	read(0, &c, 1);
	errkod = 0;
    }
    return(1);
}

/*
 *    
 */
static int mac_perr(s1, s2)
char *s1,*s2;
{
    return(ErrI(1, s1));
}

/*
 * MatchTname(ac,av) - 1,      
 */
int MatchTname(ac,av)
int ac;
char **av;
{
    extern char *TtyType;  /*    */

    if (ac <= 0)
	return(1);
    while (ac && strcmp(*av, TtyType)) {
	ac--;
	av++;
    }
    if (ac > 0 )
	return(1);
    return(0);
}

/*
 * MacSave(path,howstate) -
 *      "path"
 *      path, 
 *    "%"
 * howstate -   
 * 0 -   
 * 1 - ,    , .  "/"
 * 2 -   
 */
int MacSave(path, howstate)
char *path;
int howstate;
{
    char *sname;
    FILE *fd;
    extern char *next_path(), *StrCalc();
    char keybuf[LKEYSTR];

    if (path == NULL)
	path = MacroFile;
    if (path[0] == '!') {
	howstate = 2;
	path++;
	if (!path[0])
	    path = MacroFile;
    }
    sname = StrCalc(next_path(&path));
    if (sname)
	unlink(sname);      /*   */
    if (sname == NULL || (fd = fopen(sname,"w")) == NULL) {
	sname = append(DIAG("Can't create ","   "), sname);
	error(sname);
	free(sname);
	return(-1);
    }
    telluser(DIAG("MSave: ", ": "), 0);
    telluser(sname,6);
    free(sname);    /*      */
    MacWrite(fd);
    TabWrite(fd);
    fprintf(fd, "set keys \"%s\"\n", getkeys(keybuf, LKEYSTR - 1));
    WriteSet(fd);
    if (howstate)
	StateWrite(fd,howstate);
    fclose(fd);

    return(0);
}

/*
 *     - MacRead(path)
 *
 */
void MacRestore(path)
char *path;
{
    if (path == NULL)
	path = MacroFile;
    telluser(DIAG("MRead:", ":"), 0);
    telluser(path, 7);
    ReadInit(path, 0);
    return;
}


/*
 * StateWrite(fd,howstate) -    
 *             -      
 * howtstate == 0 -  , 1 -     ,
 *                                    ,
 *              2 - 
 * :
 * status
 * 
 * Pl,r,t,b,m,p - left,right, top,bottom,marg, prev_port
 * 
 * PZ,p -  ZOOM 
 *      r < 0 -  r-LINEL, b<0 -  b-NLINES
 * fl0,c0,l,c, 
 *       F
 * ...
 * P...
 * F...  F ,   
 * ...
 * C__
 * Z__
 * . -  -   
 */
void StateWrite(fd,howstate)
FILE *fd;
int howstate;
{
    int i;
    register int portnum;
    char *fname;
    register struct viewport *port;

    if (!howstate ||
	(howstate == 1 && (nportlist == 1 ||
			   (zoomedp != NULL && nportlist == 2) ) ) )
	return;
    curwksp->ccol = cursorcol;
    curwksp->crow = cursorline;
    fprintf(fd,"status\n");
    for (i=0; i < nportlist; i++) {
	port = portlist[i];
	if (port == &zoomport)
	    fprintf(fd,"PZ,");
	else
	    fprintf(fd, "P%d,%d,%d,%d,%d,",
		    port->lmarg,
		    (port->rmarg >= LINEL-1? port->rmarg-LINEL:port->rmarg),
		    port->tmarg,
		    (port->bmarg + NPARAMLINES >= NLINES-1? port->bmarg-NLINES:port->bmarg),
		    (port->lmarg != port->ltext));
	fprintf(fd, "%d\n", port->prevport);
	curwksp = port->wksp;
	do {
	    char c;
	    curwksp = curwksp->next_wksp;
	    fname = openfnames[curwksp->wfile];
	    c = (port != curport            &&
		 curwksp == port->wksp      &&
		 (zoomedp == NULL || port == &zoomport)
		? 'F' : 'f') ;
	    if (fname == NULL   ||
		(howstate < 2 && (c != 'F'||fname[0] != '/') ) )
		continue;
	    fprintf(fd, "%c%d,%d,%d,%d,",
		    c,
		    curwksp->ulhclno,
		    curwksp->ulhccno,
		    curwksp->crow,
		    curwksp->ccol);
	    fprintf(fd, " %s\n", fname ? fname : "");
	}
	while (curwksp != port->wksp) ;
    }
    for (portnum = 0; portnum < nportlist; portnum++)
	if (portlist[portnum] == curport)
	    break;
    fprintf(fd, "C%d\n", portnum);
    if (zoomedp) {
	for (portnum = 0; portnum < nportlist; portnum++)
	    if (portlist[portnum] == zoomedp)
		break;
	fprintf(fd, "Z%d\n", portnum);
    }
    fprintf(fd, ".\n");

    return;
}

/*
 * StateRead(rline,err)
 *  
 *     (*rline)(s,len)
 *    - (*err)(s1,s2)
 */
void StateRead(rline, errpt)
char *(*rline)();
int   (*errpt)();
{
    char buf[MAX_ILINE];
    register int i;
    register struct viewport *port;
    int j, l, r, t, b, m, c, l0, c0;
    char *cp;
    char flg;       /* unused ? */

    if (RedKeys != NULL) {
      setkeys(RedKeys);
      free(RedKeys);
      RedKeys = NULL;
    }
    if (nportlist > 0)
	return;
    while ((*rline)(buf, MAX_ILINE)) {
        i = buf[0];
	switch (i) {
	    case 'C':
		if (sscanf(buf+1, "%d\n", &j) != 1 ||  j < 0 || j >= nportlist )
		    goto bad_args;
		switchport(portlist[j]);
		break;
	    case 'P':
		if (nportlist >= MAXPORTLIST) {
		    (*errpt)(DIAG("Too many ports","  "),NULL);
		    break;
		}
		if (buf[1] == 'Z') {
		    if (sscanf(buf+2, "%d\n", &j) != 1 )
			j = 0;
		    port = portlist[nportlist++]
			 = &zoomport;
		    switchport(&zoomport);
		} else {
		    if (sscanf(buf+1, "%d,%d,%d,%d,%d,%d\n",
			       &l, &r, &t, &b, &m, &j) != 6 )
			goto bad_args;
		    if (r < 0)
			r += LINEL;
		    if (b < 0)
			b += NLINES;
		    port = portlist[nportlist++]
			 = (struct viewport *)salloc(SVIEWPORT, sizeof(char));
		    setupviewport(port, l, r, t, b, m);
		    drawport(port, DRAW_HORI);
		}
		port->prevport = j;
		break;
	    case 'f':
	    case 'F':
		if (sscanf(buf+1, "%d,%d,%d,%d,%c%s\n",
			   &l0, &c0, &l, &c, &flg, buf) != 6 )
		    goto bad_args;
		cp = append(buf,NULL);
		editfile(cp, l0 + defplline, c0, 0, (i == 'F' ? 1 : 0));
		curwksp->ccol = c;
		curwksp->crow = l;
		poscursor(c,l);
		break;
	    case 'Z':
		if (sscanf(buf + 1, "%d\n", &j) != 1 )
		    goto bad_args;
		if (j < 0 || j >= nportlist - 1 )
		    goto bad_args;
		zoomedp = portlist[j];
		zoomflag = 1;
		break;
	    default:
		(*errpt)(DIAG("Unknown status line",
			      "   "));
		break;
        }
        continue;
bad_args:
	(*errpt)(DIAG("Bad args in status line",
		      "    "),NULL);
        continue;
    }
    return;
}

