/*
 *  $Id: r.tabs.c,v 2.2 2001/08/09 10:02:38 w Exp w $
 *
 *   RED.
 *
 *  r.tabs.c -   
 *
 *  $Log: r.tabs.c,v $
 *  Revision 2.2  2001/08/09 10:02:38  w
 *  Legacy restriction removed: 32767 lines maximum at writing
 *  editing result.
 *  Fixes for ANSI-fication, "-fwritable-strings -Wtraditional"
 *  options do not reqired anymore, and -Wall going well.
 *  Some fixes "0 vs. NULL" pointers.
 *  New undocumented feature: "arg: 0l rpl ..." work with
 *  whole file now.
 *  'register' type qualifyer on the way of removing.
 *  dumpfsd() fixed to be functional (enabled by -DDEBUG).
 *  [s]append(...,"") using improved a bit.
 *  dumpfsd() activation changed to ^X.
 *  Version numbering changed to major.minor.ext.build scheme.
 *
 *  Revision 2.1  1998/05/13 18:34:30  w
 *  ANSI-     glibc  redhat-5.0.
 *       .
 *
 *  Revision 2.0  1997/05/30 18:33:56  w
 *  !!!
 *  Red   8- (control-   ).
 *         .
 *
 *  Revision 1.2  1997/04/26 13:32:03  w
 *   
 *
 *  Revision 1.1  1997/04/26 09:48:37  w
 *  Initial revision
 *
 *  Revision 4.20  90/05/22  23:22:20  alex
 *  First rev. red 4.2
 */
#include "r.defs.h"

SCALE tabstps[LSCALE(MAXTCOL)];
int chg_tabs;
int deftabstep = 8;         /*    */

/*
 * char *SetTab(&tcol,cmd) -
 *   
 * - NULL - O'K,    
 *   - tcol
 * 
 * "-" -  .   
 * "[+]" -  .   
 * "-" -   
 * "*" -  .   , .  
 * "ac" == 0 -  av == 0 -  . 
 *                  != 0 - 
 *   - chg_tabs = 1;
 */
char *SetTab(tcol, cmd)
register int *tcol;
char *cmd;
{
    int set;        /* 0 - . , 1 -  , 2 - .  , 3 -    */
    int count;
    register int i;
    count = -1;
    if (cmd == NULL) {
	set = 0;
	cmd = "";
    } else {
	switch (*cmd) {
	    case 0:
		set = 3;
		break;
	    case '+':
		set = 0;
		cmd++;
		break;
	    case '-':
		set = 1;
		cmd++;
		break;
	    case '*':
		set = 2;
		cmd++;
		break;
	    default:
		if ( *cmd < '0' || *cmd > '9' )
		    goto err;
		set = 0;
		break;
	}
    }
    if (*cmd && (s2i(cmd, &count) != NULL))
	goto err;
    if (set != 2 && count > 0)
	*tcol = count - 1;
    if (*tcol > MAXTCOL || *tcol < 0)
	goto err1;
    switch (set) {
	case 0:
	    i = *tcol;
	    SETTAB(i);
	    break;
	case 1:
	    i = *tcol;
	    CLRTAB(i);
	    break;
	case 2:
	    if (count <= 0)
		count = deftabstep;
	    i = *tcol;
	    while (i < MAXTCOL) {
		SETTAB(i);
		i += count;
	    }
	    break;
	case 3:
	    i = *tcol;
	    /*      ,      */
	    while (i < MAXTCOL) {
		CLRTAB(i);
		i += 1;
	    }
	    break;
    }
    chg_tabs = 1;
    return(NULL);
err:
    return(DIAG("Bad. [+-*][NUM] is correct",".  [+-*][]"));
err1:
    return(DIAG("Bad col number",".  "));
}

/*
 * .  - deftabstep
 *     
 */
void InitTabs()
{
    int col = 8;
    SetTab( &col, "*");
}

/*
 * TabWrite(fd) -
 *     
 */
void TabWrite(fd)
FILE *fd;
{
    register int i;
    int t0 = -1;
    int count = -1;
    int isstar = 0;
    register int tcnt = 2;

    fprintf(fd,"tabset -1 \"\"");
    for (i = 1; i < MAXTCOL+1; i++ ) {
	if ( !ISTAB(i-1) )
	    continue;
	/*      count -  t0,   */
	if (count > 0 && ((i - t0) == count)) {
            t0 = i;
	    if (!isstar) {
		fprintf(fd," *%d",count);
		isstar = count;
	    }
            continue;
        }
	isstar = 0;
        /*  ? */
	if (tcnt + 3 >= MAX_IARGS) {
            tcnt = 0;
            fprintf(fd,"\ntabset");
        }
        /*      -    */
	if (t0 < 0 || count < 0) {
            fprintf(fd," %d", i);
	    tcnt++;
	    if (t0 > 0)
		count = i - t0;
            t0 = i;
            continue;
        }
        /*   */
	fprintf(fd," %d %d \"\"", i, i + 1);
        tcnt += 3;
        count = -1;
        t0 = -1;
    }
    fprintf(fd,"\n");
    return;
}

/*
 * char *settab(tcol,str) -  ,      
 *                   NULL -  .
 *                   ""   -  .
 */
char *settab(tabcol,arg)
int tabcol;
char *arg;
{
    char *args[MAX_IARGS+1], **av;
    int ac;
    char *ko = NULL ;

    av = args;
    /*       */
    if ((arg == NULL) || !*arg )
	return(SetTab(&tabcol, arg)) ;
    ac = SelectArgs(arg, av, MAX_IARGS);
    while (ac-- &&
	   ((ko = SetTab( &tabcol, *av++)) == NULL)) ;

    return(ko);
}

