/*
 *  $Id: r.tele.c,v 2.4 2001/08/09 10:02:38 w Exp w $
 *
 *   RED.
 *
 *  r.tele.c -    -  
 *
 *  $Log: r.tele.c,v $
 *  Revision 2.4  2001/08/09 10:02:38  w
 *  Legacy restriction removed: 32767 lines maximum at writing
 *  editing result.
 *  Fixes for ANSI-fication, "-fwritable-strings -Wtraditional"
 *  options do not reqired anymore, and -Wall going well.
 *  Some fixes "0 vs. NULL" pointers.
 *  New undocumented feature: "arg: 0l rpl ..." work with
 *  whole file now.
 *  'register' type qualifyer on the way of removing.
 *  dumpfsd() fixed to be functional (enabled by -DDEBUG).
 *  [s]append(...,"") using improved a bit.
 *  dumpfsd() activation changed to ^X.
 *  Version numbering changed to major.minor.ext.build scheme.
 *
 *  Revision 2.3  1998/05/13 18:34:30  w
 *  ANSI-     glibc  redhat-5.0.
 *       .
 *
 *  Revision 2.2  1997/12/29 19:04:39  w
 *     ,   
 *      .
 *  (       ).
 *
 *  Revision 2.1  1997/06/12 23:15:29  w
 *    gt.
 *          -8,
 *     g_table (  ).
 *    .
 *      splitline(), openlines(). ( ""
 *      ).
 *    CSI (0233).
 *    cntrl- (  ,
 *    termio (BSD)):      (0377).
 *   /    ""   .
 *
 *  Revision 2.0  1997/05/30 18:33:56  w
 *  !!!
 *  Red   8- (control-   ).
 *         .
 *
 *  Revision 1.2  1997/04/26 13:32:03  w
 *   
 *
 *  Revision 1.1  1997/04/26 09:48:37  w
 *  Initial revision
 *
 * Revision 4.20  90/05/22  23:22:14  alex
 * First rev. red 4.2
 * 
 * Revision 4.10  90/02/05  19:52:32  alex
 * Base revision 4.1
 * 
 * Revision 4.1  88/03/31  22:04:50  alex
 *  4.1 -   UTEC, 
 * 
 * Revision 3.9  88/03/30  17:26:53  alex
 *    readch.    /
 *     ChangeScroll/InsertLine-DeleteLine.
 * 
 * Revision 3.1.2.6  87/07/09  20:43:27  alex
 * REVISION
 * 
 * Revision 3.1.2.5  87/07/03  22:03:22  alex
 * Graph_characters used in margin
 * 
 * Revision 3.1.2.4  87/06/29  17:56:51  alex
 * Commans set to 0200-0277
 * 
 * Revision 3.1.2.3  87/06/24  22:35:47  alex
 * New readch + gettc + tc table Tested
 * 
 * Revision 3.1.2.2  87/06/23  18:53:01  alex
 * wYNESENA PEREMENNAQ lread1 I \TO OTLAVENO
 * 
 * Revision 3.1.2.1  87/06/19  17:02:06  alex
 * Start revision for red/4
 * 
 * Revision 3.8  87/06/12  18:11:27  alex
 *     vilcase    vt-200
 * 
 * Revision 3.7  87/06/06  16:49:42  alex
 *  roll    sr/sf  
 *     -t +  
 * 
 * Revision 3.6  87/06/05  23:51:24  alex
 *  roll    sr/sf  
 *     -t +  
 * 
 * Revision 3.5  87/06/04  23:44:33  alex
 * Scroll on -sr- or -al/dl- added
 * 
 * Revision 3.4  86/09/19  19:55:47  alex
 *   -1700
 * 
 * Revision 3.3  86/08/04  20:52:54  alex
 * Bepqh dk LMNQ/DELNQ 2
 * 
 * Revision 3.2  86/07/24  19:05:13  alex
 * '      
 * 
 * Revision 3.1.1.6  86/07/15  22:13:45  alex
 * RED 3.3/EC.
 * 
 * Revision 3.1.1.5  86/06/20  23:35:44  alex
 * 
 * Revision 3.1.1.4  86/06/16  22:19:58  alex
 *      ( )
 * 
 * Revision 3.1.1.2  86/06/05  18:54:17  alex
 * __
 * 
 * Revision 3.1.1.1  86/06/05  00:06:18  alex
 * __
 * 
 * Revision 3.1  86/04/20  23:42:39  alex
 *    .
 * 
 * Revision 3.1  86/04/20  23:42:39  alex
 * *** empty log message ***
 * 
 * Revision 1.5  86/04/13  22:01:59  alex
 */

#include "r.defs.h"

#ifdef DEMOSES
#define fixcurs() /* */
#endif

/*   out_win(l0,lf,c0,cf) -    l0  lf,   c0  cf
 *    cf < 0 -    
 *    lf < 0 -    
 *   out_lines(l0,lf ) == out_win(l0,lf,-1,-1)
 *   out_cols (c0,cf) == out_win(cursorline,cursorline,c0,cf)
 *    :  c0 == cf,    , 
 *           
 */
void out_cols(c0,cf)
int c0,cf;
{
    out_win(cursorline, cursorline, c0, cf);
}

void out_lines(l0,lf)
int l0,lf;
{
    out_win(l0,lf,0,-1);
}

void out_win(l0,lf,c0,cf)
int l0,lf;
int c0,cf;
{
    register int col;   /*   */
    register int i;     /*   */
    int lin, alin;      /*   - .  .  */
    int fc, lc;         /*       () */
    schar lmc;
    schar rmargflg;
    int uc;             /*      */
    register char *cp;  /*   y */
    char *ce;           /* .    */

    if (zoomflag && curport != &zoomport)
	return;
    if (cf < 0)
	cf = curport->rtext;
    if (lf < 0)
	lf = curport->btext;
    uc = ABS_COL(0);
    lmc = (curport->lmarg == curport->ltext
	  ? 0 : uc == 0 ? LMCH : MLMCH);
    rmargflg = (curport->ltext + curport->rtext < curport->rmarg);
    while ((lin = l0++) <= lf) {
	if (lin != lf && intrup())
	    return;
	if (!getline(alin = ABS_LIN(lin))) {
	    if (lmc)
		lmc = BLMCH;
        }
	if (lmc != curport->lmchars[lin] && lmc != 0) {
	    poscursor(-LMARG, lin);
	    putch(lmc | A_MARG, 0);
	    curport->lmchars[lin] = lmc;
        }
	if (rmargflg != 0)
	    rmargflg = RMCH;
        /*        */
        cp = cline + uc + c0;
	if (uc + cf + 1 < ncline-1) {
	    ce = cline + (uc + cf + 1);
	    rmargflg = MRMCH;   /*      */
	} else
            ce = cline + (ncline-1);

        /*      fc, lc */
	fc = 0x7fff & curport->firstcol[lin] ;
	lc = 0x7fff & curport->lastcol[lin]  ;
        /*     -    */
        i = 0;
        col = c0;
        /* !        */
	if (fc >= c0) {
	    while (cp < ce && *cp == ' ') {
		if (col >= fc) {
		/*    ,        */
		    if (!i)
			poscursor(col,lin), setatr(A_NORM);
                    i++;
                }
                col++;
                cp++;
            }
	    if (i > 0)
		putblanks(i);
	    /*  1. fc     2.    */
	    if (col != fc && (fc <= cf || cp < ce))
		(curport->firstcol)[lin] = col;
        }
        /*     */
	if (cp < ce) {
	    if (i == 0)
                poscursor(col,lin), setatr(A_NORM);
            i = 0;
	    while (cp < ce) {
                putcha(*cp++);
                i++;
            }
            cursorcol += i;
            col += i;
            /*   -       */
	    if (col > curport->rtext  &&
                *cp != NEWLINE )
            {
		if (!rmargflg) {
		    poscursor(col-1, lin);
		    setatr(A_INFO);
		    putcha(cp[-1]);
		}
            }
        }
        /*          */
        /*   col==0 -  .    -1 */
        /* lc          */
        /* i == 0,     . ,  .  */
	if ( lc <= cf +1 )
            (curport->lastcol)[lin] = col;
        else
	    lc = cf+1; /*  */
	/*      - c0 == cf,   ' '  */
	/* 1. c0 == cf 2.    */
	   if ( cf == c0 && i == 0)
		lc = col+1; /*    */
	   if ( lc > col )
	    {
		if ( !i ) poscursor(col,lin), setatr(A_NORM);
		putblanks(lc-col);
	    }
	/*   .   ,   */
	if (sel_flag                    &&
	    curwksp == sel_wspace       &&
	    sel_lin == alin             &&
	    (i = (sel_col-uc)) >= c0    &&
	    i <= cf )
	{
	    poscursor(i, lin);
	    putch('+' | A_ERROR, 1);
	}
	/*    */
	if (rmargflg && rmargflg != curport->rmchars[lin]) {
            poscursor(curport->rmarg - curport->ltext, lin);
	    putch(rmargflg | A_MARG, 0);
	    curport->rmchars[lin] = rmargflg;
        }
    }
}


/*
 * out_mark(lin,col,N)
 *     
 * 0 -  
 * 1 -  
 */
void out_mark(lin,col,marka)
register int lin,col,marka;
{
    int l,c;
    lin = REL_LIN(lin);
    col = REL_COL(col);
    if (    lin < 0                 ||
	    col < 0                 ||
	    lin > curport->btext    ||
	    col > curport->rtext)
        return;
    l = cursorline;
    c = cursorcol;
    if (marka == 0) {
	out_win(lin, lin, col, col);
    } else {
        poscursor(col,lin);
	putch('+' | A_ERROR, 1);
    }
    poscursor(c,l);
}

/*
 * poscursor(col,lin) -
 *     
 */
void poscursor(col,lin)
int col,lin;
#ifndef DEMOSES
{ 
    register int scol,dcol,dlin;
    int slin,alin;

    if (cursorcol + curport->ltext >= LINEL)
	goto direct;
    if (cursorline == lin) {
	if (cursorcol == col)
	    return;
	if (cur_atr != 0)
	    goto direct;
	if ((cursorcol == col - 1) && (putcha(CORT))) {
            ++cursorcol;
            return;
        }
	if ((cursorcol == col + 1) && (putcha(COLT))) {
            --cursorcol;
            return;
        }
    }
    if (cursorcol == col) {
	/*   scroll-  */
	if (    n0scroll == (alin = cursorline + curport->ttext) ||
		n1scroll == alin)
	    goto direct;
	if (cur_atr != 0)
	    goto direct;
	if ((cursorline == lin - 1) && (putcha(CODN))) {
            ++cursorline;
            return;
        }
	if ((cursorline == lin + 1) && (putcha(COUP))) {
            --cursorline;
            return;
        }
    }
direct:
    scol = col + curport->ltext;
    slin = lin + curport->ttext; /* screen col, lin */
    dcol = col - cursorcol;
    dlin = lin - cursorline;           /* delta col,lin   */
    cursorcol = col;
    cursorline = lin;
    if (pcursor(scol, slin))
	return;         /* direct positioning */
    if ((abs(scol) + abs(slin)) < (abs(dcol) + abs(dlin))) {
        putcha(COHO); 
	dcol = scol;
	dlin = slin;
    }
    if (dcol > 0) {
	while (dcol--)
	    putcha(CORT);
    } else if (dcol<0) {
	while (dcol++)
	    putcha(COLT);
    }
    if (dlin > 0) {
	while (dlin--)
	    putcha(CODN);
    } else if (dlin < 0) {
	while (dlin++)
	    putcha(COUP);
    }
    return;
}
#else +DEMOSES
{ 
    register int scol, slin;
    if (cursorline == lin && cursorcol == col ) return;
    scol=col+curport->ltext; 
    slin=lin+curport->ttext; /* screen col, lin */
    cursorcol=col;cursorline=lin;
    pcursor(scol,slin);
    return;
}
#endif +DEMOSES

/*
 *           "curscreen"
 *
 *   0,    ,   .
 *
 *       :
 *
 *               0 -   ( )
 *     CCMOVEUP    - 
 *     CCRETURN    -    
 *     CCMOVEDOWN  -   
 *     CCMOVERIGHT -   
 *     CCMOVELEFT  -   
 *     CCTAB       -  
 *     CCBACKTAB   -  
 *
 *              .
 */
int movecursor(arg, fix)
int arg;
int fix;    /*   ,      */
{
    register int lin, col;
    int ko;

    ko  = 0 ;
    lin = cursorline;
    col = cursorcol;
    switch (arg) {
	case 0:
	    break;
	case CCHOME:
	    col = lin = 0;
	    break;
	case CCMOVEUP:
	    if (!fix && lin == curport->tedit + defedit) {
		ko = CCMILINE;
		goto retn;
	    }
	    --lin;
	    break;
	case CCRETURN:
	    col = curport->ledit;       /* break   */
	    if (on_autoi)
		col = REL_COL(autoindent);
	case CCMOVEDOWN:
	    if (!fix && lin == curport->bedit - defedit) {
		ko = CCPLLINE;
		goto retn;
	    }
	    ++lin;
	    break;
	case CCMOVERIGHT:
	    ++col;
	    break;
	case CCMOVELEFT:
	    --col;
	    break;
	case CCTAB:
	    col = col + curwksp->ulhccno;
	    while (++col < MAXTCOL && !ISTAB(col))
		;
	    col -= curwksp->ulhccno;
	    break;
	case CCBACKTAB:
	    col = col + curwksp->ulhccno;
	    while (--col > 0 && !ISTAB(col))
		;
	    col = (col < 0 ? -1 : col - curwksp->ulhccno);
	    break;
    }
    if (!fix) {
	if (col > curport->redit)
	    col = curport->redit, ko = CCRPORT;
	else if (col < curport->ledit)
	    col = curport->ledit, ko = CCLPORT;
	if (lin < curport->tedit)
	    lin = curport->tedit, ko = CCMILINE;
	else if (lin > curport->bedit)
	    lin = curport->bedit, ko = CCPLLINE;
    } else {
	if (col > curport->redit)
	    col = curport->ledit;
	else if (col < curport->ledit)
	    col = curport->redit;
	if (lin < curport->tedit)
	    lin = curport->bedit;
	else if (lin > curport->bedit)
	    lin = curport->tedit;
    }
retn:
    poscursor(col, lin);
    return(ko);
}

/*
 * putch(c, flag) -
 *          .
 *        flag=1,   
 *        
 */
void putch(c, flg)
int c;
int flg;
{
    int atr;

    atr = c & ATRMASK;
    if (atr != cur_atr)
	setatr(atr);
    if (flg && c != ' ') {
        if ((curport->firstcol)[cursorline] > cursorcol)
            (curport->firstcol)[cursorline] = cursorcol;
        if ((curport->lastcol)[cursorline] <= cursorcol)
	    (curport->lastcol)[cursorline] = cursorcol + 1;
    }
#ifdef DEMOSES
    putcha(c);
    ++cursorcol;
#else /* -DEMOSES */
    ++cursorcol;
    if (fixcurs() == 0)
	putcha(c);
    if (cursorcol <= 0)
	poscursor(curport->ledit,
		  cursorline < curport->tedit ? curport->tedit :
		  cursorline > curport->bedit ? curport->tedit :
						cursorline);
    movecursor(0, fix_screen);
#endif /* -DEMOSES */
}

#ifndef DEMOSES
/*
 * fixcurs() -
 *     .
 *  cursorcol, cursorline   
 *   eolflag (=1 -     )
 *      cursorcol,   eolflag.
 *  :
 * 1)  cursorcol; 2)  fixcurs; 3)  ;
 * 4)  cursorcol <= 0,  . fixcurs  1,
 *         .
 */

int fixcurs()
{
    if (eolflag && curport->ltext+cursorcol >= LINEL)   /* for VT-52 */
    { 
	cursorcol = LINEL-curport->ltext;
        return 0;
    }
    if (curport->ltext + cursorcol >= LINEL) {
        cursorcol = - curport->ltext;
        if (curport->ttext + ++cursorline >= NLINES) {
            cursorline = - curport->ttext;
            putcha(COHO);
            return (1);
        }
    }
    return (0);
}


/*
 *  param() -  
 *        .
 *              paramtype = -1 --  
 *              paramtype = 0  --  
 *              paramtype = 1  -- .
 *                  paramtype = -2 - tag defined
 *         ,  paramv - .  .
 *           (paramv).
 *          paraml.
 *          paraml  0,  paramv
 *      ,      ,
 *        paraml.
 *       "param"      
 */
#define LPARAM 20       /*    */
int param(macro)
int macro;
{
    register char *c1;
    char *cp, *c2;
    register int i,pn;
    int lread1;
    struct viewport *w;
    int chr;

    if (paraml != 0 && paramv != NULL && paramv != 0)
	free(paramv);
    paraml = 0;
    paramv = NULL;

    paramc1 = paramc0 = cursorcol;
    paramr1 = paramr0 = cursorline;
    putch(COCURS, 1);
    poscursor(cursorcol, cursorline);
    w = curport;
back:
    telluser(macro ? "mac: " : "arg: ", 0);
    switchport(&paramport);
    poscursor(5,0);
    do {
	lread1 = readch();
    } while (lread1 == CCBACKSPACE) ;
    if (macro)
	goto rmac;
    if (ISACMD(lread1)) {
	switch (lread1) {
	    case CCMOVEUP:
	    case CCMOVEDOWN:
	    case CCRETURN:
	    case CCHOME:
	    case CCMOVERIGHT:
	    case CCMOVELEFT:
	    case CCTAB:
	    case CCBACKTAB:
	    case CCBEGIN:
	    case CCEND:
	    case CCWORDLEFT:
	    case CCWORDRIGHT:
		switchport(w);
		poscursor(paramc0,paramr0);
		unread1(lread1);
		return(CCSELECT);
	    default:
		paraml = 0;
		paramv = NULL;
		paramtype = 0;
	}
    } else {
rmac:           
	unread1(lread1);
        paraml = pn = 0;
loop:
	chr = lread1 = readch();
	if (pn >= paraml) {
            cp = paramv;
	    paramv = salloc(paraml + LPARAM + 1, sizeof(schar));    /* 1 for dechars */
            c1 = paramv;
            c2 = cp;
	    for (i=0; i < paraml; ++i)
		*c1++ = *c2++;
            if (paraml) free(cp);
            paraml += LPARAM;
        }
        /*    */
	if ( (!macro && ISACMD(lread1) && lread1 != CCCTRLQUOTE) ||
	     lread1 == CCBACKSPACE ||
	     lread1 == CCQUIT)
        {
	    if (lread1 == CCBACKSPACE &&  cursorcol != curport->ledit)
                /* backspace */
            {
		if (pn == 0)
                    goto loop;
		movecursor(CCMOVELEFT, 1);
                --pn;
		if ((paramv[pn] & 0340) == 0) {
		    putch(' ' | A_OUT, 0);
		    movecursor(CCMOVELEFT, 1);
		    movecursor(CCMOVELEFT, 1);
                }
                paramv[pn] = 0;
		putch(' ' | A_OUT, 0);
		movecursor(CCMOVELEFT, 1);
		if (pn == 0)
		    goto back;
                goto loop;
	    } else
		chr = 0;
        }
	if (chr == 0177)
	    chr = 0;    /* del is a contol code  */
	paramv[pn++] = chr;
	if (chr) {
	    if ((chr & 0140) == 0) {
		putch('^', 0);
		chr = chr | 0100;
            }
	    putch(chr | A_OUT, 0);
            goto loop;
        }
        paramtype = 1;
    }
    switchport(w);
    out_win(paramr0, paramr0, paramc0, paramc0);
    poscursor(paramc0, paramr0);
    setatr(A_NORM);
    return (lread1);
}
#endif /* -DEMOSES */

/*
 * drawport(newp,vertf) -
 *   newp (). vertf ,  
 *  .   : DRAW_HORI, DRAW_ALL, DRAW_TABS ( )
 */
void drawport(newp, vertf)
struct viewport *newp;
int vertf;
{
    struct viewport *newport;
    int i;
    int j;
    int cc,cl;
    int lu,ld,ru,rd;

    newport = newp;
    if (zoomflag && curport != &zoomport)
	goto retn;
    switchport(&wholescreen);
    cc = cursorcol;
    cl = cursorline;
    setscroll(&wholescreen,0);
    if (newport->tmarg == 0 ) {
	lu = LUCOR;
	ru = RUCOR;
    } else {
	lu = (newport->lmarg ? LUCOR : DLMAR);
	ru = (newport->rmarg != wholescreen.rmarg ? RUCOR : DRMAR);
    }
    if (newport->bmarg == wholescreen.bmarg - NPARAMLINES) {
	ld = LDCOR;
	rd = RDCOR;
    } else {
	ld = (newport->lmarg ? LDCOR : DLMAR);
	rd = (newport->rmarg != wholescreen.rmarg ? RDCOR : DRMAR);
    }
    if (vertf != DRAW_TABS && newport->tmarg != newport->ttext) {
	poscursor(newport->lmarg, newport->tmarg);
	putch(lu | A_MARG, 0);
	for (i = newport->lmarg + 1; i <= newport->rmarg - 1; i++)
	    /*--     --*/
	    putch(TMCH | A_MARG, 0);
	putch(ru | A_MARG, 0);
    }
    if (vertf == DRAW_ALL) {
	/*--     --*/
	for (j = newport->tmarg + 1; j <= newport->bmarg - 1; j++) {
	    poscursor(newport->lmarg, j);
	    putch(newport->lmchars[j - newport->tmarg - 1] | A_MARG, 0);
        }
	/*--     --*/
	for (j = newport->tmarg + 1; j <= newport->bmarg - 1; j++) {
	    poscursor(newport->rmarg, j);
	    putch(newport->rmchars[j - newport->tmarg - 1] | A_MARG, 0);
        }
    }
    if (newport->bmarg != newport->ttext + newport->btext) {
	poscursor(newport->lmarg, newport->bmarg);
	putch(ld | A_MARG, 0);
	for (j = newport->wksp->ulhccno,i = newport->lmarg+1;
	     i <= newport->rmarg - 1;
	     j++, i++)
	    putch(B_MARG(j) | A_MARG, 0);
	putch(rd | A_MARG, 0);
    }
    poscursor(cc, cl);
retn:
    switchport(newport);
    need_box = 0;
    chg_tabs = 0;
}

static int tellatr = A_INFO;
/*
 * error(msg) -
 *    
 */
void error(msg)
char *msg;
{
    if (video_mode == 0) {
	printf(DIAG("Error: %s\n", ": %s\n"), msg);
	return;
    }
    ps_inmac = (schar *)NULL ;
    putcha(COBELL);
    putcha(COBELL);
    putcha(COBELL);
    tellatr = A_ERROR;
    telluser("**** ", 0);
    telluser(msg, 5);
    tellatr = A_INFO;
    errsw = 1;
}

/*
 * telluser(msg,col) -
 *      col.  col =0 -
 *   
 */
void telluser(msg,col)
char *msg;
int col;
{
    struct viewport *oldport;
    register int c,l;
    int oldledit;
    int oldatr;
    if (video_mode == 0) {
	printf(DIAG("Mesg: %s\n", ": %s\n"), msg);
	return;
    }
    oldport = curport;
    c = cursorcol;
    l = cursorline;
    switchport(&paramport);
    oldatr = setatr(A_INFO);
    oldledit = paramport.ledit;
    paramport.ledit = 0;
    if (col == 0) {
	poscursor(0, 0);
        putblanks(paramport.redit);
    }
    poscursor(col, 0);
    /*      while (*msg) putch(*msg++, 0);   */
    info(msg, PARAMREDIT);
    paramport.ledit = oldledit;
    switchport(oldport);
    setatr(oldatr);
    poscursor(c, l);
    dumpcbuf(0);
}

/*
 * infmesg(msg,col,atr) -
 *   msg   col,  atr   .
 */
void infmesg(msg, col, atr)
char *msg;
int col;
int atr;
{
    struct viewport *oldport;
    int c,l;
    int j;

    if (video_mode == 0)
	return;
    oldport = curport;
    c = cursorcol;
    l = cursorline;
    switchport(&paramport);
    poscursor(col, 0);
    j = setatr(atr);
    while (*msg)
	putcha(*msg++); /* ,atr); */
    j = setatr(j);
    switchport(oldport);
    poscursor(c, l);
    dumpcbuf(0);
}

/*
 * info(ss,ml)
 * -  (    ) 
 * ss   , .  "ml"
 */
void info(ss,ml)
char *ss;
int ml;
{ 
    char putbuf[PARAMRINFO + 5], *si, *so;
    char *s = ss;

    so = putbuf;
    if (lcasef) {
	int no = 1;
	si = s;
	while (*s++)
	    ;   /*   */
        exinss(&si, --s, &so, &no, PARAMRINFO);
	*so = 0;
	s = putbuf;
    }
    while (*s && cursorcol < ml)
	/* putch((latf ? *s++ & 0177 : *s++ ) | tellatr, 0);    #31.w */
	putch((0377 & *s++) | tellatr, 0);   /* #31.w */
}

#ifndef DEMOSES
/*
 * shiftview(n0, nl) -     
 *   n0-  nl   (,  <0)
 */
int shiftview(n0,nl)
int n0,nl;
{
    int i, j;
    struct viewport *cp;

    cp = curport;
    if (nl > 0) {
	for(i = n0, j = n0 + nl; j <= cp->btext; i++, j++) {
	    cp->lmchars[i] = cp->lmchars[j];
	    cp->rmchars[i] = cp->rmchars[j];
	    cp->firstcol[i] = cp->firstcol[j];
	    cp->lastcol[i] = cp->lastcol[j];
	}
	for(; i <= cp->btext; i++) {
	    cp->lmchars[i] = cp->rmchars[i] = ' ';
	    cp->firstcol[i] = cp->lastcol[i] = 0;
	}
	return(1);
    } else {
	for (i = cp->btext, j = cp->btext + nl; j >= n0; i--, j--) {
	    cp->lmchars[i] = cp->lmchars[j];
	    cp->rmchars[i] = cp->rmchars[j];
	    cp->firstcol[i] = cp->firstcol[j];
	    cp->lastcol[i] = cp->lastcol[j];
	}
	for(; i >= n0; i--){
	    cp->lmchars[i] = cp->rmchars[i] = ' ';
	    cp->firstcol[i] = cp->rtext;
	    cp->lastcol[i] = 0;
	}
	return(1);
    }
}
/*    .. ,  . , 1984 */
#endif
