/*
 *  $Id: r.var.c,v 2.5 2001/08/09 10:02:38 w Exp w $
 *
 *   RED.
 *
 *  r.var.c -     
 *
 *  $Log: r.var.c,v $
 *  Revision 2.5  2001/08/09 10:02:38  w
 *  Legacy restriction removed: 32767 lines maximum at writing
 *  editing result.
 *  Fixes for ANSI-fication, "-fwritable-strings -Wtraditional"
 *  options do not reqired anymore, and -Wall going well.
 *  Some fixes "0 vs. NULL" pointers.
 *  New undocumented feature: "arg: 0l rpl ..." work with
 *  whole file now.
 *  'register' type qualifyer on the way of removing.
 *  dumpfsd() fixed to be functional (enabled by -DDEBUG).
 *  [s]append(...,"") using improved a bit.
 *  dumpfsd() activation changed to ^X.
 *  Version numbering changed to major.minor.ext.build scheme.
 *
 *  Revision 2.4  1998/05/13 18:34:30  w
 *  ANSI-     glibc  redhat-5.0.
 *       .
 *
 *  Revision 2.3  1997/12/29 19:35:22  w
 *     .
 *
 *  Revision 2.2  1997/12/29 17:44:32  w
 *    optarg,  next_path()   .
 *
 *  Revision 2.1  1997/06/02 18:47:53  w
 *     .
 *
 *  Revision 2.0  1997/05/30 18:33:56  w
 *  !!!
 *  Red   8- (control-   ).
 *         .
 *
 *  Revision 1.2  1997/04/26 13:32:03  w
 *   
 *
 *  Revision 1.1  1997/04/26 09:48:37  w
 *  Initial revision
 *
 *  Revision 4.20  90/05/22  23:22:25  alex
 *  First rev. red 4.2
 */
#include "r.defs.h"

/* strncpy used in next_path() */
#include <string.h>


# ifndef MAX_STRLEN
# define MAX_STRLEN 128
# endif

/*
 *   
 */
static char *UserName, *HomeDir, *TtyName,*TtyName2, *TmpDir;
char *TtyType;

char *Label; /*  */
static struct ctl_expand {
    char left_c;
    char **expand_c;
} ctl_expand[] = {
  { 'h', &HomeDir,  },
  { 't', &TtyType,  },
  { 'u', &UserName, },
  { 'd', &TtyName2, },
  { 'w', &TmpDir,   },
  { 'k', &KeyMode,  },
  { 0,   NULL /*(char **)0*/ }
};

/*
 *   
 */
extern char *TTYnm   ;
extern char *TTYtmp  ;
extern char *RFile   ;
extern char *InitPath;
extern char *HelpPath;
extern char *RedKeys;
int showtabs;
int imodesw;
int BarDrawDir = 0 ;    /*       */
int fullinsert;
int alltabs;
int chg_flag; /* 0  Init-, 1   */
extern char *wDleft, *wDright;
extern char *delimiters, *left_parents, *right_parents;
/*extern new_delims(), new_parents();*/

# define VAR_BOOL 1
# define VAR_STR  2
# define VAR_NUM  3

#define CP (char **)
/*int rescreen();
int comp_selectors();*/
/*#define NOFUN (int(*)())0*/
#define NOFUN (void(*)())NULL

struct int_vars {
    char *I_name;       /*    set                            */
    char *I_ENV ;       /*     ENV                     */
    char  I_type;       /*                                           */
    char  I_1key;       /*  ,             */
    char  I_changed;    /*  -                  */
    char  I_save;       /*  1 -   macro-             */
    char **I_ptr;       /*                         */
    /*int*/void (*I_func)();    /* ,     */
    /*char *I_linst, *I_rinst; */ /*         */
} int_vars [] = {
    /* Name         ENV_NAME    TYPE        KEY CH  SAVE    Addr            Fun    */
  { "help",         "REDHELP",  VAR_STR,    0,  0,  0,      &HelpPath,      NOFUN,       },
  { "init",         "REDINIT",  VAR_STR,    0,  0,  0,      &InitPath,      NOFUN,       },
  { "macro",        "REDMACRO", VAR_STR,    0,  0,  0,      &MacroFile,     NOFUN,       },
  { "tmp",          "REDTMP",   VAR_STR,    0,  0,  0,      &TmpDir,        NOFUN,       },
  { "keys",         "REDKEYS",  VAR_STR,    0,  0,  0,      &RedKeys,       NOFUN,       },
  { "keymode",      "REDMODE",  VAR_STR,    0,  0,  0,      &KeyMode,       NOFUN,       },
  { "tmpfile",      NULL,       VAR_STR,    0,  0,  0,      &TTYtmp,        NOFUN,       },
  { "savefile",     "REDSAVE",  VAR_STR,    0,  0,  0,      &RFile,         NOFUN,       },
  { "recfile",      NULL,       VAR_STR,    0,  0,  0,      &TTYnm,         NOFUN,       },
  { "label",        NULL,       VAR_STR,    0,  0,  0,      &Label,         NOFUN,       },
  { "search",       NULL,       VAR_STR,    0,  1,  1,      &searchkey,     NOFUN,       },
  { "cols",         NULL,       VAR_NUM,    0,  0,  0,      CP &LINEL,      NOFUN,       },
  { "lines",        NULL,       VAR_NUM,    0,  0,  0,      CP &NLINES,     NOFUN,       },
  { "lboard",       NULL,       VAR_NUM,    0,  0,  1,      CP &defedit,    NOFUN,       },
  { "noruscase",    NULL,       VAR_BOOL,   'e',0,  0,      CP &latf,       rescreen,    },
  { "lcase",        NULL,       VAR_BOOL,   'l',0,  0,      CP &lcasef,     rescreen,    },
  { "insertmode",   NULL,       VAR_BOOL,   'i',0,  1,      CP &imodesw,    NOFUN,       },
  { "fullinsert",   NULL,       VAR_BOOL,   'I',0,  1,      CP &fullinsert, NOFUN,       },
  { "slowmode",     NULL,       VAR_BOOL,   0,  0,  0,      CP &slowsw,     NOFUN,       },
  { "scrollon",     NULL,       VAR_BOOL,   's',0,  1,      CP &on_scroll,  NOFUN,       },
  { "autoindent",   NULL,       VAR_BOOL,   'a',0,  1,      CP &on_autoi,   NOFUN,       },
  { "indentcol",    NULL,       VAR_NUM,    0,  1,  1,      CP &autoindent, NOFUN,       },
  { "fixscreen",    NULL,       VAR_BOOL,   'f',0,  1,      CP &fix_screen, NOFUN,       },
  { "tabsexpand",   NULL,       VAR_BOOL,   't',0,  1,      CP &flgtabs,    rescreen,    },
  { "atabsexpand",  NULL,       VAR_BOOL,   'T',0,  1,      CP &alltabs,    rescreen,    },
  { "showtabs",     NULL,       VAR_BOOL,   'S',0,  1,      CP &showtabs,   rescreen,    },
  { "zoomed",       NULL,       VAR_BOOL,   'z',0,  1,      CP &zoomflag,   rescreen,    },
  { "lparents",     NULL,       VAR_STR,    0,  0,  1,      &left_parents,  new_parents, },
  { "rparents",     NULL,       VAR_STR,    0,  0,  1,      &right_parents, new_parents, },
  { "delims",       NULL,       VAR_STR,    0,  0,  1,      &delimiters,    new_delims,  },
  { "wdleft",       NULL,       VAR_STR,    0,  0,  0,      CP &wDleft,     NOFUN,       },
  { "wdright",      NULL,       VAR_STR,    0,  0,  0,      CP &wDright,    NOFUN,       },
  { "drawmode",     NULL,       VAR_BOOL,   'd',0,  1,      CP &BarDrawDir, NOFUN,       },
  { NULL,           NULL,       0,          0,  0,  0,      CP 0,           NOFUN        }
};

/*char *getenv();*/
/*
 * VarEInit() -   
 *   ENVIRONMENT
 *     -   
 */
void VarEInit()
{
    char *cp;
    struct int_vars *pi;

    for(pi = int_vars;pi->I_name;pi++)
    {
	if ( pi->I_type == VAR_STR && pi->I_ENV && (cp=getenv(pi->I_ENV)))
	    *(pi->I_ptr) = append(cp,NULL);
    }
}

/*
 *      /usr/man:/usr/local/man:...
 *  -    
 *  :    ':',
 *      read-only .
 */
char *next_path(pps)
char **pps;
{
    char *s = *pps;
    char *s0;
    size_t n = 1;

    while ( *s == ':' )
	s++;
    if ( *s == 0 )
	return(NULL);
    s0 = s;
    while ( *++s && *s != ':' )
	n++;
    *pps = s ;
    s0 = strncpy((char *)salloc(n+1,1), s0, n);
    s0[n] = '\0';

    if ( *s == ':' ) {
	/* *s = 0 ; */
	*pps += 1 ;
    }
    return(s0);
}


/*
 *  ,  
 *   
 */
int InitConsts()
{
	/*extern char *getenv(), *ttyname(), *getnm();*/

	if ( UserName ) return(1);
	UserName = getenv("USER");
	if ( !UserName ) UserName = getnm(userid);
	TtyType = getenv("TERM");
	if ( !TtyType ) TtyType = "";
	HomeDir = getenv("HOME");
	if ( ! HomeDir ) HomeDir = ".";
	TtyName = ttyname(0);
	if ( !TtyName ) TtyName = /* "nottyno" */ "/dev/ttyNO";

	/*  '/dev/' */
/*        TtyName2 = TtyName + (strlen(TtyName) - 2);       */
	for (TtyName2 = TtyName + 1; *TtyName2; ++TtyName2) {
	    if (*TtyName2 == '/') {
		++TtyName2 ;
		break ;
	    }
	}

	if ( !TmpDir ) TmpDir = "/tmp/";
	return(0);
}

/*
 *  StrCalc(char *s)
 *    s
 *  %h - home dir
 *               %t -  
 *               %u -  
 *               %d -    
 *     salloc
 * .     CPP MAX_STRLEN
 */
char *StrCalc(s)
register char *s;
{
	char sbuf[MAX_STRLEN + 2];
	register char *p;
	register struct ctl_expand *pctl;
	char *ss;
	p = sbuf;
	while ( *s && p < sbuf+MAX_STRLEN )
	{
		if ( *s == '%' && s[1] ) {
			if ( s[1] == '%' ) {
				*p++ = '%'; 
				s += 2; 
				continue;
			}
			for(pctl = ctl_expand; pctl->left_c && pctl->left_c != s[1];pctl++);
			if ( pctl->left_c )
			{
				ss = s;
				s = *(pctl->expand_c);
				while ( *s && p < sbuf+MAX_STRLEN ) *p++ = *s++;
				s = ss+2;
				continue;
			};
		};
		*p++ = *s++;
	}
	*p++ = 0;
	ss = salloc(p - sbuf + 1, sizeof(char));
	p = sbuf;
	s = ss;
	while ( (*s++ = *p++) != 0 );
	return(ss);
}

/*
 * char *SetVar(name, av, ac ) -
 *   name.
 * av -  
 * ac -   
 * : NULL - O'key, STR -  
 */
char *SetVar(name, av, ac)
char *name;
char *av[];
int ac;
{
    struct int_vars *pi;
    int i;

    for (pi = int_vars; (pi->I_name != NULL); pi++) {
	if (strcmp(pi->I_name, name) == 0)
	break;
    }
    if (pi->I_name == NULL)
	return("undefined");
    switch (pi->I_type) {
	case VAR_BOOL:
	    if (ac > 1)
		return("bad arg count");
	    *((int *)(pi->I_ptr)) = (ac == 1 && *av[0] == '0') ? 0 : 1;
	    break;
	case VAR_STR:
	    if (ac != 1)
		return("bad arg count");
	    *(pi->I_ptr) = append(av[0],NULL);
	    break;
	case VAR_NUM:
	    if (ac != 1)
		return("bad arg count");
	    if (s2i(av[0], &i) != NULL)
		return("bad arg format");
	    *((int *)(pi->I_ptr)) = i;
	    break;
	default:
	    return("internal error");
    }
    if (pi->I_func != NOFUN)
	(*pi->I_func)();
    pi->I_changed = chg_flag;
    return(NULL);
}


/*
 * setkeys()
 * -  .
 */
int setkeys(keys)
register char *keys;
{
    int set=1, ko= -1;
    struct int_vars *pi;
    int i;

    while ((i = *keys) != 0) {
	switch ( *keys++ ) {
	    case '-':
		set = 0;
		break;
	    case '+':
		set = 1;
		break;
	    case 'w':
#ifdef DEMOSES
		newedit = 1;
#endif /* +DEMOSES      */
		if(curwksp && curwksp->wfile )
		    openwrite[curwksp->wfile]= set;
		break;
	    default:
		for (pi = int_vars; (pi->I_name != NULL); pi++)
		{
		    if ( pi->I_1key == i && pi->I_type == VAR_BOOL ) break;
		}
		if (pi->I_name == NULL) {
		    if (ko < 0)
			ko = 0;
		    break;
		}
		*((int *)(pi->I_ptr)) = set;
		if (pi->I_func != NOFUN)
		    (*pi->I_func)();
		pi->I_changed = chg_flag;
		break;
	}
    }
    return(ko);
}

/*
 * char *getkeys(buf,len)
 * -        
 *       /  
 *
 */
char *getkeys(buf0, len)
char *buf0;
int len;
{
#define ADD(c) if (len <= 0) { goto retn; } else { *buf++ = c; len--; }
    register char *cp;
    register struct int_vars *pi;
    int set = -1, i;
    char *buf = buf0;

    cp = buf;
    len--;
    for (pi = int_vars; (pi->I_name != NULL); pi++) {
	if (pi->I_1key != 0 && pi->I_type == VAR_BOOL) {
	    i = *((int *)(pi->I_ptr));
	    if (i != set) {
		ADD(i ? '+' : '-');
	    }
	    set = i;
	    ADD(pi->I_1key);
	}
    }
retn:
    *buf++ = 0;
    return(buf0);
}

/*
 * do_set(str) -    
 *  str == NULL -   
 * ( )
 */
int do_set(str)
register char *str;
{
    char *args[10];
    int i;
    char *cp;

    if (str == NULL)
	return(-1);     /*    */
    i = SelectArgs(str, args, 10);
    if (i < 0)
	return(-1);
    if ((cp = SetVar(args[0], args+1, i-1)) != NULL) {
	ErrI(1, cp);
	return(-1);
    }
    return(0);
}

/*
 * WriteSet(fd) -      fd
 *      
 *   fd = 0 -  ,    
 */
void WriteSet(fd)
FILE *fd;
{
    register char *cp;
    register struct int_vars *pi;
    register int i;

    for( pi = int_vars;pi->I_name; pi++)
    {
        /* ,     -   */
	if (pi->I_1key || ! pi->I_changed || ! pi->I_save)
            continue;
	switch (pi->I_type) {
	    case VAR_BOOL:
		fprintf(fd,"set %s %d\n",
			pi->I_name,
			( *((int *)(pi->I_ptr)) ? 1 : 0 ) );
		continue;
	    case VAR_NUM:
		fprintf(fd,"set %s %d\n",
			pi->I_name,
			*((int *)(pi->I_ptr))  );
		continue;
	    case VAR_STR:
		cp = *((char **)(pi->I_ptr));
		if (cp == NULL)
		    break;
		fprintf(fd,"set %s ", pi->I_name);

		{
		    char qchar;
		    qchar = DQUOTA;
		    putc(qchar,fd);
		    for( ; ; cp++ ) {
			i = *cp;
			if (!i)
			    break;
			if (i == qchar) {
			    putc(qchar, fd);
			    qchar = (qchar == DQUOTA ? QUOTA : DQUOTA);
			    putc(qchar,fd);
			}
			putc(i,fd);
		    }
		    putc(qchar,fd);
		    putc('\n',fd);
		}
		continue;
	    default:
		break;
        }
    } /*    pi */
    return;
}

