* [w.pro wk 11.11.91] standard profile for W  *
* Copyright (c) 1991-93 by Werner Koch (dd9jn)*
* This file is part of the W-Editor.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
* $Id: w.pro,v 1.16 1996/09/10 12:20:03 wk Exp $
*****************************************************

*-----------------------------------------------------
*----------- Keyboard Definitions --------------------
*-----------------------------------------------------

*-------------------------
* Define keys:
*
*  defkey scan <scancode> <std>|- <shift>|- <meta>|-
*
* <scancode> is the keyboard scancode
* <std>      the value to produce with no shift keys
* <shift>    the value to produce with shift-key pressed
* <meta>     the value to produce with the meta-key (right-alt-key) pressed
*
* Define deadkeys:
*
*  defkey compose <mod> <first> <mod> <second> <value> [ <mod> <scan> ]
*
* <mod>       is [shift|ctrl|alt]
* <first>     the scancode of the first key pressed
* <second>    the scancode of the second key pressed
* <value>     the composed value or 0 to remove this definition.
* <scan>      use this as a faked scan code.
*-------------------------

# jump over this section if not Linux.
:%Zsysname:'Linux';jmp diff; leap to end-of-keydef-section

* W defaults to a german keyboard. To change the mapping
* you have to use the defkey command. (The keynames given to
* the command define (def,d) are always the original US
* keyboard keys).
*
* To use a specific keyboard uncomment the following lines

*------------------
* German Keyboard -
* (there are no defaults for composed keys)
*------------------
defkey compose	     13       30 ''
defkey compose	     13 shift 30 ''
defkey compose shift 13       30 ''
defkey compose shift 13 shift 30 ''

*  *--------------
*  * US-Keyboard -
*  *--------------
*  defkey scan	 2   -	  '!'
*  defkey scan	 3   -	  '@'
*  defkey scan	 4   -	  '#'
*  defkey scan	 5   -	  '$'
*  defkey scan	 6   -	  '%'
*  defkey scan	 7   -	  '^'
*  defkey scan	 8   -	  '&'
*  defkey scan	 9   -	  '*'
*  defkey scan	10   -	  '('
*  defkey scan	11   -	  ')'
*  defkey scan	12  '-'   '_'
*  defkey scan	13  '='   '+'
*  defkey scan	21  'y'   'Y'
*  defkey scan	26  0x5b  '{'
*  defkey scan	27  0x5c  '}'
*  defkey scan	39  0x3b  ':'
*  defkey scan	40  0x27  0x22
*  defkey scan	41  0x5c  '|'
*  defkey scan	44  'z'   'Z'
*  defkey scan	51  ','   '<'
*  defkey scan	52  '.'   '>'
*  defkey scan	53  '/'   '?'
*  *---- end us-keyboard ----










end-of-keydef-section:

*-----------------------------------------------------
*----------- Layout Definitions ----------------------
*-----------------------------------------------------

* uncomment the next line to change layout
*set dlayout 0
*   1 = text  cmd   info  msg
*   2 = info  msg   cmd   text
*   3 = info  msg   text  cmd
*   4 = msg   info  text  cmd
*   5 = info  text  cmd   msg
*   6 = msg   info  text  cmd
*   7 = msg   info  cmd   text
*	top ------------> bottom of screen

* uncomment the next line to change colors
*set dcolors <string>
*	   default mono  = "0f 70 70 70 0f 09 8f 0f 07 0f"
*	   default color = "1f 4f 70 2f 0f 0c 0c 0b 30 1f"
*    Text ------------------!  !  !  !	!  !  !  !  !  !
*    Mark ---------------------!  !  !	!  !  !  !  !  !
*    Cursor ----------------------!  !	!  !  !  !  !  !
*    Cmdline ------------------------!	!  !  !  !  !  !
*    Status ----------------------------!  !  !  !  !  !
*    Status2 (changed) --------------------!  !  !  !  !
*    Message (error) -------------------------!  !  !  !
*    Message2 (info) ----------------------------!  !  !
*    Browse ----------------------------------------!  !
*    Overscan -----------------------------------------!
*  color values:
*  0 = Black	  8 = Dark grey 	First digit is background
*  1 = Blue	  9 = Light blue	Second digit is foreground
*  2 = Green	  A = Light green	Background > 7 will blink
*  3 = Cyan	  B = Light cyan
*  4 = Red	  C = Light red
*  5 = Magenta	  D = Light magenta
*  6 = Brown	  E = Yellow
*  7 = White	  F = Bright white
*
* Or use the new format:
*   set color <element>  <foreground> on <background>
*
* "set color" is an alias for "set dcolors",
* <element> is one of:
*  "Text", "Mark", "Cursor", "Cmdline", "Status", "Status2",
*  "Message", "Message2", "Browse", "Overscan",
*  "Hilite1", "Hilite2", "Hilite3", "Hilite4", "Hilite5",
*  "Hilite6", "Hilite7", "Hilite8", "Hilite9"
* and <foreground> and <background> are one of:
*  "Black", "Blue", "Green", "Cyan", "Red", "Magenta", "Brown", "White",
*  "Dark-grey", "Light-blue", "Light-green", "Light-cyan", "Light-red",
*  "Light-magenta", "Yellow", "Bright-white"
*
* The default color palete for mode color is:
* set color Text     Bright-White on Blue
* set color Mark     Bright-White on Red
* set color Cursor   Black on White
* set color Cmdline  Bright-White on Green
* set color Status   Bright-White on Black
* set color Status2  Light-Red on Black
* set color Message  Light-Red on Black
* set color Message2 Light-Cyan on Black
* set color Browse   Black on Cyan
* set color Overscan Bright-White on Blue
* set color Hilite1  Black on Blue
* set color Hilite2  Green on Blue
* set color Hilite3  Cyan on Blue
* set color Hilite4  Red on Blue
* set color Hilite5  Magenta on Blue
* set color Hilite6  Brown on Blue
* set color Hilite7  White on Blue
* set color Hilite8  Dark-Grey on Blue
* set color Hilite9  Light-Blue on Blue
*
*********************

*-----------------------------------------------------
*----------- KEYPAD  Definitions ---------------------
*-----------------------------------------------------
** Map keypad to cursorblock
d paddel = key del
d padins = key ins
d pad1	 = key end
d pad2	 = key down
d pad3	 = key pgdn
d pad4	 = key left
d pad6	 = key right
d pad7	 = key home
d pad8	 = key up
d pad9	 = key pgup
d padenter = cc;ex
d s-paddel = key s-del
d s-padins = key s-ins
d s-pad1   = key s-end
d s-pad2   = key s-down
d s-pad3   = key s-pgdn
d s-pad4   = key s-left
d s-pad6   = key s-right
d s-pad7   = key s-home
d s-pad8   = key s-up
d s-pad9   = key s-pgup
d c-paddel = key c-del
d c-padins = key c-ins
d c-pad1   = key c-end
d c-pad2   = key c-down
d c-pad3   = key c-pgdn
d c-pad4   = key c-left
d c-pad6   = key c-right
d c-pad7   = key c-home
d c-pad8   = key c-up
d c-pad9   = key c-pgup
d c-padenter = key c-enter

*-----------------------------------------------------
*----------- STD-Key Definitions ---------------------
*-----------------------------------------------------

d f5 =	co; ex;
d f6 =	cc; bl; ee;'line '
d f7 =	cc; bl; ee;'/'
d f10 =  fn; :%ZColumn^evl; il; column;
d f12 = toggle
d enter = bl;in;:%ZNLines:%ZLine:1^add;down;jmp gt nop; up;il;in;

* we will use c-padminus and c-padplus for commandline history.
* You may use any other keycombination; quite common is up and
* down, but I prefer the first one
d padminus = bw
d padplus  = tw
d c-padminus = cc;history up
d c-padplus  = cc;history down
*d up	= :%ZInCmd jmp true; history up; uo
*d down = :%ZInCmd jmp true; history down; down

*-----------------------------------------------------
*----------- SHIFT-Key Definitions -------------------
*-----------------------------------------------------

d s-f1 =  wb;
d s-f2 =  we;
d s-f3 =  ca; split; il; up; el; down; left;' ' jo; up;
d s-f4 =  ee; bl; down; im;' ' left; \
	  um; mb; fn; left; mb; dm; rm; up; el; jo;
d s-f5 =  bl; ee;
d s-f6 =  ee;
d s-f7 =  sl;
d s-f8 =  sr;
d s-f9 =  e .unnamed; ring off
d s-pad5 = cl
d s-pgup = te
d s-pgdn = be
d s-home = le
d s-end = re
d s-ins = paste
d s-del = cut

*-----------------------------------------------------
*----------- CTRL-Key Definitions --------------------
*-----------------------------------------------------
d c-ins = copy

d c-a = _loadatcrs
d c-b = matchblock
d c-c = ps; ml; ci; um; po;
* d c-d = :'dos "':%ZCmdLine^cat:'"'^cat;copy to history %ZCtop;excl %ZCpop
d c-d = key del
d c-f = cf
d c-h = :'cd ':%ZDir^cat;ex %ZCpop
d c-i = bm; sr; up; left; cc; bl; ee; im;'c/ //*M' column 5;
d c-j = ps; down; fn; mb; el; we; mb; up; el; we; right; cm; down; um; dl; up; po;
d c-k = ee
d c-l = sb
d c-o = down; cl; ob;
d c-t = ct;
* (ctrl-Z is Ctrl-Y on the german keyboard)
d c-z = dl
d c-f1 = dir
d c-f2 = varlist; ring off;
d c-f3 = ps; ml; cm; po;
d c-f4 = fm;
d c-f5 = uc;
d c-f6 = bm;
d c-f7 = lc;
d c-f8 = em;
d c-f10 = rf;
d c-left = left 40;
d c-right = right 40;
d c-pgup = scrollup 10
d c-pgdn = scrolldown 10
d c-backspace =  ps; mb; nb; nnb; split; bm; ee; jo; po;

*-----------------------------------------------------
*----------- ALT-Key Definitions ---------------------
*-----------------------------------------------------

d a-backspace = undo

d a-b =  el;' {' key f10;'}' up; key f10; tb;

* Write the hostname:
* (Use $HOSTNAME if %Znodename does not return a value)
d put_hostname = :%Znodename^len;jmp true; %Znodename; %HOSTNAME%

d a-c = :'ChangeLog'^dup;^ineditor; jmp true; begin; load %ZCpop; ca; end; \
	load %ZCpop;s tabs rpt 8;ring off; ca; top; bl; split; \
	%ZCTime'  '%ZRealName'  ('%LOGNAME%'@' put_hostname ')' \
	il;il;column 9;'* ';il;up; el;
d a-d =  key f10;'#define '
d a-e = '#endif'
*			!- replace that with your favorite header directory
d a-h =  cc; bl; ee;'load c:/ibmc/include/'
d a-i =  key f10;'#include <'
d a-j =  cc; bl; ee;'load c:/toolkt20/c/os2h/'
d a-k =  key f10;'* '
d a-l =  key f10;'/**************** ' key f10;' * ' key f10;'*/' up;
d a-n =  il;'#ifdef DOCUMENTATION' il;'@Summary ' il;\
	 '@Description' il;'@Return Value' il;\
	 '@See Also' il;'@Notes' il;'@Example' il;'#endif /*DOCUMENTATION*/'\
	 il; up 7; el;
d a-o =  set margins 6 70 8; rf; set margins default;
d a-p = '->'
d a-r =  key f10;'RCSID("$'; 'Id$")'
d a-s = 'static '
d a-t = %ZDate


*-----------------------------------------------------
*----------- Mouse commands --------------------------
*-----------------------------------------------------

*** mouse buttons ***
d a-lclick=:%ZPath:'.editlist'jmp diff;editlist;ring off;posatmouse;bl;:%ZWordDel:~%ZWordDel;e %ZWrdAtCrs;~%ZWordDel
d c-rclick=posatmouse; matchblock

*** mouse menu ***
d mf1l = scrollleft
d mf1r = scrollright
d s-mf1l = left
d s-mf1r = right
d mf2l = scrollup
d mf2r = scrolldown
d s-mf2l = up
d s-mf2r = down
d mf3l = pu
d mf3r = pd
d s-mf3l = top
d s-mf3r = bottom

*-----------------------------------------------------
*----------- Edit-Procedures etc. --------------------
*-----------------------------------------------------

* Now set tabs according to the extension
:'s tabs rpt 4; set margins default'~%ZEditPrc
:'s tabs 8 12 20 28 64'~%ZEditPrc_cob
:'s nt on'~%ZEditPrc_ipf
:'set hilite on'~%ZEditPrc_c
:'set hilite on'~%ZEditPrc_l
:'set hilite on'~%ZEditPrc_h
:'set hilite on'~%ZEditPrc_m
:'set hilite cls; set hilite on'~%ZEditPrc_cls
:'set hilite srm; set hilite on'~%ZEditPrc_srm
:'set hilite sgml; set hilite on'~%ZEditPrc_sgml
:'set hilite sgml; set hilite on'~%ZEditPrc_html
:'set hilite sgml; set hilite on'~%ZEditPrc_dtd

* And define the characters to be used as word delimiters
:',;=!(){}><%~"?:^|'~%ZWordDel

* enable wordwrap for the current file
d wordwrap = set margins 1 70 1


*-----------------------------------------------------
*----------- Error file handling ---------------------
*-----------------------------------------------------

* MSDOS only: replace ztc.err with the name of your errorfile
d begin_error_dos = load -j0 ztc.err\
		    ring off; top;bl :%ZPath~%ErrFile :1~%ErrLine

* Load/switchTo errorfile, set cursor to top of file
d begin_error = s sps off; :%ZOS:'MSDOS';jmp same;begin_error_dos \
		noerror; :%ZPath^evl \
		sp;top;bl; :%ZPath~%ErrFile :1~%ErrLine \
		load %ZCpop

*  quit the errorfile  (may be useful in some cases)
*d end_error = :%ErrFile^len;jmp false;error 26 \
*	       noerror :%ZPath^evl; e %ErrFile;quit :''~%ErrFile; e %ZCpop



* set cursor to next error (Zortech C version)
d nxt_errorZTC = :%ErrFile^len;jmp false;error 26 \
	      load %ErrFile;:%ErrLine;line;el \
	      l/) : /;		   \
	      s sps on; noerror :%ZLine~%ErrLine     \
	      ca;up;fn;:%ZColumn^evl;down;bl \
	      l/(/ ; right \
	      :%ZWordDel^evl :'()'~%ZWordDel \
	      :%ZWrdAtCrs^evl; bl :'-ji ':%ZWrdAtCrs^cat \
	      up 2; load %ZCpop;goto lineid;~%ZWordDel;column

* set cursor to previous error (Zortech C version)
d prv_errorZTC = :%ErrFile^len;jmp false;error 26 \
	      load %ErrFile;:%ErrLine;line;bl	\
	      l/) : /-; 	    \
	      s sps on; noerror :%ZLine~%ErrLine     \
	      ca;up;fn;:%ZColumn^evl;down;bl \
	      l/(/ ; right \
	      :%ZWordDel^evl :'()'~%ZWordDel \
	      :%ZWrdAtCrs^evl; bl :'-ji ':%ZWrdAtCrs^cat \
	      up 2; load %ZCpop;goto lineid;~%ZWordDel;column


* set cursor to next error (C Set/2 version)
d nxt_errorIBM = :%ErrFile^len;jmp false;error 26 \
	load %ErrFile;:%ErrLine;line;el \
	l/) : /;  \
	bl;s sps on;noerror :%ZLine~%ErrLine  \
	:%ZWordDel^evl :'()'~%ZWordDel;:%ZWrdAtCrs^evl \
	tw; :'(:)'~%ZWordDel :%ZWrdAtCrs^evl^swap tw; :%ZWrdAtCrs^evl^swap  \
	bl;:'-ji '^swap^cat;load %ZCpop;column;goto lineid; ~%ZWordDel

* set cursor to previous error (C Set/2 version)
d prv_errorIBM = :%ErrFile^len;jmp false;error 26 \
	load %ErrFile;:%ErrLine;line;bl \
	l/) : /-;  \
	bl;s sps on;noerror :%ZLine~%ErrLine  \
	:%ZWordDel^evl :'()'~%ZWordDel;:%ZWrdAtCrs^evl \
	tw; :'(:)'~%ZWordDel :%ZWrdAtCrs^evl^swap tw; :%ZWrdAtCrs^evl^swap  \
	bl;:'-ji '^swap^cat;load %ZCpop;column;goto lineid; ~%ZWordDel

* set cursor to next error (GNU version)
d nxt_errorGNU = :%ErrFile^len;jmp false;error 26 \
	load %ErrFile;:%ErrLine;line;el \
	l/:[0-9]+/r; \
	bl;s sps on;noerror :%ZLine~%ErrLine  \
	:':'^getword;tw ':';:':'^getword \
	^dup :0 jmp eq; begin; ^pop^pop; end \
	bl; ^swap;:'-ji '^swap^cat;load %ZCpop;goto lineid


* set cursor to previous error (GNU version)
d prv_errorGNU = :%ErrFile^len;jmp false;error 26 \
	load %ErrFile;:%ErrLine;line;bl \
	l/:[0-9]+/r-; \
	bl;s sps on;noerror :%ZLine~%ErrLine  \
	:':'^getword;tw ':';:':'^getword \
	^dup :0 jmp eq; begin; ^pop^pop; end \
	bl; ^swap;:'-ji '^swap^cat; load %ZCpop;goto lineid

* set cursor to next error (Watcom C version)
d nxt_errorWTC = :%ErrFile^len;jmp false;error 26 \
	      load %ErrFile;:%ErrLine;line;el \
	      l/): /;		  \
	      s sps on; noerror :%ZLine~%ErrLine     \
	      ca;up;fn;:%ZColumn^evl;down;bl \
	      l/(/ ; right \
	      :%ZWordDel^evl :'()'~%ZWordDel \
	      :%ZWrdAtCrs^evl; bl :'-ji ':%ZWrdAtCrs^cat \
	      up 2; load %ZCpop;goto lineid;~%ZWordDel;column

* set cursor to previous error (Watcom C version)
d prv_errorWTC = :%ErrFile^len;jmp false;error 26 \
	      load %ErrFile;:%ErrLine;line;bl	\
	      l/): /-;		   \
	      s sps on; noerror :%ZLine~%ErrLine     \
	      ca;up;fn;:%ZColumn^evl;down;bl \
	      l/(/ ; right \
	      :%ZWordDel^evl :'()'~%ZWordDel \
	      :%ZWrdAtCrs^evl; bl :'-ji ':%ZWrdAtCrs^cat \
	      up 2; load %ZCpop;goto lineid;~%ZWordDel;column



d makeIBM = :'detach "cmd.exe /c ibminit & make.exe ' \
	:%ZCmdLine; copy to history %ZCtop; ^cat      \
	:';beep;begin_error"' ^cat \
	cc; bl; ee; ex %ZCpop
d makeZTC = :'detach "cmd.exe /c ztcinit & make.exe ' \
	:%ZCmdLine; copy to history %ZCtop; ^cat      \
	:';beep;begin_error"' ^cat \
	cc; bl; ee; ex %ZCpop
# probs with my make: seg. viloation trap when used without shell?
# so we use + to force execution via /bin/sh
d makeGNU = :'detach "+make ' \
	:%ZCmdLine; copy to history %ZCtop; ^cat      \
	:';beep;begin_error"' ^cat \
	cc; bl; ee; ex %ZCpop
d makeWTC = :'detach "cmd.exe /c wtcinit & make.exe ' \
	:%ZCmdLine; copy to history %ZCtop; ^cat      \
	:';beep;begin_error"' ^cat \
	cc; bl; ee; ex %ZCpop
d makeEMX = :'detach "cmd.exe /c emxinit & make.exe ' \
	:%ZCmdLine; copy to history %ZCtop; ^cat      \
	:';beep;begin_error"' ^cat \
	cc; bl; ee; ex %ZCpop

* assign some keys
d s-padmul = s sps off; load %ErrFile; :1~%ErrLine; top; bl;
d s-paddiv = s sps off; load %ErrFile
d make = beep
d c-m = make

d useIBM = ex 'd s-padplus = nxt_errorIBM'; ex 'd s-padminus = prv_errorIBM' \
     ex 'd make = makeIBM' ; ex "d a-h = cc; bl; ee;'load c:/ibmc/include/' "
d useIBM2 = ex 'd s-padplus = nxt_errorIBM'; ex 'd s-padminus = prv_errorIBM' \
     ex 'd make = makeIBM2' ; ex "d a-h = cc; bl; ee;'load c:/ibmc/include/' "
d useZTC = ex 'd s-padplus = nxt_errorZTC'; ex 'd s-padminus = prv_errorZTC' \
     ex 'd make = makeZTC' ; ex "d a-h = cc; bl; ee;'load c:/bin/ztc/include/' "
d useZTC2 = ex 'd s-padplus = nxt_errorZTC'; ex 'd s-padminus = prv_errorZTC' \
     ex 'd make = makeZTC2' ; ex "d a-h = cc; bl; ee;'load c:/bin/ztc/include/' "
d useGNU = ex 'd s-padplus = nxt_errorGNU'; ex 'd s-padminus = prv_errorGNU' \
     ex 'd make = makeGNU' ; ex "d a-h = cc; bl; ee;'load /usr/include/' "
d useWTC = ex 'd s-padplus = nxt_errorWTC'; ex 'd s-padminus = prv_errorWTC' \
     ex 'd make = makeWTC' ; ex "d a-h = cc; bl; ee;'load e:/watcom/h/' "
d useEMX = ex 'd s-padplus = nxt_errorGNU'; ex 'd s-padminus = prv_errorGNU' \
     ex 'd make = makeEMX' ; ex "d a-h = cc; bl; ee;'load c:/usr/emx/include/' "


*-----------------------------------------------------
*----------- set some options ------------------------
*-----------------------------------------------------

*-- comment out the next line to disable binary read mode
* set readbinary off

*-- comment out the next line to disable memory swapping
*-- (memswapping has no affect for the OS/2 version)
set memswap on

*-- comment the next line to disable commandline history
set history 30

* save mode 1 is quite good for OS/2 2.0, for you can recover with
* the undelete command - if there is no DELDIR variable, we will
* select savemode 7 (create a backuptree under /tmp/w.bak)
:%ZOS:'OS/2';jmp diff;set savemode 1; \
	:%DELDIR%^len; jmp true;set savemode 1; set savemode 7
:%ZOS:'UNIX';jmp same; set savemode 2

* with tabmode 1 tabs are not inserted into lines containing strings
set tabmode 1

:%LCD_MONO%;^len;jmp true;set dcolors mono

# disable "edit" (that is: map "edit" to "load")
set editcmd off

*-----------------------------------------------------
*----------- final operations ------------------------
*-----------------------------------------------------

*******
** If you prefer standard terminal switching you should
** uncomment the following lines
*
*:%Zsysname:'Linux';jmp diff; leap to no-alt-fkey-redefinition
*d a-f1 = switch console 1
*d a-f2 = switch console 2
*d a-f3 = switch console 3
*d a-f4 = switch console 4
*d a-f5 = switch console 5
*d a-f6 = switch console 6
*d a-f7 = switch console 7
*d a-f8 = switch console 8
*d a-f9 = switch console 9
*d a-f10= switch console 10
*d a-f11= switch console 11
*d a-f12= switch console 12
*no-alt-fkey-redefinition:
******

*  Change some colors
set color hilite1 blue	on white
:%ZScreen:'con';jmp same;leap to no-highlighting
set color text	  black on bright-white
set color overscan black on bright-white
set color cmdline black on cyan
set color hilite1 blue	on bright-white
set color hilite2 magenta on bright-white
set color hilite5 green on bright-white
set color hilite6 red on bright-White

no-highlighting:

* inform child processes about loaded W
* a second copy of W can not be loaded unless you specify option "-ne"
* or remove the next line
putenv ";W_IS_ACTIVE=1"

* default compiler
:%ZOS:'UNIX';jmp same; useGNU; useWTC

* Include a private macro file
:%HOME%:'/.w-profile'^cat^dup^exist;jmp true; m %ZCpop; ^pop


rehash

************ Examples *******************************
*** nice colors for X version,
* :%DISPLAY%^len;jmp false;leap to not-xwindows
* set color text    black on bright-white
* set color overscan black on bright-white
* set color cmdline black on cyan
* set color hilite1 blue  on bright-white
* set color hilite2 magenta on bright-white
* set color hilite5 green on bright-white
* set color hilite6 red   on bright-White
*
* :'set hilite on'~%ZEditPrc_c
* :'set hilite on'~%ZEditPrc_l
* :'set hilite on'~%ZEditPrc_h
* :'set hilite on'~%ZEditPrc_m
* :'set hilite cls; set hilite on'~%ZEditPrc_cls
* :'set hilite sgml; set hilite on'~%ZEditPrc_sgml
* :'set hilite sgml; set hilite on'~%ZEditPrc_html
*
*
*
*
* d a-v = 'var->'
*
* d make_unique = ca; top; ct; :%ZEof ; until true; begin \
*	    :%ZCmdLine^evl down; ct; :%ZCmdLine while sameCI; begin \
*						      dl;ct; end; end
*
* d unix = set latin on; set unixsave on
* d nounix = set latin off; set unixsave off
**********************************************************************

**** bottom of standard profile *****
