.* [w1.ipf wk 24.8.92] Documentation for W Part 1
.*      Copyright (c) 1992 by Werner Koch (dd9jn)
.* History:
.*
.*********************************************************************



.*****************************************
:h3 id='backtab'.BACKTAB  (bt)
:p.Cursor auf den vorhergehenden Tabstop setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
backtab
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf den vorhergehenden Tabstop der Zeile.
Tabstops knnen fr jeden File einzeln gesetzt werden, wobei aber implizit
die erste Position einer Zeile immer einen Tabstop darstellt.
Befindet der Cursor sich bereits auf der ersten Position der Zeile, so
hat das Kommando keinen Effekt.
Tabstops sind auch auf der Kommandozeile vorhanden, dort aber fest auf
alle 8 Positionen verdrahtet.

:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='tab'     .TAB:elink.
:li.&sqbul. :link reftype=hd refid='set tabs'.SET TABS:elink.
:li.&sqbul. :link reftype=hd refid='? tabs'  .? TABS:elink.
:esl.


.*****************************************
:h3 id='backtab word'.BACKTAB WORD  (bw)
:p.Cursor auf den Anfang des vorhergehenden Wortes setzen.
:p.:hp2.Syntax:ehp2.
:xmp.
:hp4.backtab word:ehp4.
oder
:hp4.bw:ehp4.
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf das erste Zeichen des vorhergehenden Wortes;
d.h. falls er sich auf einem Wort befindet, so wird er nicht auf dessen
Anfang, sondern auf den Anfang des Wortes davor gesetzt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='tab word'  .TAB WORD:elink.
:li.&sqbul. :link reftype=hd refid='begin word'.BEGIN WORD:elink.
:li.&sqbul. :link reftype=hd refid='end word'  .END WORD:elink.
:esl.

.*****************************************
:h3 id='begin line'.BEGIN LINE  (bl)
:p.Cursor auf den Zeilenanfang setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
begin line
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf die erste Position der aktuellen Zeile. Funktioniert
im Textbereich und in der Kommandozeile.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='end line'  .END LINE:elink.
:esl.


.*****************************************
:h3 id='begin word'.BEGIN WORD  (wb)
:p.Cursor auf den Anfang des Wortes setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
begin word
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf das erste Zeichen des Wortes, auf dem er gerade steht;
falls der Cursor nicht auf einem Wort steht, so wird er auf den Anfang
des vorhergehenden Wortes gesetzt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='end word'  .END WORD:elink.
:li.&sqbul. :link reftype=hd refid='tab word'  .TAB WORD:elink.
:li.&sqbul. :link reftype=hd refid='backtab word'.BACKTAB WORD:elink.
:esl.



.*****************************************
:h3 id='bottom edge'.BOTTOM EDGE  (be)
:p.Setzt den Cursor auf die letzte Zeile im Textbereich.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
bottom edge
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf die letzte gltige und sichtbare Zeile
im Textbereich. Dieses Kommando ndert nur die Position des
Cursors im Textbereich, schaltet aber nicht auf den Textbereich um.
:note. Die Anzahl der sichtbaren Zeilen im Textbereich hngt vom
verwendeten Bildschirm, Videomodus oder der Version von :hp2.W:ehp2. ab.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='top edge'  .TOP EDGE:elink.
:li.&sqbul. :link reftype=hd refid='left edge' .LEFT EDGE:elink.
:li.&sqbul. :link reftype=hd refid='right edge'.BOTTOM EDGE:elink.
:esl.



.*****************************************
:h3 id='bottom'.BOTTOM  (bo)
:p.Cursor auf die letzte Zeile im File setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
bottom
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf die letzte Zeile im File und positioniert
den Textbereich so, da die letzte Zeile sichtbar ist.
:note.Eine letzte Zeile ist immer vorhanden, da :hp2.W:ehp2.
dafr sorgt, da zumindest eine Zeile immer vorhanden ist.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='top'  .TOP:elink.
:esl.


.*****************************************
:h3 id='center line'.CENTER LINE  (cl)
:p.Setzt die aktuelle Zeile in die Mitte.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
center line
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt die aktuelle Zeile in die Mitte des Textbereichs; dazu wird der
Textbereich entsprechend verschoben. Sollte die Anzahl der Zeilen
im File kleiner als die Anzahl der darstellbaren Zeilen sein, so hat dieses
Kommando keinen Effekt.


.*****************************************
:h3 id='column'.COLUMN
:p.Setzt den Cursor auf eine bestimmte Spalte.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
column :ehp4.[:hp1.n:ehp1.]
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf die angegebene Spalte. Dieses Kommando funktioniert
im Textbereich und in der Kommandozeile. Falls kein Argument angegeben
ist oder dieses 0 ist, so wird der Wert vom CalculationStack genommen
und dort entfernt. Mit dieser letzten Funktion ist es mglich,
den Cursor auf eine berechnete Spalte, oder auf eine in einer Variabeln
gespeicherten Wert, zu setzen.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='line'  .LINE:elink.
:esl.



.*****************************************
:h3 id='command toggle'.COMMAND TOGGLE  (cg)
:p.Umschalten zwischen Text- und Kommandoeingabe
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
command toggle
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Schaltet zwischen Textbereich und Kommandozeile hin und her.
Es gibt immer einen aktiven Bereich, dies kann der Textbereich
oder die Kommandozeile sein.
Ist die Kommadozeile aktiv, so wird der Cursor im Textbereich anders
dargestellt. Ist der Textbereich aktiv, so wird die Darstellung des
Cursors auf der Kommandozeile unterdrckt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='cursor command'  .CURSOR COMMAND:elink.
:li.&sqbul. :link reftype=hd refid='cursor data'  .CURSOR DATA:elink.
:esl.



.*****************************************
:h3 id='cursor command'.CURSOR COMMAND  (cc)
:p.Umschalten auf Kommandoeingabe.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
cursor command
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Schaltet auf die Kommandozeile um.
Ist die Kommadozeile aktiv, so wird der Cursor im Textbereich anders
dargestellt. Ist der Textbereich aktiv, so wird die Darstellung des
Cursors auf der Kommandzeile unterdrckt.
:note. Dieses Kommando wird von :hp2.W:ehp2. automatisch ausgefhrt, sobald
er ein SIGINT (Ctrl-Break) erhlt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='cursor data'  .CURSOR DATA:elink.
:li.&sqbul. :link reftype=hd refid='command toggle'  .COMMAND TOGGLE:elink.
:esl.



.*****************************************
:h3 id='cursor data'.CURSOR DATA  (ca)
:p.Umschalten auf Texteingabe.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
cursor data
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Schaltet auf den Textbereich um.
Ist die Kommadozeile aktiv, so wird der Cursor im Textbereich anders
dargestellt. Ist der Textbereich aktiv, so wird die Darstellung des
Cursors auf der Kommandzeile unterdrckt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='cursor command'  .CURSOR COMMAND:elink.
:li.&sqbul. :link reftype=hd refid='command toggle'  .COMMAND TOGGLE:elink.
:esl.



.*****************************************
:h3 id='down'.DOWN
:p.Cursor nach unten setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
down :ehp4.[:hp1.n:ehp1.]
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor eine Zeile nach unten, wobei die Spalte nicht verndert wird.
Befindet sich der Cursor bereits auf der letzten Zeile, so erscheint
in der Statuszeile ein Hinweis (EOF), da das Ende des Files erreicht worden
ist. Dieser Hinweis spiegelt sich auch in der Systemvariabeln
:link reftype=hd refid='ROVars'.ZEof:elink. wieder.
Falls der Cursor sich auf der letzten angezeigten Zeile im Textbereich
befindet, so wird der Textbereich um eine Zeile verschoben.
:note. Falls die
Kommandozeile aktiv ist, so wird der Cursor lediglich auf die letzte
angezeigte Zeile gesetzt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='up'   .UP   :elink.
:li.&sqbul. :link reftype=hd refid='left' .LEFT :elink.
:li.&sqbul. :link reftype=hd refid='right'.RIGHT:elink.
:esl.



.*****************************************
:h3 id='end line'.END LINE  (el)
:p.Cursor auf das Zeilenende setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
end line
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
:p.Setzt den Cursor ein Zeichen hinter das letzte Zeichen der Zeile.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='begin line'.BEGIN LINE:elink.
:esl.




.*****************************************
:h3 id='end word'.END WORD  (we)
:p.Cursor auf das Ende des Wortes setzen.
:p.:hp2.Syntax:ehp2.
:xmp.
:hp4.end word:ehp4.
oder
:hp4.we:ehp4.
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf das letzte Zeichen des Wortes, auf dem er gerade steht;
falls der Cursor nicht auf einem Wort steht, so wird er auf das letzte
Zeichen des nchsten Wortes gesetzt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='begin word'  .BEGIN WORD:elink.
:li.&sqbul. :link reftype=hd refid='tab word'  .TAB WORD:elink.
:li.&sqbul. :link reftype=hd refid='backtab word'.BACKTAB WORD:elink.
:esl.



.*****************************************
:h3 id='find blank line'.FIND BLANK LINE  (fb)
:p.Cursor auf die nchste leere Zeile setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
find blank line
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Falls der Cursor sich nicht bereits auf einer leeren Zeile befindet,
so wird er auf die nchste leere Zeile gesetzt. Existiert keine weitere
leere Zeile, so wird eine Fehlermeldung ausgegeben.
:p.
Eine leere Zeile ist eine Zeile die keine Zeichen enthlt oder
nur aus Leerzeichen besteht.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='first nonblank' .FIRST NONBLANK  :elink.
:li.&sqbul. :link reftype=hd refid='next nonblank'  .NEXT NONBLANK  :elink.
:li.&sqbul. :link reftype=hd refid='next blank'     .NEXT BLANK     :elink.
:esl.


.*****************************************
:h3 id='first nonblank'.FIRST NONBLANK  (fn)
:p.Setzt den Cursor auf das erste nonblank Zeichen der Zeile.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
first nonblank
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf das erste Zeichen der aktuellen Zeile, welches
kein Leerzeichen ist. Falls die Zeile nur aus Leerzeichen besteht, oder
keine Zeichen enthlt, so wird der Cursor hinter das Ender der Zeile gesetzt.

:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='next nonblank'  .NEXT NONBLANK  :elink.
:li.&sqbul. :link reftype=hd refid='next blank'     .NEXT BLANK     :elink.
:li.&sqbul. :link reftype=hd refid='find blank line'.FIND BLANK LINE:elink.
:esl.



.*****************************************
:h3 id='goto label'.GOTO LABEL  (gb)
:p.Cursor auf eine gespeicherte Position setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
goto label
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf die Position und den File, der unter dem Label
gespeichert ist. Das Ausfhren dieses Kommandos veranlat :hp2.W:ehp2.
den Benutzer nach einem Label zu fragen. Der Benutzer kann dann dieses Label
eingeben. Ein Label ist ein Buchstabe von A - Z, wobei Gro-/Kleinschreibung
nicht unterschieden wird. Falls das Label nicht gesetzt ist, oder der File
nich mehr geladen ist, so wird eine Fehlermeldung ausgegeben.
:p.Labels knnen als Lesezeichen benutzt werden, da sie nicht eine exakte
Position (Filename,Zeile und Spalte) darstellen, sondern an den Text selbst
angebunden sind.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='set label'  .SET LABEL:elink.
:esl.

.*****************************************
:h3 id='goto lineid'.GOTO LINEID
:p.Cursor auf eine markierte Zeile setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
goto lineid [lineid]
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf die angegebene lineid, falls keine angegeben wird,
so wird sie vom Calculation-Stack genommen. Eine lineid ist eine Markierung
der Zeile die an die Zeile gehaftet ist und nicht an die Zeilennummer;
damit ist es mglich neue Zeilen einzuschieben oder zu lschen und doch
noch eine bestimme Zeile wiederzufinden. Be bestimmten Operationen wird die
lineid natrlich entfernt und das Kommando gibt einen Fehler zurck.
Benutzt wird diese Funktionalitt z.B. zu Bearbeiten von Datein nach
einem Compiler-Lauf. Zur Benutzung dieser Funktion muss die Datei mit
der Opeion "-ji" geladen worden sein. Zur Zeit werden nur die ersten 65535
Zeilen mit einer lineid belegt, da im Normalfall Sourcefiles relativ
kurz sind.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='load'  .LOAD:elink.
:esl.



.*****************************************
:h3 id='indent'.INDENT  (in)
:p.Bedingtes Einrcken.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
indent
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Falls der Cursor sich auf der ersten Zeile des Files befindet oder die
vorhergehende Zeile leer ist, so wird der Cursor auf
die Einrckposition in der Zeile gesetzt; andernfalls wird er auf
die linke Ausrichtungsposition gesetzt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='set margins'     .SET MARGINS      :elink.
:li.&sqbul. :link reftype=hd refid='left margin'     .LEFT MARGIN      :elink.
:li.&sqbul. :link reftype=hd refid='right margin'    .RIGHT MARGIN     :elink.
:li.&sqbul. :link reftype=hd refid='paragraph margin'.PARAGRAPH MARGIN :elink.
:esl.



.*****************************************
:h3 id='left edge'.LEFT EDGE  (le)
:p.Cursor auf die erste Spalte im Textbereich setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
left edge
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf die erste sichtbare Spalte im Textbereich.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='right edge'.BOTTOM EDGE:elink.
:li.&sqbul. :link reftype=hd refid='top edge'  .TOP EDGE:elink.
:li.&sqbul. :link reftype=hd refid='bottom edge'.BOTTOM EDGE:elink.
:esl.



.*****************************************
:h3 id='left margin'.LEFT MARGIN  (lg)
:p.Cursor auf die linke Ausrichtposition setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
left margin
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Der Cursor wird auf der aktuellen Zeile auf die linke
Ausrichtposition gesetzt. (1. Argument von "set margins")
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='set margins'     .SET MARGINS     :elink.
:li.&sqbul. :link reftype=hd refid='right margin'    .RIGHT MARGIN    :elink.
:li.&sqbul. :link reftype=hd refid='paragraph margin'.PARAGRAPH MARGIN:elink.
:esl.



.*****************************************
:h3 id='left'.LEFT
:p.Cursor nach links setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
left :ehp4.[:hp1.n:ehp1.]
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Den Cursor um n Stellen nach links setzen. Maximal wird er auf die 1. Spalte
gesetzt. Wenn n nicht angegeben wird, so wird 1 fr n angenommen.
Funktioniert im Textbereich und auf der Kommandozeile.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='right'  .RIGHT:elink.
:esl.



.*****************************************
:h3 id='line'.LINE
:p.Setzt den Cursor auf eine bestimmte Zeile.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
line :ehp4.[:hp1.n:ehp1.]
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf die angegebene Zeile. Dieses Kommando funktioniert
nur im Textbereich. Falls kein Argument angegeben
ist oder dieses 0 ist, so wird der Wert vom CalculationStack genommen
und dort entfernt. Mit dieser letzten Funktion ist es mglich,
den Cursor auf eine berechnete Zeile, oder auf eine in einer Variabeln
gespeicherten Wert, zu setzen.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='column'  .COLUMN:elink.
:esl.


.*****************************************
:h3 id='locate'.LOCATE  (l)
:p.Suchen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
locate/<string>/[flags]
:ehp4.:exmp.
:p.:hp2.Flags:ehp2.
:parml compact break=fit.
:pt.-
:pd.Rckwrts suchen
:pt.e
:pd.(exact) Unabhngig von der mit "set searchcase" gesetzten Einstellung
wird bei der Suche Klein-/Groschreibung unterschieden.
:pt.a
:pd.(any) Unabhngig von der mit "set searchcase" gesetzten Einstellung
wird bei der Suche Klein-/Groschreibung nicht unterschieden.
:pt.m
:pd.(mark) Es wird nur innerhalb der Markierung gesucht. Die Suche beginnt
erst am Markierungsanfang und ended am Markierungsende.
:pt.l
:pd.(left) Der Suchstring wird nur gefunden, wenn er am linken Rand beginnt.
Zusammen mit der Option :hp2.mark:ehp2. ist der linke Rand der der Markierung.
:pt.r
:pd.(r.e.) Der Suchstring enthlt regular-expressions. Der Syntax entspricht
der von regexp(3), ursprngliche Kodierung ist von Henry Spencer.
:eparml.
:p.:hp2.Beschreibung:ehp2.:p.
Im aktuellen File nach einem Text suchen. Die Suche beginnt ein Zeichen
nach der aktuellen Position. Der Text ist zwischen 2 beliebigen Trennzeichen
anzugeben; d.h. statt "/" kann z.B. auch "!" oder "a" benutzt werden. Das
abschliessende Trennzeichen kann auch entfallen, allerdings knnten dann
eventuell nachfolgende Blanks als zum String gehrend betrachtet werden.
.br
Hinter dem 2. Trennzeichen knnen die Flags in beliebiger Reihenfolge
angegeben werden.
Das Kommando kann durch "l" abgekrzt werden;
falls "/" als Trennzeichen benutzt wird, so kann selbst das "l" entfallen.
:p.:hp2.Beispiele:ehp2.
:lines.
         locate/Wo ist dieser Text/
         l/while/
         /include/-
:elines.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='change'.CHANGE:elink.
:li.&sqbul. :link reftype=hd refid='set searchcase'.SET SEARCHCASE:elink.
:esl.



.*****************************************
:h3 id='matchblock'.MATCHBLOCK
:p.Das inverse Zeichen suchen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
matchblock
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Befindet sich der Cursor auf einem der Zeichen:
.br
{  }  (  )   [  ]   <  >  `  '
.br
so wird das zugehrige inverse Zeichen gesucht; hierzu wird entsprechend
rckwrts oder vorwrts gesucht, je nach Zeichen. Sind die Blcke
verschachtelt, so wird dies entsprechend bercksichtigt.
.br
Mit diesem Kommando kann man sich also leicht bersicht ber
komplizierte Klammerausdrcke verschaffen.


.*****************************************
:h3 id='next blank'.NEXT BLANK  (nb)
:p.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf das nchste Zeichen, welches ein Blank ist.
Falls sich in der aktuellen Zeile kein solches Zeichen mehr befindet,
so wird der Cursor hinter das Zeilenende gesetzt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='first nonblank' .FIRST NONBLANK  :elink.
:li.&sqbul. :link reftype=hd refid='next nonblank'  .NEXT NONBLANK:elink.
:li.&sqbul. :link reftype=hd refid='find blank line'  .FIND BLANK LINE:elink.
:esl.


.*****************************************
:h3 id='next nonblank'.NEXT NONBLANK  (nnb)
:p.Leerzeichen berspringen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
next nonblank
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf das nchste Zeichen, welches kein Blank ist.
Falls sich in der aktuellen Zeile keine solchen Zeichen mehr befinden,
so wird der Cursor hinter das Zeilenende gesetzt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='first nonblank' .FIRST NONBLANK  :elink.
:li.&sqbul. :link reftype=hd refid='next blank'     .NEXT BLANK:elink.
:li.&sqbul. :link reftype=hd refid='find blank line'  .FIND BLANK LINE:elink.
:esl.



.*****************************************
:h3 id='page down'.PAGE DOWN  (pd)
:p.Eine Seite vorwrts.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
page down
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Der angezeigte Textbereich wird um eine Seite nach unten verschoben.
Eine Seite ist hierbei die Anzahl der angezeigten Zeilen minus 2.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='page up'.PAGE UP:elink.
:esl.



.*****************************************
:h3 id='page up'.PAGE UP  (pu)
:p.Eine Seite zurck
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
page up
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Der angezeigte Textbereich wird um eine Seite nach oben verschoben.
Eine Seite ist hierbei die Anzahl der angezeigten Zeilen minus 2.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='page down'.PAGE DOWN:elink.
:esl.



.*****************************************
:h3 id='paragraph margin'.PARAGRAPH MARGIN  (pg)
:p.Cursor auf die Einrckposition setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
paragraph margin
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Der Cursor wird auf der aktuellen Zeile auf die
Einrckposition gesetzt. (3. Argument von "set margins")
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='set margins'    .SET MARGINS     :elink.
:li.&sqbul. :link reftype=hd refid='left margin'    .LEFT MARGIN    :elink.
:li.&sqbul. :link reftype=hd refid='right margin'    .RIGHT MARGIN    :elink.
:esl.


.*****************************************
.*   COMMAND: "posatmouse"
.*
.*     Moves the cursor to the current mouse position, if this is in
.*   the commandline, the commandline will get the focus; if it is in
.*   the textarea, the textarea will get the inputfocus.  This command
.*   will have no effect if the mouse is not in the textarea or
.*   commandline.
:h3 id='posatmouse'.POSATMOUSE
:p.Cursor auf Mosueposition setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
posatmouse
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf die Position, auf der sich der Mousecursor
befindet. Falls dies im Textbereich ist, so wird auch die Eingabe
auf den Textbereich umgeschaltet. Ensprechendes gilt fr die
Kommandozeile.
.br
Falls der Mousecursor sich weder im Textbereich noch auf der Kommandozeile
befindet, so hat dieses Kommando keinen Effekt.


.*****************************************
:h3 id='right edge'.RIGHT EDGE  (re)
:p.Cursor auf die letzte Spalte im Textbereich setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
right edge
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf die letzt sichtbare Spalte im Textbereich.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='left edge'.LEFT EDGE:elink.
:li.&sqbul. :link reftype=hd refid='top edge'  .TOP EDGE:elink.
:li.&sqbul. :link reftype=hd refid='bottom edge'.BOTTOM EDGE:elink.
:esl.



.*****************************************
:h3 id='right margin'.RIGHT MARGIN  (rg)
:p.Cursor auf die rechte Ausrichtposition setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
right margin
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Der Cursor wird auf der aktuellen Zeile auf die rechte
Ausrichtposition gesetzt. (2. Argument von "set margins")
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='set margins'     .SET MARGINS     :elink.
:li.&sqbul. :link reftype=hd refid='left margin'    .LEFT MARGIN    :elink.
:li.&sqbul. :link reftype=hd refid='paragraph margin'.PARAGRAPH MARGIN:elink.
:esl.



.*****************************************
:h3 id='right'.RIGHT
:p.Cursor nach rechts setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
right :ehp4.[:hp1.n:ehp1.]
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Den Cursor um n Stellen nach rechts setzen. Maximal wird er auf die
letztmgliche Spalte
gesetzt.
Wenn n nicht angegeben wird, so wird 1 fr n angenommen.
Funktioniert im Textbereich und auf der Kommandozeile.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='left'  .LEFT:elink.
:esl.



.*****************************************
:h3 id='scrolldown'.SCROLLDOWN
:p.Den Cursor nach unten setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
scrolldown :ehp4.[:hp1.n:ehp1.]
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Der Cursor wird um n Zeilen nach unten gesetzt, wobei der Textbereich
gleichzeitig nach unten verschoben wird.
Wenn n nicht angegeben wird, so wird 1 fr n angenommen.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='scrollup'   .SCROLLUP    :elink.
:li.&sqbul. :link reftype=hd refid='scrollleft' .SCROLLLEFT  :elink.
:li.&sqbul. :link reftype=hd refid='scrollright'.SCROLLRIGHT :elink.
:esl.




.*****************************************
:h3 id='scrollleft'.SCROLLLEFT
:p.Den Cursor nach links setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
scrollleft :ehp4.[:hp1.n:ehp1.]
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Der Cursor wird um n Zeilen nach links gesetzt, wobei der Textbereich
gleichzeitig nach links verschoben wird.
Wenn n nicht angegeben wird, so wird 1 fr n angenommen.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='scrollright'.SCROLLRIGHT :elink.
:li.&sqbul. :link reftype=hd refid='scrollup'   .SCROLLUP    :elink.
:li.&sqbul. :link reftype=hd refid='scrolldown' .SCROLLDOWN  :elink.
:esl.


.*****************************************
:h3 id='scrollright'.SCROLLRIGHT
:p.Den Cursor nach rechts setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
scrollright :ehp4.[:hp1.n:ehp1.]
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Der Cursor wird um n Zeilen nach rechts gesetzt, wobei der Textbereich
gleichzeitig nach rechts verschoben wird.
Wenn n nicht angegeben wird, so wird 1 fr n angenommen.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='scrollleft'.SCROLLLEFT :elink.
:li.&sqbul. :link reftype=hd refid='scrollup'   .SCROLLUP    :elink.
:li.&sqbul. :link reftype=hd refid='scrolldown' .SCROLLDOWN  :elink.
:esl.




.*****************************************
:h3 id='scrollup'.SCROLLUP
:p.Den Cursor nach oben setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
scrollup :ehp4.[:hp1.n:ehp1.]
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Der Cursor wird um n Zeilen nach oben gesetzt, wobei der Textbereich
gleichzeitig nach oben verschoben wird.
Wenn n nicht angegeben wird, so wird 1 fr n angenommen.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='scrolldown' .SCROLLDOWN  :elink.
:li.&sqbul. :link reftype=hd refid='scrollleft' .SCROLLLEFT  :elink.
:li.&sqbul. :link reftype=hd refid='scrollright'.SCROLLRIGHT :elink.
:esl.





.* .*****************************************
.* .*   COMMAND: "set hscroll" "s hscroll"
.* .*
.* .*   Syntax: set hscroll <on>|<off>
.* .*
.* .*     This controls, how the cursor move when he passes the right or
.* .*   left edge of the screen:  If hscroll is on, the textarea will be
.* .*   scrolled by one; if hscroll is off, the cursor will be placed in
.* .*   the middle of the line.
.* :h3 id=''.
.* :p.
.* :p.:hp2.Syntax:ehp2.
.* :xmp.:hp4.
.* :ehp4.:exmp.
.* :p.:hp2.Beschreibung:ehp2.:p.
.* :p.:hp2.Siehe auch:ehp2.:sl compact.
.* :li.&sqbul. :link reftype=hd refid=''  .:elink.
.* :esl.



.*****************************************
:h3 id='set label'.SET LABEL  (sb)
:p.Markierung auf aktuelle Position setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set label
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt ein Label auf die aktuelle Position.
Das Ausfhren dieses Kommandos veranlat :hp2.W:ehp2.
den Benutzer nach dem Label zu fragen. Der Benutzer kann dann dieses Label
eingeben. Ein Label ist ein Buchstabe von A - Z, wobei Gro-/Kleinschreibung
nicht unterschieden wird. Ein bereits gesetztes Label mit diesem Namen
wird berschrieben.
:p.Labels knnen als Lesezeichen benutzt werden, da sie nicht eine exakte
Position (Filename,Zeile und Spalte) darstellen, sondern an den Text selbst
angebunden sind.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='goto label'  .GOTO LABEL:elink.
:esl.





.*****************************************
:h3 id='set margins'.SET MARGINS
:p.Ausrichtpositionen setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set margins <left> [<right> [<ident>]] | default
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt die 3 Positionen fr verschiedene andere Kommandos.
Diese Positionen knnen fr jeden File verscheiden definiert werden.
Beim Laden eines neuen File werden die margins des aktuellen Files
bernommen. Wird "default" als Argument benutzt, so werden die maximal
mglichen Werte benutzt; d.h left und ident werden auf 1, und
right wird auf die maximale Zeilenlnge gesetzt.
:note. Mit Hilfe von
:link reftype=hd refid='SysVar_ZEditPrc'.EditProzeduren:elink.
knnen fr jeden Filetyp bestimmte Werte gesetzt werden.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='left margin'.LEFT MARGIN:elink.
:li.&sqbul. :link reftype=hd refid='right margin'.RIGHT MARGIN:elink.
:li.&sqbul. :link reftype=hd refid='paragraph margin'.PARAGRAPH MARGIN:elink.
:li.&sqbul. :link reftype=hd refid='paragraph margin'.PARAGRAPH MARGIN:elink.
:li.&sqbul. :link reftype=hd refid='reflow'.REFLOW:elink.
:esl.

.*****************************************
:h3 id='set latin'.SET LATIN
:p.Aktiven Zeichensatz umstellen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set latin on|off
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Wenn diese Option eingeschaltet wird, so wird zur Eingabe von Zeichen
und zur Anzeige der ISO Zeichensatz 8859-1 benutzt. Dies kann auch beim
Programmstart mit der Option -8 eingestellt werden.



.*****************************************
:h3 id='set pureascii'.SET PUREASCII
:p.Eingabe von Nicht-ASCII-Zeichen verhindern.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set pureascii on|off
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Wenn diese Option eingeschaltet wird, so wird die Eingabe von Zeichen
die nicht ASCII entsprechen, verhindert. Falls dies versucht wird, so
erscheint eine Fehlermeldung und ein akustisches Signal wird ausgegeben.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='varlist'  .VARLIST:elink.
:esl.



.*****************************************
:h3 id='set searchcase'.SET SEARCHCASE
:p.Gro-/Kleinschreibungsunterscheidung festlegen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set searchcase any|exact
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Legt das Verhalten der Suchfunktion fest.
br
alls searchcase auf any eingestellt ist, so wird
ro-/Kleinschreibung nicht unterschieden.
.br
Falls searchcase auf exact eingestellt ist, so wird
Gro-/Kleinschreibung unterschieden.
.br
Diese Eigenschaft kann bei jedem Suchen auch explizit mit den Flags
bestimmt werden. Mit diesem Kommando sollte das vorwiegend benutzte
Verfahren eingestellt werden.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='locate'  .LOCATE:elink.
:li.&sqbul. :link reftype=hd refid='change'  .CHANGE:elink.
:li.&sqbul. :link reftype=hd refid='varlist' .VARLIST:elink.
:esl.



.*****************************************
:h3 id='set tabs'.SET TABS
:p.Tabulatorpositionen festlegen
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set tabs  <t1> {<tn>} | rpt <n>
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Hiermit werden die Tabulatorpositionen fr jeden File festgelegt.
Entweder werden sie aufgezhlt oder aber mit dem Schlsselwort rpt auf
alle <n> Positionen gesetzt.
Beim Laden eines neuen File werden die Tabstops des aktuellen Files
bernommen.
:note.An Position 1 befindet sich immer ein Tabulatorstop,
er braucht also nicht angegeben zu werden.
:note. Mit Hilfe von
:link reftype=hd refid='SysVar_ZEditPrc'.EditProzeduren:elink.
knnen fr jeden Filetyp bestimmte Werte gesetzt werden.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='tab'  .TAB:elink.
:li.&sqbul. :link reftype=hd refid='backtab'  .BACKTAB:elink.
:li.&sqbul. :link reftype=hd refid='? tabs' .? TABS:elink.
:esl.

.*****************************************
:h3 id='set unixsave'.SET UNIXSAVE
:p.Immer im UNIX Stil speichern
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set unixsave on|off
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Wenn diese Option eingeschaltet wird, so werden Dateieneimmer nur mit
einem Linefeed am Zeilenende gespeichert. Dies entspricht der Speicheroption
"-fu". Falls gegenteilige Speicheroptionen (auch in "ZDefSaveOpt")
angegeben sind, so hat diese Option keine Auswirkung.
:note. Da MSDOS Probleme mit UNIX Dateien hat, ist hier als Besonderheit
eingebaut, da fr die Dateien "c&colon./config.sys" und "c&colon./autoexec.bat"
diese Option keine Wirkung hat.


.*****************************************
:h3 id='tab'.TAB  (tb)
:p.Cursor auf den nchsten Tabstop setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
tab
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf den nchsten Tabstop der Zeile.
Tabstops knnen fr jeden File einzeln gesetzt werden, wobei aber implizit
die erste Position einer Zeile immer einen Tabstop darstellt.
Tabstops sind auch auf der Kommandozeile vorhanden, dort aber fest auf
alle 8 Positionen verdrahtet.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='backtab' .BACKTAB:elink.
:li.&sqbul. :link reftype=hd refid='set tabs'.SET TABS:elink.
:li.&sqbul. :link reftype=hd refid='? tabs'  .? TABS:elink.
:esl.



.*****************************************
:h3 id='tab word'.TAB WORD  (tw)
:p.Cursor auf den Anfang des nchsten Wortes setzen.
:p.:hp2.Syntax:ehp2.
:xmp.
:hp4.tab word:ehp4.
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf das erste Zeichen des nchsten Wortes.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='backtab word'.BACKTAB WORD:elink.
:li.&sqbul. :link reftype=hd refid='begin word'  .BEGIN WORD:elink.
:li.&sqbul. :link reftype=hd refid='end word'  .END WORD:elink.
:esl.






.*****************************************
:h3 id='top edge'.TOP EDGE  (te)
:p.Setzt den Cursor auf die erste Zeile im Textbereich.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
top edge
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf die erste gltige und sichtbare Zeile
im Textbereich. Dieses Kommando ndert nur die Position des
Cursors im Textbereich, schaltet aber nicht auf den Textbereich um.
:note. Die Anzahl der sichtbaren Zeilen im Textbereich hngt vom
verwendeten Bildschirm, Videomodus oder der Version von :hp2.W:ehp2. ab.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='bottom edge'  .BOTTOM EDGE:elink.
:li.&sqbul. :link reftype=hd refid='left edge' .LEFT EDGE:elink.
:li.&sqbul. :link reftype=hd refid='right edge'.BOTTOM EDGE:elink.
:esl.



.*****************************************
:h3 id='top'.TOP
:p.Cursor auf die erste Zeile im File setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
top
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor auf die ertse Zeile im File und positioniert
den Textbereich so, da die erste Zeile sichtbar ist.
:note.Eine erste Zeile ist immer vorhanden, da :hp2.W:ehp2.
dafr sorgt, da zumindest eine Zeile immer vorhanden ist.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='bottom'  .BOTTOM:elink.
:esl.



.*****************************************
:h3 id='up'.UP
:p.Cursor nach oben setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
up :ehp4.[:hp1.n:ehp1.]
:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt den Cursor eine Zeile nach oben, wobei die Spalte nicht verndert wird.
Befindet sich der Cursor bereits auf der ersten Zeile, so hat dieses Kommando
keine Wirkung.
Falls der Cursor sich auf der ersten angezeigten Zeile im Textbereich
befindet, so wird der Textbereich um eine Zeile verschoben.
:note. Falls die
Kommandozeile aktiv ist, so wird der Cursor lediglich auf die letzte
angezeigte Zeile gesetzt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='down' .DOWN :elink.
:li.&sqbul. :link reftype=hd refid='left' .LEFT :elink.
:li.&sqbul. :link reftype=hd refid='right'.RIGHT:elink.
:esl.




.*****************************************
:h3 id='? margins'.? MARGINS  (?m)
:p.Ausrichtpositionen anzeigen
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
? margins
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Zeigt die Ausrichtpositionen fr den aktuellen File an; diese werden auf
der Kommandozeile so ausgegeben, da sie das entsprechende
Kommando zum setzen dieser Werte bilden.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='set margins'.SET MARGINS:elink.
:esl.


.*****************************************
:h3 id='? tabs'.? TABS  (?t)
:p.Tabulatorpositionen anzeigen
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
? tabs
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Zeigt die Tabstops fr den aktuellen File an; diese werden auf
der Kommandozeile so ausgegeben, da sie das entsprechende
Kommando zum setzen dieser Werte bilden.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='set tabs'.SET TABS:elink.
:esl.



.****** end of file *********
