.* [w4.ipf wk 24.8.92] Documentation for W - Flowcontrol
.*      Copyright (c) 1992 by Werner Koch (dd9jn)
.* History:
.*
.*********************************************************************


.*****************************************
.*   COMMAND: "call"
.*
.*   Syntax: call <operator>
.*
.*     The next command will be executed if the result of the
.*   operation is true, if the result is false, the next command will
.*   be skipped.  See the section operators for a list of valid
.*   operators.
:h3 id='call'.CALL
:p.Bedingte Ausfhrung
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
call <operator>; <Bedingtes Kommando>; [<Weitere Kommandos>]
:ehp4.oder:hp4.
call <operator>; begin; <Bedingte Kommandos>; end; [<Weitere Kommandos>]
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Wenn die durch den Operator durchgefhrte Operation einen wahren Wert liefert
(Einen Wert ungleich 0), so wird das bzw. die bedingten Kommandos durchgefhrt
und danach eventuell folgende weitere Kommandos; im anderen Fall werden
die bedingten Kommandos bersprungen und nur die eventuell vorhandenen
weiteren Kommandos durchgefhrt.

:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='Operators'.Operatoren:elink.
:li.&sqbul. :link reftype=hd refid='jmp'  .JMP:elink.
:esl.



.*****************************************
.*   COMMAND: "clear message" "ce"
.*
.*     Deletes the messageline
:h3 id='clear message'.CLEAR MESSAGE  (ce)
:p.Meldung lschen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
clear message
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Lscht eine eventuell vorhandene Fehler- oder Informationsmeldung.
Meldungen werden auch durch den nchsten Tastendruck gelscht. Dieses
Kommando kann innerhalb eines lngeren Makros benutzt werden, um
unerwnschte Meldungen zu unterdrcken.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='error'.ERROR:elink.
:esl.




.*****************************************
.*   COMMAND: "demo end" "de"
.*
.*     Terminates the demo mode; this function will be executed
.*   internally when "W" receives SIGINT (Ctrl-Break key for MS-DOS).
.*
.*
:h3 id='demo end'.DEMO END  (de)
:p.DEMO-Modus beenden.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
demo end
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Beendet den DEMO-Modus. :hp2.W:ehp2. fhrt dieses Kommando intern aus,
sobald er ein :hp2.SIGINT:ehp2. (Ctrl-Break Taste) empfngt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='demo slow'.DEMO SLOW:elink.
:li.&sqbul. :link reftype=hd refid='demo fast'.DEMO FAST:elink.
:esl.




.*****************************************
.*   COMMAND: "demo fast" "df"
.*
.*     Starts demo mode:  The screen will be updated after the
.*   execution of each command.  Normally screenupdate is delayed
.*   until "W" waits for a new keystroke.
.*
:h3 id='demo fast'.DEMO FAST  (df)
:p.DEMO-Modus einschalten.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
demo fast
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Startet den DEMO-Modus&colon. Der Bildschirm wird nach jedem
Kommando aufgefrischt; normalerweise verzgert :hp2.W:ehp2. den
Bildschirmneuaufbau bis er auf eine neue Taste wartet.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='demo end'.DEMO END:elink.
:li.&sqbul. :link reftype=hd refid='demo slow'.DEMO SLOW:elink.
:esl.




.*****************************************
.*   COMMAND: "demo slow" "ds"
.*
.*     Same as command "demo fast", but an additional delay of 1
.*   second will be inserted after every screenupdate.
:h3 id='demo slow'.DEMO SLOW  (ds)
:p.Langsamen DEMO-Modus einschalten.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
demo slow
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Startet den DEMO-Modus&colon. Der Bildschirm wird nach jedem
Kommando aufgefrischt und eine Pause von einer Sekunde eingelegt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='demo end'.DEMO END:elink.
:li.&sqbul. :link reftype=hd refid='demo fast'.DEMO FAST:elink.
:esl.




.*****************************************
.*   COMMAND: "error"
.*
.*   Syntax: error n
.*
.*     Creates an error with code n.  The errormessage will be shown.
.*   You can use this function for debugging macros. You may use
.*   "error 0" to reset the Errorvariable "ZErr"
:h3 id='error'.ERROR
:p.Fehler auslsen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
error <n>
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Erzeugt einen Fehler mit dem internen Fehlercode n. Dies hat zur Folge,
da die entsprechende Fehlermeldung angezeigt wird.
:note.Um die Variable :hp4.ZErr:ehp4. zurckzusetzen, kann dieses Kommando
mit dem Argument 0 benutzt wird.



.*****************************************
.*   COMMAND: "jmp"
.*
.*   Syntax: jmp <operator>
.*
.*     The next command will be executed if the result of the
.*   operation is true and the rest of the commands will be skipped,
.*   if the result is false, the next command will be skipped.
.*   See the section operators for a list of valid operators.
:h3 id='jmp'.JMP
:p.Bedingte Ausfhrung
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
jmp <operator>; <Bedingtes Kommando>; <Andere Kommandos>
:ehp4.oder:hp4.
jmp <operator>; begin; <Bedingte Kommandos>; end; <Andere Kommandos>
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Wenn die durch den Operator durchgefhrte Operation einen wahren Wert liefert
(Einen Wert ungleich 0), so wird das bzw. die bedingten Kommandos durchgefhrt
und die Ausfhrung des Makros danach beendet;
im anderen Fall werden
die bedingten Kommandos bersprungen und nur die
anderen Kommandos durchgefhrt.

:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='Operators'.Operatoren:elink.
:li.&sqbul. :link reftype=hd refid='call'  .JMP:elink.
:esl.




.*****************************************
.*   COMMAND: "key"
.*
.*   Syntax: key <keyname>
.*
.*     Executes the commands which are bounded to the keyname.  You
.*   can use this as a subroutine
:h3 id='key'.KEY
:p.Unterprogramm aufrufen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
key <keyname>
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Die dem angegebenen keyname zugeordneten Kommandos werden durchgefhrt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='define'.DEFINE:elink.
:esl.




.*****************************************
.*   COMMAND: "pause"
.*
.*   Syntax: pause [n]
.*
.*     Halts the execution for n seconds; if n is ommited or n is
.*   longer than one hour, n defaults to 1 second.
:h3 id='pause'.PAUSE
:p.Ausfhrung anhalten.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
pause [<n>]
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Hlt die Ausfhrung fr n Sekunden an. Falls n nicht angegeben wird,
so wird eine Sekunde pausiert. Selbstvertndlich kann auch
dieses Kommando durch SIGINT (Ctrl-Break Taste) abgebrochen werden.


.****************
.* Command: "LEAP TO"
.*
:h3 id='leap to'.LEAP TO
:p.Springen innerhalb eines Macrofiles
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
leap to <leaptarget>
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Dieses Kommando hat nur eine Wirkung innerhalb einer Macrofiles; d.h.
bei der Ausfhrung des Commandos "macro".
Nach diesem Befehl wird die Ausfrhrung des Macrofiles mit der Zeile
die auf das <leaptarget> folgt, fortgesetzt. Das <leaptarget> kann ein
beliebiger String sein und mu um erkannt zu werden alleine auf einer
Zeile stehen und direkt von einem Doppelpunkt gefolgt sein.

Es wird das nchste gefundene leaptarget benutzt und wenn keines gefunden wird,
noch mal ab Anfang des Macrofiles gesucht - somit ist die Konstruktion
von Schleifen auch ber mehrere Zeilen hinweg mglich.

Beim lesen von Macrofiles werden Zeilen die nach einem Leaptarget aussehen
ignoriert. Zeilenfortsetzung funktioniert bei Leaptargets nicht,
Kommentarzeilen werden erkannt.


.*****************************************
.*   COMMAND: "until"
.*
.*   Syntax: until <operator>
.*
.*     This executes the next command until the operation defined by
.*   operator results in false value.  The check is done after the
.*   command is executed.  See the sections macros and operators for
.*   further information.
:h3 id='until'.UNTIL
:p.Bedingte Schleife.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
until <operator>; <Kommando>; <Andere Kommandos>
:ehp4.oder:hp4.
until <operator>; begin; <Kommandos>; end; <Andere Kommandos>
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Fhrt das Kommando, bzw. die in BEGIN und END geklammerten Kommandos
solange aus, wie die durch den Operator beschriebene Operation den
Wahrheitswert Falsch (Wert gleich 0) liefert. Der Operator wird
immer :hp2.nach:ehp2. Ausfhrung des/der Kommandos angewandt. Somit ist
es mglich, erst innerhalb der Schleife die Werte fr den Operator
bereitzustellen. Nach Ende der Schleife werden die Argumente entsprechend
dem Operator von Stapel entfernt und eventuell vorhandene
andere Kommandos durchgefhrt.
:p.
Auch wenn die Werte auf dem Stapel innerhalb der Schleife gendert werden
knnen, wird man im Normalfall eine Variable und und eventuell eine Konstante,
vor der Ausfhrung dieses Kommandos, auf dem Stapel ablegen.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='Operators'.Operatoren:elink.
:li.&sqbul. :link reftype=hd refid='while'  .WHILE:elink.
:esl.




.*****************************************
.*   COMMAND: "while"
.*
.*   Syntax: while <operator>
.*
.*     This executes the next command until the operation defined by
.*   operator results in false value.  The check is done before the
.*   command is executed.  See the sections macros and operators for
.*   further information.
:h3 id='while'.WHILE
:p.Bedingte Schleife.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
while <operator>; <Kommando>; <Andere Kommandos>
:ehp4.oder:hp4.
while <operator>; begin; <Kommandos>; end; <Andere Kommandos>
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Fhrt das Kommando, bzw. die in BEGIN und END geklammerten Kommandos
solange aus, wie die durch den Operator beschriebene Operation den
Wahrheitswert Wahr (Wert ungleich 0) liefert. Der Operator wird
immer :hp2.vor:ehp2. Ausfhrung des/der Kommandos angewandt; d.h. die
Schleife mu nicht in jedem Fall durchlaufen werden.
Nach Ende der Kommandos werden die Argumente entsprechend
dem Operator von Stapel entfernt und eventuell vorhandene
andere Kommandos durchgefhrt.
:p.
Normalerweise wird man eine Variable und und eventuell eine Konstante,
vor der Ausfhrung dieses Kommandos, auf dem Stapel ablegen.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='Operators'.Operatoren:elink.
:li.&sqbul. :link reftype=hd refid='until'  .UNTIL:elink.
:esl.


.****** end of file *********
