.* [w5.ipf wk 24.8.92] Documentation for W - Files
.*      Copyright (c) 1992 by Werner Koch (dd9jn)
.* History:
.*
.*********************************************************************


.*****************************************
:h3 id='commit'.COMMIT
:p.Alle Files speichern.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
commit
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Die alle genderten Files werden abgespeichert; dies gilt nicht
fr interne Files, da diese nicht auf Platte gespeichert werden knnen.
Besondere Optionen knnen natrlich beim speichern nicht benutzt werden.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='quit'.QUIT:elink.
:esl.



.*****************************************
:h3 id='edit'.EDIT  (e)
:p.Eine File laden.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
edit [optionen] [filename|varname]
:ehp4.:exmp.
:p.:hp2.Optionen:ehp2.
:parml break=fit.
:pt.-fl
:pd.Ldt eine Datei die einen 2 Byte Lngenvorspann besitzt; dieser
mu als "Big-Endian" kodiert sein.
:pt.-fb[:hp1.n:ehp1.]
:pd.Ldt die Datei binr; d.h. jede Zeile wird mit max. :hp1.n:ehp1. Zeichen
gefllt und Zeilenvorschub etc. werden nicht ausgewertet. Mit dieser
Option ist es demnach mglich, jede beliebige Datei zu laden und zu verndern.
Default-Wert fr :hp1.n:ehp1. ist aktuelle Bildschirmbreite.
:pt.-f[:hp1.n:ehp1.]
:pd.Ldt eine Datei mit der festen Satzlnge :hp1.n:ehp1.. Zeilenvorschub etc.
wird nicht ausgewertet. Beim Speichern dieser Datei werden zu kurze Zeilen
mit Blanks aufgefllt. Default-Wert fr :hp1.n:ehp1. ist 80.
:pt.-nt
:pd.Tabulatoren werden nicht expandiert.
:pt.-nb
:pd.Blanks am Ende einer Zeile werden beim Laden nicht abgeschnitten.
:pt.-s<:hp1.n:ehp1.>
:pd.Ldt die Datei erst ab Zeile/Satz :hp1.n:ehp1.. Um
versehentliches Speichern zu verhindern wird das ReadOnlyFlag gesetzt.
:pt.-m<:hp1.n:ehp1.>
:pd.Ldt maximal :hp1.n:ehp1.. Zeilen/Stze der Datei. Um
versehentliches Speichern zu verhindern wird das ReadOnlyFlag gesetzt.
:pt.-j0
:pd.Unterdrckt die Ausfhrung der EditProzeduren.
:pt.-ji
:pd.Markiert Zeilen mit ihren ursprnglichen Zeilennummern
(Fr das Kommando :link reftype=hd refid='goto lineid'.GOTO LINEID:elink.).
:pt.-jR
:pd.Reload. Der aktuelle File wird auf jeden Fall
(d.h auch ohne Sicherheitsabfrage) neu geladen (wie das Kommando REEDIT).
:eparml.
:p.:hp2.Beschreibung:ehp2.:p.
Ldt den genannten File in :hp2.W:ehp2. und macht ihn zum aktiven File.
Falls dieser File bereits geladen ist, so wird er aktiviert, d.h.
im Textbereich angezeigt.
Existiert der File nicht, so wird ein leerer File (mit einer Zeile)
in :hp2.W:ehp2., aber nicht auf der Platte, erzeugt.
:p.
Wird kein Filename angegeben, so wird der nchste File aktiviert.
:hp2.W:ehp2. verwaltet alle geladenen Files in einem Ringpuffer; mit
diesem Kommando ist es demnach mglich, durch diesen Puffer zu blttern.
:p.
Falls ein File neu erzeugt wird, oder von Platte geladen wird, so
werden bestimmte
:link reftype=hd refid='SysVar_ZEditPrc'.EditProzeduren:elink.
aufgerufen.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='reedit'.REEDIT:elink.
:li.&sqbul. :link reftype=hd refid='load'.LOAD:elink.
:li.&sqbul. :link reftype=hd refid='new'.NEW:elink.
:li.&sqbul. :link reftype=hd refid='save'.SAVE:elink.
:esl.


.*****************************************
:h3 id='editlist'.EDITLIST
:p.Liste aller Files anzeigen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
editlist
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Baut den internen File ".editlist" neu auf und aktiviert diesen.
Dieser File enthlt alle
in :hp2.W:ehp2. geladenenen Files und einige Informationen dazu.



.*****************************************
:h3 id='exit'.EXIT
:p.:hp2.W:ehp2. beenden.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
exit
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Beendet :hp2.W:ehp2.. Falls noch FIles mit nicht gespeicherten
nderungen vorhanden sind, so erfolgt eine Sicherheitsabfrage.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='quit'.QUIT:elink.
:esl.



.*****************************************
:h3 id='file'.FILE
:p.File speichern und aus :hp2.W:ehp2. entfernen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
file [optionen] [filename|varname]
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Es wird das Kommando
:link reftype=hd refid='save'.SAVE:elink.
ausgefhrt und falls dieses fehlerfrei durchgefhrt wurde,
wird das Kommando
:link reftype=hd refid='quit'.QUIT:elink.
ausgefhrt.



.*****************************************
:h3 id='load'.LOAD
:p.Eine File laden.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
load [optionen] [filename|varname]
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Dies ist identisch mit dem Kommando
:link reftype=hd refid='edit'.EDIT:elink.
, aber es wird kein neuer File erzeugt.


.*****************************************
:h3 id='name'.NAME  (n)
:p.File umbenennen
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
name <filename> | .
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
ndert den Namen des aktiven Files. Falls statt eines Filenamens ein Punkt
angegeben wird, so wird nur der Directory-Teil des  aktiven Files durch
das aktuelle Arbeitsdirectory ersetzt.
.br
Befindet sich auf der Platte bereits ein File mit diesem neuen Namen
und hat dieser das ReadOnlay-Attribut gesetzt, so wird es auch fr den
File in :hp2.W:ehp2. gesetzt.
:p.
Mit diesem Kommando ist es auch mglichen einen internen File umzubenennen;
als Filename kann aber nicht der eines internen Files angegeben werden.

:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='save'.SAVE:elink.
:esl.



.*****************************************
:h3 id='print'.PRINT  (pr)
:p.Den aktive File drucken.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
print
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Der Text des aktiven Files wird auf dem Standarddrucker ausgegeben.
Hierbei wird nach sptestens 55 Zeilen ein Seitenvorschubzeichen
ausgegeben.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='print mark'.PRINT MARK:elink.
:esl.



.*****************************************
:h3 id='quit'.QUIT  (q)
:p.File aus :hp2.W:ehp2. entfernen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
quit
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Entefernt den aktiven File aus :hp2.W:ehp2. ohne ihn abzuspeichern.
Falls noch ungesicherte nderungen vorhanden sind, so erfolgt eine
Sicherheitsabfrage. Falls nach dem Ausfhren keine Files mehr in :hp2.W:ehp2.
vorhanden sind, wird :hp2.W:ehp2. beendet; der interne File ".unnamed"
wird hierbei nicht mitgezhlt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='exit' .EXIT:elink.
:li.&sqbul. :link reftype=hd refid='file' .FILE:elink.
:esl.



.*****************************************
:h3 id='reedit'.REEDIT
:p.Eine File nachladen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
reedit [optionen] [filename|varname]
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Dies ist nahezu identisch mit dem Kommando
:link reftype=hd refid='edit'.EDIT:elink.
; mit dem Unterschied, das falls ein File dieses Names bereits in :hp2.W:ehp2.
geladen ist, dieser zuerest entfernt wird um ein nachladen von Platte
sicherzustellen.
:note. Dieses Kommando ist mit Vorsicht zu benutzen, da keine
Sicherheitsabfrage erfolgt.


.*****************************************
:h3 id='ring'.RING
:p.Ring Attribut setzen oder lschen
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
ring on|off
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Falls das Attribut Ring fr einen File nicht gesetzt ist, so erscheint
dieser beim durchblttern der aktiven Files mit "edit" nicht. Er kann
aber angezeigt werden, indem edit mit seinem Namen angegeben wird.
:note. Normalerweise sind alle Files im Ring. Die Ausnahme ist ".unnamed"
der das Ring-Attribut  nie gesetzt hat.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='edit'.EDIT:elink.
:li.&sqbul. :link reftype=hd refid='toggle'.TOGGLE:elink.
:esl.



.*****************************************
:h3 id='save'.SAVE
:p.Eine File speichern.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
save [optionen] [filename|varname]
:ehp4.:exmp.
:p.:hp2.Optionen:ehp2.
:parml break=fit.
:pt.-fu
:pd.Speichert im UNIX Moudus ab (LF).
:pt.-fd
:pd.Speichert im DOS Modus ab (CR,LF).
:pt.-fl
:pd.Speichert mit einem 2 Byte Lngenvorspann; dieser
wird "Big-Endian" kodiert.
:pt.-fb
:pd.Speichert binr (nur sinnvoll wenn auch so geladen).
:pt.-f[:hp1.n:ehp1.]
:pd.Speichert mit der festen Satzlnge :hp1.n:ehp1.. Zeilenvorschub etc.
wird nicht ausgewertet. Zu kurze Zeilen werden mit Blanks gefllt.
Default-Wert fr :hp1.n:ehp1. ist 80.
:pt.-F[:hp1.n:ehp1.]
:pd.Wie oben, aber falls eine Zeile zu lang ist, wird nicht abgebrochen.
:pt.-nt
:pd.Es werden keine Tabulatoren eingefgt.
:pt.-nb
:pd.Blanks am Ende einer Zeile werden nicht abgeschnitten.
:pt.-z
:pd.Hngt in jedem Fall ein Ctrl-Z an die Datei an.
:pt.-js<:hp1.n:ehp1.>
:pd.Benutzt fr diesen File den savemode :hp1.n:ehp1..
:eparml.
:p.:hp2.Beschreibung:ehp2.:p.
Eine Datei auf Platte abspeichern aber nicht aus :hp2.W:ehp2. entfernen.
Wird kein Name angegeben, so wird der Name wie er :hp2.W:ehp2. bekannt
ist benutzt andernfalls wird unter dem angegebenen Namen abgespeichert.
Werden keine Formatoptionen angegeben, so werden, die auch beim Laden
des Files, verwendeten Optionen entsprechend benutzt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='set savemode'  .SET SAVEMODE:elink.
:li.&sqbul. :link reftype=hd refid='commit'.COMMIT:elink.
:li.&sqbul. :link reftype=hd refid='file'  .FILE:elink.
:li.&sqbul. :link reftype=hd refid='quit'  .QUIT:elink.
:li.&sqbul. :link reftype=hd refid='edit'  .EDIT:elink.
:esl.



.*****************************************
:h3 id='set appctrlz'.SET APPCTRLZ
:p.Option Ctrl-Z anhngen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set appctrlz on|off
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Wenn diese Option eingeschaltet ist, so wird ein Ctrl-Z beim speichern
an den File angehangen. Obwohl dies ein uraltes Verfahren ist,
(war es CP/M) brauchen einige Programme dies immer noch.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='save'.SAVE:elink.
:li.&sqbul. :link reftype=hd refid='varlist'.VARLIST:elink.
:esl.



.*****************************************
:h3 id='set blankstrip'.SET BLANKSTRIP
:p.Option Blanks am Zeileende entfernen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set blankstrip on|off
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Wenn eingeschaltet, werden Blanks am Ende einer Zeile nicht mit abgespeichert.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='save'.SAVE:elink.
:li.&sqbul. :link reftype=hd refid='varlist'.VARLIST:elink.
:esl.



.*****************************************
.*   COMMAND: "set notabs" "s notabs" "s nt"
.*
.*   Syntax: set notabs <on>|<off>
.*
.*     Sets or resets the NoTabs fileflag of the current file.  if the
.*   NoTabs flag is set, runs of blanks will not be replaced by tab
.*   characters, when the file is saved.  The default state is:  OFF.
:h3 id='set notabs'.SET NOTABS  (s nt)
:p.Option keine Tabulatoren speichern.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set notabs on|off
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt bzw. lscht das NoTabsFlags fr den aktuellen File.
Wenn dieses Flag gesetzt ist, so werden mehrere Blanks nicht durch
das Tabulatorzeichen ersetzt. Diese Umwandlung wird beim Speichern
durchgefhrt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='edit'.EDIT:elink.
:li.&sqbul. :link reftype=hd refid='save'.SAVE:elink.
:esl.



.*****************************************
.*   COMMAND: "set readbinary"
.*
.*   Syntax: set readbinary <on>|<off>
.*
.*      Controls the behaviour of "W", when loading a file. If this
.*   option is off, "W" will stop reading a file at the first Ctrl-Z;
.*   with this option enabled, "W" will read the file complete and
.*   display all Ctrl-Z. Default state is: ON.
:h3 id='set readbinary'.SET READBINARY
:p.Option Verhalten bei Ctrl-Z.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set readbinary on|off
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Bestimmt das Verhalten von :hp2.W:ehp2. beim Laden eines Files.
Ist diese Option eingeschaltet, so wird ein File komplett gelesen
und alle vorhandenen Ctrl-Z mit angezeigt; ist diese Option ausgeschaltet,
so wird :hp2.W:ehp2. das Einlesen eines Files beim ersten Ctrl-Z beenden.
:note. Diese Option sollte immer eingeschaltet sein, damit versehentlich
eingegebene Ctrl-Zs beim nchsten Laden und Speichern nicht zu Datenverlust
fhren.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='varlist'.VARLIST:elink.
:esl.



.*****************************************
.*   COMMAND: "set readonly" "set ro" "s ro"
.*
.*     Sets the ReadOnly flag for the current file.  A file with a set
.*   ReadOnly flag cannot be saved until you reset it.  When a file is
.*   loaded into the editor, this flag is set according to the
.*   readonly attribute of the file on disk.
:h3 id='set readonly'.SET READONLY  (s ro)
:p.Datei auf Read-Only setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set readonly
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Setzt das :link reftype=hd refid='ReadOnlyFlag'.ReadOnlyFlag:elink.
fr den aktuellen File. Ein File mit gesetztem
Flag kann nicht editiert werden.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='set readwrite'.SET READWRITE:elink.
:esl.



.*****************************************
.*   COMMAND: "set readwrite" "set rw" "s rw"
.*
.*     Resets the ReadOnly flag for the current file.  It is not
.*   possible to reset this flag, when a file on disk with that name
.*   has the readonly attribute.
:h3 id='set readwrite'.SET READWRITE  (s rw)
:p.Datei auf Read-Write setzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set readwrite
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Lscht das :link reftype=hd refid='ReadOnlyFlag'.ReadOnlyFlag:elink.
fr den aktuellen File. Falls die Datei auf der Platte ein Read-Only
Attribut gesetzt hat, so wird dieses Kommando nicht zugelassen.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='set readonly'.SET READONLY:elink.
:esl.



.*************************************
:h3 id='set savemode'.SET SAVEMODE
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set savemode <n>
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Bestimmt das Verfahren, wie eine
Datei abgespeichert wird. Diese Angaben sind bitweise
kodiert und knnen entsprechend kombiniert werden&colon.
:parml break=fit compact.
:pt.Bit 0  (Wert=1)
:pd.Datei auf eine temporren Datei schreiben, die Originaldatei
lschen und die temporre Datei umbennen.
:pt.Bit 1  (Wert=2)
:pd.Originaldatei in ein eventuell neu erzeugtes Subdirectory
"BACKUP.W" umbenennen und dann die Datei speichern.
:pt.Bit 2  (Wert=4)
:pd.Zusatz zu Bit 1&colon. Die Originaldatei wird in ein
(eventuell neu erzeugtes) Subdirectory auf dem aktuellen Laufwerk
umbenannt. Dieses Subdirectory hat den den Namen des Originaldirectories
mit einem vorangestellten "/tmp/w.bak". Falls in einem dieser
Directories gespeichert wird, so wird dieses Backup-Verfahren nicht
durchgefhrt.
:eparml.
Falls nichts angegeben ist, so wird die Datei direkt geffnet
und beschrieben, was bei einem Schreibfehler zum Verlust der Datei
fhren knnte.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='SAVE'.SAVE:elink.
:li.&sqbul. :link reftype=hd refid='VARLIST'.VARLIST:elink.
:esl.



.*****************************************
:h3 id='set tabexpand'.SET TABEXPAND
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
set tabexpand on|off
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Wenn Tabexpand eingeschaltet ist, so werden beim Laden einer Datei
die Tabulatoren expandiert, d.h. durch eine entsprechende Anzahl
Blanks ersetzt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='EDIT'.EDIT:elink.
:li.&sqbul. :link reftype=hd refid='VARLIST'.VARLIST:elink.
:esl.


.****** end of file *********
