.* [w6.ipf wk 24.8.92] Documentation for W - Edit
.*      Copyright (c) 1992 by Werner Koch (dd9jn)
.* History:
.*
.*********************************************************************



.*****************************************
.*   COMMAND: "change" "c"
.*
.*   Syntax: change/<old>/<new>/[flags]
.*
.*     Replaces, starting at the cursor, the string old by the string
.*   new; there is no need for the strings to have same length.  The
.*   delimiter "/" can be changed by any other character.  Only one
.*   replacement will take place.  If the string old is found, you
.*   will get the message "Please confirm change !" - if you decide to
.*   do so, you have to issue the command:  "confirm change" ("co").
.*   The optional flags are the same as those of the locate command
.*   (see command:  "") plus the additional flag "*":  if you
.*   specify this, you will not be asked for confirmation, but "W"
.*   will replace all occurences of old by new (may be only inside a
.*   mark if flag "m" is specified).
:h3 id='change'.CHANGE  (c)
:p.Suchen und Ersetzen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
change/<string>/<newString>/[flags]
:ehp4.:exmp.
:p.:hp2.Flags:ehp2.
:parml compact break=fit.
:pt.-
:pd.Rckwrts suchen und ersetzen :note.Kann nicht mit "*" kombiniert werden.
:pt.e
:pd.(exact) Unabhngig von der mit "set searchcase" gesetzten Einstellung
wird bei der Suche Klein-/Groschreibung unterschieden.
:pt.a
:pd.(any) Unabhngig von der mit "set searchcase" gesetzten Einstellung
wird bei der Suche Klein-/Groschreibung nicht unterschieden.
:pt.m
:pd.(mark) Es wird nur innerhalb der Markierung gesucht und ersetzt.
Die Suche beginnt
erst am Markierungsanfang und ended am Markierungsende.
:pt.*
:pd.Es erfolgt keine Abfrage vor dem Ersetzen; sondern es werden alle
gefundenen Stexte ersetzt.
:eparml.
:p.:hp2.Beschreibung:ehp2.:p.
Im aktuellen File nach einem Text suchen. Die Suche beginnt ein Zeichen
nach der aktuellen Position. Der Text ist zwischen 2 beliebigen Trennzeichen
anzugeben; d.h. statt "/" kann z.B. auch "!" oder "a" benutzt werden. Der
Text, der den Gefundenen ersetzen soll, wird nach dem 2. Trennzeichen angegeben;
dieser kann eine beliebige Lnge haben (auch 0).
.br
Hinter dem 3. Trennzeichen knnen die Flags in beliebiger Reihenfolge
angegeben werden.
Das Kommando kann durch "c" abgekrzt werden.
:p. Wird ein Text gefunden, so erscheint in der Infozeile eine Meldung:
:hp4."Please confirm change !:ehp4.. Danach kann durch Anwendung des
Kommandos
:link reftype=hd refid='confirm change'.CONFIRM CHANGE:elink.
die Ersetzung durchgefhrt werden; wird dieses Kommando daraufhin nicht
gegeben, so wird nicht ersetzt.
:p.:hp2.Beispiele:ehp2.
:lines.
         change/alter text/dies war der alte Text/
         c/myFunc/MyFunc/*e
:elines.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='locate'.LOCATE:elink.
:li.&sqbul. :link reftype=hd refid='set searchcase'.SET SEARCHCASE:elink.
:esl.



.*****************************************
.*   COMMAND: "confirm change" "co"
.*
.*     Performs replacement; this command works together with command
.*   "change" and is only valid if a change is pending.
:h3 id='confirm change'.CONFIRM CHANGE  (co)
:p.Textersetzung durchfhren.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
confirm change
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Die durch das Kommando
:link reftype=hd refid='change'.CHANGE:elink. eingeleitete Textersetzung
besttigen. Dieses Kommando wird nur akzeptiert,
wenn zuvor :hp2.CHANGE:ehp2.
einen zu ersetzenden Text gefunden hat; in allen anderen Fllen wird dieses
Kommando mit einer Fehlermeldung zurckgewiesen.



.*****************************************
.*   COMMAND: "COPY FROM COMMAND" "cf"
.*
.*     Inserts a new line into the file and copies the contents of the
.*   commandline to that line.
:h3 id='copy from command'.COPY FROM COMMAND  (cf)
:p.Kommandozeile in Text kopieren.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
copy from command
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Fgt die aktuelle Kommandozeile, als neue Zeile, in den Textbereich ein.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='copy to command'.COPY TO COMMAND:elink.
:esl.

.*****************************************
:h3 id='copy to command'.COPY TO COMMAND  (ct)
:p.Zeile in Kommandozeile kopieren.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
copy to command
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Kopiert die aktuelle Zeile in die Kommandozeile.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='copy from command'.COPY FROM COMMAND:elink.
:esl.



.*****************************************
.*   COMMAND: "cstr"
.*
.*   Syntax: cstr <variable>|<string>
.*
.*     Put the string or the contents of the variable into the file at
.*   the current position.  This command differs from command "put" in
.*   that:  It will be switched to the textarea and you can use the a
.*   standard C-string or a varibale containing a C-string.  All the
.*   C-escape sequences are supported.
:h3 id='cstr'.CSTR
:p.String mit Escape-Sequenzen einfgen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
cstr <variable>|<string>
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Fgt den String bzw. den Inhalt der Variabeln an der aktuellen Position
in den Text ein. Im Unterschied zu :hp2.PUT:ehp2. wird immer nur im Textbereich
und nicht in der Kommandozeile eingefgt.
.br
Das Besondere an diesem Kommando ist, da der String vorher auf
Escape-Sequenzen untersucht wird und diese entsprechend bercksichtigt
werden. Wie aus dem Namen des Kommandos hervorgeht, werden die bekannten
C-Escape Sequenzen benutzt. Alle nach ANSI definierten Sequenzen werden
untersttzt. :note. Mit diesem Kommando ist es auch mglich ein Zeichen
mit dem Wert 0 einzufgen: :hp4.cstr "\0":ehp4..
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='put'.PUT:elink.
:esl.



.*****************************************
.*   COMMAND: "delete char" "dc"
.*
.*   Syntax: delete char [n]
.*
.*     Deletes the character at the cursor and shifts the line back.
.*   If you specify n, this command will be repeated n times.
:h3 id='delete char'.DELETE CHAR  (dc)
:p.Zeichen lschen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
delete char [<n>]
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Lscht das Zeichen unter dem Cursor und schiebt den Rest der Zeile nach links.
Wird n angegeben, so wird dieses Kommando n mal wiederholt.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='rubout'.RUBOUT:elink.
:li.&sqbul. :link reftype=hd refid='delete line'.DELETE LINE:elink.
:esl.



.*****************************************
.*     COMMAND: "delete line" "dl"
.*
.*       Removes the current line from the file. If this line is inside
.*     a mark, the mark will be adjusted appropiate.
:h3 id='delete line'.DELETE LINE  (dl)
:p.Zeile lschen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
delete line
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Entfernt die aktuelle Zeile im Textbereich. Falls diese Zeile innerhalb
einer Markierung liegt, so wird dies entsprechend angepasst.
:note.Da :hp2.W:ehp2. in jedem File min. eine Zeile hat, ist es nicht
mglich diese (einzige) Zeile zu entfernen.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='insert line'.INSERT LINE:elink.
:esl.



.*****************************************
.*     COMMAND: "ERASE BEGIN LINE" "eb"
.*
.*       Removes all characters from the begin of the line up to and
.*     including the current position.  The rest of the line will be
.*     shift back.  The cursor will not change his position.
:h3 id='erase begin line'.ERASE BEGIN LINE  (eb)
:p.Alle Zeichen links vom Cursor lschen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
erase begin line
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Entfernt alle Zeichen vom Anfang der Zeile bis einschlielich
der aktuellen Position und schiebt die Zeile entprechend nach links.
.br
Der Cursor behlt seine ursprngliche Position.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='erase end line'.ERASE END LINE:elink.
:esl.



.*****************************************
.*     COMMAND: "ERASE END LINE" "ee"
.*
.*       Removes all characters from the current position and including
.*     this up to the end of the line.
:h3 id='erase end line'.ERASE END LINE  (ee)
:p.Lschen bis Zeileende.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
erase end line
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Entfernt alle Zeichen ab (einschlielich) der aktuellen Position
bis zum Ende der Zeile.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='erase begin line'.ERASE BEGIN LINE:elink.
:esl.



.*****************************************
.*     COMMAND: "escape" "es"
.*
.*       Permits you to input any character, wich will be used as it is
.*     and not interpreted as a command.  You will be asked to hit a
.*     key.  Also you can use any character, be aware of using Linefeed
.*     or End-Of-File, for that will insert a new line or end the will,
.*     next time this file is loaded into the editor.
:h3 id='escape'.ESCAPE  (es)
:p.Beliebiges Zeichen eingeben.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
escape
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Erlaubt die Eingabe jedes Zeichens, ohne das es in irgendeiner Weise
interpretiert wird. Es erscheint eine Meldung
:hp4."Please type a character !":ehp4. und :hp2.W:ehp2. wartet auf die
Eingabe eines Zeichens.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='cstr'.CSTR:elink.
:esl.



.*****************************************
.*     COMMAND: "insert line" "il"
.*
.*       Inserts a new line into the file behind the current line.  If
.*     the current line is inside a mark, the mark will be extended.  To
.*     insert a line before the first line, use the "split" command.
:h3 id='insert line'.INSERT LINE  (il)
:p.Neue zeile einfgen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
insert line
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Fgt eine neue leere Zeile im Textbereich ein. Diese wird hinter der
aktuellen Zeile eingefgt und falls diese sich innerhalb einer Markierung
befindet, wird die Markierung entsprechend erweitert.
:note.Um eine Zeile vor der ersten Zeile einzufgen, kann z.B. :hp2.SPLIT:ehp2.
benutzt werden.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='delete line'.DELETE LINE:elink.
:li.&sqbul. :link reftype=hd refid='split'.SPLIT:elink.
:esl.



.*****************************************
.*     COMMAND: "join" "jo"
.*
.*       Joins the next line with the current line.
:h3 id='join'.JOIN  (jo)
:p.Zeilen zusammenziehen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
join
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Verbindet die aktuelle Zeile mit der nchsten Zeile und lscht die
nchste Zeile.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='split'.SPLIT:elink.
:esl.



.*****************************************
.*     COMMAND: "put"
.*
.*     Syntax: [put] 'String'
.*
.*       You can ommit the keyword "put".  If you want to put a quote at
.*     the current position, you have to enclose it into doublequotes.
:h3 id='put'.PUT
:p.Text einfgen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
[put] '<string>' | "<string>"
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Einen Text an der aktuellen Position einfgen. Enthlt der Text
einfache Hochkommas, so ist die zweite Version zu whlen.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='cstr'.CSTR:elink.
:esl.



.*****************************************
.*     COMMAND: "rubout" "ro"
.*
.*       Combination of the commands:  "left" and "delete char".
:h3 id='rubout'.RUBOUT  (ro)
:p.Zeichen links vom Cursor lschen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
rubout
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Lscht das Zeichen links vom Cursor und schiebt die Zeile entsprechend auf.
Falls der Cursor sich bereist auf der ersten Position befindet,
so wird das Zeichen unter dem Curso gelscht.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='delete char'.DELETE CHAR:elink.
:esl.



.*****************************************
.*     COMMAND: "split"
.*
.*       Splits the current line at the cursor.  The character under the
.*     cursor and all the trailing characters will be removed from the
.*     line and inserted into a new created line.
:h3 id='split'.SPLIT
:p.Zeile aufspalten.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
split
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Spaltet die aktuelle Zeile an der aktuellen Cursorposition;
das Zeichen unter dem Cursor und alle folgenden Zeichen werden in eine
neu eingefgte Zeile kopiert und an ihrer alten Position gelscht.
:p.:hp2.Siehe auch:ehp2.:sl compact.
:li.&sqbul. :link reftype=hd refid='join'.JOIN:elink.
:esl.



.*****************************************
.*     COMMAND: "undo" "ud"
.*
.*       Undos the last changes within the current line.  If you made
.*     changes to other lines, you cannot undo previous changes at the
.*     current line; but you can retrieve them form the ".unnamed" file.
:h3 id='undo'.UNDO  (ud)
:p.nderung zurcknehmen.
:p.:hp2.Syntax:ehp2.
:xmp.:hp4.
undo
:ehp4.:exmp.
:p.:hp2.Beschreibung:ehp2.:p.
Macht die nderungen in der aktuellen Zeile wieder rckgngig.
Diese Kommando funktioniert nur im Textbereich und auch nur solange
die aktuelle Zeile nicz verlassen wurde.
:note. Durch Eingabe von&colon. :hp4."e .unnamed":ehp4. schaltet :hp2.W:ehp2.
auf einen internen File um, in dem die letzten nderungen protokuliert werden.
Damit ist es dann mglich (wenn auch von Hand), grere nderungen
rckgngig zu machen.


.****** end of file *********
