/* [wcmd.h wk 2.7.91] Defs for Commands
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /vol1/src/master/apps/w/src/wcmd.h,v 1.10 1996/05/17 18:49:30 wernerk Exp $
 */

#ifndef HDR_WCMD
#define HDR_WCMD 1
#ifndef INCL_ALT_KEYCODES
  #define INCL_ALT_KEYCODES 1
#endif
#include <wk/keys.h>
#ifndef HDR_WFILE
  #include "wfile.h"
#endif
#if __cplusplus
extern "C" {
#endif

/****** constants *******/
#define CMD_BACKTAB		       1
#define CMD_BACKTAB_WORD	       2
#define CMD_BEEP		       3
#define CMD_BEGIN_LINE		       4
#define CMD_BEGIN_MARK		       5
#define CMD_BEGIN_WORD		       6
#define CMD_BOTTOM		       7
#define CMD_BOTTOM_EDGE 	       8
#define CMD_CENTER_IN_MARGINS	       9
#define CMD_CENTER_LINE 	      10
#define CMD_CHANGE		      11
#define CMD_CHDIR		      12
#define CMD_CLEAR_MARKS 	      13
#define CMD_CLEAR_MESSAGE	      14
#define CMD_COLUMN		      15
#define CMD_COMMAND_TOGGLE	      16
#define CMD_CONFIRM_CHANGE	      17
#define CMD_COPY_FROM_COMMAND	      18
#define CMD_COPY_MARK		      19
#define CMD_COPY_TO_COMMAND	      20
#define CMD_CURSOR_COMMAND	      21
#define CMD_CURSOR_DATA 	      22
#define CMD_DEFINE		      23
#define CMD_DELETE_CHAR 	      24
#define CMD_DELETE_LINE 	      25
#define CMD_DELETE_MARK 	      26
#define CMD_DEMO_END		      27
#define CMD_DEMO_FAST		      28
#define CMD_DEMO_SLOW		      29
#define CMD_DIR 		      30
#define CMD_DOS 		      31
#define CMD_DOWN		      32
#define CMD_EDIT		      33
#define CMD_END_LINE		      34
#define CMD_END_MARK		      35
#define CMD_END_WORD		      36
#define CMD_ERASE		      37
#define CMD_ERASE_BEGIN_LINE	      38
#define CMD_ERASE_END_LINE	      39
#define CMD_ERROR		      40
#define CMD_ESCAPE		      41
#define CMD_EXECUTE		      42
#define CMD_FILE		      43
#define CMD_FILL_MARK		      44
#define CMD_FIND_BLANK_LINE	      45
#define CMD_FIRST_NONBLANK	      46
#define CMD_INDENT		      47
#define CMD_INSERT_LINE 	      48
#define CMD_INSERT_MODE 	      49
#define CMD_INSERT_TOGGLE	      50
#define CMD_JOIN		      51
#define CMD_KEY 		      52
#define CMD_LEFT		      53
#define CMD_LEFT_EDGE		      54
#define CMD_LEFT_MARGIN 	      55
#define CMD_LINE		      56
#define CMD_LOCATE		      57
#define CMD_LOWERCASE		      58
#define CMD_MACRO		      59
#define CMD_MARK_BLOCK		      60
#define CMD_MARK_CHAR		      61
#define CMD_MARK_LINE		      62
#define CMD_MOVE_MARK		      63
#define CMD_NAME		      64
#define CMD_NEXT_VIEW		      65
#define CMD_NEXT_WINDOW 	      66
#define CMD_NOP 		      67
#define CMD_OVERLAY_BLOCK	      68
#define CMD_PAGE_DOWN		      69
#define CMD_PAGE_UP		      70
#define CMD_PARAGRAPH_MARGIN	      71
#define CMD_POP_MARK		      72
#define CMD_PRINT		      73
#define CMD_PRINT_MARK		      74
#define CMD_PUSH_MARK		      75
#define CMD_PUT 		      76
#define CMD_QUIT		      77
#define CMD_REDRAW		      78
#define CMD_REFLOW		      79
#define CMD_PAUSE		      80
#define CMD_REPLACE_MODE	      81
#define CMD_RIGHT		      82
#define CMD_RIGHT_EDGE		      83
#define CMD_RIGHT_MARGIN	      84
#define CMD_RUBOUT		      85
#define CMD_SAVE		      86
#define CMD_SCROLLDOWN		      87
#define CMD_SCROLLLEFT		      88
#define CMD_SCROLLRIGHT 	      89
#define CMD_SCROLLUP		      90
#define CMD_SET_ABBREV		      91
#define CMD_SET_BACKUP		      92
#define CMD_SET_BLANKSTRIP	      93
#define CMD_SET_DISPLAY 	      94
#define CMD_SET_HSCROLL 	      95
#define CMD_SET_MARGINS 	      96
#define CMD_SET_SEARCHCASE	      97
#define CMD_SET_TABEXPAND	      98
#define CMD_SET_TABS		      99
#define CMD_SHIFT_LEFT		     100
#define CMD_SHIFT_RIGHT 	     101
#define CMD_SPLIT		     102
#define CMD_SPLIT_SCREEN	     103
#define CMD_TAB 		     104
#define CMD_TAB_WORD		     105
#define CMD_TOP 		     106
#define CMD_TOP_EDGE		     107
#define CMD_UNDO		     108
#define CMD_UNMARK		     109
#define CMD_UP			     110
#define CMD_UPPERCASE		     111
#define CMD_ZOOM_WINDOW 	     112
#define CMD_Q_ABBREV		     113
#define CMD_Q_BACKUP		     114
#define CMD_Q_BLANKSTRIP	     115
#define CMD_Q_AUTOLOCK		     116
#define CMD_Q_DIR		     117
#define CMD_Q_DISKSPACE 	     118
#define CMD_Q_HSCROLL		     119
#define CMD_Q_KEY		     120
#define CMD_Q_MARGINS		     121
#define CMD_Q_MEMORY		     122
#define CMD_Q_SEARCHCASE	     123
#define CMD_Q_TABEXPAND 	     124
#define CMD_Q_TABS		     125
#define CMD_SET_NOTABS		     126
#define CMD_Q_HEAP		     127
#define CMD_INTERNALCMDLINEEXEC      128
#define CMD_PUTENV		     129
#define CMD_WHILE		     130
#define CMD_UNTIL		     131
#define CMD_SET_PUREASCII	     132
#define CMD_Q_PUREASCII 	     133
#define CMD_SET_RO		     134
#define CMD_SET_RW		     135
#define CMD_EXECUTECLEAR	     136
#define CMD_GOTO_LABEL		     137
#define CMD_SET_LABEL		     138
#define CMD_EDITLIST		     139
#define CMD_KEYDEFS		     140
#define CMD_POSATMOUSE		     141
#define CMD_AUTOMARK		     142
#define CMD_ENTER		     143
#define CMD_JMP 		     144
#define CMD_CALL		     145
#define CMD_CALC		     146
#define CMD_ASSIGN		     147
#define CMD_VARLIST		     148
#define CMD_RING		     149
#define CMD_CSTR		     150
#define CMD_SET_CRTSAVE 	     151
#define CMD_Q_CRTSAVE		     152
#define CMD_NEXT_NONBLANK	     153
#define CMD_NEXT_BLANK		     154
#define CMD_EXIT		     155
#define CMD_SET_KEYPREFIX	     156
#define CMD_SET_AUTOLOCK	     157
#define CMD_LOCK		     158
#define CMD_UNLOCK		     159
#define CMD_SET_LOCKCHECK	     160
#define CMD_Q_LOCKCHECK 	     161
#define CMD_SET_APPCTRLZ	     162
#define CMD_Q_APPCTRLZ		     163
#define CMD_REEDIT		     164
#define CMD_SET_MEMSWAP 	     165
#define CMD_Q_MEMSWAP		     166
#define CMD_MATCHBLOCK		     167
#define CMD_SET_DLAYOUT 	     168
#define CMD_SET_DCOLORS 	     169
#define CMD_ASCII		     170
#define CMD_HELP		     171
#define CMD_LOAD		     172
#define CMD_PLAY_MARK		     173
#define CMD_TREE		     174
#define CMD_SET_HISTORY 	     175
#define CMD_Q_HISTORY		     176
#define CMD_SET_SUPSCREEN	     177
#define CMD_SET_READBINARY	     178
#define CMD_SET_SAVEMODE	     179
#define CMD_SET_TABMODE 	     180
#define CMD_DETACH		     181
#define CMD_KILL_PROCESS	     182
#define CMD_SHOW_PROCESS	     183
#define CMD_SET_REFRESH 	     184
#define CMD_CUT 		     185
#define CMD_COPY		     186
#define CMD_PASTE		     187
#define CMD_COPY_TO_HISTORY	     188
#define CMD_HISTORY_UP		     189
#define CMD_HISTORY_DOWN	     190
#define CMD_HISTORY		     191
#define CMD_TOGGLE		     192
#define CMD_NEW 		     193
#define CMD_NOERROR		     194
#define CMD_RECORD_START	     195
#define CMD_RECORD_STOP 	     196
#define CMD_RECORD_CANCEL	     197
#define CMD_SORT		     198
#define CMD_COMMIT		     199
#define CMD_BEGIN		     200
#define CMD_END 		     201
#define CMD_SET_INTCLIP 	     202
#define CMD_STRIPBLANKS 	     203
#define CMD_CANCEL_PROCESS	     204
#define CMD_GOTO_LINEID 	     205
#define CMD_SHOW_COPYING	     206
#define CMD_SHOW_WARRANTY	     207
#define CMD_VIEW		     208
#define CMD_SET_LATIN		     209
#define CMD_SET_UNIXSAVE	     210
#define CMD_DEMO_KEYS		     211
#define CMD_REHASH		     212
#define CMD_DEFKEY		     213
#define CMD_LEAP_TO		     214
#define CMD_SWITCH_CONSOLE	     215
#define CMD_SET_EDITCMD 	     216
#define CMD_SET_HILITE		     217

#define CMDFNC_BASE		     512  /* first  defined command */

    /* bases for key modifieres */
#define KEYCOD_MASK   0x07ff
#if KEYCOD_MASK >= K_USER_BASE
   #error K_USER_BASE is too high
#endif
#define KEYMOD_STD    0
#define KEYMOD_SHIFT  0x1000
#define KEYMOD_CTRL   0x2000
#define KEYMOD_ALT    0x4000
#define KEYMOD_USR    0x8000
#define KEYMOD_EXT    0xf000

    /* values must fit into a byte */
#define ARGTYPE_NO     0
#define ARGTYPE_STRING 1
#define ARGTYPE_NUMBER 2
#define ARGTYPE_KEY    4	/* e.g. :  "[key a-f1]" */
#define ARGTYPE_KEYDEF 5	/* e.g. :  "def a-f1=...." */
#define ARGTYPE_CHG    6	/* e.g. :   */
#define ARGTYPE_LOC    7	/* e.g. :   */
#define ARGTYPE_FILE   8	/* e.g. :   */
#define ARGTYPE_ONOFF  9	/* e.g. :   */
#define ARGTYPE_ANYEXA 10	/* e.g. :   */
#define ARGTYPE_ASCII  11	/* use arg.keyId as it is */
#define ARGTYPE_VAR    12	/* e.g. : "%FileDir" */
#define ARGTYPE_VARENV 13	/* e.g. : "%PATH%" */
#define ARGTYPE_OP     14	/* operator, is a number ( OPERATOR_xxx ) */
#define ARGTYPE_FILEORVAR  15	/* internal */
#define ARGTYPE_STRORVAR   16	/* internal */
#define ARGTYPE_FNCDEF	   17	/* internal */

    /* values must fit into a byte */
#define OPERATOR_NOP	0   /* no operation */
#define OPERATOR_LT	1   /* less than */
#define OPERATOR_LE	2   /* less than or equal */
#define OPERATOR_EQ	3   /* equal */
#define OPERATOR_GE	4   /* greater than or equal */
#define OPERATOR_GT	5   /* greater than */
#define OPERATOR_TRUE	6   /* true ( not 0 or string not empty ) */
#define OPERATOR_FALSE	7   /* false = !true */
#define OPERATOR_ADD	8   /* add 2 operands*/
#define OPERATOR_SUB	9   /* subtract 2 operands */
#define OPERATOR_MLT   10   /* multiplicate 2 operands */
#define OPERATOR_DIV   11   /* divide 2 operands */
#define OPERATOR_MOD   12   /* Modulo 2 operands*/
#define OPERATOR_LEN   13   /* length of value on stack */
#define OPERATOR_DUP   14   /* duplicate value on the stack */
#define OPERATOR_EVL   15   /* evaluate the value on the stack, that is */
			    /* if the value is a variable, it will be replaced*/
			    /* by its value */
#define OPERATOR_SAME  16   /* strings are identical */
#define OPERATOR_DIFF  17   /* strings are not identical */
#define OPERATOR_CAT   18   /* concatenate string */
#define OPERATOR_NE    19   /* not equal */
#define OPERATOR_POP   20   /* remove a value from the stack */
#define OPERATOR_CLEAR 21   /* remove all values from the stack */
#define OPERATOR_TPATH 22   /* translate path string */
#define OPERATOR_SWAP  23   /* swap two operands*/
#define OPERATOR_SAMECI  24   /* strings are identical (caseinsensitive)*/
#define OPERATOR_DIFFCI  25   /* strings are not identical (caseinsensitive)*/
#define OPERATOR_VAL   26   /* strings to numeric (integer) (auto hex or dec)*/
#define OPERATOR_VALX  27   /* strings to numeric (integer) (hex) */
#define OPERATOR_VALB  28   /* strings to numeric (integer) (bin) */
#define OPERATOR_HEX   29   /* strings to numeric (integer) */
#define OPERATOR_BIN   30   /* strings to numeric (integer) */
#define OPERATOR_JULIAN 31  /* push current julian date onto stack */
#define OPERATOR_TMOFDAY 32 /* push current time of day onto stack */
#define OPERATOR_GETWORD 33 /* Get Word */
#define OPERATOR_EXIST	 34 /* file is accessable */
#define OPERATOR_INEDITOR 35 /* file is loaded into editor */


#define SETOPT_ABBREV	    1	/* true: use abbreviations */
#define SETOPT_SEARCHCASE   2	/* true: exact match ; false: any match */
#define SETOPT_PUREASCII    3	/* true: use only 7-Bit */
#define SETOPT_TABEXPAND    4	/* true: expand tabs */
#define SETOPT_CRTSAVE	    5	/* 0 = no CRTSave, otherwise: seconds */
#define SETOPT_AUTOLOCK     6	/* true: try to lock every file */
#define SETOPT_LOCKCHECK    7	/* true: locks will be checked at loadtime */
#define SETOPT_BLANKSTRIP   8	/* true: remove blanks at line ends */
#define SETOPT_BACKUP	     9	/* number of lines in .unnamed */
#define SETOPT_APPCTRLZ     10	/* append a ctrlz at the end of the file */
#define SETOPT_MEMSWAP	    11	/* memory swapping on/off */
#define SETOPT_LOADUPD	    12	/* zpdate screen while loading file */
#define SETOPT_HISTORY	    13	/* number of stored commandlines */
				/* 0 = history off */
#define SETOPT_READBINARY   14	/* number of stored commandlines */
#define SETOPT_SAVEMODE     15	/* special saveflags */
#define SETOPT_TABMODE	    16	/* special tabmodes */
#define SETOPT_REFRESH	    17	/* auto refreshmode */
#define SETOPT_INTCLIP	    18	/* internal clipboard */
#define SETOPT_LATIN	    19	/* Latin-1 charset */
#define SETOPT_UNIXSAVE     20	/* always save in UNIX style */
#define SETOPT_EDITCMD	    21	/* off := edit behaves like load */


/******* types ******/
typedef struct t_cmd {
	short	cmd;
	struct t_cmd *nxtCmd;	/* ptr to next Command or NULL */
	byte	type;	    /* ARGTYPE_.... */
	union {
	    ulong number;   /* off/any = false; on/exact = true */
	    int keyId;
	    char string[1]; /* will be extended */
	} arg;
    } cmd_t;


/****** protos ******/
void InitCmdTables(int);
const char *Cmd2String( int cmd, int mode );
int String2Cmd( const char *string );
int AddBinding( int keyId, const char *cmdline );
int ReadCmdFile( const char *filename, int modeflag );
int GetKeyId(int*);
int GetKeyValue(void);
int ParseCmdLine( const char *cmdline, cmd_t **retcmd );
int PrintBindings( int fileHd );
char *GetKeyDefString( int keyId );
int GetLastCmdError(void);
int Cmd_RecordStart( cmd_t *cmd );
int Cmd_RecordStop(void);
int Cmd_RecordCancel(void);
void RehashCommandTable(void);

const char *GetKeyName( int level, int keyid );

#if __cplusplus
}
#endif

#ifndef HDR_CMDPR
  #include "wcmdpr.h"
#endif

#endif /* HDR_WCMD */
