/* [wcmdpr.h wk 1.10.91] Prototypes for Commands
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /usr/src/master/apps/w/src/wcmdpr.h,v 1.9 1996/09/10 12:20:03 wk Exp $
 */

#ifndef HDR_WCMDPR
#define HDR_WCMDPR 1
#ifndef HDR_WCMD
  #include "wcmd.h"
#endif
#if __cplusplus
extern "C" {
#endif

    /*-- wcmd.c */
int SetLeapTarget( const char *s );
int ExecCmd( cmd_t * );
int ExecTempCmd( cmd_t * );
int ExecFunction( cmd_t * );
int ExecKeyCmd( int keyCode, int keyValue );
int ExecOneCmdBlock( cmd_t * );
int Cmd_Keydefs( cmd_t *cmd );
void PrefixNextGetKeyId( char pref );

    /*-- wproc.c --*/
int ProcessCmd( cmd_t * );
int GetSetOption( int opt );
void PutSetOption( int opt, int val );
void Write2CurCmdLine( const char * string );
const char *GetSetOptionString( int opt );
int Cmd_Exit( void );
int Cmd_Quit( void );
int Cmd_Edit( const char *);
int Cmd_View( const char *);
int Cmd_ReEdit( const char *);
int Cmd_Load( const char *);
int Cmd_New( const char *);
int Cmd_Switch2NamedFile( const char *);
int Cmd_Switch2FileHd( int fhd );
int ExecuteCmdLine(void);
int Cmd_ExecuteString( const char *string, int argType );
int Cmd_History(void);
void EnableHistoryUpdate(int onoff);

    /*-- wmark.c --*/
int Cmd_GotoMark( int mode );
int Cmd_ChangeCase( int mode );
int Cmd_StripBlanks( void );
int Cmd_CopyMark(void);
int Cmd_OverlayBlock( cmd_t *cmd );
int Cmd_ShiftMark( int );
int Cmd_DeleteMark(void);
int Cmd_FillMark( cmd_t * cmd, int c );
int Cmd_PlayMark(void);
int Cmd_SetLabel( cmd_t *cmd );
int Cmd_GotoLabel( cmd_t *cmd );

    /*-- wdos.c --*/
int Cmd_Dos( cmd_t *cmd );
int Cmd_Detach( const char *string );
int Cmd_ChDir( cmd_t *cmd );
int Cmd_ShowDir( cmd_t *cmd );
int Cmd_Dir( cmd_t *cmd );
int CheckFileLock( const char *fileName );
int SetFileLock( const char *fileName );
int ResetFileLock( const char *fileName );
const char * GetFileLockOwner( const char *fileName );

int CheckDetachedProcs(void);
int GetDetachedProcInfo( int seq, char *buffer, ushort bufferSize,
				int *pid, ushort *tc, ushort *rc );
int Cmd_KillProcess( int pid );
int Cmd_CancelProcess( int pid );
int Cmd_ShowProcess( int pid );

    /*-- wvar.c --*/
int CalcStackPopULong( ulong * val );
char *VarValue( cmd_t *cmd );
char *VarValueStr( const char *str, int argType );
void FreeVarValue( char *p );
int Cmd_Enter( cmd_t *cmd );
int Cmd_Assign( cmd_t *cmd );
int Cmd_Call( cmd_t *cmd );
int Cmd_Jmp( cmd_t *cmd );
int Cmd_While( cmd_t *cmd );
int Cmd_Until( cmd_t *cmd );
int Cmd_Calc( cmd_t *cmd );
int Cmd_VarList( cmd_t *cmd );

    /*-- wsrch.c --*/
int Cmd_Locate( cmd_t *cmd );
int Cmd_Change( const char *, int );
int GetLastFoundState(void);

    /*-- wio.c --*/
int Cmd_Save( cmd_t *cmd );
int Cmd_Print( cmd_t *cmd, int mode );
int Cmd_EditList( cmd_t *cmd );
int Cmd_Erase( cmd_t *cmd );

    /*-- wedit1.c --*/
int Cmd_DeleteLine(void);
int Cmd_DeleteChar(void);
int Cmd_EraseEndLine(void);
int Cmd_EraseBeginLine(void);

    /*-- wedit2.c --*/
int Cmd_Put( const char *string );
int Cmd_CStr( cmd_t *cmd );
int Cmd_InsertLine( const char *, ushort );
int PutTTYString( const char *p, ushort len );

    /*-- wedit3.c --*/
int Cmd_Split(void);
int Cmd_Join(void);

    /*-- wedit4.c --*/
int Cmd_SetTabs( cmd_t *cmd );
void Cmd_QueryTabs(void);
int Cmd_SetMargins( cmd_t *cmd );
void Cmd_QueryMargins(void);

    /*-- wedit5.c --*/
int Cmd_CenterInMargins(void);
int Cmd_Reflow(void);
int Cmd_GotoMargin( int mode );
int Cmd_GotoWord( int mode );
int Cmd_GotoWord1( int mode, const char *str );
int Cmd_GotoWord2( int mode, cmd_t *cmd );
int Cmd_FindBlankLine(void);
int Cmd_FirstNonBlank(void);
int Cmd_NextNonBlank(void);
int Cmd_NextBlank(void);

    /*-- wedit6.c --*/
int Cmd_MatchBlock(void);
int Cmd_Ascii(void);
int Cmd_Help( const char *key );

    /*-- wedit7.c --*/
int Cmd_Tree(void);
int ShowGNUInfo(int);

    /*-- wedit8.c --*/
int Cmd_Copy(void);
int Cmd_Cut(void);
int Cmd_Paste(void);

#if __cplusplus
}
#endif
#endif /* HDR_WCMDPR */
