/* [wdos.c wk 6.9.91] W-Editor DOS-Operations
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Histroy:
 * 11.11.92 wk	Neu Funktion GetFileLockOwner()
 * 20.12.92 wk	noprompt option '@' for Cmd_Dos
 * 04.04.93 wk	Anzahl von detached Procs von 5 auf 8 erweitert
 * 07.04.93 wk	detached Info um cwd at time of detach erweitert
 * 15.05.93 wk	changed macro to load logfile
 * 05.07.94 wk	changed printing of file-time: On OS/2 the year of
 *		the "." and ".." directories are greater than 100,
 *		btw: this fix is also good for the next centuary.
 * 14.11.94 wk	replaced localtime() by gmtime()
 */

#include "wtailor.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#if UNIX
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <signal.h>
#endif
#if __ZTC__
#include <direct.h>
#endif
#include <wk/io.h>
#include <wk/lib.h>
#include <wk/file.h>
#include <wk/string.h>
#include <wk/direc.h>
#include <time.h>
#if MSDOS && __ZTC__
#include <swap.h>
#endif
#if OS2
    #define INCL_DOSFILEMGR 1
    #define INCL_DOSPROCESS 1
    #define INCL_DOSSIGNALS 1
    #define INCL_DOSEXCEPTIONS 1  /* OS20*/
    #include <os2def.h>
    #include <bsedos.h>
#endif

#include "w.h"
#include "wcmd.h"
#include "wscreen.h"
#include "wfile.h"
#ifdef __linux__
  #include "wkbddrv.h" /* VTLinux... prototypes */
  #include "jnx.h"
#endif

/****** constants *********/
#define MAX_PROCESS 8  /* max. # of detachable processes */
/******* typedefs ********/
#if OS2 || UNIX
typedef struct {
	enum { sUNUSED, sSTARTING, sRUNNING, sCOMPLETE } state;
	char *fileName;     /* name of temp. output file */
	char *cmdline;	    /* (malloced) */
	int  pid;	    /* pid of process */
	ushort tc;	    /* termination code */
	ushort rc;	    /* result code */
	int    autoCmd;
	char  *dirInfo;     /* malloced Directory String */
    } processInfo_t;
#endif
/******* globals **********/
#if W_FULL
static char actDirPattern[F_MAX_PATH];	/* stores last Dir pattern */
#if OS2 || UNIX
static processInfo_t processTbl[MAX_PROCESS];
static int lastProcessId;   /* Id of last completed process */
static int cleanupInstalled;
#endif
#endif


/******* prototypes *******/
static int PrintDirectory( int fHd , const char *string, int *dirFlag );
static char *MakeLockFileName( const char *srcName );
static void CleanUp(void*);
/******* functions ********/


int Cmd_Dir( cmd_t *cmd )
{
  #if W_FULL
    int err=0, fhd, dirFlag;

    if( !(err=Cmd_Edit(".dir")) ) {
	fhd = QryScreenFile();
	ResetFileFlag( fhd, WFILE_RO );
	DeleteAllLines( fhd );
	dirFlag = 0;
	err = PrintDirectory( fhd, cmd->arg.string, &dirFlag );
	if( !err && dirFlag ) {
	    DeleteAllLines( fhd );
	    dirFlag = 1;
	    err = PrintDirectory( fhd, cmd->arg.string, &dirFlag );
	}
	SeekLine( fhd, 0 );
	if( GetFileTotLines( fhd ) > 1 )
	    DeleteLine( fhd );
	Move2Pos( fhd, 0, 29 );
      #ifdef UNIX
	SortLines( fhd, "-dn" );
      #endif
	ResetFileFlag( fhd, WFILE_CHG );
	SetFileFlag( fhd, WFILE_RO );
	if( !err )
	    ResetFileFlag( fhd, WFILE_INCMD);
    }
    return err;
  #else
    return ERR_USPCMD;
  #endif
}


/****************
 * in den File mit dem Handle fHd das im string angegebene Directory ausgeben
 * dirFlag hat folgende Bewandniss: wenn es beim Aufruf auf 0 steht, so
 * geschieht nicht, ist es beim Aufruf aber auf 1 gesetzt, so wird an String
 * ein / und *.* angehangen, gleich zeitig gibt es folgende Werte zurck:
 * falls nur ein File gefunden wurde, und dieser war ein Directory, so
 * wird es auf 1 gesetzt, andernfdalls auf 0
 */
#if W_FULL
static int
PrintDirectory( int fHd , const char *string, int *dirFlag )
{
    int err, handle, isDir=0, ex, fsType, ddot;
    unsigned attr;
    char *pathBuffer, *lineBuffer;
    struct stat statBuf;
    size_t n;
    const char*p;
    struct tm *tm;
    long count;
    char convertBuf[F_MAX_FNAME+F_MAX_EXT];
  #ifndef UNIX
    enum { pass_DIR, pass_FILES, pass_END } passFlag;
  #endif

    err = 0;
    pathBuffer = xmalloc( F_MAX_PATH );
    lineBuffer = xmalloc( MAX_LINELEN+1);
    xassert( (8+1+8+1+8+1+3+1+F_MAX_PATH ) < MAX_LINELEN );

    ddot = 0;
    if( *string ) {
	mem2str( pathBuffer, string, F_MAX_PATH-4 );
	if( *dirFlag ) {
	  #if MSDOSFILESYSTEM
	    strcat( pathBuffer, "/*.*" );
	  #else
	    strcat( pathBuffer, "/*" );
	  #endif
	}
	else
	    ddot++;
    }
    else {
      #if MSDOSFILESYSTEM
	strcpy( pathBuffer, "*.*" );
      #else
	strcpy( pathBuffer, "*" );
      #endif
    }
    FilenameMkAbs( NULL, pathBuffer );
    n = strlen( pathBuffer );
    if( pathBuffer[n-1] == '/' && !*dirFlag ) {
      #if MSDOSFILESYSTEM
	strcat( pathBuffer, "*.*" );
      #else
	strcat( pathBuffer, "*" );
      #endif
	ddot = 0;
    }

    strcpy( actDirPattern, pathBuffer );
    count = 0;
  #if UNIX
    if( !err )
  #else
    for( passFlag = pass_DIR; !err && passFlag != pass_END; passFlag++ )
  #endif
    {
	strcpy( pathBuffer, actDirPattern );
      #if UNIX
	attr = 1|2|(1<<8); /* directory, special files and use lstat() */
      #else
	attr = 2; /* scan also hidden files */
	if( passFlag == pass_DIR )
	    attr |= 1;	/* include directories in scan */
      #endif
	ex = FindFile( 0, pathBuffer, F_MAX_PATH, &attr, &handle );
	fsType = ex? 0 : FileQryFS( pathBuffer );
      #if UNIX
	ddot = 1;
      #else
	if( ddot && passFlag == pass_DIR )
      #endif
	    err = InsertLine( fHd, "01.01.70 00:00:00    <DIR>    ..", 32);
	while( !err && !ex ) {
	    p = FindFileStat( &handle, &statBuf );
	    if( ddot && *p=='.' && p[1]=='.' && !p[2] )
		;
	    else if( !(*p == '.' && !p[1]) ) {
	      #if !UNIX
		if( ((attr & 1) && passFlag == pass_DIR) ||
		    (!(attr & 1) && passFlag == pass_FILES) ) {
	      #endif
		    count++;
		    tm = gmtime( &statBuf.st_mtime );
		    n = sprintf( lineBuffer,
			     "%2d.%02d.%02d %2d:%02d:%02d ",
			     tm->tm_mday, tm->tm_mon+1, tm->tm_year%100,
			     tm->tm_hour, tm->tm_min, tm->tm_sec   );
		    if( fsType == F_FS_FAT )
			mem2str( convertBuf, p, DIM(convertBuf) );
		    if( attr & 1) {
			strcpy( lineBuffer+n, "   <DIR>" );
			n += 8;
			isDir = 1;
			if( fsType == F_FS_FAT )
			    strupr( convertBuf );
		    }
		    else  {
			isDir = 0;
			n += sprintf( lineBuffer+n, "%8ld", statBuf.st_size );
			if( fsType == F_FS_FAT )
			    strlwr( convertBuf );
		    }
		    sprintf( lineBuffer+n , " %c%c %s",
			  #if UNIX
			     attr & 2 ? 'S' : attr & 4? 'L' : ' ',
			  #else
			    attr & 2 ? 'H' : ' ',
			  #endif
			     attr & 16? 'R' : ' ',
			     fsType == F_FS_FAT ? convertBuf : p );
		    err = InsertLine( fHd, lineBuffer, strlen(lineBuffer));
	      #if !UNIX
		}
	      #endif
	    }
	    if( !err ) {
		ex = FindFile( 1, pathBuffer, F_MAX_PATH, &attr, &handle );
	    }
	}
    }
    free( lineBuffer );
    free( pathBuffer );
    *dirFlag = ( count == 1 && isDir && *string );
    return err;
}
#endif

const char *GetDirPattern()
{
  #if W_FULL
    return actDirPattern;
  #else
    return "";
  #endif
}



/****************
 * EIn DOS Command ausfuehren oder die Shell aufrufen
 */

int Cmd_Dos( cmd_t *cmd )
{
  #if W_FULL
    int err, noprompt;
    char *p;
  #if MSDOS && __ZTC__
    int swapOpt;
  #endif

    err = 0;
   #if OS2
    if( !strcmp( cmd->arg.string, "ShutDown!" ) ) {
	int i;

	ShowMessage("Shutdown this machine - ARE YOU SURE ? "
						"Type Y to shutdown");
	for(;;) {
	    while( !(i=GetKeyValue()) )
		;
	    if( i== 'Y' || i == 'y' ) {
		ShowMessage("Shutdown in progress ...");
		p = xmalloc(1000);  /* allocate some memory */
		free(p);	    /* and release ist */
		if( !DosShutdown( 0 ) ) {
		    DosBeep( 440, 2000 );
		    ShowMessage("- It is now save to switch the power off ! -");
		    for(;;) /* endless loop */
			;
		}
		break;
	    }
	    else
		break;
	}
	ShowMessage(NULL);
	return 0;
    }
  #endif
    RemoveScreen();
  #if MSDOS && __ZTC__
    swapOpt = GetSetOption( SETOPT_MEMSWAP );
    if( !swapOpt )
	swap_off();   /* default is swap on */
  #endif
  #if USE_VT_LINUX
    if( !JnxAvailable() )
	VTLinuxClose();
  #endif
    p = cmd->arg.string;
    if( noprompt = *p == '@' && strlen(p) > 1 )
	p++;
    system( *p ? p :
	#if MSDOS || DOS386 || DOS16RM
	    getenv("COMSPEC")
		#elif OS2
		    getenv("COMSPEC")
		#elif UNIX
		    getenv("SHELL")
		#else
		    ""
		#endif
	  ) ;
  #if MSDOS && __ZTC__
    if( !swapOpt )
	swap_on();   /* return to default setting */
  #endif
  #if USE_VT_LINUX
    if( !JnxAvailable() )
	if( VTLinuxOpen() )
	    Error(4,"Sorry, can't reopen the keyboard");
  #endif
    if( !noprompt && *p ) {
	fputs("\nPress the Spacebar to continue\n", stderr );
	fflush(stderr);
	while( GetKeyValue() != ' ' )
	    ;
    }
    EndRemoveScreen();
    RedrawScreen();
    return err;
  #else
    return ERR_USPCMD;
  #endif
}



/****************
 * EIn OS/2 Command im Hintergrund ausfuehren
 */

#if W_FULL
#ifdef UNIX
int Cmd_Detach( const char *string )
{
    int err = 0, i, rpt, use_shell=0;
    processInfo_t *procInfo;
    int   saveStdoutFlag, saveStderrFlag, saveStdinFlag;
    FILE *st, *st2;
    char *p;

    if( !cleanupInstalled ) {
	AddCleanUp( CleanUp, NULL );
	cleanupInstalled++;
    }

    st = st2 = NULL;
    saveStdinFlag = saveStdoutFlag = saveStderrFlag = 0;
    rpt = 0;
    do {
	for(i=0, procInfo = NULL; i < MAX_PROCESS; i++ )
	    if( processTbl[i].state == sUNUSED ) {
		procInfo = processTbl + i;
		procInfo->state = sSTARTING;
		break;
	    }
	if( !procInfo && !rpt ) {
	    for(i=lastProcessId+1; i >= 0 && i < MAX_PROCESS; i++ )
		if( processTbl[i].state == sCOMPLETE ) {
		    Cmd_KillProcess( i+1 );
		    break;
		}
	    if( !(i < MAX_PROCESS) )
		for(i=0; i < MAX_PROCESS; i++ )
		    if( processTbl[i].state == sCOMPLETE ) {
			Cmd_KillProcess( i+1 );
			break;
		    }
	    rpt++; /* and once more */
	}
	else if( !procInfo ) {
	    err = ERR_SYSLIMIT;
	    goto retLabel;
	}
	else
	    rpt = 0;
    } while( rpt );

    if( !(procInfo->fileName = CreateTmpFile( "$W1_" )) ) {
	err = ERR_DETACH;
	goto retLabel;
    }

    if( !(st=fopen(procInfo->fileName, "w")) ) {
	err = ERR_DETACH;
	goto retLabel;
    }
    fprintf( st, "Invoked by: %s\n", string );
    fflush(st);
    if( !(st2=fopen("/dev/null", "r")) ) {
	err = ERR_DETACH;
	goto retLabel;
    }

    if( *string == ';' ) {  /* do not use autoexec commands */
	procInfo->autoCmd = 0;
	string++;
    }
    else
	procInfo->autoCmd = 1;
    if( *string == '+' ) {  /* force shell usage */
	string++;
	use_shell++;
    }

    procInfo->dirInfo = xmalloc( F_MAX_PATH );
    getcwd( procInfo->dirInfo, F_MAX_PATH-1 );
    procInfo->cmdline = xstrdup(string);
    if( (i = fork()) == -1 ) {	/* error */
	err = ERR_DETACH;
	goto retLabel;
    }
    else if( !i ) {  /* the child */
	char **argv;

	if( dup2( fileno(st2), STDIN_FILENO ) == -1 )
	    goto dup_failed;
	if( dup2( fileno(st), STDOUT_FILENO ) == -1 )
	    goto dup_failed;
	if( dup2( fileno(st), STDERR_FILENO ) == -1 )
	    goto dup_failed;
	fclose(st); st = NULL;
	fclose(st2); st2 = NULL;
	if( procInfo->autoCmd && (p=strchr( procInfo->cmdline, ';')) )
	    *p = 0; /* remove autoexec commands */
	if( !use_shell && !strpbrk( procInfo->cmdline, "*?[]~" ) ) {
	    /* we do not need the shell for globbing */
	    if( p = strpbrk( procInfo->cmdline, " \t\n" ) )
		p = mem2str(NULL,procInfo->cmdline, p - procInfo->cmdline +1);
	    else
		p = procInfo->cmdline;
	    argv = StringToArray(xstrdup(procInfo->cmdline),0);
	  #ifdef DEBUG
	    if( !argv ) {
		Fatal("out of core while building argv");
		_exit(EXIT_FAILURE);
	    }
	    Info("execvp(%s)", p );
	    fflush(stderr);
	    for(i=0; argv[i]; i++ )
		fprintf(stderr,"arg %d = (%s)\n", i, argv[i] );
	    fflush(stderr);
	  #endif
	    if( execvp(p, argv ) && errno != ENOEXEC ) {
		Fatal("execvp() failed");
		_exit(EXIT_FAILURE);
	    }
	  #ifdef DEBUG
	    Info("now trying with \"/bin/sh -c\"");
	  #endif
	    /* let'ts try with the shell */
	}

	execlp("/bin/sh", "/bin/sh", "-c", procInfo->cmdline, NULL);
	Fatal("execlp(\"/bin/sh\") failed");
	_exit(EXIT_FAILURE);
      dup_failed:
	Fatal("dup2() failed");
	_exit(EXIT_FAILURE);
    }
    else { /* the parent */
	procInfo->pid = i;
    }
    procInfo->state = sRUNNING;
    ShowMessageAsInfo("Job %d detached (pid %d)",
				   (procInfo - processTbl)+1, procInfo->pid);


  retLabel:
    if( st )
	fclose(st);
    if( st2 )
	fclose(st2);

    if( err &&	procInfo ) {
	if(procInfo->fileName ) {
	    remove(procInfo->fileName);
	    free(procInfo->fileName);
	}
	FREE(procInfo->cmdline);
	FREE(procInfo->dirInfo);
	procInfo->state = sUNUSED;
    }

    return err;
}
#else /* not unix */
int Cmd_Detach( const char *string )
{
  #if OS2
    int err = 0, i, rpt, use_shell=0;
    processInfo_t *procInfo;
    HFILE saveStdout, saveStderr, saveStdin;
    HFILE newStdout, newStderr, newStdin;
    RESULTCODES resCodes;
    char failBuffer[100];
    int   saveStdoutFlag, saveStderrFlag, saveStdinFlag;
    FILE *st, *st2;
    char *pgmString, *p;
    int saveChar;
    const char *pc;

    if( !cleanupInstalled ) {
	AddCleanUp( CleanUp, NULL );
	cleanupInstalled++;
    }

    pgmString = NULL;
    st = st2 = NULL;
    saveStdinFlag = saveStdoutFlag = saveStderrFlag = 0;
    rpt = 0;
    do {
	for(i=0, procInfo = NULL; i < MAX_PROCESS; i++ )
	    if( processTbl[i].state == sUNUSED ) {
		procInfo = processTbl + i;
		procInfo->state = sSTARTING;
		break;
	    }
	if( !procInfo && !rpt ) {
	    for(i=lastProcessId+1; i >= 0 && i < MAX_PROCESS; i++ )
		if( processTbl[i].state == sCOMPLETE ) {
		    Cmd_KillProcess( i+1 );
		    break;
		}
	    if( !(i < MAX_PROCESS) )
		for(i=0; i < MAX_PROCESS; i++ )
		    if( processTbl[i].state == sCOMPLETE ) {
			Cmd_KillProcess( i+1 );
			break;
		    }
	    rpt++; /* and once more */
	}
	else if( !procInfo ) {
	    err = ERR_SYSLIMIT;
	    goto retLabel;
	}
	else
	    rpt = 0;
    } while( rpt );

    if( !(procInfo->fileName = CreateTmpFile( "$W1_" )) ) {
	err = ERR_DETACH;
	goto retLabel;
    }

    if( !(st=fopen(procInfo->fileName, "w")) ) {
	err = ERR_DETACH;
	goto retLabel;
    }
    fprintf( st, "Invoked by: %s\n", string );
    fflush(st);
    if( !(st2=fopen( "nul" , "r")) ) {
	err = ERR_DETACH;
	goto retLabel;
    }

    saveStdin  = 0xffff;    /* create new Handle */
    if( DosDupHandle( 0, &saveStdin ) ) {
	err = ERR_DETACH;
	goto retLabel;
    }
    saveStdinFlag = 1;
    saveStdout = 0xffff;    /* create new Handle */
    if( DosDupHandle( 1, &saveStdout ) ) {
	err = ERR_DETACH;
	goto retLabel;
    }
    saveStdoutFlag = 1;
    saveStderr = 0xffff;
    if( DosDupHandle( 2, &saveStderr ) ) {
	err = ERR_DETACH;
	goto retLabel;
    }
    saveStderrFlag = 1;


    newStdin = 0;
    if( DosDupHandle( fileno(st2), &newStdin ) ) {
	err = ERR_DETACH;
	goto retLabel;
    }
    newStdout = 1;
    if( DosDupHandle( fileno(st), &newStdout ) ) {
	err = ERR_DETACH;
	goto retLabel;
    }
    newStderr = 2;
    if( DosDupHandle( fileno(st), &newStderr ) ) {
	err = ERR_DETACH;
	goto retLabel;
    }

    if( *string == ';' ) {  /* do not use autoexec commands */
	procInfo->autoCmd = 0;
	string++;
    }
    else
	procInfo->autoCmd = 1;
    if( *string == '+' ) {  /* force shell usage */
	string++;
	use_shell++;
    }

    if( pc = strpbrk( string, " \t\n" ) )
	i = pc - string;
    else
	i = strlen( string );
    if( i > 4 ) /* testen, ob extension exe vorhanden ist */
	if( !memicmp( string + i - 4, ".EXE", 4 ) )
	    pgmString = mem2str( NULL, string, i+1 );
    if( !pgmString ) {/* extension anhaengen */
	pgmString = xmalloc( i+4+1 );
	mem2str(pgmString, string, i+1);
	strcat(pgmString,".exe");
    }
    strlwr(pgmString);
    procInfo->dirInfo = xmalloc( F_MAX_PATH );
    getcwd( procInfo->dirInfo, F_MAX_PATH-1 );
    procInfo->cmdline = xmalloc( strlen( pgmString )+1 + strlen(string)+1+1 );
    stpcpy( stpcpy( stpcpy( procInfo->cmdline, pgmString)+1,
		     string[i] == ' '? (string+i+1):(string+i) )+1, "");
    if( !procInfo->autoCmd )
	p = NULL;

    else if( p = strchr( procInfo->cmdline+strlen(pgmString)+1, ';' ) ) {
	saveChar = p[1];
	*p = 0;
	p[1] = 0;
    }
    if( DosExecPgm( failBuffer, DIM(failBuffer),
		    EXEC_ASYNCRESULT,
		    (PSZ)procInfo->cmdline,
		    NULL, /* inherit environment */
		    &resCodes,
		    (PSZ)pgmString ) )
    {
	if( p ) {
	    *p = ';';
	    p[1] = saveChar;
	}
	err = ERR_DETACH;
	goto retLabel;
    }
    procInfo->pid = resCodes.codeTerminate;
    if( p ) {
	*p = ';';
	p[1] = saveChar;
    }
    procInfo->cmdline[strlen(procInfo->cmdline)] = ' '; /* make args visible*/
    procInfo->state = sRUNNING;
    ShowMessageAsInfo("Job %d detached (pid %d)",
				   (procInfo - processTbl)+1, procInfo->pid);


  retLabel:
    free( pgmString );
    if( st )
	fclose(st);
    if( st2 )
	fclose(st2);
    if( saveStdinFlag ) {
	if( dup2( saveStdin, 0 ) == -1 )
	    Fatal("Error reassigning STDIN");
	close( saveStdin  );
    }
    if( saveStdoutFlag ) {
	if( dup2( saveStdout, 1 ) == -1 )
	    Fatal("Error reassigning STDOUT");
	close( saveStdout );
    }
    if( saveStderrFlag ) {
	if( dup2( saveStderr, 2 ) == -1 )
	    Fatal("Error reassigning STDERR");
	close( saveStderr );
    }

    if( err &&	procInfo ) {
	if(procInfo->fileName ) {
	    remove(procInfo->fileName);
	    free(procInfo->fileName);
	}
	FREE(procInfo->cmdline);
	FREE(procInfo->dirInfo);
	procInfo->state = sUNUSED;
    }

    return err;
  #else /* Not OS/2 */
    return ERR_USPCMD;
  #endif
}
#endif
#endif

/****************
 *  KillProcess (ProcessTree durchfuehren, aber sicherstellen,
 * das die ID auch von uns detached wurde; falls bereits completed,
 * wird der slot freigemacht, 0 = Alle completed process freimachen.
 */
#if W_FULL
int Cmd_KillProcess( int id )
{
  #if OS2 || UNIX
    int i, err=0;

    if( !id ) {
	for(i=0; i < MAX_PROCESS; i++ )
	    if( processTbl[i].state == sCOMPLETE ) {
		if( processTbl[i].fileName ) {
		    remove( processTbl[i].fileName );
		    FREE( processTbl[i].fileName );
		}
		FREE( processTbl[i].cmdline );
		FREE( processTbl[i].dirInfo );
		processTbl[i].state = sUNUSED;
	    }
    }
    else {
	err = ERR_INVPID;
	i = id-1;
	if( i >= 0 && i < MAX_PROCESS ) {
	    if( processTbl[i].state == sRUNNING  ||
		processTbl[i].state == sCOMPLETE    ) {
		err = 0;
		if( processTbl[i].state == sRUNNING )
		  #if UNIX
		    if( kill(processTbl[i].pid, SIGTERM) )
		  #else
		    if( DosKillProcess(DKP_PROCESSTREE, processTbl[i].pid ) )
		  #endif
			err = ERR_KILLP;
		if( processTbl[i].fileName ) {
		    remove( processTbl[i].fileName );
		    FREE( processTbl[i].fileName );
		}
		FREE( processTbl[i].cmdline );
		FREE( processTbl[i].dirInfo  );
		processTbl[i].state = sUNUSED;
	    }
	}
    }
    return err;
  #else /* Not OS/2 */
    return ERR_USPCMD;
  #endif
}


/****************
 *  Ctrl-C an process senden; aber sicherstellen,
 * das die ID auch von uns detached wurde; falls bereits completed,
 * wird der slot freigemacht, 0 = letzen process abbrechen
 */

int Cmd_CancelProcess( int id )
{
  #if OS2 || UNIX
    int err=0;

    if( !id )
	id = lastProcessId;
    else
	id--;

    if( id >= 0 && id < MAX_PROCESS ) {
	if( processTbl[id].state == sRUNNING ) {
	  #if UNIX
	    if( kill(processTbl[id].pid, SIGINT) )
	  #elif OS20
	    if( DosSendSignalException(processTbl[id].pid, XCPT_SIGNAL_INTR))
	  #else
	    if( DosSendSignal(processTbl[id].pid, SIG_CTRLC))
	  #endif
		err = ERR_SNDSIG;
	}
	else if( processTbl[id].state != sCOMPLETE )
	    err = ERR_INVPID;
    }
    else
	err = ERR_INVPID;
    return err;
  #else /* Not OS/2 */
    return ERR_USPCMD;
  #endif
}



/****************
 * Eine Process anzeigen completed
 * Besonderheit: id = 0; Zeige letzten beendeten process
 */

int Cmd_ShowProcess( int id )
{
  #if OS2 || UNIX
    int err;
    char *buffer;

    err = ERR_INVPID;
    if( !id )
	id = lastProcessId;
    else
	id--;
    if( id >= 0 && id < MAX_PROCESS )
	if( processTbl[id].state == sCOMPLETE && processTbl[id].fileName  ) {
	    buffer = xmalloc( 50 + strlen( processTbl[id].fileName ) + 1 );
	    sprintf(buffer, "load \"%s\";s ro;ring off",
			    processTbl[id].fileName );
	    err = Cmd_ExecuteString( buffer, ARGTYPE_STRING );
	    free(buffer );
	}
    return err;
  #else /* Not OS/2 and not UNIX */
    return ERR_USPCMD;
  #endif
}

#endif


/****************
 * Test Function called in an Idle loop, to check for completed
 * processes
 * Returns: 0 = nothing
 *	    1 = Process complete
 *	    2 = Process complete and commands executed
 */

#if UNIX
int
CheckDetachedProcs(void)
{
    const char *fmtText;
    int i, err;
    char *p;
    int pid, status;

    if( !(pid=waitpid(-1, &status, WNOHANG)) )
	return 0; /* no terminated child */
    else if( pid == -1 )
	return 0; /* ECHILD */

    for(i=0; i < MAX_PROCESS; i++ )
	if( processTbl[i].state == sRUNNING
	    && processTbl[i].pid == pid ) {
		lastProcessId = i;
		processTbl[i].state = sCOMPLETE;
		if( WIFEXITED(status) ) {
		    processTbl[i].tc = 0;
		    processTbl[i].rc = WEXITSTATUS(status);
		    fmtText = "Job %d ended; CC=%u-%u";
		}
		else if( WIFSIGNALED(status) ) {
		    processTbl[i].tc = 1;
		    processTbl[i].rc = WTERMSIG(status);
		    fmtText = "Job %d signaled; CC=%u-%u";
		}
		else { /* oops */
		    processTbl[i].tc = 255;
		    processTbl[i].rc = status;
		    fmtText = "Job %d ended weird; CC=%u-%u";
		}
		ShowMessageAsInfo(fmtText, i+1,
				processTbl[i].tc, processTbl[i].rc  );
		if( processTbl[i].autoCmd &&
		    (p = strchr( processTbl[i].cmdline, ';')) ) {
		    /* autoexecute commands */
		    if( err = Cmd_ExecuteString( p+1, ARGTYPE_STRING ) )
			ShowMessage( "Can't execute autocommands: %s",
						     GetErrorString(err) );
		    else
			ShowMessageAsInfo(fmtText, i+1,
				processTbl[i].tc, processTbl[i].rc);
		    return 2; /* force Screen update */
		}
		else
		    return 1; /* check only one process at a time */
	    }

    return 0; /* not my child */
}
#elif OS2
int
CheckDetachedProcs(void)
{
    static const char fmtText[] = "Job %d ended; CC=%u-%u";
    int i, err;
    char *p;
    RESULTCODES resCodes;
    PID pid;

    for(i=0; i < MAX_PROCESS; i++ )
	if( processTbl[i].state == sRUNNING )
	    if( !DosCwait( DCWA_PROCESSTREE, DCWW_NOWAIT,
			   &resCodes, &pid, (PID)processTbl[i].pid ) ) {
		lastProcessId = i;
		processTbl[i].state = sCOMPLETE;
		processTbl[i].tc = resCodes.codeTerminate;
		processTbl[i].rc = resCodes.codeResult;
		ShowMessageAsInfo(fmtText, i+1,
				resCodes.codeTerminate, resCodes.codeResult  );
		if( processTbl[i].autoCmd &&
		    (p = strchr( processTbl[i].cmdline, ';')) ) {
		    /* autoexecute commands */
		    if( err = Cmd_ExecuteString( p+1, ARGTYPE_STRING ) )
			ShowMessage( "Can't execute autocommands: %s",
						     GetErrorString(err) );
		    else
			ShowMessageAsInfo(fmtText, i+1,
				resCodes.codeTerminate, resCodes.codeResult);
		    return 2; /* force Screen update */
		}
		else
		    return 1; /* check only one process at a time */
	    }
    return 0; /* no events */
}
#endif

/****************
 * Get Information about detached processes:
 * seq is the Sequence number, count it upfrom 0  until you get an error.
 * returns: -1 = end of sequence numbers or
 *	    state : 0 = unused ( don't process this infos )
 *		    1 = starting
 *		    2 = running
 *		    3 = complete
 *     wenn Bit 7 gesetzt ist, handelt es sich um den letzen detached Process
 */
#if OS2 || UNIX
int GetDetachedProcInfo( int seq, char *buffer, ushort bufferSize,
			 int *pid, ushort *tc, ushort *rc )
{
    char *p;
    int x;
    size_t len;

    if( seq < 0 || seq >= MAX_PROCESS )
	return -1;
    x = lastProcessId == seq ? 0x80 : 0;
    if( processTbl[seq].state == sUNUSED )
	return x;
    mem2str(buffer, processTbl[seq].cmdline, bufferSize );
    if( processTbl[seq].autoCmd )
	if( p = strchr( buffer, ';' ) )
	    *p = 0;  /* remove autocommands */
    len = strlen(buffer);
    if( len + 3 + 5 + 1 < bufferSize ) {/* 5 = min. len needed for directory */
	strcat(buffer, "  {" );
	len += 3;
	Filename2Str( processTbl[seq].dirInfo, buffer+len, bufferSize-len-1 );
	strcat(buffer, "}" );
    }

    *pid = processTbl[seq].pid;
    *tc = processTbl[seq].tc;
    *rc = processTbl[seq].rc;
    return processTbl[seq].state | x;
}

#endif




#if W_FULL
int
Cmd_ChDir( cmd_t *cmd )
{
    size_t len;
    char *p;
    const char *path;

    p = NULL;
    if( (len=strlen( cmd->arg.string )) > 1 )
	if( cmd->arg.string[len-1] == '/' ) {
	    p = xstrdup(cmd->arg.string);
	    p[len-1] = '\0';
	}
    path = p ? p: cmd->arg.string;
  #ifdef UNIX
    if( *path == '~' )  {
	const char *s;
	char *buf;

	if( (s = getenv("HOME")) && *s ) {
	    buf = xmalloc(strlen(s)+strlen(path)+2);
	    strcpy(buf,s);
	    strcat(buf,path+1);
	    if(p)
		free(p);
	    p = buf;
	    path = p;
	}
    }
  #endif
    if( ChangeDirectory( path ) ) {
	free(p);
	return ERR_DIRNF;
    }
    else {
	free(p);
	return 0;
    }
}


int Cmd_ShowDir( cmd_t *cmd )
{
  #if W_FULL
    char *p;

    p = xmalloc( 6+F_MAX_PATH );
    strcpy( p, "chdir " );
    getcwd( p+6, F_MAX_PATH );
    Write2CurCmdLine( p );
    free(p);
    return 0;
  #else
    return ERR_USPCMD;
  #endif
}
#endif

/****************
 * Setzt ein Filelock fr einen File, d.h.
 * es wird ein file erzeugt mit dem Name des Files, aber mit dem 3.
 * Zeichen der Extension changed to '&'
 * filename must include the complete path.
 * Returns: 0 = Okay
 *	    -1 = Failed ( lock file exists or something other )
 */
#if W_FULL
int SetFileLock( const char *fileName )
{
    const char *lockName, *user;
    FILE *st;

    lockName = MakeLockFileName( fileName );

    if( access( lockName, F_OK ) ) {
	/* no file, so lock it */
	if( st = fopen( lockName, "w" ) ) {
	    if( !(user = getenv("USER")) )
		if( !(user = getenv("USERID")) )
		    user = "Unknown";
	    fprintf( st, "Semaphore created by: %s\n", user );
	    fputs( CopyRight(10), st );
	    fclose(st);
	    return 0; /* okay: locked */
	}
    }
    return -1;
}


/****************
 * Testet ob file lock gesetzt.
 * filename must include the complete path.
 * Returns: 0 = Okay
 *	    -1 = Failed ( lock file exists or something other )
 */

int CheckFileLock( const char *fileName )
{
    const char *lockName;

    lockName = MakeLockFileName( fileName );

    if( access( lockName, F_OK ) )
	return 0; /* file is locked */
    return -1;
}



/****************
 * Gibt einen Ptr auf eine statischen Speicher zurueck,
 * der den Namen des Users, der den Filelock besitzt
 * beinhaltet.
 */

const char * GetFileLockOwner( const char *fileName )
{
    const char *lockName, *p;
    FILE *st;
    static char buffer[17];
    int i, c;

    lockName = MakeLockFileName( fileName );

    if( st = fsopen( lockName, "r" ) ) {
	for( p = "Semaphore created by: "; *p ; p++ )
	    if( getc(st) != *p )
		break;
	if( *p )
	    strcpy(buffer,"[Not a W-Lock]");
	else {
	    for(i=0; i < DIM(buffer)-1; i++ )
		if( (c=getc(st)) == EOF )
		    break;
		else if( c == '\n' )
		    break;
		else
		    buffer[i] = c;
	    buffer[i] = 0;
	}
	fclose(st);
    }
    else
	strcpy(buffer,"[Not Locked]");
    return buffer;
}


/****************
 * complementary function to SetFileLock
 * Returns: 0 = Okay
 *	    -1 = some error
 * (NOTICE: This function may be called by a CleanUp() function )
 */

int ResetFileLock( const char *fileName )
{
    const char *lockName;

    lockName = MakeLockFileName( fileName );

    return remove( lockName );
}


/****************
 * Create the name of the lock semaphore file
 * Returns a Pointer to a static buffer
 */

static char *MakeLockFileName( const char *srcName )
{
    static char name[F_MAX_PATH]; /* static - may be called by CleanUp */
    char *p;
    int i;

    strcpy( name, srcName );
    i = FileExtCheck( name );
    p = name + strlen( name );

    for( ; i < F_MAX_EXT-1 ; i++, p++ )
	*p = i ? '_' : '.';
    *p = '\0';
    p[-1] = '&';
    return name;
}
#endif

#if OS2 || UNIX
static void
CleanUp(void *dummy)
{
    int i;

    for(i=0; i < MAX_PROCESS; i++ )
	if( processTbl[i].state != sUNUSED ) {
	  #if UNIX
	    if( processTbl[i].state == sRUNNING )
		kill( processTbl[i].pid, SIGTERM );
	  #else
	    if( processTbl[i].state == sRUNNING )
		DosKillProcess(DKP_PROCESSTREE, processTbl[i].pid );
	  #endif
	    if( processTbl[i].fileName ) {
	      #if DEBUG
		fprintf(stderr,"removing '%s'\n", processTbl[i].fileName );
	      #endif
		remove( processTbl[i].fileName );
		FREE( processTbl[i].fileName );
	    }
	    FREE( processTbl[i].cmdline );
	    FREE( processTbl[i].dirInfo );
	}
}
#endif


/*** bottom of file ***/
