/* [wedit2.c wk 3.10.91] W-Editor Operations 2
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 25.10.92 wk	C-Escape "\0" funktionierte nicht - fixed
 * 03.01.93 wk	Removed unused vars
 * 10.08.94 wk	reworked word-wrap
 */

#include "wtailor.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/lib.h>
#include <wk/string.h>
#if __ZTC__
  #include <dos.h>
  #include <sound.h>
#endif

#include "w.h"
#include "wcmdpr.h"
#include "wscreen.h"
#include "wfile.h"

/****** constants *********/
/******* typedefs ********/
/******* globals **********/
/******* prototypes *******/
static int DoPut( const char *string, ushort len );
static size_t ProcStrg( char *d, const char *s, size_t n );
/******* functions ********/
#define is_octdigit( c ) ( (c) >= '0' && (c) <= '7' )
#define oct_value( c )	((byte)((c)-'0'))
#define hex_value( c )	(isdigit(c)?(byte)((c)-'0'): \
			(byte)((c)-(isupper(c)?'A':'a')+10))


int Cmd_Put( const char *string )
{
    return DoPut( string, strlen(string) );
}


#if W_FULL
int Cmd_CStr( cmd_t *cmd )
{
    int fhd, cmdLine, err=0;
    unsigned flags;
    const char *source;
    char *varValue;
    char *buffer;
    ushort n;

    fhd = QryScreenFile();
    GetFileInfo( fhd, &flags );
    if( cmdLine = flags & WFILE_INCMD )
	ResetFileFlag( fhd, WFILE_INCMD );
    varValue = NULL;
    if( cmd->type == ARGTYPE_STRING )
	source = cmd->arg.string;
    else {
	varValue = VarValue( cmd );
	source = varValue;
    }

    buffer = xmalloc( MAX_LINELEN+1 );
    n = ProcStrg( buffer, source, MAX_LINELEN );
    if( varValue )
	FreeVarValue( varValue );

    err = DoPut( buffer, n );
    free(buffer);
    if( cmdLine )
	SetFileFlag( fhd, WFILE_INCMD );
    return err;
}


/****************
 *  Einfaches Teletyp write, d.h. umbruch bei LF
 */

int PutTTYString( const char *p, ushort len )
{
    int err = 0, x;
    ushort n;
    const char *p2;

    n = 0;
    do {
	if( SigIntPoll() ) {
	    err = ERR_CMDINT;
	    goto errLabel;
	}
	for(; n < len ; p++, n++ )   /* skip leading CRs */
	    if( *p != '\r' )
		break;
	for(p2=p; n < len ; p2++, n++ )  /* look for terminating CR or LF */
	    if( *p2 == '\n' || *p2 == '\r' )
		break;
	if( p != p2 )
	    if( err = DoPut( p, p2 - p ) )
		goto errLabel;
	p = p2;
	x = *p == '\r' ;
	if( *p == '\n' || x ) {
	    p++; n++;
	    if( x && n < len )
		if( *p == '\n' ) {
		    p++; n++;
		}
	    if( n < len )
		if( err = Cmd_InsertLine( NULL, 0 ) )
		    goto errLabel;
	}
    } while( n < len );
  errLabel:
    return err;
}


#endif

static int DoPut( const char *string, ushort len )
{
    int fHd, err, app;
    unsigned flags;
    ushort pos, n, nbytes, lmarg, rmarg, dmarg;
    char *p;

    xassert( len < MAX_LINELEN );
    err = 0;
    fHd = QryScreenFile();
    GetFileInfo( fHd, &flags );
  #if W_FULL
    if( GetSetOption( SETOPT_PUREASCII) ) {
	for(n=0; n < len ; n++ )
	    if( string[n] & 0x80 ) {
	      #if __ZTC__
		sound_beep(400);
	      #endif
		err = ERR_NOASCII;
		break;
	    }
    }
  #endif
    if( err )
	;
    else if( flags & WFILE_INCMD ) {
	p = GetPtr2CmdLine( fHd, &pos );
	nbytes = strlen(p);
	/* Fillup with blanks */
	for(n=nbytes; n < pos && n < MAX_LINELEN-1; n++ )
	    p[n] = ' ';
	if( n != nbytes )
	    p[n] = '\0';
	if( flags & WFILE_INSERT ) {
	    if( pos < MAX_LINELEN-1 ) {
		StrNShift( p+pos, len, MAX_LINELEN-1-pos );
		nbytes += len;
	    }
	}
	for(n=0, pos; pos < MAX_LINELEN-1 && len ; pos++, len--, n++ )
	    p[pos] = *string++;
	if( pos > nbytes )
	    p[pos] = '\0';
	MoveCmdRight( fHd, n );
    }
    else if( flags & WFILE_RO )  /* in Text but ReadOnly */
	err = ERR_EDTRO;
    else {  /* in Text */
	GetFilesMargins( fHd, &lmarg, &rmarg, &dmarg );
	p = GetEditBuf( fHd, &nbytes );
	GetFilePos( fHd, &pos );
	app = nbytes <= pos;
	/* Fillup with blanks up to insert position */
	for(n=nbytes; n < pos && n < rmarg; n++ )
	    p[n] = ' ';
	if( n == nbytes && (flags & WFILE_INSERT) ) {
	    if( pos+len < MAX_LINELEN )
		if( n = MAX_LINELEN-pos-len ) {
		    memmove( p+pos+len, p+pos, n );
		    if( nbytes+len <= MAX_LINELEN )
			nbytes += len;
		    else
			nbytes = MAX_LINELEN;
		    SetEditBuf( fHd, nbytes );
		}
	}
	for( n=0; pos < MAX_LINELEN && len ; pos++, len--,n++ )
	    p[pos] = *string++;
	if( pos > nbytes ) {
	    nbytes = pos;
	    SetEditBuf( fHd, nbytes );
	}
	MoveRight( fHd, n );
	if( app && nbytes > rmarg ) { /* auto split line (word wrap)*/
	    /* go back to the begin of the last word */
	    for( n = nbytes-1; n ; n-- )  /* (nbytes is > 0 ) */
		if( !(isspace( (byte)p[n] ) || !p[n]) ) {
		    n--;
		    break;
		}
	    for( ; n ; n-- )
		if( isspace( (byte)p[n] ) || !p[n] )
		    break;
	    if( n && n > lmarg ) {
		if( n < rmarg )
		    n++;
		Move2Column( fHd, n );
		/* split line */
		if( !(err= Cmd_Split()) ) {
		    MoveDown( fHd, 1 );
		    p = GetEditBuf( fHd, &nbytes );
		    pos = nbytes;
		    /* shift this line to the left margin */
		    if( nbytes + lmarg < MAX_LINELEN-1 ) {
			memmove( p+lmarg, p, nbytes );
			memset( p, ' ', lmarg );
			pos += lmarg;
		    }
		    if( pos > nbytes ) {
			nbytes = pos;
			SetEditBuf( fHd, nbytes );
		    }
		    Move2Column( fHd, pos );
		}
	    }
	    else if( n ) { /* only 1 word in line - do not split */
		if( !(err = Cmd_InsertLine( NULL, 0 )) )
		    Move2Column( fHd, lmarg );
	    }
	}
    }

    return err;
}






int Cmd_InsertLine( const char *data, ushort dataLen )
{
    int err=0, fhd;
    ulong lnr;

    if( !data ) {
	data = "";
	dataLen = 0;
    }

    fhd = QryScreenFile();
    FlushEditBuf( fhd );
    lnr = GetFilePos( fhd, NULL );
    err = InsertLine( fhd, data, dataLen );
    SeekLine( fhd, lnr );
    if( !err ) {
	MoveDown( fhd, 1 );
	Move2Column( fhd, 0 );
    }
    return err;
}



/***************************************
 * ProcStrg	copy a string with escape characters
 *
 * size_t ProcStrg( char *d, const char *s, size_t max );
 * char *d ;		  Destination Buffer
 * char *s ;		  Source Buffer
 * size_t max ; 	  Lnge des Buffers
 *
 * Die Funktion kopiert einen String in einen Buffer:
 * Die C Escapesequencen werden dabei bercksichtigt.
 * max gibt die maximal Lnge des buffers an.
 * Return Value: Anzahl der gltigen Zeichen in d
 */

#if W_FULL
static size_t ProcStrg( char *d, const char *s, size_t n )
{
    int escape, okay ;
    size_t copied;

    okay = 0;
    copied = n ; /* save max. buffer length */

    for( escape = 0 ; *s && n; s++ ) {
	if( escape ) {
	    if( is_octdigit( *s ) && is_octdigit(s[1]) && is_octdigit(s[2]) ) {
		*d++ = (char)(64*oct_value(*s) +
			       8*oct_value(s[1])+oct_value(s[2])) ;
		s += 2 ;
	    }
	    else
		switch( *s ) {
		  case 'x':
		    if( isxdigit(s[1]) && isxdigit(s[2]) ) {
			*d++ = (char)(16 * hex_value(s[1]) + hex_value(s[2]));
			s += 2 ;
		    }
		    else
			*d++ = 'x' ;
		    break ;
		  case 'a':   *d++ = '\a' ; break ;
		  case 'b':   *d++ = '\b' ; break ;
		  case 'f':   *d++ = '\f' ; break ;
		  case 'n':   *d++ = '\n' ; break ;
		  case 'r':   *d++ = '\r' ; break ;
		  case 't':   *d++ = '\t' ; break ;
		  case 'v':   *d++ = '\v' ; break ;
		  case '0':   *d++ = '\0' ; break ;
		  default:    *d++ = *s ;
		}
	    n-- ;
	    escape = 0 ;
	}
	else if( *s == '\\' )
	    escape = 1 ;
	else if( *s == '\"' ) {
	    okay++;
	    s++;
	    break ;
	}
	else {
	    *d++ = *s ;
	    n-- ;
	    escape = 0 ;
	}
    }

    copied -= n ; /* actual copied charcters */

    return copied;
}
#endif

/*** bottom of file ***/
