/* [wedit5.c wk 3.10.91] W-Editor Operations 5
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  margins / reflow / goto word
 * History:
 *  6.12.92 wk	Added Error return NFOUD  for ..GotoWord
 * 03.01.93 wk	Removed unused vars
 * 09.01.93 wk	..GotoWord(): No error if mode==0,2 && atWord
 */

#include "wtailor.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <wk/lib.h>
#include <wk/string.h>

#include "w.h"
#include "wcmdpr.h"
#include "wscreen.h"
#include "wfile.h"

/****** constants *********/
/******* typedefs ********/
/******* globals **********/
/******* prototypes *******/
static int IsLineBlank( int fhd );
/******* functions ********/
#if W_FULL
int Cmd_CenterInMargins(void)
{
    int err = 0;
    int fhd;
    ushort lmarg, rmarg, dmarg, pos, nbytes, n, len, mlen;
    ulong lnr, line1, line2;
    char *p, *hp;
    saveFilePos_t savePos;

    fhd = QryScreenFile();
    if( MarkInfo( &fhd ) == MARKTYPE_LINE ) {
	GetFilesMargins( fhd, &lmarg, &rmarg, &dmarg );
	mlen = rmarg - lmarg + 1;
	SaveFilePos( fhd, &savePos );
	line1 = MarkStart( NULL );
	line2 = MarkEnd( NULL );
	for( lnr = line1; lnr <= line2 && !err; lnr++ ) {
	    SeekLine( fhd, lnr );
	    p = GetEditBuf( fhd, &nbytes );
	    for( ; nbytes; nbytes-- )
		if( p[nbytes-1] != ' ' )
		    break;
	    /* get pos of first non blank character */
	    for( hp=p, n=0; n < nbytes; n++, hp++ )
		if( !(*hp == ' ' || !*hp) )
		    break;

	    if( n < nbytes ) { /* any charcaters in line ? */
		len = nbytes - n; /* yes! */
		pos = lmarg;
		if( len < mlen )
		    pos += (mlen - len)/2;
		if( pos+len < MAX_LINELEN ) {
		    memmove( p+pos, p+n, len );
		    memset( p, ' ', pos );
		    nbytes = pos + len;
		}
	    }

	    SetEditBuf(fhd, nbytes );
	    if( SigIntPoll() )
		err = ERR_CMDINT;
	}
	RestFilePos( &savePos );
    }
    else
	err = ERR_NOLMRK;

    return err;
}



int Cmd_Reflow(void)
{
    int err = 0;
    int fhd, wrkfhd, oldBackup, needNewSrcLine, needNewWrkLine, c;
    int wordsInLine=0, addSpaceCount=0, first, ident;
    ushort lmarg, rmarg, dmarg, nbytes, mlen, wrknbytes;
    ushort lastnbytes=0, lastwrknbytes=0;
    ulong lnr, line1, line2;
    char *p;
    const char *src=NULL, *lastsrc=NULL;
    saveFilePos_t savePos;
    unsigned dummy;
    enum { sWAIT, sCOPY       } state;

    fhd = QryScreenFile();
    if( MarkInfo( &fhd ) == MARKTYPE_LINE ) {
	oldBackup = GetSetOption( SETOPT_BACKUP ); /* save backupstate */
	PutSetOption( SETOPT_BACKUP, 0 );	   /* and switch it off */
	GetFilesMargins( fhd, &lmarg, &rmarg, &dmarg );
	mlen = rmarg - lmarg + 1;
	SaveFilePos( fhd, &savePos );

	/* now open a temp workfile */
	if( !(err=Cmd_Edit(".work")) ) {
	    wrkfhd = QryScreenFile();
	    ResetFileFlag( wrkfhd, WFILE_RO );
	    DeleteAllLines( wrkfhd );

	    line1 = MarkStart( NULL );
	    line2 = MarkEnd( NULL );
	    lnr = line1;
	    needNewSrcLine = needNewWrkLine = 1;
	    state = sCOPY;
	    p = NULL ;
	    ident = first = 1;
	    while( 1 ) {
		while( needNewSrcLine ) {
		    needNewSrcLine = 0;
		    if( SigIntPoll() ) {
			err = ERR_CMDINT;
			goto endLabel;
		    }
		    if( lnr > line2 ) {
			goto endLabel;
		    }
		    SeekLine( fhd, lnr ); lnr++;
		    src = GetPtr2Line( fhd, &nbytes );
		    for( ; nbytes; nbytes--, src++ )
			if( *src != ' ' && *src )
			    break;
		    if( !nbytes ) {
			needNewSrcLine++;
			needNewWrkLine=1;
			ident = 2;
		    }
		    else if( first ) {
			addSpaceCount = 0;
			first = 0;
		    }
		    else {
			if( state == sCOPY ) {
			    lastsrc = src;
			    lastnbytes = nbytes;
			    lastwrknbytes = wrknbytes;
			}
			addSpaceCount++;
		    }
		}
		if( needNewWrkLine ) {
		    needNewWrkLine = 0;
		    if( p ) {/* update last work line */
			SetEditBuf(wrkfhd, wrknbytes );
			p = NULL ;
		    }
		    if( ident == 2 ) /* one extra line */
			if( err = InsertLine( wrkfhd, "", 0 ) )
			    goto endLabel;
		    if( err = InsertLine( wrkfhd, "", 0 ) )
			goto endLabel;
		    p = GetEditBuf( wrkfhd, &wrknbytes );
		    for( ;wrknbytes < (ident ? dmarg : lmarg); wrknbytes++ )
			*p++ = ' ';
		    ident = 0;
		    wordsInLine = 0;
		    addSpaceCount = 0;
		}
		switch( state ) {
		  case sWAIT:
		    for( ; nbytes; nbytes--, src++ )
			if( *src != ' ' && *src )
			    break;
		    if( nbytes ) {
			state = sCOPY;
			lastsrc = src;
			lastnbytes = nbytes;
			lastwrknbytes = wrknbytes;
			addSpaceCount++;
		    }
		    else
			needNewSrcLine++;
		    break;

		  case sCOPY:
		    while( nbytes ) {
			c =  addSpaceCount ? ' ' : *src;
			if( (c != ' ' && c) || addSpaceCount ) {
			    *p++ = c;
			    if( wrknbytes > rmarg ) {
				if( wordsInLine ) { /* go back */
				    src = lastsrc;
				    nbytes = lastnbytes;
				    wrknbytes = lastwrknbytes;
				}
				else
				    wordsInLine++;
				needNewWrkLine++;
				break;
			    }
			    else
				wrknbytes++;
			}
			else {
			    state = sWAIT;
			    break;
			}

			if( addSpaceCount )
			    addSpaceCount--;
			else {
			    nbytes--; src++;
			}
		    }
		    if( !nbytes ) {
			wordsInLine++;
			needNewSrcLine++;
		    }
		    break;

		  default: Bug("Invalid state in reflow: %d", state);
		}
	    }
	  endLabel:
	    if( p ) /* update last work line */
		SetEditBuf(wrkfhd, wrknbytes );

	    if( !err ) { /* copy to file */
		PutSetOption( SETOPT_BACKUP, oldBackup );  /* restore backup */
		if( !(err = Cmd_DeleteMark() ) ) {
		    SeekLine( wrkfhd, 1 );
		    SetMark( wrkfhd, MARKTYPE_LINE );
		    SeekLine( wrkfhd, ULONG_MAX );
		    SetMark( wrkfhd, MARKTYPE_LINE );
		    if( !line1 ) {
			Move2Pos( fhd, 0, 0 );
			Cmd_Split();
			line1++;
			c = 1;
		    }
		    else
			c = 0;
		    line2 = line1 + GetFileTotLines( wrkfhd )-2;
		    Move2Line( fhd, line1-1 );
		    Cmd_Switch2NamedFile( GetFileInfo( fhd, &dummy ) );
		    if( !(err = Cmd_CopyMark()) ) {
			SetMark( wrkfhd, 0 );
			if( c ) { /* remove splitted line */
			    SeekLine(fhd, 0);
			    DeleteLine( fhd );
			    line1--;
			    line2--;
			}
			SeekLine( fhd, line1 );
			SetMark( fhd, MARKTYPE_LINE );
			SeekLine( fhd, line2 );
			SetMark( fhd, MARKTYPE_LINE );
			Move2Pos( fhd, line2+1, lmarg );
		    }
		}
	    }
	    Cmd_Switch2NamedFile( GetFileInfo( wrkfhd, &dummy ) );
	    Cmd_Quit();  /* get rid of the internal work file */
	    Cmd_Switch2NamedFile( GetFileInfo( fhd, &dummy ) );
	}
	if( err )
	    RestFilePos( &savePos );
	PutSetOption( SETOPT_BACKUP, oldBackup );  /* restore backupstate */
    }
    else
	err = ERR_NOLMRK;

    return err;
}






/****************
 * Position at margin:
 * mode 0 = at left margin
 *	1 = at right margin
 *	2 = at indent
 *	3 = at indent or left
 */

int Cmd_GotoMargin( int mode )
{
    int fhd;
    ushort lmarg, rmarg, dmarg, pos;
    ulong lnr;

    fhd = QryScreenFile();
    GetFilesMargins( fhd, &lmarg, &rmarg, &dmarg );
    if( !mode )
	pos = lmarg;
    else if( mode==1 )
	pos = rmarg;
    else if( mode==2 )
	pos = dmarg;
    else if( !(lnr = GetFilePos( fhd, NULL )) ) /* first line */
	pos = dmarg;
    else {
	SeekLine( fhd, lnr+1 );
	pos = IsLineBlank(fhd) ? dmarg : lmarg ;
	SeekLine( fhd, lnr );
    }
    Move2Column( fhd, pos );
    return 0;
}
#endif


/****************
 * Some Commands to pos at a word
 * mode 0: Pos at begin of word (thru complete file)
 *	1: Pos at begin of prev word (thru complete file)
 *	2: Pos at end of word (thru complete file)
 *	3: Pos at begin of next word (thru complete file)
 */


int Cmd_GotoWord( int mode )
{
    return Cmd_GotoWord1( mode, GetWordDelimiters() );
}

int Cmd_GotoWord1( int mode, const char *delim )
{
    int fhd, found, atWord, err=0;
    ulong lnr, lastlnr, orgLine;
    ushort pos, nbytes, orgPos;
    const char *p;

    if( !delim )
	delim = "";

    fhd = QryScreenFile();
    p = GetPtr2Line( fhd, &nbytes );
    orgLine = lnr = GetFilePos( fhd, &pos );
    orgPos = pos;

    atWord = 0;
    if( pos < nbytes )
	if( !(p[pos] == ' ' || !p[pos] || strchr( delim, p[pos] )) )
	    atWord++;

    found = 0;
    if( mode == 0 || mode == 1) {
	if( mode == 1 )
	    while( !found && !err && atWord ) {
		for( ;pos ; pos-- )
		    if( pos >= nbytes ) {
			found++;
			break;
		    }
		    else if( p[pos]==' ' || !p[pos] || strchr(delim,p[pos])) {
			found++;
			break;
		    }
		if( found )
		    atWord=0;
		else if( !lnr )
		    found++; /* very first position reached */
		else {
		    MoveUp( fhd, 1 );
		    p = GetPtr2Line( fhd, &nbytes );
		    lnr = GetFilePos( fhd, &pos );
		    pos = nbytes;
		}
		if( sigIntPending )
		    err = ERR_CMDINT;
	    }

	found = 0;
	while( !found && !err && !atWord ) {
	    for( ;pos ; pos-- )
		if( pos < nbytes )
		    if( !(p[pos]==' ' || !p[pos] || strchr(delim,p[pos])) ) {
			found++;
			break;
		    }
	    if( found )
		atWord++;
	    else if( !lnr )
		found++; /* very first position reached */
	    else {
		MoveUp( fhd, 1 );
		p = GetPtr2Line( fhd, &nbytes );
		lnr = GetFilePos( fhd, &pos );
		if( pos = nbytes )
		    pos--;
	    }
	    if( sigIntPending )
		err = ERR_CMDINT;
	}

	if( !err ) { /* go back, till start of word found */
	    if( atWord && pos ) {
		do {
		    pos--;
		    if( p[pos] == ' ' || !p[pos] || strchr( delim, p[pos])) {
			pos++;
			break;
		    }
		} while( pos );
	    }
	    Move2Column( fhd, pos );
	}
    }
    else if( mode == 2 ) {
	lastlnr = GetFileTotLines( fhd )-1;
	while( !found && !err && !atWord ) {
	    for( ;pos<nbytes ; pos++ )
		if( !(p[pos] == ' ' || !p[pos] || strchr( delim, p[pos] )) ) {
		    found++;
		    break;
		}
	    if( found )
		atWord++;
	    else if( lnr == lastlnr )
		found++; /* very last position reached */
	    else {
		MoveDown( fhd, 1 );
		p = GetPtr2Line( fhd, &nbytes );
		lnr = GetFilePos( fhd, &pos );
		pos = 0;
	    }
	    if( sigIntPending )
		err = ERR_CMDINT;
	}

	if( !err ) { /* go forward, till end of word found */
	    if( atWord && pos < nbytes ) {
		found = 0;
		do {
		    if( p[pos] == ' ' || !p[pos] || strchr( delim, p[pos]) ) {
			found++;
			pos--;
		    }
		    else
			pos++;
		} while( pos< nbytes && !found );
	    }
	    if( !found && pos )
		pos--;
	    Move2Column( fhd, pos );
	}
    }
    else if( mode == 3 ) {
	lastlnr = GetFileTotLines( fhd )-1;
	for( ;pos < nbytes ; pos++ )
	    if( p[pos] == ' ' || !p[pos] || strchr( delim, p[pos] ) )
		break;
	atWord = 0;
	while( !found && !err && !atWord ) {
	    for( ;pos<nbytes ; pos++ )
		if( !(p[pos] == ' ' || !p[pos] || strchr( delim, p[pos] )) ) {
		    found++;
		    break;
		}
	    if( found )
		atWord++;
	    else if( lnr == lastlnr )
		found++; /* very last position reached */
	    else {
		MoveDown( fhd, 1 );
		p = GetPtr2Line( fhd, &nbytes );
		lnr = GetFilePos( fhd, &pos );
		pos = 0;
	    }
	    if( sigIntPending )
		err = ERR_CMDINT;
	}
	if( !err )
	    Move2Column( fhd, pos );
    }
    else
	BUG();

    if( !err )
	if( orgPos == pos )
	    if( orgLine == GetFilePos( fhd, &pos ) )
		if( !(atWord && (!mode || mode==2)) )
		    err = ERR_NFOUND;
    return err;
}

int Cmd_GotoWord2( int mode, cmd_t *cmd )
{
    int err;
    char *p;

    if( cmd->type == ARGTYPE_VAR || cmd->type == ARGTYPE_VARENV ) {
	p = VarValue( cmd );
	err = Cmd_GotoWord1( mode, p );
	FreeVarValue( p );
    }
    else if( *cmd->arg.string )   /* not empty, so use it */
	err = Cmd_GotoWord1( mode, cmd->arg.string );
    else /* no args, use ZWordDel */
	err = Cmd_GotoWord1( mode, GetWordDelimiters() );
    return err;
}



int Cmd_FindBlankLine()
{
    int err=0, fhd;
    ulong lastlnr;

    fhd = QryScreenFile();
    lastlnr = GetFileTotLines( fhd )-1;
    while( !IsLineBlank( fhd ) && !err ) {
	if( lastlnr == GetFilePos( fhd, NULL ) )
	    err = ERR_NFOUND;
	else if( sigIntPending )
	    err = ERR_CMDINT;
	else
	    MoveDown( fhd, 1 ) ;
    }

    return err;
}



int Cmd_FirstNonBlank()
{
    int fhd;
    const char *p;
    ushort nbytes, n;

    fhd = QryScreenFile();
    p = GetPtr2Line( fhd, &nbytes );
    for( n=0; n < nbytes; n++, p++ )
	if( !(*p == ' ' || !*p) )
	    break;
    Move2Column( fhd, n );
    return 0;
}


/****************
 *  set cursor to the next non blank character within the line
 */

int Cmd_NextNonBlank()
{
    int fhd;
    const char *p;
    ushort nbytes, n;

    fhd = QryScreenFile();
    p = GetPtr2Line( fhd, &nbytes );
    GetFilePos( fhd, &n );
    for( p += n; n < nbytes; n++, p++ )
	if( !(*p == ' ' || !*p) )
	    break;
    Move2Column( fhd, n );
    return 0;
}

/****************
 *  set cursor to the next blank character within the line
 */

int Cmd_NextBlank()
{
    int fhd;
    const char *p;
    ushort nbytes, n;

    fhd = QryScreenFile();
    p = GetPtr2Line( fhd, &nbytes );
    GetFilePos( fhd, &n );
    nbytes++; /* so it will be sure on a blank */
    for( p += n; n < nbytes; n++, p++ )
	if( *p == ' ' || !*p )
	    break;
    Move2Column( fhd, n );
    return 0;
}



/****************
 * Returns true it the current line is blank
 */

static int IsLineBlank( int fhd )
{
    ushort nbytes;
    const char *p;

    for( p = GetPtr2Line( fhd, &nbytes ); nbytes; nbytes--, p++ )
	if( !( *p == ' ' || !*p) )
	    return 0 ;
    return 1;
}

/*** bottom of file ***/
