/* [werr.h wk 10.9.92] Error codes for W
 *	Copyright (c) 1992 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 *
 */

#ifndef HDR_WERR
#define HDR_WERR 1
#if __cplusplus
extern "C" {
#endif


/****** ErrorCodes ****/
#define ERR_NOERROR 0
#define ERR_UNKNOWN 1
#define ERR_NOMEM  2
#define ERR_NOLINE 3
#define ERR_INVCMD 4
#define ERR_MRKCFL 5	    /* Mark conflict */
#define ERR_INTNAM 6        /* internal name, can't save it */
#define ERR_FINUSE 7	    /* file alread in use */
#define ERR_FILEHD 8	    /* out of file Handles */
#define ERR_INVARG 11	    /* Invalid Arg to an Command */
#define ERR_INVKEY 12	    /* Invalid key */
#define ERR_LOCCMD 13	    /* error in locate or change command */
#define ERR_SETCMD 14	    /* error in set command */
#define ERR_NOPRO  15	    /* no profile */
#define ERR_NOCHGP 16	    /* no change pending */
#define ERR_MISNAM 17	    /* missing filename */
#define ERR_2DEEP  18	    /* recursion is too deep */
#define ERR_NOMRK  19	    /* no marked area */
#define ERR_USPCMD 20	    /* unsupported command */
#define ERR_STCNFL 21	    /* Source and target conflict */
#define ERR_DIRNF  22	    /* Directory not found */
#define ERR_PUTENV 23	    /* putenv() error */
#define ERR_LOOP   24	    /* loop error */
#define ERR_NOBMRK 25	    /* no block mark */
#define ERR_NFOUND 26	    /* not found */
#define ERR_SRCHPAT 27	    /* search pattern error  */
#define ERR_CMDINT  28	    /* command interrupted  */
#define ERR_NOASCII 29	    /* not ascii */
#define ERR_NOFILE  30      /* no file (can't switch to this) */
#define ERR_SAVINT  31      /* can't save internal file */
#define ERR_SAVRO   32      /* can't save readonly file */
#define ERR_SETRW   33      /* can't set to readwrite */
#define ERR_OPNFIL  34	    /* error opening file */
#define ERR_WRTFIL  35	    /* error writing file */
#define ERR_NOSAVE  36	    /* save not allowed for this file */
#define ERR_NOLABEL 37	    /* Label not set */
#define ERR_INVLAB  38	    /* Invalid label */
#define ERR_PUSHMRK 39	    /* push mark error */
#define ERR_POPMRK  40	    /* pop mark error */
#define ERR_SIGINT  41	    /* nearly the same as cmdINT */
#define ERR_INVOP   42	    /* invalid operartor */
#define ERR_CSTKOVR 43	    /* calculation stack overflow */
#define ERR_CSTKUDR 44	    /* calculation stack underflow */
#define ERR_DIVZERO 45	    /* Division by zero */
#define ERR_VARROOM 46	    /* not enough room for variables */
#define ERR_INVVAR  47	    /* invalid variable */
#define ERR_PSEUDO_SKIP 48  /* pseudo command */
#define ERR_PSEUDO_END	49  /* pseudo command */
#define ERR_LTRUNC	50  /* lines truncated */
#define ERR_EDTRO       51  /* can't edit readonly file */
#define ERR_INVTAB	52  /* invalid tab setting */
#define ERR_INVMRG	53  /* invalid margin setting */
#define ERR_PSEUDO_CFN	54  /* pseudo command set confirm */
#define ERR_NOLMRK	55  /* no line mark */
#define ERR_DELFIL	56  /* delete file error */
#define ERR_REDFIL	57  /* error reading file */
#define ERR_VALRNG	58  /* value range error */
#define ERR_INVDEL	59  /* invalid delimiter */
#define ERR_SYSLIMIT	60  /* system limit reached */
#define ERR_READPER	61  /* no read permission */
#define ERR_RENFIL	62  /* error renaming  */
#define ERR_DETACH	63  /* error detaching process */
#define ERR_INVPID	64  /* invalid PID */
#define ERR_KILLP	65  /* KillProcess Error */
#define ERR_MAC2LNG	66  /* Macro is too long */
#define ERR_FILEXIST	67  /* File exists */
#define ERR_CLPBRD	68  /* clipboard error */
#define ERR_PSEUDO_NE	69  /* pseudo: stop error trapping */
#define ERR_PSEUDO_CE	70  /* pseudo: clear error */
#define ERR_INVOPT	71  /* invalid option	   */
#define ERR_USPFFMT	72  /* unsupported file format */
#define ERR_INVOPTC	73  /* invalid option combination */
#define ERR_INVRLEN	74  /* invalid record length */
#define ERR_LTRUNCNS	75  /* lines truncated - not saved */
#define ERR_INVNAME	76  /* Invalid name */
#define ERR_UDFFNC	77  /* undefined function */
#define ERR_NOTFNC	78  /* not a fucntion */
#define ERR_UXPBEG	79  /* unexpected begin */
#define ERR_UXPEND	80  /* unexpected end */
#define ERR_MISEND	81  /* missing end */
#define ERR_BLKNEST	82  /* blocks to deep nested */
#define ERR_MRK2LRG	83  /* mark too large */
#define ERR_CLPEMPTY	84  /* clipboard empty */
#define ERR_SNDSIG	85  /* error sending signal */
#define ERR_NOLINEID	86
#define ERR_INVRE	87  /* invalid r.e. */
#define ERR_BUG 	88  /* internal error */
#define ERR_VIEW	89  /* not supported in view mode */
#define ERR_INVCP	90  /* CP not available */



#if __cplusplus
}
#endif
#endif /* HDR_WERR */
