/* [wfile.h wk 4.7.91] Defs for Filehandling
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /vol1/src/master/apps/w/src/wfile.h,v 1.5 1996/05/17 18:49:40 wernerk Exp $
 */

#ifndef HDR_WFILE
#define HDR_WFILE 1
#if __cplusplus
extern "C" {
#endif
#ifdef UNIX
  #include <sys/stat.h>
  #include <unistd.h>
#endif
#include "wmove.h"


#define WFILE_NEW   1	    /* Flagbit: This is a new file */
#define WFILE_CHG   2	    /* Flagbit: File contents was changed */
#define WFILE_INT   4	    /* Flagbit: Is internal file */
#define WFILE_RO    8	    /* Flagbit: Is readonly file */
#define WFILE_INSERT 16     /* Flagbit: Cursor is in InsertMode */
#define WFILE_INCMD  32     /* Flagbit: Cursor is in Commandline */
#define WFILE_NOTAB  64     /* Flagbit: Save without tab comprerssing */
#define WFILE_RING  128     /* Flagbit: File is in Ring */
#define WFILE_LOCK  256     /* Flagbit: File is locked by semaphore */
#define WFILE_VIEW  512     /* Flagbit: This is a View-File */
#define WFILE_HILITE 1024   /* Flagbit: enable syntax highlighting */

#define WFILE_FMT_STD 0     /* File format ist standard */
#define WFILE_FMT_FIX 1     /* fixed record length */
#define WFILE_FMT_2PR 2     /* 2 byte header gives size of each line */
#define WFILE_FMT_BIN 3     /* binary mode */


#define MARKTYPE_LINE	1
#define MARKTYPE_BLOCK	2
#define MARKTYPE_CHAR	3

typedef struct {	/* internal to SaveFilePos() , RestFilePos() */
	int   fhd;
	ulong lnr;
	ushort pos;
	ushort x,y;
    } saveFilePos_t;	/* Parameter for SaveFilePos, RestFilePos() */


int AllocFile( int *fHd, const char *name, int mode,
	       int format, ushort reclen, ulong startline, ulong maxlines);
int RenameFile( int fhd, const char *newName );
int GetFileHandle( const char *name );
int GetNextFileHandle( int fhd );
int GetPrevFileHandle( int fhd );
void UpdateFileRing( int fhd );
int IsInternalFileName( const char *name );
int IsScratchFile( const char *name );
void ReleaseFile( int fHd );
void ReleaseAllFiles( void );
const char *GetFileInfo( int fHd, unsigned *flags );
const char *GetFileInfo2( int fHd, unsigned *flags,int *format, ushort *rl );
const char *GetFilesExt( int fHd );
const char *GetFilesHiliteType( int fHd );
void SetFilesHiliteType( int fHd, const char *newtype );
void SetFilesTabSettings( int fHd, ushort *tabArray, ushort cnt );
ushort GetFilesTabSettings( int fHd, ushort *tabArray, ushort arrSize );
void SetFilesMargins( int fHd, ushort left, ushort right, ushort indent );
void GetFilesMargins( int fHd, ushort *left, ushort *right, ushort *indent );
#ifdef UNIX
struct stat *GetFileStat( int fHd );
#endif
void SetFileFlag( int fHd, int flag );
void ResetFileFlag( int fHd, int flag );
void UnlockFile( int fHd );
char *GetPtr2CmdLine( int fHd, ushort *pos );
char *GetAllCmdLineInfo( int fhd, ushort *nbytes,
			 ushort *pos, ushort *win, ushort *crs );
void SetAllCmdLineInfo( int fhd, ushort pos, ushort win, ushort crs );
int  GetTextCrsPos( int fHd, ushort *x, ushort *y );
char *GetEditBuf( int fHd, ushort *nbytes );
void SetEditBuf( int fHd, ushort nbytes );
void ClearEditBuf( int fHd );
void FlushEditBuf( int fHd );
int GetFileCount(void);
ulong GetFilePos( int fileHandle, ushort *pos );
ulong GetFileTotLines( int fhd );
ulong GetAllFilePos( int fhd, ushort *filX, ulong *filY,
			      ushort *winX, ulong *winY,
			      ushort *crsX, ushort *crsY );
void SetTextAreaPos( int fhd, ushort winX, ulong  winY,
			      ushort crsX, ushort crsY );

int InsertLine( int fileHandle, const char *data, ushort dataLen );
int DeleteLine( int fileHandle );
int DeleteAllLines( int fhd );
int  SeekLine( int fileHandle, ulong lnr );
void PosLine( int fileHandle, ushort newPos );
void SeekAndPosLine( int fileHandle, ushort newPos, ulong newLine );
const char *GetPtr2Line( int fileHandle, ushort *length );
int GetLineBlock( int hd, ulong lnr, const char **block, ushort *len,
		  size_t blockSize,
		  size_t *ml1, ushort *mp1, size_t *ml2, ushort *mp2 );
#if USE_EMS
int GetLineBlockInit( int fileHandle, ulong newLnr, size_t blockSize,
		       size_t *ml1, ushort *mp1, size_t *ml2, ushort *mp2 );
const char *GetLineBlockNext( ushort *retlen );
#endif
void SaveFilePos( int, saveFilePos_t * );
void RestFilePos( saveFilePos_t * );
int SetMark( int fileHandle, int marktype );
void AdjustBlockMark( int fhd, int value );
int PushMark(void);
int PopMark(void);
int MarkInfo( int *);
ulong MarkStart( ushort *);
ulong MarkEnd( ushort *);
void ResetMarkStack(void);
int FileSetLabel( int label, int fhd );
int FileGetLabel( int label, int *fhd, ulong *lnr, ushort *pos );
int CheckFileBuffers(void);
int SortLines( int fileHandle, const char *options );
int GetLineNrFromLineId(int fhd, ulong *retLineNr );
void RefreshLineIds( int fileHandle );
int GetHiliteLine( int fhd, ulong seeklnr, const char **rbuf,
		   ushort *length, int *state, unsigned *flags);
int SetHiliteState( int fhd, ulong seeklnr, int state );

#if OS2 /* in file wedit8.c */
void CleanupPMClipBoard(void);
#endif

#if __cplusplus
}
#endif
#endif /* HDR_WFILE */
