/* [wkbddrv.h wk 26.7.91] W-Editor Keyboard driver defs
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /usr/src/master/apps/w/src/wkbddrv.h,v 1.8 1996/09/10 12:20:04 wk Exp $
 */

#ifndef HDR_WKBDDRV
#define HDR_WKBDDRV 1
#if __cplusplus
extern "C" {
#endif


/*** prototypes ***/

void KybrdDrvOpen( int mode );
void KybrdDrvSetTrans( int mode );
void KybrdDrvSetPrefix( char pref );
char KybrdDrvGetPrefix(void);
int KybrdDrvGetKeyId(int *);
int KybrdDrvDefKey(char *buf);
const char *KybrdDrvEnumKeyDef(int mode, int seq);

#ifdef __linux__
  #define USE_VT_LINUX 1
   /*-- vt_linux.c --*/
int  VTLinuxOpen(void);
int  VTLinuxOpenVCS( ushort *retX, ushort *retY );
int  VTLinuxGetCharSet(void);
void VTLinuxSetCharSet( int mode );
void VTLinuxClose(void);
int  VTLinuxReadScan( ushort *ret_scan, unsigned *ret_kstate );
unsigned VTLinuxGetKeyState(void);
int VTLinuxWait(void);
int VTLinuxPoll(void);
int VTLinuxGetScreenSize( int fd, ushort *x, ushort *y );
int VTLinuxSwitchConsole( int no );
#endif

#if __cplusplus
}
#endif
#endif /* HDR_WKBDDRV */
