/* [wpmdrv.c wk 06.05.93] GUI Driver for W
 *	Copyright (c) 1991-93 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 27.01.93 wk	C Set/2 Support
 * 06.05.93 wk	...
 */


#include "wtailor.h"
#define DBG_SCANCODES 0

#define USEBUFFER 1

#if !defined(OS20)
    #error This implementation is only for OS/2 v2.0
#endif
#define OS20_PM 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/lib.h>
#define INCL_ALT_KEYCODES 1
#include <wk/keys.h>
#include <wk/sema.h>

#define INCL_DOSPROCESS 1
#define INCL_KBD 1
#define INCL_WIN 1
#define INCL_VIO 1
#define INCL_AVIO 1
#define INCL_DOSDEVIOCTL 1
#define INCL_GPILCIDS 1
#include <os2.h>
#define INCL_WK_WSCRDRV_GUI 1

#include <wk/wscrdrv.h>
#include "wscrdrvi.h"

/****** constants **********/
#define MAX_AVIOKEYS 10

/******* types *************/
typedef struct {
	char c;
	char a;
    } cell_t;

typedef volatile cell_t *crtptr_t;

/******** globals **********/

#if USEBUFFER
static crtptr_t vioBuffer ;
#endif

DCL_SERIALIZE(startupGUISem);
HAB	hab;	 /* anchor block handle */

static struct {/* these are the local vars for the AvioWinProc */
    HPS hps;
    HVPS hvps;
    QMSG qmsg;
    HMQ hmq;
    HWND hwndFrame, hwndClient;
    TID  tidAvio;    /* thread ID of message loop */
    short cxChar, cxCaps, cyChar, cyDesc, cxClient, cyClient;
    HWND hwndHScroll, hwndVScroll;
    short posHScroll, posVScroll, maxHScroll, maxVScroll;
    short cxTextTotal;
    int shutdownInProgress;
} avio;

DCL_SERIALIZE(keyBufAccessSem);
static struct {
    MPARAM mp1, mp2;
} avioKeyBuf[MAX_AVIOKEYS]; /* type ahead buffer */
static volatile int avioKeyCnt;  /* number of keys in buffer */


static int isColor ;		  /* flag for color-mode */
static struct {
	int sx, sy, sxMul2;
	int x2, y2 ;
	int crsX, crsY ;
	int crsForm ;
	int crsActiv ;
	int size ;		  /*total size*/
	int buttons;		  /* # of mouse button s or 0 when no mouse*/
    } screen ;			  /* Screen Parameters*/


static struct {
	ushort cursorForm;
	int crsX, crsY;
	ushort orgScrSize;	    /* # of elem in orgScr */
	ushort orgScrRows;
	ushort orgScrCols;
	cell_t *orgScr; 	    /* area to save org Screen */
    } save ;			    /* save original screen Environment*/


static cell_t *image ;	   /* area to store the image */
static int translateCodes;

static volatile int *breakFlagAddr;


/********** prototypes *********/
static int AvioSetup(void);
static void AvioTerminate(void*);
#if __IBMC__
static void AvioThread( void *dummyParm );
#else
static void APIENTRY AvioThread(ulong);  /* executed by its own thread */
#endif
MRESULT EXPENTRY AvioWndProc( HWND, ULONG, MPARAM, MPARAM );
static int AvioInkey( ushort *rVkey, ushort *rVal,
		      ushort *rScan, ushort *rRpt, ushort *rFlags );

/*********** defined functions ********/
/*********** functions ****************/

/****************
 * Returns: 0 = standard color screen
 *	    1 = standard mono screen
 */


int ScrDrvOpen()
{
    int err=0, cols, rows, pages , i ;
    ushort r16;
    USHORT * _Seg16 vBuffer;
    ULONG vioBufferSize;


  #if DEBUG
    xassert( sizeof (cell_t) == 2 );
  #endif
    avio.hvps = 0;
    cols    = 80;   /* initial screen size */
    rows    = 25;
    isColor = 1;

    /**** Setup Screen Parameters ****/
    screen.sx = cols ;
    screen.sy = rows ;
    screen.sxMul2 = cols*2 ;
    screen.x2 = cols -1 ;
    screen.y2 = rows -1 ;
    screen.size = screen.sx * screen.sy ;
    if( !(image = calloc( screen.size, sizeof *image )) )
	{ err = -1; goto retlab ; }

    if( AvioSetup() )
	{ err = -1; goto retlab ; }

  #if USEBUFFER
    r16 = VioGetBuf( (PULONG)&vBuffer, (PUSHORT)&vioBufferSize, avio.hvps);
    if( r16 )
	Fatal("VioGetBuf=%d", r16);
    vioBuffer = (crtptr_t)vBuffer;
  #endif

    save.orgScrSize = screen.size;
    save.orgScrRows = screen.sy;
    save.orgScrCols = screen.sx;
    if( !(save.orgScr = malloc( save.orgScrSize * sizeof *save.orgScr)) )
	{ err = -1; goto retlab ; }
    ScrDrvMouseOn();
    ScrDrvSaveScreen();
    ScrDrvShowCrs( 1 ); /* initial painting of cursor */
    ScrDrvHideCrs();	/* and hide him */
    ScrDrvRepaint();	/* Sync with image */
    MouseShow();

  retlab:
    if( r16 )
	Error(4,"Can't open CRT: not enough core");
    return isColor ? 0 : 1;
}


void ScrDrvClose()
{
    AvioTerminate(NULL);
    ScrDrvRegBreakFlag( NULL );
    FREE( image );
    FREE( save.orgScr );
}


static int AvioSetup()
{
    ulong  osErr;

    /* Create an thread for the message loop and start the loop */
    avioKeyCnt = 0;
    avio.shutdownInProgress = 0;
    AddCleanUp( AvioTerminate, NULL );
    RESET_SEMAPHORE( startupGUISem );
  #if __IBMC__
    if( (avio.tidAvio = _beginthread( AvioThread, NULL, 8192, NULL)) == -1 )
	Error(4,"Error creating AvioThread" );
  #else
    if( osErr = DosCreateThread( &avio.tidAvio,
			 AvioThread,
			 0, /* parameter */
			 0, /* Immediate Execution, default stack initial. */
			 8192 )      )
	Error(4,"Error creating AvioThread: %ul", osErr );
  #endif

    WAIT_SEMAPHORE( startupGUISem );

    return 0;
}



/****************
 * Terminates the AVIO,
 */

static void AvioTerminate( void *dummy )
{
  #if 0
    ushort dmyPrty;

    if( DosGetPrty( PRTYS_THREAD, &dmyPrty, avio.tidAvio ) )
	return ; /* error received = Thread not running */
    WinPostMsg( avio.hwndFrame, WM_CLOSE, 0, 0 );
    if( !DosGetPrty( PRTYS_THREAD, &dmyPrty, avio.tidAvio ) )
	DosSleep(0); /* wait until thread has terminated */
  #endif
}


/****************
 * Gibt den Anchor Block Handle zuruekc (clipboard..)
 */

HAB ScrDrvGetActiveHAB(void)
{
    return hab;
}


#if __IBMC__
static void AvioThread( void *dummyParm )
#else
static void APIENTRY AvioThread( ulong dummyParm )
#endif
{
    static ULONG frameFlags = FCF_TITLEBAR | FCF_SYSMENU | FCF_MINMAX |
			      FCF_SIZEBORDER | FCF_SHELLPOSITION |
			      FCF_VERTSCROLL | FCF_HORZSCROLL |
			      FCF_TASKLIST ;
    static char clientClassName[] = "WPmDrvAvio";

    if( !(hab = WinInitialize(0)) )
	Error(4,"Error retrieving anchor block");
    if( !(avio.hmq = WinCreateMsgQueue(hab,0)) )
	Error(4,"Error creating message queue" );

    /* AvioWindProc nehmen anscheinen immer noch als msg USHORT
     * im Gegensatz zum normalen ULONG - siehe prototype am
     * Ende vom pmavio.h - deswegen der cast (wk 27.01.93)
     */
    if( !WinRegisterClass( hab, (PSZ)clientClassName,
			   AvioWndProc, CS_SIZEREDRAW, 0 ) )
	Error(4,"Error registering class `%s'", clientClassName );

    if( !(avio.hwndFrame = WinCreateStdWindow(
		    HWND_DESKTOP,   /* parent window handle */
		    WS_VISIBLE,     /* style of frame */
		    &frameFlags,    /* ptr to control data */
	       (PSZ)clientClassName,/* Client window class name */
	       (PSZ)CopyRight(15),  /* titlebar text */
		    0L, 	    /* style of client window */
		    NULL,	    /* module handle for resources */
		    0,		    /* ID of resources */
		    &avio.hwndClient ))) /* ptr to client window handle */
	Error(4,"Error creating main window" );
    if( !avio.hwndClient )
	Error(4,"Error creating client window" );

    {
	/* WC_LISTBOX */
	FONTMETRICS fm;
	HPS hps;
	HWND hwnd;
	static char avioFont[] = "10.System Monospaced";


	hwnd = avio.hwndClient;
	WinSetPresParam( hwnd, PP_FONTNAMESIZE,
			(ULONG)strlen(avioFont)+1, avioFont);

	hps = WinGetPS(hwnd);
	GpiQueryFontMetrics(hps, (long)sizeof(FONTMETRICS), &fm);
	WinReleasePS(hps);

	WinSendMsg( hwnd, LM_SETITEMHEIGHT,
		    (MPARAM)fm.lMaxBaselineExt, 0L);

    }


    /* tell other thread about working message queue */
    POST_SEMAPHORE( startupGUISem );
    for(;;) {
	while( WinGetMsg( hab, &avio.qmsg, NULL, 0, 0 ) )
	    WinDispatchMsg( hab, &avio.qmsg );
	if( WinMessageBox( HWND_DESKTOP, avio.hwndClient,
		    (PSZ)"\nDo you really want to exit this program ?\n",
			   (PSZ)CopyRight(15), 0,
			   MB_OKCANCEL | MB_ICONQUESTION) == MBID_OK )
	    break;  /* forloop */
	WinCancelShutdown(avio.hmq, FALSE );
    }
    avio.shutdownInProgress = 1;

    WinDestroyWindow( avio.hwndFrame );
    WinDestroyMsgQueue( avio.hmq );
    WinTerminate( hab );
  #ifndef __IBMC__
    DosExit(EXIT_THREAD, 0);
  #endif
}


MRESULT APIENTRY
AvioWndProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    HDC hdc;
    short row, inc, r16;
    int i;
    SIZEL  sizl;
    USHORT vioBufferSize;
    MENUITEM miSysMenu;
    HWND     hwndSysMenu, hwndSysSubMenu;
    short idSysMenu;

    switch( msg ) {
      case WM_CREATE:
	hdc = WinOpenWindowDC(hwnd);
	sizl.cx = sizl.cy = 0;
	avio.hps = GpiCreatePS(hab, hdc, &sizl, PU_PELS | GPIF_DEFAULT |
					     GPIT_MICRO | GPIA_ASSOC  );
	r16 = VioCreatePS( &avio.hvps, screen.sy, screen.sx, 0, 1, NULL );
	if( r16 )
	    Fatal("VioCreatePS=%d", r16);
	VioAssociate( hdc, avio.hvps );
	if( r16 )
	    Fatal("VioAssociate=%d", r16);

	r16 = VioGetDeviceCellSize( &avio.cyChar, &avio.cxChar, avio.hvps );
	if( r16 )
	    Fatal("VioGetDeviceCellSize=%d", r16);
	avio.hwndHScroll = WinWindowFromID( WinQueryWindow(hwnd, QW_PARENT),
							     FID_HORZSCROLL );
	avio.hwndVScroll = WinWindowFromID( WinQueryWindow(hwnd, QW_PARENT),
							     FID_VERTSCROLL );

	break;


      case WM_DESTROY:
	VioAssociate( NULL, avio.hvps );
	VioDestroyPS( avio.hvps );
      #if USEBUFFER
	vioBuffer = NULL;
      #endif
	GpiDestroyPS( avio.hps );
	break;


      case WM_SIZE:
	avio.cxClient = SHORT1FROMMP( mp2 );
	avio.cyClient = SHORT2FROMMP( mp2 );
	avio.maxHScroll =max( 0, screen.sx -1 );
	avio.posHScroll =min( avio.posHScroll, avio.maxHScroll );
	WinSendMsg( avio.hwndHScroll, SBM_SETSCROLLBAR,
			MPFROM2SHORT( avio.posHScroll, 0 ),
			MPFROM2SHORT( 0, avio.maxHScroll )  );
	WinEnableWindow( avio.hwndHScroll, avio.maxHScroll? TRUE : FALSE );
	avio.maxVScroll =max( 0, screen.sy-1 );
	avio.posVScroll =min( avio.posVScroll, avio.maxVScroll );
	WinSendMsg( avio.hwndVScroll, SBM_SETSCROLLBAR,
			MPFROM2SHORT( avio.posVScroll, 0 ),
			MPFROM2SHORT( 0, avio.maxVScroll )  );
	WinEnableWindow( avio.hwndVScroll, avio.maxVScroll? TRUE : FALSE );
	WinDefAVioWindowProc(hwnd, msg, (ULONG)mp1, (ULONG)mp2 );
	break;


      case WM_VSCROLL:
	switch( SHORT2FROMMP(mp2) ) {
	  case SB_LINEUP:
	    inc = -1;
	    break;
	  case SB_PAGEUP:
	    inc = min(-1, -avio.cyClient / avio.cyChar );
	    break;
	  case SB_SLIDERTRACK:
	    inc = SHORT1FROMMP( mp2 ) - avio.posVScroll;
	    break;
	  case SB_PAGEDOWN:
	    inc = min(1, avio.cyClient / avio.cyChar );
	    break;
	  case SB_LINEDOWN:
	    inc = 1;
	    break;
	  default:
	    inc = 0;
	    break;
	}
	inc = max( -avio.posVScroll, min( inc, avio.maxVScroll - avio.posVScroll));
	if( inc ) {
	    avio.posVScroll += inc;
	    VioSetOrg( avio.posVScroll, avio.posHScroll, avio.hvps );

	    WinSendMsg( avio.hwndVScroll, SBM_SETPOS,
			    MPFROM2SHORT(avio.posVScroll,0), NULL );
	    WinUpdateWindow(hwnd);
	}
	break; /* WM_VSCROLL */

      case WM_CHAR:
	if( CHARMSG(&msg)->fs & KC_KEYUP )
	    ;
	else if( CHARMSG(&msg)->fs & KC_INVALIDCHAR )
	    ;
	else if( CHARMSG(&msg)->fs & KC_INVALIDCOMP )
	    ;
	else if( (CHARMSG(&msg)->fs & KC_VIRTUALKEY) &&
		  CHARMSG(&msg)->vkey == VK_BREAK && breakFlagAddr )
	    *breakFlagAddr = 1;
	else if( avioKeyCnt+1 < MAX_AVIOKEYS ) {
	    if( BEGIN_SERIALIZE2( keyBufAccessSem, 80 ) )
		return 0;     /* do not violate 1/10 second rule !*/
	    avioKeyBuf[avioKeyCnt].mp1 = mp1;
	    avioKeyBuf[avioKeyCnt].mp2 = mp2;
	    avioKeyCnt++;
	    /*POST_SEMAPHORE( eventOccuredSem );*/
	    END_SERIALIZE( keyBufAccessSem );
	}
	else  /* buffer overflow */
	    WinAlarm( HWND_DESKTOP, WA_NOTE );
	break;


      case WM_COMMAND:
	switch( COMMANDMSG(&msg)->cmd ) {
	  case IDM_ABOUT:
	    WinMessageBox( HWND_DESKTOP, hwnd,
		    (PSZ)"\nA fine program - Isn't it ?\n",
			   (PSZ)CopyRight(15), 0,
			   MB_OK | MB_ICONASTERISK);

	    break;

	  case IDM_HELP:
	    WinMessageBox( HWND_DESKTOP, hwnd,
			   (PSZ)CopyRight(12),
			   (PSZ)CopyRight(15), 0,
			   MB_OK | MB_ICONASTERISK);

	    break;

	  case IDM_FONT:
	    WinMessageBox( HWND_DESKTOP, hwnd,
			   (PSZ)"Font switching not yet implemented",
			   (PSZ)CopyRight(15), 0,
			   MB_OK | MB_ICONEXCLAMATION);

	    break;
	}
	break;


      case WM_PAINT:
	WinBeginPaint(hwnd, avio.hps, NULL );
	GpiErase(avio.hps);
	VioShowBuf(0, screen.size*2, avio.hvps );
	WinEndPaint(avio.hps);
	break; /* WM_PAINT */

      default: return WinDefAVioWindowProc( hwnd, msg, (ULONG)mp1, (ULONG)mp2 );
    }
    return 0;
}






/****************
 *  enables or disables code translation
 */

void ScrDrvCodeTrans( int mode )
{
    translateCodes = mode ;
}

void ScrDrvRegBreakFlag( volatile int *flag )
{
    breakFlagAddr = flag;
}




void ScrDrvQrySize( int *x, int *y )
{
    *x = screen.sx ;
    *y = screen.sy ;
}


void ScrDrvSetCrs( int x, int y )
{
    screen.crsY=y;
    screen.crsX=x ;
    if( screen.crsActiv )
	/* post notification to set cursor.... */;
}


void ScrDrvHideCrs()
{
    screen.crsActiv = 0 ;
    /* hide cursor ... */
}

void ScrDrvMouseOn()
{
    screen.buttons = 2; /* einfach mal 2 kneppe annehmen */
}


void ScrDrvMouseOff()
{
    screen.buttons = 0;
}


void ScrDrvShowCrs( int form )
{
    if( form == screen.crsForm )
	;
    else if( form == 1 ) {
	screen.crsForm = 1 ;
	/* notifiy wndproc ... */
    } else if( form == 2 ) {
	screen.crsForm = 2 ;
	/* notifiy wndproc ... */
    }
    screen.crsActiv = 1 ;
    WKBiosSetCursorPos( 0, screen.crsY, screen.crsX ) ;
    /* notifiy wndproc ... */
}


void ScrDrvSaveScreen()
{
    /* thats now GUIs task */
}


void ScrDrvRestScreen()
{
    /* thats now GUIs task */
}



void ScrDrvShow()
{
    VioShowBuf( 0, screen.size*2, avio.hvps);
}


void ScrDrvRepaint()
{
    /* thats now GUIs task */
}



/****************
 * Query the Mouse
 * Returns: Number of Buttons or 0 if no Mouse available in this screen Area
 */

int ScrDrvQryMouse( int *btn, int *px, int *py )
{
    *btn = 0;	/* .... get from WndProc */
    *px = 0;
    *py = 0;
    return screen.buttons;
}


void ScrDrvReadCell( int x, int y, int *c, int *a )
{
    int i;

    i = y * screen.sx + x ;
    if( i >= 0 && i < screen.size ) {
	*c = translateCodes ? MapIbm2Iso( image[i].c, 1 ) : image[i].c;
	*a = image[i].a;
    }
}


void ScrDrvWriteCell( int x, int y, int c, int a )
{
    int i;

  #if USEBUFFER
    if( !vioBuffer )
	return;
  #endif
    i = y * screen.sx + x ;
    if( c & 0x80 )
	if( translateCodes )
	    c = MapIso2Ibm(c,1);
    if( i >= 0 && i < screen.size ) {
	if( image[i].c != c || image[i].a != a ) {
	    image[i].c = c ;
	    image[i].a = a ;
	  #if USEBUFFER
	    vioBuffer[i] = image[i];
	  #else
	    VioWrtCellStr( (PCH)&image[i], 2, i/screen.sx, i%screen.sx,avio.hvps) ;
	  #endif
	}
    }
}


void ScrDrvWriteStr( int x, int y, const char *buf, size_t len, int a )
{
    int i, c;

  #if USEBUFFER
    if( !vioBuffer )
	return;
  #endif
    i = y * screen.sx + x ;
    if( i >= 0 )
	for( ; len && i < screen.size; len--, i++, buf++ ) {
	    c = *buf;
	    if( c & 0x80 )
		if( translateCodes )
		    c = MapIso2Ibm(c,1);
	    if( image[i].c != c || image[i].a != a ) {
		image[i].c = c ;
		image[i].a = a ;
	      #if USEBUFFER
		vioBuffer[i] = image[i];
	      #else
		VioWrtCellStr( (PCH)&image[i], 2, i/screen.sx, i%screen.sx,avio.hvps);
	      #endif
	    }
	}
}


/****************
 * Einen String der laenge len ausgeben und rechts mit blanks
 * bis auf laenge maxlen auffuellen. Attribute werden nicht geschrieben.
 * der String wird aber nur solange ausgegeben bis auch maxlen erreicht ist;
 * nur ein eventuell kuerzerer String wird mit blanks aufgefuellt.
 */

void ScrDrvWriteStrFill( int x, int y, const char *buf,
			 size_t len, size_t maxlen )
{
    int i, c;

  #if USEBUFFER
    if( !vioBuffer )
	return;
  #endif
    i = y * screen.sx + x ;
    if( i >= 0 ) {
	for( ; maxlen && len && i < screen.size; len--, maxlen--,i++, buf++ ) {
	    c = *buf;
	    if( c & 0x80 )
		if( translateCodes )
		    c = MapIso2Ibm(c,1);
	    if( image[i].c != c ) {
		image[i].c = c ;
	      #if USEBUFFER
		vioBuffer[i] = image[i];
	      #else
		VioWrtCellStr( (PCH)&image[i], 2, i/screen.sx, i%screen.sx,avio.hvps);
	      #endif
	    }
	}
	for( ; maxlen && i < screen.size; maxlen--,i++ ) {
	    if( image[i].c != ' ' ) {
		image[i].c = ' ' ;
	      #if USEBUFFER
		vioBuffer[i] = image[i];
	      #else
		VioWrtCellStr( (PCH)&image[i], 2, i/screen.sx, i%screen.sx,avio.hvps);
	      #endif
	    }
	}
    }
}



void ScrDrvWriteNChar( int x, int y, int c, int a, size_t n )
{
    int i;

  #if USEBUFFER
    if( !vioBuffer )
	return;
  #endif
    i = y * screen.sx + x ;
    if( c & 0x80 )
	if( translateCodes )
	    c = MapIso2Ibm(c,1);
    if( i >= 0 )
	for( ; n && i < screen.size; n--, i++ ) {
	    if( image[i].c != c || image[i].a != a ) {
		image[i].c = c ;
		image[i].a = a ;
	      #if USEBUFFER
		vioBuffer[i] = image[i];
	      #else
		VioWrtCellStr( (PCH)&image[i], 2, i/screen.sx, i%screen.sx,avio.hvps) ;
	      #endif
	    }
	}
}


/****************
 * Nur Attribute schreiben
 */

void ScrDrvWriteNAttr( int x, int y, int a, size_t n )
{
    int i;

  #if USEBUFFER
    if( !vioBuffer )
	return;
  #endif
    i = y * screen.sx + x ;
    if( i >= 0 )
	for( ; n && i < screen.size; n--, i++ ) {
	    if( image[i].a != a ) {
		image[i].a = a ;
	      #if USEBUFFER
		vioBuffer[i] = image[i];
	      #else
		VioWrtCellStr( (PCH)&image[i], 2, i/screen.sx, i%screen.sx,avio.hvps) ;
	      #endif
	    }
	}
}



/****************
 * Mode = 1 : Put Crt into Pause Mode
 *	  0 : Restore CRT if CRT  is in Pause Mode
 */

void ScrDrvPauseCrt( int mode )
{
}




/****************
 * Ermittelt die aktuellen Togglekey states:
 * Bit 0 = Scroll Lock
 *     1 = Num Lock
 *     2 = Caps Lock
 */

unsigned ScrDrvGetToggleKeys()
{
    unsigned state;
    KBDINFO kbi;

    state = 0;
    kbi.cb = sizeof kbi;
    if( !KbdGetStatus( &kbi, 0 ) )
	state = (kbi.fsState >> 4) & 0x07;
    return state;
}


/****************
 * Get the scancode, the value, and the status;
 * look at the mouse buttons.
 * when a mouse buuton is hit, K_FLAG_MOUSE is set in flags
 * and rVal contains the keycode K_BTN_xxxxx
 *
 * Returns wether a keyvalue is available or not
 */

int
ScrDrvBasicInkey( ushort *rVal, ushort *rScan, unsigned *rFlags )
{
    ushort flags, chr, scan;
    int any=0, i;

    chr = scan = flags = 0;

    if( !avioKeyCnt )  /* ...entfernen, und hier auf event warten */
	return 0;

    /* Wait for event */
    /* WAIT_SEMAPHORE( eventOccuredSem ) */
    BEGIN_SERIALIZE( keyBufAccessSem );
      /*RESET_SEMAPHORE( eventOccuredSem );*/
    if( avioKeyCnt ) {
	/* get the first one and shift the rest */
	flags = SHORT1FROMMP(avioKeyBuf[0].mp1);
	/*rpt	= CHAR3FROMMP(avioKeyBuf[0].mp1);*/
	scan  = CHAR4FROMMP(avioKeyBuf[0].mp1);
	chr   = SHORT1FROMMP(avioKeyBuf[0].mp2);
	/*vkey	= SHORT2FROMMP(avioKeyBuf[0].mp2);*/
	for(i=1; i < avioKeyCnt; i++ )
	    avioKeyBuf[i-1] = avioKeyBuf[i];
	avioKeyCnt--;
	any++; /* flag, that we got a keycode to examine */
    }
    END_SERIALIZE( keyBufAccessSem );
    if( !any )
	return 0;

    *rVal  = chr;
    *rScan = scan;
    *rFlags =flags;
    return 1;
}




/****************
 * Brauchen wir hier nicht mehr (war bei MSDOS notwendig)
 */

void ScrDrvPoll(void)
{
}


/**** end of file ***/
