/* [wscreen.h wk 3.7.91] Defs for Screen Kit
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * This file is part of the W-Editor.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /vol1/src/master/apps/w/src/wscreen.h,v 1.6 1996/05/17 18:49:50 wernerk Exp $
 */

#ifndef HDR_WSCREEN
#define HDR_WSCREEN 1
#if __cplusplus
extern "C" {
#endif

void MakeScreen( int,int );
void ScreenSetTrans( int mode );
void LockTextUpdate( int );
void RedrawScreen(void);
void RemoveScreen(void);
void EndRemoveScreen(void);
void BindScreen(  int fHd );
void UpdateWindowTitle( int fHd );
void BindSupplementaryScreen( int fhd );
void UpdateScreen(void);
void IdleScreen( int mode );
void ShowMessage( const char *frmt, ... );
void ShowMessageAsInfo( const char *frmt, ... );
void GetScreenSize( int *sx, int *sy );
int QryScreenFile(void);
int QrySupplementaryScreenFile(void);
ushort GetCmdLineLen(void);
#if MSDOS || DOS386 || DOS16RM
void ShowMessageViaBios( const char *s, ... );
#endif
int ScreenMousePos( int *btn, ulong *retlnr, ushort *retpos );
void ScreenAutoMark(void);
int ScreenQryMenuID( int x, int y );
int ScreenChangeLayout(int);
int ScreenChangeColors( const char *);
const char *GetScreenColorDef( int n );
int ScreenQryCodeTrans(void);

#if __cplusplus
}
#endif
#endif /* HDR_WSCREEN */
