/* [wk/dabf.h wk 15.5.92] Defs for dataBuffers
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Id: dabf.h,v 1.4 1995/03/08 16:49:54 wk Exp $
 */

#ifndef HDR_WK_DABF
#define HDR_WK_DABF 1
#ifndef HDR_WK_LIB
    #include <wk/lib.h>
#endif
#include <stdarg.h>  /* for typedef of va_list */

#if __cplusplus
extern "C" {
#endif

/****** constants ******/
    /* Errorcodes */
#define E_DABF_NOMEM  1 /* not enough memory */
#define E_DABF_INVARG 2 /* invalid argument */
#define E_DABF_NOHD   3 /* no more handles or handle not in use */
#define E_DABF_INVHD  4 /* not a valid handle */

    /* notify reasons */
#define DABF_N_CREATE  1
#define DABF_N_CLOSE   2
#define DABF_N_DATA    3    /* new data */
#define DABF_N_CHAR    4    /* for terminal: new char/attr received */
			    /* Format of Notify call:		    */
			    /* (hd,reason, ushort x, ushort y,	    */
			    /*		   dabfAttr_t a, byte c)    */
#define DABF_N_SCROLL  5    /* for terminal: scroll up */
#define DABF_N_CLS     6    /* for terminal: clear screen */
			    /* Same parameters as in ..N_CHAR */
			    /* but only a is used */
#define DABF_N_CLEL    7    /* for terminal: clear to end of line */
			    /* Same parameters as in ..N_CHAR */
#define DABF_N_CRSPOS  8    /* for terminal: position of cursor changed*/
			    /* parameters are: .. ushort x, ushort y */

    /* flags */
#define DABF_F_ATTR    1    /* use attributes */

    /* buffer types */
#define DABF_T_STD     0    /* standard buffer type */
#define DABF_T_ANSI    1    /* ANSI Terminal like buffer type */


typedef struct {
	unsigned fore: 3;  /* 0=black, 1=red, 2=green, 3=yellow */
	unsigned back: 3;  /* 4=blue, 5=magenta, 6=cyan, 7=white */
	unsigned bold: 1;
	unsigned faint:1;
	unsigned italic:1;
	unsigned blink:1;
	unsigned rblink:1;    /* rapid blink */
	unsigned reverse:1;
	unsigned concealed:1;
	unsigned reserved: 4;
    } dabfAttr_t;

/****** prototypes *****/
int DaBfGetInfo( int hd, int *type, unsigned *flags, long *size );
void *DaBfAppData( int hd, const void *appData );
int DaBfRegisterNotify( void (*fnc)(int,int, ...) );
void DaBfDeRegisterNotify( int hd );
int DaBfCreate( int *retHd, int type, unsigned flags, long size );
int DaBfClose( int hd );
int DaBfGetLines( int hd, const char **retArray, ushort arraySize,
		  int mode, long offset );
int DaBfGetALines( int hd, const char **retArray,
		   const dabfAttr_t **retAttr, ushort arraySize,
		       int mode, long offset );
void DaBfUnlockPtrs( const void **array );
int DaBfPutString( int hd, const char *string );
int DaBfPrintf( int hd, const char *format, ... );
int DaBfVprintf( int hd, const char *format, va_list args);
int DaBfPutChar( int hd, int c);
int DaBfPutCtrlString( int hd, const char *str);


/***********************/

#if __cplusplus
}
#endif
#endif /* HDR_WK_DABF */
