/* [wk/environ.h wk 6.2.91] Defs for Environment
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Header: /vol1/src/master/libs/wk/environ.h,v 1.9 1995/03/30 12:12:39 wernerk Exp $
 */

#ifndef HDR_WK_ENVIRON
#define HDR_WK_ENVIRON 1
#ifndef HDR_WK_LIB
    #include <wk/lib.h>
#endif

#if __cplusplus
extern "C" {
#endif

/***** protos ******/

    /*-- srchenv.c --*/
char *SearchEnv( const char *, const char *, char *);
    /*-- srchcmd.c --*/
int SearchCommand( char * );
    /*-- codepg.c --*/
int QryActiveCodePage(void);
int SetActiveCodePage(int);
byte MapIso2Ibm(byte,int);  /* Map ISO 8859-1 CodeSet to IBM CodePage 850 */
byte MapIbm2Iso(byte,int);  /* Map IBM CodePage 850 to ISO 8859-1 CodeSet */
    /*-- codepg2.c --*/
byte MapEbcdic2Ibm( byte c, int dialect );
byte MapIbm2Ebcdic( byte c, int dialect );
    /*-- environ.c --*/
const char *GetEnvironmentStrings(void);
    /*-- loadmod.c --*/
void *WKLoadModule(const char *modName, const char *fncName, int *errCode );
    /*-- time1.c --*/
void Wklib_registerYield( int mode, void (*f)(void) );
    /*-- dskspace.c --*/
ulong QryAvailableDiskSpace(void);

#if __cplusplus
}
#endif
#endif /* HDR_WK_ENVIRON */
