/* [wk/sgmlhl.h wk 23.04.96]
 *	Copyright (c) 1996 by Werner Koch (dd9jn)
 *  This file is part of SGMLHL, the SGML Handling Library.
 *
 *  SGMLHL is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  SGMLHL is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with SgmlHL; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *
 * $Id: sgmlhl.h,v 1.3 1996/07/16 10:33:47 wernerk Exp $
 */


#ifndef HDR_WK_SGMLHL
#define HDR_WK_SGMLHL
#include <wk/lib.h>	/* Of cource we need the WkLib */


typedef struct struct_SGMLHL *SGMLHL;	/* the handle */

#ifndef MODULE_DEFINES_STRUCT_SGMLHL
struct struct_SGMLHL { char does_not_matter[1]; };
#endif

/* Errorcodes */
#define ESGMLHL_GENERAL 	1
#define ESGMLHL_OUT_OF_CORE	2
#define ESGMLHL_INV_VALUE	3
#define ESGMLHL_INV_HANDLE	4
#define ESGMLHL_OUT_OF_HANDLES	5
#define ESGMLHL_OPEN_FILE	6
#define ESGMLHL_CLOSE_FILE	7
#define ESGMLHL_READ_FILE	8

/* Stopcodes */
#define SGMLHL_STOP_TAGC 1	/* stop after closing tag */
#define SGMLHL_STOP_TAG  2	/* stop at tags */
#define SGMLHL_STOP_ETAG 4	/* stop at end-tags */
#define SGMLHL_STOP_COM  8	/* stop at comments */
#define SGMLHL_STOP_ER	 16	/* stop at ERs */
#define SGMLHL_STOP_PER  32	/* stop at PERs */
#define SGMLHL_STOP_ATTR 64	/* stop at attributes */
#define SGMLHL_STOP_LF	 128	/* stop at linefeeds */
#define SGMLHL_STOP_MS	 256	/* stop at marked sections */

/* Stopreasons */
#define SGMLHL_EOF	   1 /* end of file */
#define SGMLHL_BUF_FULL    2 /* the buffer is full */
#define SGMLHL_LF	   3

#define SGMLHL_STAGO	   5 /* start tag open*/
#define SGMLHL_ETAGO	   6 /* end tag open */
#define SGMLHL_MDO	   7 /* markup declaration open */
#define SGMLHL_PIO	   8 /* processing instruction open */
#define SGMLHL_TAGC	   9 /* tag/MD/PI close */
#define SGMLHL_COMO	  10 /* comment open */
#define SGMLHL_COMC	  11 /* comment close */
#define SGMLHL_MSB	  12 /* marked section begin */
#define SGMLHL_MSE	  13 /* marked section end   */
#define SGMLHL_MSC	  14 /* marked section close */

/*-- sgmlpars.c --*/
const char *SgmlHLStrError( int rc );
int SgmlHLOpenFile( SGMLHL *ret_hd, const char *filename, const char *mode );
int SgmlHLOpenString( SGMLHL *ret_hd, const char *string, const char *mode );
int SgmlHLOpenBuffer( SGMLHL *ret_hd, const char *buffer, size_t length,
							  const char *mode );
int SgmlHLClose( SGMLHL hd );
int SgmlHLParse( SGMLHL hd, char *buffer, size_t buflen,
		 unsigned stopflags, int *stopreason, size_t *nbytes  );
ulong SgmlHLQueryPos( SGMLHL h, int which );
int SgmlHLParseToTag( SGMLHL h, char *buffer, size_t buflen, int *reason,
		      const char *tag );

int SgmlHLTestTag( const char *buffer, const char *tag );

#endif /* HDR_WK_SGMLHL */
