/* [strgbuf.h wk 13.07.93] String Buffer Package
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Id: strgbuf.h,v 1.6 1995/03/08 16:51:49 wk Exp $
 * History:
 * 05.08.93 wk	New layout of structure and more macros
 */

#ifndef HDR_WK_STRGBUF
#define HDR_WK_STRGBUF 1
#ifndef HDR_WK_LIB
    #include <wk/lib.h>
#endif

#if __cplusplus
extern "C" {
#endif


typedef struct {
    size_t reserved;
    size_t siz;     /* allocated length of bufferOne -1 */
    size_t len;     /* current length */
    size_t rptr;
    size_t chunk;
    size_t savelen;
    char **arr;     /* malloced pointer array oder NULL */
    char *p;	    /* malloced buffer */
} strgbuf_t;


strgbuf_t *AllocStrgbuf( size_t initial );
void GrowStrgbuf( strgbuf_t *a );
void FreeStrgbuf( strgbuf_t *a );
char **GetStrgbufArray( strgbuf_t *a );
void AppStrgbuf( strgbuf_t *a, const char *s );

#define PutStrgbuf(a,c) do { if( (a)->len >= (a)->siz ) GrowStrgbuf(a); \
			     (a)->p[(a)->len++] = (c); } while(0)
#define FREEStrgbuf(a) do { FreeStrgbuf(a); (a) = NULL; } while(0)
#define ClearStrgbuf(a) do { (a)->len = (a)->rptr = 0; } while(0)
#define RewindStrgbuf(a) do { (a)->rptr = 0; } while(0)
#define GetStrgbuf(a)	 ((a)->rptr < (a)->len ? (a)->p[(a)->rptr++] : -1 )
#define WriteStrgbuf(a,f)  do { if( (a)->rptr < (a)->len )     \
				    if( fwrite( (a)->p + (a)->rptr,\
					(a)->len-(a)->rptr, 1 , (f) ) == 1) \
					   (a)->rptr = (a)->len; \
			   } while(0);
#define StrgbufLen(a)	  ((a)->len)
#define StrgbufPtr(a)	  ((a)->p)  /* use with care! */


#if __cplusplus
}
#endif
#endif /* HDR_WK_STRGBUF */
