/* [string.h wk 2.6.88] Defs for String and Buffer manipulation
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Id: string.h,v 1.21 1996/08/28 13:21:23 wk Exp $
 * History:
 * 31.01.93 wk	added C Set/2 support
 * 16.01.95 wk	added base-64 support
 */

#ifndef HDR_WK_STRING
#define HDR_WK_STRING 1
    #include <stdio.h>	/* FILE */
    #include <string.h>
    #include <wk/lib.h>
#ifdef __GNUC__    /* needed for the inline functions */
    #include <ctype.h>
#endif

#if __cplusplus
extern "C" {
#endif

/******* prototypes ********/
    /*-- strg1.c ---*/
char *mem2str( char *, const void *, size_t);
char *IdentStr( char *s );
    /*-- strg2.c ---*/
char *StripWSpaces( char * );
char *StripLeadingWSpaces( char * );
char *StripTrailingWSpaces( char * );
int  AreWSpaces( const char *);
    /*-- strg3.c ---*/
char *nstrtok( char * , char *, char **);
    /*-- strg4.c ---*/
char *StrNShift( char *, int, unsigned );
char *stristr( const char *, const char * );
char *StrNRepl( char *, const char *, unsigned, unsigned );
    /*-- strg4b.c ---*/
char *MemStr( const char*, const char*, size_t);
    /*-- strg5.c ---*/
size_t InsertTabs( char *, size_t);
size_t InsertTabs2( char *, size_t);
    /*-- strg6.c --- (ANSI support; use strcmpl(), memicmp() ) */
int StrICmp( const char *a, const char *b );
int MemICmp( const char *a, const char *b, size_t n );
int strnicmp( const char *a, const char *b, size_t n );
#if __IBMC__ || __MSC__ || __WATCOMC__ || __DECC || (HPUX && !__GNUC__)
  char *stpcpy(char *,const char *);
#endif
#if (HPUX || VMS) && !__GNUC__
  char *strupr(char*);
  char *strlwr(char*);
#endif
#if __DECC || (HPUX && !__GNUC__)
  char *strset(char*a, int c);
#endif
    /*-- strg7.c --- */
int StrCmpNTS( const char *a, const char *b ); /* .. no trailing white spaces*/
size_t StrLenNTS( const char *s);   /* len w/o trailing white spaces */
    /*-- strg9.c --- */
size_t StrCountChr( const char *s, int c );
    /*-- strg10.c --- */
size_t ConvertToBase64( char *buffer, const void *src, size_t srclen );
size_t ConvertFromBase64( void *buffer, const char *string );
size_t FWriteFromBase64( FILE *fp, const char *string );
int CheckBase64String( const char *string );
    /*-- strg11.c --*/
char **StringToArray( char *string, int options );

    /*-- atoxn.c ---*/
long Atoln(const char *string, size_t n);

/******** defined functions *********/
#if __GNU_LIBRARY__ || GNU_C_LIB_OS2 || EMX || ( HPUX && __GNUC__ )

#ifdef __GNUC__
#ifndef EMX
static inline char *strlwr(char *s)
{
    char *p;
    for(p=s; *p; p++ )
	*p = tolower(*p);
    return s;
}
static inline char *strupr(char *s)
{
    char *p;
    for(p=s; *p; p++ )
	*p = toupper(*p);
    return s;
}

static inline char *strrev(char *a)
{
    char *p1,*p2;

    p1 = a;
    p2 = a + strlen(a) - 1;
    while( a < p2 ) {
	*a   ^= *p2;	    /* swap the bytes (funny trick) */
	*p2  ^= *a;
	*a++ ^= *p2--;
    }
    return p1;
}
static inline char *strset(char *a, int c)
{
    char *p;
    for(p=a; *p; p++ )
	*p = c;
    return a;
}
#endif /* !EMX */
#ifdef HDR_WK_HAVE_STPCPY_KLUDGE
  #undef stpcpy
#endif
static inline char *stpcpy(char *a,const char *b)
{
    while( *b )
	*a++ = *b++;
    *a = 0;
    return a;
}
#else
char *strlwr( char *);
char *strupr( char *);
char *stpcpy(char *,const char *);
#endif
#endif	/* GNU_C_LIB */

#define ATOI_1( p )   ( isdigit(*(p)) ? *(p) - '0' : 0 )
#define ATOI_2( p )   (( ATOI_1(p) * 10) + ATOI_1( (p)+1 ))
#define ATOI_4( p )   (( ATOI_2(p) * 100) + ATOI_2( (p)+2 ))


#if __STDC__
  #define strcmpl(a,b) StrICmp((a),(b))
  #define stricmp(a,b) StrICmp((a),(b))
  #define memicmp(a,b,n) MemICmp((a),(b),(n))
#elif __IBMC__
  #define strcmpl(a,b) stricmp((a),(b))
#elif !__MSC__
  #define stricmp(a,b) strcmpl((a),(b))
#endif


#define STRINGSTRING(a) STRING(a) /* does not work with ZTC; a known bug */

#if __cplusplus
}
#endif

#endif /* HDR_WK_STRING */
