/* [wk/tailor.h wk 23.06.93] Tailoring files for different machines
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Id: tailor.h,v 1.21 1996/08/28 13:21:23 wk Exp $
 */

#ifndef HDR_WK_TAILOR
#define HDR_WK_TAILOR 1
#ifdef HDR_WK_LIB
    #error This should be the very first include file in any source
#endif


#if defined(__linux__)
    #define _GNU_SOURCE 1
    #include <features.h> /* define _POSIX_SOURCE etc. */
    #ifndef UNIX
      #define UNIX 1
    #endif
    #define POSIX 1
#elif defined(__hpux)
    #ifndef HPUX
      #define HPUX 1
    #elif !HPUX
      #undef HPUX
      #define HPUX 1
    #endif

#define _INCLUDE_POSIX_SOURCE	/* HP Compiler needs this */
#define _INCLUDE_XOPEN_SOURCE	/* and this */
#define _INCLUDE_HPUX_SOURCE  /* need this too */
#define _POSIX_SOURCE 1
    #define POSIX 1

#define ltoa ltoa_orig_hp	/* map HP function to this name */

#elif defined(__WATCOMC__)
    #ifdef __WINDOWS__
       #define MSDOS 1
       #define MSDOS_WINDOWS 1
    #endif
    #if MSDOS_WINDOWS && !defined(__SW_ZU)
      #error Watcom switch -zu should be defined
    #endif
#elif EMX
#elif !defined(_POSIX_SOURCE)
    #define _POSIX_SOURCE 1
    #define POSIX 1
#endif

#ifdef _POSIX_SOURCE
  #if !_POSIX_SOURCE
    #undef _POSIX_SOURCE
    #define _POSIX_SOURCE 1
  #endif
  #ifndef _POSIX_C_SOURCE
     #define _POSIX_C_SOURCE 199309
  #endif
  #if !POSIX
    #define POSIX 1
  #endif
#endif

#ifndef WK_CPU
  #ifdef __linux__
    #define WK_CPU     "i386"
    #define WK_COMPANY "gnu"
    #define WK_SYSTEM  "linux"
  #elif defined(EMX) && defined(OS20)
    #define WK_CPU     "i386"
    #define WK_COMPANY "emx"
    #define WK_SYSTEM  "os2"
  #elif defined(_POSIX_SOURCE)
    #ifdef __alpha
      #define WK_CPU   "alpha"
    #else
      #define WK_CPU   "unknown"
    #endif
    #ifdef __DECC
       #define WK_COMPANY "dec"
    #else
       #define WK_COMPANY "unknown"
    #endif
    #ifdef __VMS
      #define WK_SYSTEM "vmsposix"
    #else
       #define WK_SYSTEM  "posix"
    #endif
  #else
    #define WK_CPU     "unknown"
    #define WK_COMPANY "unknown"
  #endif
#endif
#ifndef WK_COMPANY
  #define WK_COMPANY "unknown"
#endif
#ifndef WK_SYSTEM
  #define WK_SYSTEM "unknown"
#endif


#ifdef DEBUG
  #if !DEBUG
    #undef  DEBUG
    #define DEBUG 1
  #endif
  #if !MEM_DEBUG
    #undef  MEM_DEBUG
    #define MEM_DEBUG 1
  #endif
  #define RCSID(a) /* I never used this: static const char _rcsid[]=a; */
#else
  #define RCSID(a)
#endif

#if defined(__GNUC__) && defined(__linux__)
  /* there is a prototype for stpcpy() but the function is not */
  /* in the library, so we use the inline function in wk/string.h */
  /* put to suppress compiler warnings, we have to redefine the function */
  #define stpcpy stpcpy_missing_in_lib
  #define HDR_WK_HAVE_STPCPY_KLUDGE 1
#endif


#endif /* HDR_WK_TAILOR */
