/* [atoxn.c wk 12.9.92] extended atox functions
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: atoxn.c,v 1.5 1995/03/08 16:53:33 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/string.h>


/****************
 * Wie atol() aber max. scanlaenge ist auf n begretzt
 */

long Atoln(const char *string, size_t n)
{
    long val;
    int neg;

    val = 0; neg = 0;
    for( ;n ; n--, string++ )
	if( !isspace(*(const byte*)string) )
	    break;
    if( n ) {
        if( *string == '+') {
	    string++;
	    n-- ;
	}
        else if( *string == '-' ) {
	    neg++;
	    string++;
	    n-- ;
	}
	for( ; n ; n--, string++ )
	    if( isdigit(*(const byte*)string) )
                n = n*10 + (*string - '0');
	    else
		break;
    }
    return neg ? -n : n;
}



/***** bottom of file ******/
