/* [chkposix.c wk 27.11.95]
 *   Testen der POSIX Optionen
 * Siehe hierzu:
 *  - Lewine, Donald. The POSIX Programmers's Guide.
 *    O'Reilly & Associates. ISBN 0-937175-73-0
 *  - Gallmeister, Bill O. POSIX.4 Programming for the Real World
 *    O'Reilly & Associates. ISBN 1-56592-074-0.
 */

#define _POSIX_SOURCE
#define _POSIX_C_SOURCE 199309L
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>


static int glo_argc;
static char **glo_argv;

#ifdef _POSIX_VERSION /* posix.1 */
#include <limits.h>

const char *CheckFile( int index, int *result, int name )
{
    if( index >= glo_argc )
	return NULL;
    errno = 0;
    *result = pathconf(glo_argv[index], name );
    return glo_argv[index];
}


void DoSysconf( int mode, const char *name, int n1, int n2 )
{
    long s = sysconf(n2);
    if( mode )
	printf( "%s = %ld  ", name, n1 );
    else
	printf( "%s [undefined]  ", name );
    if( s == -1 )
	printf( "sysconf: [undefined]\n", s );
    else
	printf( "sysconf: %ld\n", s );
}

void DoPathconf( const char *filename, const char *name, int n )
{
    long s;

    printf("\t%s: %s ", filename, name);
    errno = 0;
    s  = pathconf(name, n);
    if( s == -1 && errno )
	printf("[error: %s]\n", strerror(errno) );
    else if( s == -1 )
	printf("[no limit]\n");
    else
	printf( "= %ld\n", s );
}

void Posix1(void)
{
    int i;

    puts("\nLooking at POSIX.1:");
  #ifdef ARG_MAX
    DoSysconf(1,"ARG_MAX", ARG_MAX, _SC_ARG_MAX);
  #else
    DoSysconf(0,"ARG_MAX",       0, _SC_ARG_MAX);
  #endif
  #ifdef _POSIX_CHILD_MAX
    DoSysconf(1,"CHILD_MAX", _POSIX_CHILD_MAX, _SC_CHILD_MAX);
  #else
    DoSysconf(0,"CHILD_MAX",                0, _SC_CHILD_MAX);
  #endif
  #ifdef CLK_TCK
    DoSysconf(1,"CLK_TCK", CLK_TCK, _SC_CLK_TCK);
  #else
    DoSysconf(0,"CLK_TCK",       0, _SC_CLK_TCK);
  #endif
  #ifdef _POSIX_NGROUPS_MAX
    DoSysconf(1,"NGROUPS_MAX", _POSIX_NGROUPS_MAX, _SC_NGROUPS_MAX);
  #else
    DoSysconf(0,"NGROUPS_MAX",                  0, _SC_NGROUPS_MAX);
  #endif
  #ifdef STREAM_MAX
    DoSysconf(1,"STREAM_MAX", STREAM_MAX, _SC_STREAM_MAX );
  #else
    DoSysconf(0,"STREAM_MAX",          0, _SC_STREAM_MAX );
  #endif
  #ifdef TZNAME_MAX
    DoSysconf(1,"TZNAME_MAX",  TZNAME_MAX, _SC_TZNAME_MAX);
  #else
    DoSysconf(0,"TZNAME_MAX",          0, _SC_TZNAME_MAX);
  #endif
  #ifdef _POSIX_OPEN_MAX
    DoSysconf(1,"OPEN_MAX", _POSIX_OPEN_MAX, _SC_OPEN_MAX );
  #else
    DoSysconf(0,"OPEN_MAX",               0, _SC_OPEN_MAX );
  #endif
  #ifdef _POSIX_JOB_CONTROL
    DoSysconf(1,"JOB_CONTROL", _POSIX_JOB_CONTROL, _SC_JOB_CONTROL);
  #else
    DoSysconf(0,"JOB_CONTROL",                  0, _SC_JOB_CONTROL);
  #endif
  #ifdef _POSIX_SAVED_IDS
    DoSysconf(1,"SAVED_IDS", _POSIX_SAVED_IDS, _SC_SAVED_IDS);
  #else
    DoSysconf(0,"SAVED_IDS",                0, _SC_SAVED_IDS);
  #endif
  #ifdef _POSIX_VERSION
    DoSysconf(1,"VERSION", _POSIX_VERSION, _SC_VERSION );
  #else
    DoSysconf(0,"VERSION",              0, _SC_VERSION );
  #endif
    for(i=0; i < glo_argc; i++ ) {
	DoPathconf(glo_argv[i], "LINK_MAX"          , _PC_LINK_MAX );
	DoPathconf(glo_argv[i], "MAX_CANON"         , _PC_MAX_CANON );
	DoPathconf(glo_argv[i], "MAX_INPUT"         , _PC_MAX_INPUT );
	DoPathconf(glo_argv[i], "NAME_MAX"          , _PC_NAME_MAX );
	DoPathconf(glo_argv[i], "PATH_MAX"          , _PC_PATH_MAX );
	DoPathconf(glo_argv[i], "PIPE_BUF"          , _PC_PIPE_BUF );
	DoPathconf(glo_argv[i], "CHOWN_RESTRICTED"  , _PC_CHOWN_RESTRICTED );
	DoPathconf(glo_argv[i], "NO_TRUNC"          , _PC_NO_TRUNC );
	DoPathconf(glo_argv[i], "VDISABLE"          , _PC_VDISABLE );
    }
}

#if _POSIX_VERSION >= 199309 /* posix.4 */
#ifdef _POSIX_ASYNCHRONOUS_IO
#include <fcntl.h>

#ifdef _POSIX_ASYNC_IO
#if _POSIX_ASYNC_IO == -1
    void HaveAsyncIO(void) { ; } /* not available */
#else
void HaveAsyncIO(void)
{
    puts("POSIX_ASYNCHRONOUS_IO is available");
    printf("\tAIO_LISTIO_MAX = %ld\n", (long)AIO_LISTIO_MAX);
    printf("\tAIO_MAX = %ld\n", (long)AIO_MAX);
}
#endif
#else  /* ..ASYNC_IO not defined */
void HaveAsyncIO(void)
{
    int i, res;
    const char *p;

    puts("POSIX_ASYNCHRONOUS_IO may be available");
  #ifdef AIO_LISTIO_MAX
    DoSysconf(1, "\tAIO_LISTIO_MAX", AIO_LISTIO_MAX, _SC_AIO_LISTIO_MAX);
  #else
    DoSysconf(0, "\tAIO_LISTIO_MAX",              0, _SC_AIO_LISTIO_MAX);
  #endif
  #ifdef AIO_MAX
    DoSysconf(1, "\tAIO_MAX", AIO_MAX, _SC_AIO_MAX);
  #else
    DoSysconf(0, "\tAIO_MAX",       0, _SC_AIO_MAX);
  #endif
    for(i=0; p = CheckFile(i, &res, _PC_ASYNC_IO ); i++ ) {
	printf("\t%s: Async I/O is ");
	if( !errno )
	    puts("allowed");
	else
	    printf("NOT allowed: %s\n",strerror(errno));
    }
}
#endif
#else  /* _POSIX_ASYNCHRONOUS_IO not defined */
void HaveAsyncIO(void) { }
#endif /* end _POSIX_ASYNCHRONOUS_IO */

#ifdef _POSIX_SYNCRONIZED_IO
#if _POSIX_SYNCRONIZED_IO == -1
void HaveSyncIO()  {}
#else
void HaveSyncIO()
{
    puts("POSIX_SYNCHRONIZED_IO is available");
}
#endif
#else
void HaveSyncIO()
{
    int i, res;
    const char *p;

    puts("POSIX_SYNCHRONIZED_IO may be available");
    for(i=0; p = CheckFile(i, &res, _PC_SYNC_IO ); i++ ) {
	printf("\t%s: Sync I/O is ");
	if( !errno )
	    puts("allowed");
	else
	    printf("NOT allowed: %s\n",strerror(errno));
    }
}
#endif

void Posix4(void)
{
    puts("\nLooking at POSIX.4:");
    HaveSyncIO();
    HaveAsyncIO();
}
#endif
#endif /* _POSIX_VERSION defined */


int
main(int argc, char **argv)
{
    char buffer[10];
    if( argc )
	argc--, argv++;
    if( argc && !strcmp(*argv, "-h") ) {
	puts("usage: chkposix [-h] {files_to_test}");
	exit(0);
    }
    glo_argc = argc;
    glo_argv = argv;
    strcpy(buffer, "$Revision: 1.3 $"+11);
    buffer[strlen(buffer)-1] = 0;
    printf("This is chkposix (r%s)\n\n", buffer);
  #ifdef _POSIX_VERSION
      #if _POSIX_VERSION == 199009
	puts("POSIX.1 is supported but not POSIX.4");
	Posix1();
      #elif _POSIX_VERSION >= 199309
	puts("POSIX.1 and POSIX.4 are supported");
	Posix1();
	Posix4();
      #else
	printf("Weird: _POSIX_VERSION is %lu - this is not valid\n",
		_POSIX_VERSION );
      #endif
  #else
    puts("POSIX is not supported");
  #endif
    return 0;
}
/*** end of source ***/
