/* [wk/direc.h wk 25.4.89] CreateDirectory()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 02.01.93 wk	EMX Support
 */

#include <wk/tailor.h>
RCSID("$Id: direc1.c,v 1.10 1996/04/18 14:32:11 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if __ZTC__
#include <direct.h>
#else
#include <wk/io.h>
#endif
#include <errno.h>
#include <wk/direc.h>
#include <wk/string.h>

#if !(defined(GNU_C_LIB) && OS20)
    #define HAVE_UMASK 1
#endif

#ifdef DOCUMENTATION
@Summary CreateDirectory   Create an directory
 #include <wk/direc.h>

 int CreateDirectory( path, mode );
 const char *path;	Directory
 int mode ;		Modus
@Description
 Diese Funktion erzeugt ein Directory, dabei werden eventuell noch
 nicht vorhandene bergeordnete Directories auch erzeugt.
 Modus 0 : create directory from path error if exists
       1 : create directory from path no error if exists
       2 : create directory from path no error if exists,
	   change to that directory (default drive will not be changed)
 path sollte nicht lnger als F_MAX_PATH sein.
@Return Value
 0 - okay
 1 - error creating directory
 2 - error changing to directory
#endif



int CreateDirectory( const char* path , int mode )
{
    char *p ;
    char  *dir;
    int err , n ;

    err = 0 ;
    n = 0 ;
    if( strlen(path) > 1 )
	if( path[1] == ':' )
	    n = 2 ;
    dir = xstrdup( path ) ;

    for(p=dir; *p ; p++ )
	if( *p == '\\' )
	    *p = '/' ;
    if( strlen(dir) ) {
      #if defined(GNU_C_LIB) || defined(UNIX) || POSIX || EMX
	mode_t um;

	/* I have found no other way, to get the current mask: */
      #ifdef HAVE_UMASK
	#if EMX
	  um = umask( S_IWRITE );
	#else
	  um = umask( S_IRWXU | S_IRWXG | S_IROTH ); /* irgendwelche werte */
	#endif
	umask(um); /* and reset it to old value */
      #else
	um = S_IRWXU | S_IRWXG | S_IROTH;
      #endif
	#define A_mkdir( a )  mkdir((a), um)
      #else
	#define A_mkdir( a )  mkdir((a))
      #endif
	for( (p = dir[n] == '/' ? dir+n+1:dir+n) ;
			       (p = strchr( p, '/' )); p++ ) {
	    *p = '\0' ;
	    A_mkdir( dir ) ;
	    *p = '/' ;
	}
	/* okay: now the lowest subdir */
	err = A_mkdir( dir ) ? 1 : 0;
	if( mode )
	    err = 0 ;
      #undef A_mkdir
    }
    else {
	errno = EINVAL ;
	err = 1 ;
    }

    if( mode == 1 )
	err = 0 ;
    else if( !err && mode == 2 )
	err = chdir( dir ) ? 2 : 0 ;

    free( dir ) ;

    return err ;
}

/*** bottom of file ****/
