/* [direc2.c wk 19.12.90] FindFile()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 *  1.05.92 wk	FindFileStat lieferte falschen Monat zurueck; tm hat den
 *		Wertebereich 0..11, DOS und OS/2 liefert aber 1..12:
 *		fixed, aber wieso war das fuer DOS schon korrigiert ?
 * 27.08.92 wk	struct stat durch type findFileStat ersetzt (wg. MSC
 *		und evtl. spaeteren Portierungen)
 * 02.01.93 wk	EMX Support
 * 26.01.93 wk	C Set/2 Support added: Changed DosFindFirst-infolevel
 *		from 0 to 1
 * 04.04.93 wk	Letze Umstellung hatte Bugs, FIL_STANDARD, darf nur bei
 *		OS2v2.0 benutzt werden, bei v1.3 war diese Konstante nur
 *		fuer das dort vorhandene FindFirst2 vorgesehen. v2.0
 *		muss ausserdem FILEFINDBUF3 benutzen.
 * 06.07.94 wk	Einige Programme benutzen fr flags in FindFile() leider 0
 *		um diese Fehlerquelle auszuschalten ist jetzt der NULL-ptr
 *		explizit erlaubt.
 * 14.11.94 wk	FindFileStat() did not set tm_isdst to zero.
 * 05.03.95 wk	added UNIX support via open/read/closedir()
 * 15.05.95 wk	See ChangeLog
 */

#include <wk/tailor.h>
RCSID("$Id: direc2.c,v 1.23 1996/08/26 17:51:56 wk Exp $")
#if EMX
  #include <sys/emx.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <wk/lib.h>	/* to define MSDOS or something else */
#if (UNIX  || POSIX) && !EMX
    #include <sys/types.h>
    #include <dirent.h>
    #include <fnmatch.h>    /* is this posix? (seems okay for openVMS) */
#elif NETWARE
    #include <nwdir.h>
#elif EMX && !OS20
    #include <sys/types.h>
    #include <sys/stat.h>
    #include <dirent.h>
    #include <os2.h>
    #define SEARCHCOUNTTYPE ULONG
#elif OS2
    #if OS20
      #include <sys/types.h>
      #include <sys/stat.h>
    #endif
    #ifdef EMX
	#include <os2.h>
    #else
	#include <os2def.h>
	#define INCL_DOSFILEMGR
	#include <bsedos.h>
    #endif
    #if OS20
	#define SEARCHCOUNTTYPE ULONG
    #else
	#define SEARCHCOUNTTYPE USHORT
    #endif
#else
    #include <dos.h>
#endif
#include <time.h>
#include <wk/direc.h>
#include <wk/string.h>

#if !__WATCOMC__ && !__MSC__ && !__ZTC__ && !EMX && \
    !OS2 && !UNIX && !POSIX
   #error unsupported Compiler/OS
#endif

#ifndef ENOMEM
  #define ENOMEM  EOUTOFMEM
#endif

/****** constants ********/
#define MAX_HANDLES 5
/****** types ********/
typedef struct {
	int inuse;
      #if (UNIX  || NETWARE  || POSIX) && !EMX
	DIR *dirp;
	struct dirent *ent;/* may point to data local to dirp, see readdir()*/
	struct stat statbuf;
	char *pattern; /* malloced */
	int use_lstat;
	int is_root;
      #elif OS2 || EMX
	char hdirActive;
	HDIR hdir;
	SEARCHCOUNTTYPE usSearchCount;
	#if OS20
	  FILEFINDBUF3 fi ;
	#else
	  FILEFINDBUF  fi ;
	#endif
	#if EMX  && !OS20
	    struct _find efi; /* for Dos-Mode  */
	#endif
      #else
	struct find_t fi;
      #endif
	char *fPath;
	size_t fPathSize;
	size_t dirlen;	/* damit nicht jedesmal dirname() gebraucht wird*/
    } handleTbl_t ;

/****** globals ******/
static handleTbl_t *handleTbl;

/***** prototypes *****/
static void CleanUp( void *dummy );
/***** functions ******/


static void CleanUp( void *dummy )
{
    int i;

    if( handleTbl ) {
	for(i=0; i < MAX_HANDLES; i++ )
	    if( handleTbl[i].inuse  ) {
		free(handleTbl[i].fPath);
	      #if UNIX || NETWARE
		if( handleTbl[i].dirp ) {
		    closedir(handleTbl[i].dirp);
		    handleTbl[i].dirp = NULL;
		    FREE(handleTbl[i].pattern);
		}
	      #elif OS2 || EMX
		if( handleTbl[i].hdirActive ) {
		    DosFindClose(handleTbl[i].hdir) ;
		    handleTbl[i].hdirActive = 0;
		};
	      #endif
		handleTbl[i].inuse = 0 ;
	    }
	FREE( handleTbl );
    }
}




#ifdef DOCUMENTATION
@Summary FindFile
 #include <wk/direc.h>

 int FindFile( mode, buffer, bufSize, flags, handle )
 int mode;	   0 = Open, 1 = Next, 2 = Close
 char *buffer;	    Buffer (pattern at Open) / Return: path
 size_t bufSize;    max. Size of Buffer
 unsigned *flags;   Flags ( fileflags to be searched for at open )
		    Returns: Flags of file
 int *handle;	    Working Variable
@Description
 Flag Values:
 Bit 0	    : Directory Entry
 Bit 1	    : Hidden ( or System ) File or special file on unix
 Bit 2	    : Symbolic Link
 Bit 3	    : N/A
 Bit 4	    : ReadOnly Attribute is set
 Bit 5	    : Archive Attribute is Set
 Bit 7	    : (use HPFS filenames if possible)
 Bit 8	    : Use lstat() instead of stat()
 Wenn Bit 0 oder Bit 1 gesetzt sind, so werden File mit den entsprechenden
 Attributen auch gesucht. ( Bit 2 und 3 sollten 0 sein )
 Die Suchmaske Besteht nur aus den unteren 4 Bits.
 ( Close ist nur notwendig wenn nicht alles gescannt wird, da am
   Ende eines Scans ja ein Fehler auftritt und dieser intern ein Close
   durchfhrt )
 flags darf auch NULL sein, in diesem Fall wird natrlich kein Wert
 zurckgegeben, intern wird ein flag-wert 0 benutzt.
@Return Value
 0 = okay, sonst Fehler ( errno ist dann gesetzt )
#endif /*DOCUMENTATION*/

int FindFile( int mode, char *buffer, size_t bufSize,
	      unsigned *flags, int *handle )
#if (UNIX || NETWARE || POSIX) && !EMX
{
    int i, err ;
    unsigned attr ;
    char *fDir, *fBase;
    handleTbl_t *entry;
    size_t n;
    unsigned dummyflags;

    err = 0 ;
    if( !flags )
	dummyflags = 0, flags = &dummyflags;

    fDir = fBase = NULL;
    if( !handleTbl ) { /* Initialize at first access */
	if( !(handleTbl = calloc( MAX_HANDLES, sizeof *handleTbl )) ) {
	    errno = ENOMEM;
	    err = -1;
	    *handle = -1 ; /* so table will not be accessed */
	    goto endLabel;
	}
	AddCleanUp( CleanUp, NULL );
    }

    if( !mode ) { /* search first */
	*handle = -1 ;
	for(i=0; i < MAX_HANDLES; i++ )
	    if( !handleTbl[i].inuse ) {
		if( !(handleTbl[i].fPath = malloc( F_MAX_PATH + 1 )) ) {
		    errno = ENOMEM ;
		    err = -1;
		    goto endLabel;
		}
		handleTbl[i].fPathSize = F_MAX_PATH+1;
		handleTbl[i].inuse = 1 ;
		handleTbl[i].dirp = NULL;
		handleTbl[i].pattern = NULL;
		*handle = i ;
		break ;
	    }
    }

    if( *handle < 0 || *handle >= MAX_HANDLES ) {
	errno = EINVAL; /* invalid Handle or no more Handles */
	err = -1 ;
	goto endLabel;
    }
    else
	entry = handleTbl + *handle;

    if( !mode ) {  /* find first */
	/* build Search Attribs */
	attr = 0x0000 ;
	entry->use_lstat = !!(*flags & (1<<8));
	fDir = dirname( buffer );
	entry->dirlen = strlen(fDir);
	entry->is_root = *fDir=='/' && !fDir[1];
	entry->pattern = basename(buffer);
      #if NETWARE
	if( !(entry->dirp = opendir(buffer)) )
	    err = -1;
      #else
	if( !(entry->dirp = opendir(*fDir? fDir: "." )) )
	    err = -1;
      #endif
    }
    if( err )
	;
    else if( mode == 0 || mode == 1	) {  /* find next */
      #if NETWARE
	if( !(entry->ent = readdir(entry->dirp)) ) {
	    if( !errno )
		errno = ENOENT;
	    err = -1;
	}
      #else
	do {
	    if( !(entry->ent = readdir(entry->dirp)) ) {
		if( !errno )
		    errno = ENOENT;
		err = -1;
	    }
	    else {
		i = fnmatch( entry->pattern, entry->ent->d_name, 0 );
      #ifdef FNM_NOMATCH
		if( i && i != FNM_NOMATCH )
		    err = -3;
	    }
	} while( !err && i == FNM_NOMATCH );
      #else
	    }
	} while( !err && i );
      #endif
      #endif
    }
    else if( mode == 2 ) /* Close */
	; /* same as error cleanup */
    else { /* invalid Mode */
	errno = EINVAL;
	err = -1 ;
    }

    if( !err && mode != 2 ) {
	/* set Attribut */
	attr = 0;
	fBase = basename(entry->ent->d_name);

	n = entry->dirlen + 1 + strlen(fBase) + 1;
	if( entry->fPathSize < n ) {
	    free( entry->fPath );
	    entry->fPathSize = n;
	    if( !(entry->fPath = malloc(n))) {
		errno = ENOMEM ;
		err = -1;
		goto endLabel;
	    }
	}

	if( !entry->dirlen )
	    strcpy( entry->fPath, fBase );
	else if( entry->is_root)
	    stpcpy(stpcpy( entry->fPath, "/"), fBase );
	else if( !mode )
	    stpcpy(stpcpy( stpcpy( entry->fPath, fDir), "/"), fBase );
	else
	    stpcpy(stpcpy( entry->fPath+entry->dirlen, "/"), fBase );

	if( buffer )
	    mem2str( buffer, entry->fPath, bufSize );

	if(
	  #if !NETWARE
	    entry->use_lstat? lstat( entry->fPath, &entry->statbuf ) :
	  #endif
			      stat( entry->fPath, &entry->statbuf ) )
	    err = -2; /* stat error */
	else {
	    if( S_ISDIR(entry->statbuf.st_mode) )
		attr |= 1;
	  #if !NETWARE
	    if(    !S_ISREG(entry->statbuf.st_mode)
		&& !S_ISDIR(entry->statbuf.st_mode)
		&& !S_ISLNK(entry->statbuf.st_mode) )
		attr |= 2;
	    if( S_ISLNK(entry->statbuf.st_mode) )
		attr |= 4;
	  #endif
	    *flags = attr ;
	}
    }

  endLabel:
    if( mode == 2 || err ) { /* Close also on error */
	if( *handle >= 0 && *handle < MAX_HANDLES ) {
	    FREE(handleTbl[*handle].fPath);
	    FREE(handleTbl[*handle].pattern);
	    if( handleTbl[*handle].dirp )
		closedir(handleTbl[*handle].dirp);
	    handleTbl[*handle].inuse = 0 ;
	}
	*handle = -1 ;
    }

    free(fDir);
    free(fBase);
    return err ;
}
#else /* not UNIX */
{
  #if OS2 || EMX
    HDIR hdir;
    SEARCHCOUNTTYPE usSearchCount;
    #if OS20
      FILEFINDBUF3 *fi ;
    #else
      FILEFINDBUF  *fi ;
    #endif
    #if EMX && !OS20
      struct _find *efi ;
    #endif
  #else
    struct find_t *fi ;
  #endif
    int i, err ;
    unsigned attr ;
    char *fDir, *fBase;
    handleTbl_t *entry;
    size_t n;
    unsigned dummyflags;

    err = 0 ;
    if( !flags )
	dummyflags = 0, flags = &dummyflags;

    fDir = fBase = NULL;
    if( !handleTbl ) { /* Initilize at first access */
	if( !(handleTbl = calloc( MAX_HANDLES, sizeof *handleTbl )) ) {
	    errno = ENOMEM;
	    err = -1;
	    *handle = -1 ; /* so table will not be accessed */
	    goto endLabel;
	}
	AddCleanUp( CleanUp, NULL );
    }

    if( !mode ) {
	*handle = -1 ;
	for(i=0; i < MAX_HANDLES; i++ )
	    if( !handleTbl[i].inuse ) {
		if( !(handleTbl[i].fPath = malloc( F_MAX_PATH + 1 )) ) {
		    errno = ENOMEM ;
		    err = -1;
		    goto endLabel;
		}
		handleTbl[i].fPathSize = F_MAX_PATH+1;
		handleTbl[i].inuse = 1 ;
	      #if OS2 || EMX
		handleTbl[i].hdirActive = 0;
	      #endif
		*handle = i ;
		break ;
	    }
    }

    if( *handle < 0 || *handle >= MAX_HANDLES ) {
	errno = EINVAL; /* invalid Handle or no more Handles */
	err = -1 ;
	goto endLabel;
    }
    else {
	fi = &handleTbl[*handle].fi;
      #if OS2 || EMX
	hdir =		handleTbl[*handle].hdir;
	usSearchCount = handleTbl[*handle].usSearchCount;
	#if EMX && !OS20
	  efi = &handleTbl[*handle].efi;
	#endif
      #endif
	entry = handleTbl + *handle;
    }

    if( !mode ) {  /* find first */
	/* build Search Attribs */
	attr = 0x0000 ;
      #if EMX && !OS20
	if( _osmode == DOS_MODE ) {
	    if( *flags & 0x01 )
		attr |= A_DIR;
	    if( *flags & 0x02 )
		attr |= A_HIDDEN | A_SYSTEM;
	}
	else { /* OS/2 */
	    if( *flags & 0x01 )
		attr |= 0x10; /* subdirectory */
	    if( *flags & 0x02 )
		attr |= 0x02 | 0x04;  /* hidden or system */
	}
      #elif OS2
	if( *flags & 0x01 )
	    attr |= 0x10; /* subdirectory */
	if( *flags & 0x02 )
	    attr |= 0x02 | 0x04;  /* hidden or system */
      #else
	if( *flags & 0x01 )
	    attr |= _A_SUBDIR;
	if( *flags & 0x02 )
	    attr |= _A_HIDDEN | _A_SYSTEM;
      #endif

	fDir = dirname( buffer );
	entry->dirlen = strlen(fDir);

      #if OS2 || EMX
       #if EMX && !OS20
	if( _osmode == DOS_MODE ) {
	    if( __findfirst(buffer, attr, efi) ) {
		err = -1;
		errno = ENOENT;
	    }
	}
	else {
       #endif
	hdir = 0xffff ; /* new search Handle */
	usSearchCount = 1 ;
	err = DosFindFirst( (PSZ)buffer, &hdir, attr,
			    fi, sizeof( *fi ), &usSearchCount,
							     #if OS20
							       FIL_STANDARD
							     #else
							       0
							     #endif
									    );
	if( err )
	    errno = ENOENT;
	else {
	    handleTbl[*handle].hdir = hdir;
	    handleTbl[*handle].hdirActive = 1;
	    handleTbl[*handle].usSearchCount = usSearchCount;
	}
       #if EMX && !OS20
	}
       #endif
      #else
       #if __ZTC__
	if( err = _dos_findfirst( buffer, attr, fi ) )
	    errno = ENOENT;
       #else
	err = _dos_findfirst( buffer, attr, fi );
       #endif
      #endif
    }
    else if( mode == 1 ) {  /* find next */
      #if EMX && !OS20
	if( _osmode == DOS_MODE ) {
	    if( __findnext( efi) ) {
		err = -1;
		errno = ENOENT;
	    }
	}
	else {
	    err = DosFindNext( hdir, fi, sizeof( *fi), &usSearchCount);
	    if( err )
		errno = ENOENT;
	    else
		handleTbl[*handle].usSearchCount = usSearchCount;
	}
      #elif OS2
	err = DosFindNext( hdir, fi, sizeof( *fi), &usSearchCount);
	if( err )
	    errno = ENOENT;
	else
	    handleTbl[*handle].usSearchCount = usSearchCount;
      #else
       #if __ZTC__
	if( err = _dos_findnext( fi ) )
	    errno = ENOENT;
       #else
	err = _dos_findnext( fi );
       #endif
      #endif
    }
    else if( mode == 2 ) /* Close */
	; /* same as error cleanup */
    else { /* invalid Mode */
	errno = EINVAL;
	err = -1 ;
    }

    if( !err && mode != 2 ) {
	/* set Attribut */
	attr = 0;
      #if OS2 || EMX
       #if EMX && !OS20
	if( _osmode == DOS_MODE ) {
	    if( efi->attr & A_DIR )
		attr |= 1;
	    if( efi->attr & (A_HIDDEN | A_SYSTEM) )
		attr |= 2;
	    if( efi->attr & A_RONLY )
		attr |= 16;
	    if( efi->attr & A_ARCHIVE )
		attr |= 32;
	    *flags = attr ;
	    fBase = basename(efi->name);
	}
	else {
       #endif
	    if( fi->attrFile & 0x10 ) /* subdirectory */
		attr |= 1;
	    if( fi->attrFile & (0x02 | 0x04 ) )  /* hidden or system */
		attr |= 2;
	    if( fi->attrFile & 0x01 ) /* readonly */
		attr |= 16;
	    if( fi->attrFile & 0x02 ) /* archive */
		attr |= 32;
	    *flags = attr ;
	    fBase = basename(fi->achName);
       #if EMX && !OS20
	}
       #endif
      #else
	if( fi->attrib & _A_SUBDIR )
	    attr |= 1;
	if( fi->attrib & (_A_HIDDEN | _A_SYSTEM ) )
	    attr |= 2;
	if( fi->attrib & _A_RDONLY )
	    attr |= 16;
	if( fi->attrib & _A_ARCH )
	    attr |= 32;
	*flags = attr ;
	fBase = basename(fi->name);
      #endif

	n = entry->dirlen + 1 + strlen(fBase) + 1;
	if( entry->fPathSize < n ) {
	    free( entry->fPath );
	    entry->fPathSize = n;
	    if( !(entry->fPath = malloc(n))) {
		errno = ENOMEM ;
		err = -1;
		goto endLabel;
	    }
	}

	if( !entry->dirlen )
	    strcpy( entry->fPath, fBase );
	else if( !mode )
	    stpcpy(stpcpy( stpcpy( entry->fPath, fDir), "/"), fBase );
	else
	    stpcpy(stpcpy( entry->fPath+entry->dirlen, "/"), fBase );

	if( buffer ) {
	    mem2str( buffer, entry->fPath, bufSize );
	  #if MSDOS
	    strlwr(buffer); /* Bei MSDOS Sinnvoll */
	  #endif
	}
    }

  endLabel:
    if( mode == 2 || err ) { /* Close also on error */
	if( *handle >= 0 && *handle < MAX_HANDLES ) {
	    FREE(handleTbl[*handle].fPath);
	  #if OS2 || EMX
	    if( handleTbl[*handle].hdirActive ) {
		DosFindClose(handleTbl[*handle].hdir) ;
		handleTbl[*handle].hdirActive = 0;
	    }
	  #endif
	    handleTbl[*handle].inuse = 0 ;
	}
	*handle = -1 ;
    }

    free(fDir);
    free(fBase);
    return err ;
}
#endif /* UNIX,NETWARE */



#ifdef DOCUMENTATION
@Summary FindFileStat
 #include <wk/direc.h>

 const char *FindFileStat( handle, buf )
 int *handle;	    Working Variable
 findFileStat_t *buf; Address of stat buffer ( Unix Stat buffer in sys/stat.h )
@Description
 Gibt weitere Informationen zum letzen FindFile zurck.
 Folgende Elemente sind z.Z. nicht definiert:
 st_dev , st_mode , st_rdev
@Return Value
 Pointer to Buffer containing the rootname of the file
#endif /*DOCUMENTATION*/

const char *
FindFileStat( int *handle, findFileStat_t *buf )
#if (UNIX || NETWARE || POSIX) && !EMX
{
    if( buf )
	*buf = handleTbl[*handle].statbuf;
    return handleTbl[*handle].ent->d_name;
}
#else
{
  #if OS2 || EMX
    #if OS20
      FILEFINDBUF3 *fi ;
    #else
      FILEFINDBUF  *fi ;
    #endif
    #if EMX && !OS20
      ushort t, d;
      struct _find *efi ;
    #endif
    struct tm tm;
  #else
    ushort t, d;
    struct find_t *fi ;
    struct tm tm;
  #endif

    fi = &handleTbl[*handle].fi;
    if( buf ) {
	buf->st_nlink = 1;
      #if OS2 || EMX
       #if EMX && !OS20
	if( _osmode == DOS_MODE )  {
	    buf->st_size  = ((unsigned long)efi->size_hi << 16) + efi->size_lo;
	    d = efi->date;
	    t = efi->time;
	    tm.tm_sec = (t & 0x001f) *2;
	    tm.tm_min = (t & 0x07e0) >> 5;
	    tm.tm_hour= (t & 0xf800) >> 11;
	    tm.tm_mday= d & 0x001f;
	    tm.tm_mon = ((d & 0x01e0) >> 5) -1;
	    tm.tm_year= ((d & 0xfe00) >> 9) + 80;
	    tm.tm_isdst = 0;
	    buf->st_atime = mktime( &tm );
	    buf->st_mtime = buf->st_atime;
	    buf->st_ctime = buf->st_atime;
	}
	else {
       #endif
	    buf->st_size  = fi->cbFile;
	    tm.tm_sec = fi->ftimeCreation.twosecs *2;
	    tm.tm_min = fi->ftimeCreation.minutes;
	    tm.tm_hour= fi->ftimeCreation.hours;
	    tm.tm_mday= fi->fdateCreation.day;
	    tm.tm_mon = fi->fdateCreation.month-1;
	    tm.tm_year= fi->fdateCreation.year + 80;
	    tm.tm_isdst = 0;
	    buf->st_ctime = mktime( &tm );
	    tm.tm_sec = fi->ftimeLastAccess.twosecs *2;
	    tm.tm_min = fi->ftimeLastAccess.minutes;
	    tm.tm_hour= fi->ftimeLastAccess.hours;
	    tm.tm_mday= fi->fdateLastAccess.day;
	    tm.tm_mon = fi->fdateLastAccess.month-1;
	    tm.tm_year= fi->fdateLastAccess.year + 80;
	    tm.tm_isdst = 0;
	    buf->st_atime = mktime( &tm );
	    tm.tm_sec = fi->ftimeLastWrite.twosecs *2;
	    tm.tm_min = fi->ftimeLastWrite.minutes;
	    tm.tm_hour= fi->ftimeLastWrite.hours;
	    tm.tm_mday= fi->fdateLastWrite.day;
	    tm.tm_mon = fi->fdateLastWrite.month-1;
	    tm.tm_year= fi->fdateLastWrite.year + 80;
	    tm.tm_isdst = 0;
	    buf->st_mtime = mktime( &tm );
       #if EMX && !OS20
	}
       #endif
      #else
	buf->st_size  = fi->size;
	d = fi->wr_date;
	t = fi->wr_time;
	tm.tm_sec = (t & 0x001f) *2;
	tm.tm_min = (t & 0x07e0) >> 5;
	tm.tm_hour= (t & 0xf800) >> 11;
	tm.tm_mday= d & 0x001f;
	tm.tm_mon = ((d & 0x01e0) >> 5) -1;
	tm.tm_year= ((d & 0xfe00) >> 9) + 80;
	tm.tm_isdst = 0;
	buf->st_atime = mktime( &tm );
	buf->st_mtime = buf->st_atime;
	buf->st_ctime = buf->st_atime;
      #endif
	buf->st_ino   = 0;
	buf->st_uid   = 0;
	buf->st_gid   = 0;
    }
  #if EMX && !OS20
    return _osmode == DOS_MODE ? efi->name : fi->achName ;
  #elif OS2
    return fi->achName;
  #else
    return fi->name;
  #endif
}
#endif

#ifdef DOCUMENTATION
@Summary FindFileName
 #include <wk/direc.h>

 const char *FindFileName( handle )
 int *handle;	    Working Variable
@Description
 Gibt den vollstndigen Namen des Files zurueck. Dieser ist
 nur bis zum naechsten Aufruf mit diesem Handle und solange
 der handle gueltig ist, ansprechbar.
 Mit dieser Funktion ist es moeglich, nur einen kleinen buffer
 fuer die pattern ( oder auch bei next keinen buffer ) bei
 FindFile() anzugeben und danach trotzdem noch den namen
 des File (der intern sowieso vorgehalten wird) volstaendig
 zurueckzuerhalten.
@Return Value
 Pointer to internal Buffer containing the name of the file
#endif /*DOCUMENTATION*/

const char *FindFileName( int *handle )
{
    return handleTbl[*handle].fPath;
}



/************* Test Main function *************/
#ifdef TEST

void main( int argc, char **argv )
{
    char buffer[F_MAX_PATH];
    unsigned attr;
    int handle, err;

    if( argc != 3 ) {
	puts("usage: findfile pattern attrMask");
	exit(3);
    }

    strcpy( buffer, argv[1] ); /* pattern */
    attr = atoi( argv[2] );
    printf("Searching: %s with Attrib: %#4x\n", buffer, attr );

    err = FindFile( 0, buffer, DIM(buffer), &attr, &handle );
    if( err )
	perror("Open error");

    while( !err ) {
	printf( "Found: %#4x  '%s'\n", attr, buffer );
	err = FindFile( 1, buffer, DIM(buffer), &attr, &handle );
    }

    perror("Ready");

    err = FindFile( 2, buffer, DIM(buffer), &attr, &handle );
    if( err )  /* eigentlich nur ntig, wenn nicht bis dahin kein Fehler kam */
	perror( "Close error");
    exit(0);
}


#endif /* TEST */

/**** bottom of file ****/
