/* [direc4.c wk 10.09.93] GetFileName()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <wk/tailor.h>
RCSID("$Id: direc4.c,v 1.3 1995/03/08 16:54:36 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/file.h>
#include <wk/string.h>
#include <wk/direc.h>


/****** constants ********/
/****** types ********/
/****** globals ******/
/***** prototypes *****/
/***** functions ******/

#ifdef DOCUMENTATION
@Summary GetFileName
 #include <wk/direc.h>

 char *GetFileName( buffer, bufSize, path )
 char *buffer;	    Buffer which will contain the name or NULL
 size_t bufSize;    Size of Buffer
 const char *path;  Name fo file
@Description
@Return Value
 buffer or allocated memory if buffer was NULL
#endif /*DOCUMENTATION*/

char *GetFileName( char *buffer, size_t bufSize, const char *path )
{
  #if OS2
    /* nur hier ist es notwendig, den file nach namen zu suchen*/
    /* um Unterschiede in klein-/grossschreibung beizubehalten */
    char *pathBuffer;
    unsigned attr;
    int handle;

    attr = 2; /* scan also hidden files */

    pathBuffer = xmalloc( F_MAX_PATH );
    mem2str(pathBuffer, path, F_MAX_PATH);
    if( !buffer ) {
	buffer = pathBuffer;
	bufSize = F_MAX_PATH;
    }

    if( !FindFile( 0, pathBuffer, F_MAX_PATH, &attr, &handle ) ) { /* foundit */
	if( buffer != pathBuffer )
	    mem2str(buffer, pathBuffer, bufSize);
	FindFile( 2, NULL, 0, NULL, &handle ); /* close */
    }
    else   /* not found - use original name */
	mem2str(buffer, path, bufSize);
    if( buffer != pathBuffer )
	free(pathBuffer);
    #else
    /* Einfach den originalen namen benutzen */

    if( buffer )
	mem2str(buffer, path, bufSize );
    else
	buffer = xstrdup(path);
    #endif

    return buffer;
}

/**** bottom of file ****/
