/* [dllmain.c wk 02.04.93] Pull in DLL Initialization
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */


#include <wk/tailor.h>
#include <stdio.h>
#include <wk/lib.h>

#if __IBMC__
int _exeentry = 1;
extern int _dllentry;
#endif

static void Dummy()
{
  #if __IBMC__
    int x;

    x = _dllentry;
  #endif
}




#ifdef DOCUMENTATION
@Summary WklibDLLInfo
 #include <wk/lib.h>

 const char *WklibDLLInfo( int level );
 level 0: Copyright String zurueckgeben
       1: Empty string
       2: Empty string
      10: Copyrightstring zurckgeben
      11: Empty string
      12: Empty string
      13: Programmnamen zurckgeben
      14: Versionsnummer zurckgeben
      15: Empty string
      16: Name unter dem im Profile gespeichert werden soll
      20: unused
      21: unused
      22: unused
      23: CompileTime
@Description
 Funktionsnummer wie bei CopyRight()
@Return Value
 Pointer zum String
#endif /*DOCUMENTATION*/

const char *WklibDLLInfo( int level )
{
    const char *p;
  #if __IBMC__
    int x;

    x = _dllentry;
  #endif

    if( level == 23 )
        return   __DATE__ " " __TIME__;
    else
	return CopyRight(level);
}


/******* bottom of file *******/
