/* [emxsup1.c wk 3.1.93] Missing library functions in EMX
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  These functions are missing, but declared
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: emxsup1.c,v 1.6 1996/01/25 20:16:40 wernerk Exp $")
#if EMX  /* missing in version 0.8c */
#if 0 /* now available (0.9a) */
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <ctype.h>
#include <errno.h>
#include <time.h>


unsigned long strtoul(const char *p,char **pend,int base)
{
    unsigned long number = 0;
    int c;
    int error;

    while( isspace(*(const byte*)p) )	 /* skip white spaces */
	p++;
    if( *p == '+' )
	p++;
    switch (base) {
      case 0:
	base = 10;  /* assume decimal base */
	if( *p == '0' )  {
	    base = 8;	    /* could be octal */
	    p++;
	    switch( *p ) {
	      case 'x':
	      case 'X':
		base = 16;	/* hex */
		p++;
		break;
	    }
	}
	break;
      case 16:	 /* skip over '0x' and '0X'      */
	if( *p == '0' )
	    if( p[1] == 'x' || p[1] == 'X' )
		p += 2;
	break;
    }

    error = 0;
    for(;;) {
	c = *p;
	if( isdigit(c) )
	    c -= '0';
	else if( isalpha(c) )
	    c = (c & ~0x20) - ('A' - 10);
	else /* unrecognized character	     */
	    break;  /* for-loop */

	if( c >= base )  /* not in number base */
	    break;  /* for-loop */
	if( (ULONG_MAX - c) / base < number )
	    error = 1;
	number = number * base + c;
	p++;
    }

    if(pend)
	*pend = (void *)p;
    if(error) {
	number = ULONG_MAX;
	errno = ERANGE;
    }
    return number;
}


size_t strftime (char *string, size_t size, const char *format,
		 const struct tm *t)
{
    strcpy( string, "?" );
    return 1;
}


#endif
#endif /* EMX */

/***** bottom of file ******/
