/* [environ.c wk  3.01.93] Environment Vars
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 27.01.93 wk	C Set/2 Support added
 * 09.05.93 wk	Bug in implementation for CSet and EMX
 * 25.06.93 wk	HPUX Support
 */


#include <wk/tailor.h>
RCSID("$Id: environ.c,v 1.12 1996/04/18 14:32:13 wernerk Exp $")
#if EMX
   #include <sys/emx.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/environ.h>
#if __GNU_LIBRARY__ || GNU_C_LIB_OS2 || HPUX || POSIX
  extern char **environ;
#endif

const char *GetEnvironmentStrings(void)
{
  #if NETWARE /* no environment-varaibles */
    return "\0\0\0\0\0\0";
  #elif EMX || __IBMC__ || __WATCOMC__ || \
      __GNU_LIBRARY__ || GNU_C_LIB_OS2 || HPUX || __MSC__ || POSIX
    static char *env;
    static size_t envSize;
    char **pp, **pporg;
    char *p;
    size_t n;

    /* determine needed space */
    pporg = environ;
    for(n = 0, pp = pporg; *pp ; pp++ )
	n += strlen( *pp ) + 1;
    n += 3; /* add extra 0 plus 2 for security */
    if( !env || n != envSize ) { /* first call or size changed */
	free( env );
	env = xmalloc( envSize = n );
    }
    /* copy to space */
    for(p = env, pp = pporg; *pp ; p += strlen(*pp)+1, pp++ )
	strcpy(p, *pp);
    *p++ = 0;  /* terminating 0 */
    *p++ = 0;  /* plus two extras */
    *p	 = 0;
    return env;
  #elif defined(HPUX)
    return _environ;
  #else
    return _envptr;
  #endif
}


#if defined(GNU_C_LIB) && OS20
int putenv( const char *s )
{
    return -1;
}
#endif

/*** bottom of file ***/
