/* [error.c wk 20.1.88] Error()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 26.01.93 wk	C Set/2 support
 * 06.02.93 wk	BUG,xassert etc fuer C Set erweitert
 * 26.02.93 wk	Added SNOOP Feature
 * 05.04.93 wk	CopyRigh(13) durch wklibApplicationName ersetzt
 * 25.06.93 wk	Changed initialization of wklibAppli...
 * 06.09.93 wk	All functions will now put out the applicationname first
 */


#include <wk/tailor.h>
RCSID("$Id: error.c,v 1.13 1996/01/10 19:05:55 wernerk Exp $")
#include <stdio.h>
#include <stdarg.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/lib.h>
#include <wk/errorhd.h>

#if OS20 && __IBMC__ && __MULTI__  /* nur in der MultiThread version */
  #define USE_SNOOP 1
#endif

#if USE_SNOOP /* pete fitzsimmon's SnoopServer/PmSnoop */
ushort _Far16 _Pascal  SnoopOpen(const char * _Seg16 pszPipeName,
				 ushort * _Seg16 phSnoop,
				 const char * _Seg16 pszAppName,
				 void * _Seg16 dummy );
ushort _Far16 _Pascal  SnoopWrite(ushort hsn, char * _Seg16 pszMessage);
ushort _Far16 _Pascal  SnoopClose(ushort hsn);
#endif

/****** Constants *****/
#define MAX_FNCS 5	/* max. # of registrable functions */

/****** globals *******/
static struct {
	int no; 	/* registered number, 0 shows unused entry */
	const char *(*fnc)(int); /* ptr to registred function */
    } textFncTbl[MAX_FNCS];

#if defined(stderr) && !defined(GNU_C_LIB_OS2)
  static FILE *errorSt = stderr;
  #define INIT_errorSt()  do { if(!wklibApplicationName) \
			     wklibApplicationName = CopyRight(13);} while(0)
#else
  static FILE *errorSt;
  #define INIT_errorSt()  do { if(!wklibApplicationName) \
				   wklibApplicationName = CopyRight(13); \
			       if( !errorSt ) errorSt = stderr; } while(0)
#endif
static int snoopActive;
#if USE_SNOOP
static ushort hsn;
#endif

   /* allocation of String for xassert() */
#if __IBMC__
const char xassertstring[] = "\"%s\" failed in %s : %s[%d]";
#else
const char xassertstring[] = "\"%s\" failed in %s[%d]";
#endif
    /* and and allcation for modules memdbg and xalloc */
int (*XAllocFailureHook)( size_t ) = NULLF;
    /* and for app name */
const char *wklibApplicationName;



/***** protos *********/
static void SecPrintf( const char *string, ... );
static void DummySecVprintf( const char *string, va_list arg_ptr );
#if USE_SNOOP
static void SnoopPrintf( const char *s, ... );
static void SnoopVprintf( const char *s, va_list arg );
static void SnoopCleanup( void *dummy );
#endif

/**** function pointers ***/
static void (*SecVprintf)(const char *, va_list) = DummySecVprintf;

/***** functions ******/
#if __STDC__
  #define FLUSHALL() { fflush(stdout); fflush(stderr); fflush(errorSt); }
#else
  #define FLUSHALL() flushall()
#endif


#ifdef DOCUMENTATION
@Summary Error		   Standard Error Handler
 #include <wk/lib.h>

 void Error( m, s, ... );
 int	m;		Mode
 const char *s ;	Auszugebender Text wird als Formatstring fr die
			nachfolgenden Argumenten behandelt( wie printf )
@Description
 Standard Fehlerausgaberoutine:
 Mode beinhaltet 2 Parameter:
 mode % 1000 ist der ExitCode mit dem das Programm beendet werden soll;
	     dedoch nur wenn dieser Wert ungleich 0 ist.
 Mode / 1000 hat folgende Bedeutung:
     0 - Es wird nur der Text ausgegeben.
     1 - Es wird die OS Fehlermeldung (von errno ) angehngt.
@See Also
ErrorRgText
#endif

void Error( int mode, const char *s, ... )
{
#define BUFLEN 512
    static char *buf ;
    va_list arg_ptr ;
    const char *p ;

    va_start( arg_ptr, s ) ;

    INIT_errorSt();
    fflush(errorSt) ;
    if( !buf ) {
	if( !(buf=malloc(BUFLEN)) ) {
	    fprintf(errorSt, "\n%s: error(): %s\n",wklibApplicationName, GetStr(0));
	    /* no chance to try SecPrintf, we are already out of core */
	    wklib_exit(4) ;
	}
    }
    vsprintf(buf,s,arg_ptr) ;
    va_end(arg_ptr);

    if( mode/1000 == 0 ) {
	if( *buf== '\b' )
	    fprintf(errorSt, "\r%s:%s\n" ,wklibApplicationName,buf+1);
	else
	    fprintf(errorSt, "\r%s: %s\n",wklibApplicationName,buf ) ;
	SecPrintf( "%s: %s\n", wklibApplicationName, buf );
      #if USE_SNOOP
	SnoopPrintf( "%s: %s\n", wklibApplicationName, buf );
      #endif
    }
    else {
	if( mode/1000 == 1 )
	    p = (const char*)strerror(errno);
	else {
	    int i;

	    p = "?unregistered?" ;
	    for(i=0; i < MAX_FNCS; i++ )
		if( textFncTbl[i].no == mode/1000 )  {
		    p = textFncTbl[i].fnc(-1);
		    break;
		}
	}
	if( *buf== '\b' )
	    fprintf(errorSt, "\r%s:%s: %s\n",wklibApplicationName,buf+1,p);
	else
	    fprintf(errorSt, "\r%s: %s: %s\n",wklibApplicationName,buf,p ) ;
	SecPrintf( "%s: %s: %s\n",wklibApplicationName,buf,p ) ;
      #if USE_SNOOP
	SnoopPrintf( "%s: %s: %s\n",wklibApplicationName,buf,p ) ;
      #endif
    }

    fflush(errorSt) ;
    if( !(mode%1000) )
	return ;
    wklib_exit( mode%1000 ) ;

#undef BUFLEN
} /* end Error() */



#ifdef DOCUMENTATION
@Summary Errorx 	  Standard Error Shorthand
 #include <wk/lib.h>

 void Errorx( n );
 int	n;		Fehlernummer
@Description
 Kurzform von Error(4,"%s",text(n)).  Sinnvolle Texte sind eigentlich nur 0
 (not enough core)
#endif


void Errorx( int n )
{
    Error( 4,"%s",GetStr(n)) ;
    abort(); /* make GNU-C happy (function has attribute noreturn) */
}


#ifdef DOCUMENTATION
@Summary ErrorRgText	  Register an Text delivery Function for Error()
 #include <wk/lib.h>

 void ErrorRgText( n, fnc );
 int	n;		   Modenumber
 const char *(*fnc)(int);  Funktion die Texte liefert
@Description
 Registrier eine Funktion fr die Error() Funktion,
 die Nummer muss > 1 sein, da dies fest fr syserror() definiert ist,
 ansonsten ist jede Nummer von 2 bis 31 mglich. Max. knnen zur Zeit
 5 Nummern registriert werden.
 Wird z.B. Die Funktion ScrErrorText() unter der Nummer 17 registriert,
 so wird der Text dieser Funktion mit dem Aufruf dieser Funktion
 an den Errortext angehangen. Als Argument dieser Funktion wird -1
 genommen, dies sollte dann den letzten Fehlercode zurckliefern.
@Notes
 Mehrfache Registration ist mglich, aber nur die erste wird verwendet
#endif


void ErrorRgText( int n, const char *(*fnc)(int) )
{
    int i;

    if( n > 1 && n < 32 )
	for(i=0; i < MAX_FNCS; i++ )
	    if( !textFncTbl[i].no ) {
		textFncTbl[i].no = n;
		textFncTbl[i].fnc= fnc;
		return; /* ready */
	    }
    Bug("ErrorRgText(%d)", n);
}




#ifdef DOCUMENTATION
@Summary ErrorRgMonitor
 #include <wk/lib.h>

 void ErrorRgMonitor( f );
 void (*f)(const char*, va_list);  vprintf like function
@Description
 This function registers a monitor which will have acces to
 all data, which is printed by Error, Bug, Fatal like functions.
 You must specify a vprintf like functions.
 If you specify NULL, the monitor will be disabled.
#endif /*DOCUMENTATION*/


void ErrorRgMonitor( void (*f)(const char*, va_list) )
{
    SecVprintf =  f ? f : DummySecVprintf;
}



#ifdef DOCUMENTATION
@Summary ErrorStream  Set stream for Error(), Bug() and Fatal()
 #include <wk/lib.h>

 FILE *ErrorStream( FILE *newSt );
@Description
 ndert den Ausgabe Stream fr die Funktionen:
 Error(), Bug() und Fatal() auf newSt.
 Der default stream ist stderr.
 Wird fr newSt NULL angegeben, so wird nur ein Flush durchgefhrt.
@Return Value
 Pointer auf den alten Stream.
#endif /*DOCUMENTATION*/

FILE *ErrorStream( FILE *newSt )
{
    FILE *oldSt;

    INIT_errorSt();
    ErrorSnoop(0); /* initialize snoop */
    oldSt = errorSt;
    fflush( errorSt );
    if( newSt )
	errorSt = newSt ;
    return oldSt;
}



#ifdef DOCUMENTATION
@Summary Bug	      abort program with internal error message
 #include <wk/lib.h>

 void Bug( fmt, ... );
 const char *fmt;	    Format string
@Description
 Abbruch eines Programms mit exit(8) und einer Meldung.  Die Meldung
 besteht wie bei printf aus einem format string und entsprechenden
 Argumenten.  Die Meldung wird auf stderr ausgeben,
 wobei der Text:  "Internal Error: " vorangestellt wird.
 Wird als Formatstring NULL angebeen, so wird als default ein
 Formatstring genommen fr einen File- und Zeilenangabe ( "%s[%d]" )
#endif

void Bug( const char *s, ... )
{
    va_list arg_ptr ;
    static const char text[] = "\n%s: Internal Error: " ;

    va_start( arg_ptr, s ) ;
    INIT_errorSt();
    if( !s )
      #if __IBMC__
	s = "%s : %s[%d]";
      #else
	s = "%s[%d]";
      #endif

    FLUSHALL() ;
    fprintf(errorSt, text, wklibApplicationName ) ;
    vfprintf(errorSt,s,arg_ptr) ;
    fputc( '\n' , errorSt ) ;
    FLUSHALL() ;

    SecPrintf( text, wklibApplicationName );
    SecVprintf( s, arg_ptr );
    SecPrintf( "\n" );
  #if USE_SNOOP
    /*SnoopPrintf( text, wklibApplicationName );*/
    SnoopVprintf( s, arg_ptr );
  #endif
    va_end(arg_ptr);

    wklib_exit( 8 ) ;
}

void
Bug0( const char *a, int b )
{
    Bug("%s[%d]", a, b );
}


#ifdef DOCUMENTATION
@Summary Fatal	      issue fatal error message
 #include <wk/lib.h>

 void Fatal( fmt, ... );
 const char *fmt;	    Format string
@Description
 Ausgabe einer Meldung mit vorangestlltem Text bei einem schweren Fehler.
 Das Programm wird aber nicht abgebrochen.
 Besteht wie bei printf aus einem format string und entsprechenden
 Argumenten.  Die Meldung wird auf stderr ausgeben,
 wobei der Text:  "Fatal Error: " vorangestellt wird.
 Wird als Formatstring NULL angebeen, so wird als default ein
 Formatstring genommen fr einen File- und Zeilenangabe ( "%s[%d]" )
#endif


void Fatal( const char *s, ... )
{
    va_list arg_ptr ;
    static  const char text[] = "\n%s: Fatal Error: ";

    va_start( arg_ptr, s ) ;
    INIT_errorSt();
    if( !s )
	s = "%s[%d]";

    FLUSHALL() ;
    fprintf(errorSt, text, wklibApplicationName ) ;
    vfprintf(errorSt,s,arg_ptr) ;
    fputc( '\n' , errorSt ) ;
    FLUSHALL() ;

    SecPrintf( text, wklibApplicationName );
    SecVprintf( s, arg_ptr );
    SecPrintf( "\n" );
  #if USE_SNOOP
    /*SnoopPrintf( text, wklibApplicationName );*/
    SnoopVprintf( s, arg_ptr );
  #endif
    va_end(arg_ptr);
}



#ifdef DOCUMENTATION
@Summary Info	     issue info message
 #include <wk/lib.h>

 void Info( fmt, ... );
 const char *fmt;	    Format string
@Description
 Ausgabe einer Meldung auf dem ErrorStream, Linefeed wird angehangen
#endif


void Info( const char *s, ... )
{
    va_list arg_ptr ;

    va_start( arg_ptr, s ) ;
    INIT_errorSt();
    fprintf(errorSt,"%s: ",wklibApplicationName);
    vfprintf(errorSt,s,arg_ptr) ;
    fputc( '\n' , errorSt ) ;
    SecPrintf( *s=='\b'? "%s:": "%s: ", wklibApplicationName );
    SecVprintf( *s=='\b'? (s+1):s, arg_ptr );
    SecPrintf( "\n" );
  #if USE_SNOOP
    /*SnoopPrintf( "%s: ", wklibApplicationName );*/
    SnoopVprintf( s, arg_ptr );
  #endif
    va_end(arg_ptr);
}



static void SecPrintf( const char *s, ... )
{
    va_list arg_ptr ;

    va_start( arg_ptr, s ) ;
    SecVprintf(s,arg_ptr) ;
    va_end( arg_ptr );
}


static void DummySecVprintf( const char *string, va_list arg_ptr )
{  }


#ifdef DOCUMENTATION
@Summary ErrorSnoop
 #include <wk/lib.h>

 int ErrorSnoop( int mode );
@Description
 mode 0 := gibt meldung aus, ob snoop aktiv ist
#endif

int ErrorSnoop( int mode )
{
  #if USE_SNOOP
    SnoopVprintf( NULL, NULL );
  #endif
    return snoopActive;
}


#if USE_SNOOP

static void SnoopPrintf( const char *s, ... )
{
    va_list arg_ptr ;

    va_start( arg_ptr, s ) ;
    SnoopVprintf(s,arg_ptr) ;
    va_end( arg_ptr );
}

#if 1 /* connection always open */

static void SnoopVprintf( const char *s, va_list arg )
{
    static int initialized;
    char buffer[800], *p;

    if( !initialized ) {
	if( !(p = getenv("WKSNOOP")))
	    initialized = -1;	/* not wanted */
	else if( SnoopOpen(p, &hsn, wklibApplicationName, NULL) )
	    initialized = -1;	/* no server */
	else {
	    initialized = 1;
	    snoopActive = 1;
	    AddCleanUp( SnoopCleanup, NULL );
	}
    }

    if( initialized == 1 && arg ) { /* enabled*/
	vsprintf(buffer, s, arg );
	SnoopWrite(hsn, buffer);
    }
}

static void SnoopCleanup( void *dummy )
{
    SnoopClose(hsn); /* !!! always gives an "brokenpipe" !!! */
}

#else	/* establish connection when needed */

static void SnoopVprintf( const char *s, va_list arg )
{
    static int initialized;
    static char *pipeName;
    char buffer[800], *p;

    if( !initialized ) {
	if( !(p = getenv("WKSNOOP")))
	    initialized = -1;	/* not wanted */
	else if( SnoopOpen(p, &hsn, wklibApplicationName, NULL) )
	    initialized = -1;	/* no server */
	else {
	    pipeName = xstrdup(p);
	    initialized = 1;
	    snoopActive = 1;
	    SnoopClose(hsn);
	}
    }

    if( initialized == 1 && arg ) { /* enabled*/
	vsprintf(buffer, s, arg );
	if( SnoopOpen(p, &hsn, wklibApplicationName, NULL) )
	    fputs("Error opening snoop pipe", errorSt );
	else {
	    SnoopWrite(hsn, buffer);
	    SnoopClose(hsn);
	}
    }
}

#endif

#endif

/*** bottom of file ***/
