/* [file1.c wk 11.4.89] xfopen(): extended fopen()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 19.06.93 wk	Added fcloseall() for some compilers
 * 05.08.93 wk	Added xfclose()
 */

#include <wk/tailor.h>
RCSID("$Id: file1.c,v 1.4 1995/03/08 16:55:04 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <wk/file.h>
#include <wk/io.h>


#ifdef DOCUMENTATION
@Summary xfopen 	  Open a stream and test for error

 #include <wk/wklib.h>

 FILE *xfopen( path, type );
 const char *path;	Dateiname
 const char *type;	Openflags
@Description
 Wie fopen(), bei einem Fehler wird aber mit einer Fehlermeldung und
 einem Exitcode von 2 abgebrochen.

@Return Value
 A pointer to the open file.
@See Also
 fopen
#endif


FILE *xfopen( const char *name, const char *type )
{
    FILE *st ;
    if( !(st=fopen(name,type)) )
        Error(1002,GetStr(*type=='w'?5:1),name) ;
    return st ;
}

void xfclose( FILE *fp )
{
    if( fclose( fp ) )
        Error(1002,GetStr(4),"[stream object]") ;
}


#ifdef DOCUMENTATION
@Summary IsTerminal
 #include <wk/file.h>

 int IsTerminal( level );
 int level;	reserved; should be 0
@Description
 Check whether the  stdi and stdout is connected
 to a Terminal or any other visual output device or not.
 Function should be used prior to give any progression indicator.
@Return Value
 Returns: 1 - Connected to a Videodevice
	  0 - Redirected to a file or some other device
#endif /*DOCUMENTATION*/


int IsTerminal( int level )
{
    return isatty(fileno(stdin)) && isatty(fileno(stdout)) ;
}


/****************
 * Close all open streams (used in cleanup prior to removin files)
 * Retursn # of closed files or EOF on error
 */

#if __IBMC__
int fcloseall()
{
    return _fcloseall();
}
#elif GNU_C_LIB
int fcloseall()
{
    Fatal("fcloseall() is not implemented");
    return EOF;
}
#endif

/**** end of file ****/
