/* [file13.c wk 17.06.94] More file functions
 *	Copyright (c) 1988-94 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */


#include <wk/tailor.h>
RCSID("$Id: file13.c,v 1.4 1996/01/25 20:16:41 wernerk Exp $")
#include <stdio.h>
#include <wk/file.h>

#ifdef OS20
#ifdef EMX
int	    DosForceDelete( const char *s );
#else
int _System DosForceDelete( const char *s );
#endif
#endif


#ifdef DOCUMENTATION
@Summary FileForceRemove
 #include <wk/file.h>

 int FileForceRemove( const char *fname );
@Description
 This is nearly the same as remove() but the function will try
 to remove the file in a matter that it its not any more recoverable.
 Use it for temporary file to save disk space.
@Return Value
 Zero on success or non-zero on failure.
 errno will be set on failure.
#endif /*DOCUMENTATION*/


int FileForceRemove( const char *fname )
{
  #if OS20
    if( !DosForceDelete( fname ) )
	return 0;
  #endif
    return remove( fname);
}


/******* bottom of file *******/
