/* [file3.c wk 2.2.89] fsopen()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  Purpose:
 *	Same as fopen but only for read and in shared modus
 *	uses open() function !!!!
 * History:
 * 02.01.93 wk	EMX Support
 */

#include <wk/tailor.h>
RCSID("$Id: file3.c,v 1.11 1996/04/18 14:32:15 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <wk/io.h>
#include <wk/file.h>
#include <wk/string.h>
#include <wk/environ.h>
#include <wk/direc.h>
#if __ZTC__ || __MSC__ || __IBMC__ || __WATCOMC__
#include <share.h>
#endif

#if GNU_C_LIB && __GNUC__ && OS2
    /* Die GNU-C-LIB von gcc/2 hat einen fehler in stdio/flags.c
     * (Abfrage von mode auf "b" hinter dem String moeglich), deswegen
     * haenge ich noch eine \0 an.
     * Und fdopen() funktioniert nicht richtig, da fcntl()
     * immer 0x7ffffff zurueckgibt und so immer einen Filemode
     * von O_RDWR vorspiegelt; ich implementiere deswegen
     * hier ein eigenes fcntl, welches sinnvollere Werte
     * zurueckliefert.
     */
#define DUMMY_FCNTL 1
static int fcntlEscape;
#endif


#ifndef O_BINARY
    #define O_BINARY 0	/* in raw mode only used my MSC */
#endif
#ifndef O_TEXT
    #define O_TEXT   0	/* in raw mode only used my MSC */
#endif


#ifdef DOCUMENTATION
@Summary fsopen     Open a stream for read in shared mode
 #include <wk/file.h>

 FILE *fsopen( path, type );
 const char *path;	Dateiname
 const char *type;	Openflags

@Description
 Wie fopen aber als Type nur zulssig:	"b" oder "t".  "t" ist default,
 entweder leerer string, oder NULL Weiteres Kennzeichen im typ ist:
 "e[:XXXXX]", wobei XXXXX Environmentvariablen (z.B.:  PATH ) bezeichnen,
 ber die via searchenv() nach dem File gesucht wird, ist nur 'e'
 angegeben, so wird "PATH" angegenommen, nach der Variablen drfen keine
 weiteren Zeichen folgen.  _fmode wird nicht untersttzt.  errno wird
 gesetzt. Erweiterung : als Zeichen vor e ist auch s zulssig:
 Die Datei wird dann geffnet mit schreiben und lesen von anderen Tasks
 erlaubt (VORSICHTIG Benutzen)

@Return Value
 A pointer to the open file. NULL is returned on error.
#endif


FILE *fsopen( const char *name, const char *type )
{
    FILE *st;
    char *p;
    p= fsopen2(name, type, &st );
    free(p);
    return st;
}


char *fsopen2( const char *name, const char *type, FILE **retfp )
{
    FILE *st ;
    int hd , txt , shw , find;
    char *p , *path ;
    const char *s, *r;
    int i;

    txt = 1;
    shw = 0;
    find = 0;

    st = NULL ;
    path = xmalloc(F_MAX_PATH) ;
    mem2str( path, name, F_MAX_PATH ) ;
    if( type )
	for(s=type; *s && *s != ':'; s++ )
	    if( *s == 'b' )
		txt = 0;
	    else if( *s == 's' )
		shw = 1;
	    else if( *s == 'f' )
		find=1;
	    else if( *s == 'e' && s[1] == ':' ) {
		char buf[20];
		for( r=s+2,i=1; *r && !isspace(*(const byte*)r); r++ )
		    i++;
		p = i > DIM(buf)? xmalloc(i) : buf;
		for( r=s+2,i=0; *r && !isspace(*(const byte*)r); r++ )
		    p[i++] = *r;
		p[i]=0;
		s = r-1;
		SearchEnv( name, p, path ) ;
		if( p != buf )
		    free(p);
	    }
	    else if( *s == 'e' )
		SearchEnv( name, "PATH", path );

    if( find )	/* ob das so gut ist, src == dst ? */
	GetFileName(path, F_MAX_PATH, path );

  #if EMX  || GNU_C_LIB || UNIX || POSIX
    /* currently no special sopen implemented, but RONLY will do so*/
    hd = open( path, (txt? O_RDONLY|O_TEXT : O_RDONLY|O_BINARY) );
  #elif __ZTC__
    hd = sopen( path, O_RDONLY, (shw? SH_DENYNO:SH_DENYWR) );
    if( hd == -1 && errno == EINVAL )  /* may be DOS-Version < 3.00 */
	hd = open( path, O_RDONLY);    /* try open unsharable */
  #else
    hd = sopen( path, (txt? O_RDONLY|O_TEXT : O_RDONLY|O_BINARY),
		     (shw? SH_DENYNO:SH_DENYWR));
  #endif

    if( hd != -1 ) {
      #if DUMMY_FCNTL
	fcntlEscape = 1;
	st=fdopen(hd, txt? "r\0":"rb\0" );
	fcntlEscape = 0;
      #else
	st=fdopen(hd, txt? "r":"rb" );
      #endif
	if( !st ) {
	    close(hd) ;
	    hd = -1 ;
	    errno = EBADF ;
	}
    }
  #if !__MSC__
    if( hd != -1 && st )
	if( hd != fileno(st) )
	    close(hd);	/* handle may be duplicated; */
			/* so if the handles are different, we close the old */
			/* handle. Microsoft doesn't do this */
  #endif
    *retfp = st;
    if( st )
	return path;
    free(path);
    return NULL;
}



#ifdef DOCUMENTATION
@Summary xfsopen	     Open a stream for read and test for error
 #include <wk/wklib.h>

 FILE *xfsopen( path, type );
 const char *path;	Dateiname
 const char *type;	Openflags
@Description
 Wie fsopen(), bei einem Fehler wird aber mit einer Fehlermeldung und
 einem Exitcode von 2 abgebrochen.

@Return Value
 A pointer to the open file.
@See Also
 fsopen
#endif

#if !__IBMC__ && !__DECC
#pragma check_stack(off)
#endif

FILE *xfsopen( const char *name, const char *type )
{
    FILE *st ;
    if( !(st=fsopen(name,type)) )
	Error(1002,GetStr(1),name) ;
    return st ;
}


#if DUMMY_FCNTL
/* Siehe oben */

int fcntl( int fd, int cmd, ...)
{
    if( !fcntlEscape )
	return 0x7fffffff;
    return O_RDONLY;
}

#endif

/****** bottom of file ******/
