/* [file6.c wk 5.10.88] gets() with tab expand
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /vol1/src/master/libs/wklib/file6.c,v 1.6 1995/03/30 12:12:19 wernerk Exp $
 */

#include <wk/tailor.h>
RCSID("$Id: file6.c,v 1.6 1995/03/30 12:12:19 wernerk Exp $")
#include <stdio.h>
#include <string.h>
#include <wk/file.h>


#ifdef DOCUMENTATION
@Summary FTabGets	  Read a string with tabs
 #include <wk/file.h>

 char *FTabGets( p, n, st, skip, sklen, endl, elen, pos );
 char *p ;		Buffer
 int n ;		Bufferllnge
 FILE *st ;		Stream
 const char *skip ;	Buffer mit den zeichen die bersprungen werden
 int sklen ;		Anzahl skipzeichen
 const char *endl ;	Buffer mit allen end-of-line zeichen
 int elen ;		Anzahl end-of-line zeichen
 int *pos ;		Position innerhalb der Zeile (fr tabs)
@Description
 Funktion exakt wie fgets, aber:  Zeichen die in einer skipliste stehen
 werden bersprungen.  das zeilenende wird durch die zeichen in endl
 bestimmt (sofern nicht in skipliste tabulatoren werden, sofern sie nicht
 in der skipliste stehen durch 8 blanks ersetzt.  pos gibt die position
 innnerhalb der Zeile an; ist als letztes das zeilenende gelesen worden,
 so wird pos = 0 gesetzt, beim ersten lesen sollte dies auch geschehen.
 am ende des buffers wird immer eine '\0' angehngt
@Return Value
 Wenn fehlerfrei wird Pointer auf p zurckgegeben;
 beim einem fehler oder eof wird NULL zurckgegeben - mit
 feof oder ferror kann dann festgestellt werden, ob es sich
 um einen fehler oder eof handelt.
@Example
 #include <stdio.h>
 #include <wk/file.h>

 FILE *st ;
 char buf[30] ;
 int  zpos ;

 st = fopen( "test.dat","r" ) ;
 zpos = 0 ;
 FTabGets( buf, 30, st, "\x1a", 1, "\n\f",2 , &zpos ) ;

#endif	/* end docu */



char *FTabGets( char *ptr, int n , register FILE *st ,
		const char *skip, int sklen ,
		const char *endl, int elen , int *pos )
{
    register char *p ;
    int r , j , c , eof ;

    p = ptr ;
    eof = ( feof(st) || ferror(st) )? 1 : 0 ;
    while( --n > 0 && !eof ) {
	c = getc(st) ;
	if( feof(st) || ferror(st) )
	    *pos = n = 0 ;
	else if( memchr( skip, c, sklen ) )
	    continue ;	/* skip character found */
	else if( memchr( endl, c, elen ) )
	    *(p++) = (char)c , (*pos) = 0 , n = 0 ; /* end of line */
        else if( c == '\t' ) {
	    r = 8 - ((*pos<8)? *pos:(*pos-8) % 8 ) ;
            *(p++) = ' ' , (*pos)++ ;
	    for( j = 1 ; --n > 0 && j < r ; j++ )
                *(p++) = ' ' , (*pos)++ ;
	}
	else
	    *(p++) = (char)c , (*pos)++ ;
    }
    *p = '\0' ;
    return (eof || ( feof(st) && !*ptr))? NULL : ptr ;

}

/***** end of file ****/
